<?php

class UM_DateTime {

	function __construct() {
	
	}
	
	/***
	***	@Display time in specific format
	***/
	function get_time( $format ) {
		return current_time( $format );
	}
	
	/***
	***	@Get age
	***/
	function get_age($then) {
		if ( !$then ) return '';
		$then_ts = strtotime($then);
		$then_year = date('Y', $then_ts);
		$age = date('Y') - $then_year;
		if( strtotime('+' . $age . ' years', $then_ts) > current_time( 'timestamp' ) ) $age--;
		if ( $age == 1 )
			return sprintf(__('%s year old','ultimatemember'), $age );
		if ( $age > 1 )
			return sprintf(__('%s years old','ultimatemember'), $age );
		if ( $age == 0 )
			return __('Less than 1 year old','ultimatemember');
	}
	
	/***
	***	@Reformat dates
	***/
	function format($old, $new){
		$datetime = new DateTime($old);
		$output = $datetime->format( $new );
		return $output;
	}
	
	/***
	***	@Get last 30 days as array
	***/
	function get_last_days($num = 30, $reverse = true) {
		$d = array();
		for($i = 0; $i < $num; $i++) {
			$d[ date('Y-m-d', strtotime('-'. $i .' days')) ] = date('m/d', strtotime('-'. $i .' days'));
		}
		if ($reverse == true){
			return array_reverse($d);
		} else {
			return $d;
		}
	}

}