jQuery( document ).ready( function () {

	jQuery( "#itsec_malware_enabled" ).change( function () {

		if ( jQuery( "#itsec_malware_enabled" ).is( ':checked' ) ) {

			jQuery( "#malware-settings" ).show();

		} else {

			jQuery( "#malware-settings" ).hide();

		}

	} ).change();

	//process tooltip actions
	jQuery( '#itsec_one_time_malware_scan' ).submit( function ( event ) {

		event.preventDefault();

		var data = {
			action: 'itsec_malware_request_url_scan_ajax',
			nonce : itsec_malware.nonce
		};

		//let user know we're working
		jQuery( "#itsec_one_time_malware_scan_submit" ).removeClass( 'button-primary' ).addClass( 'button-secondary' ).attr( 'value', itsec_malware.scanning_button_text );

		//call the ajax
		jQuery.ajax( {
			             url     : ajaxurl,
			             type    : 'POST',
			             data    : data,
			             dataType: 'json',
			             async   : false,
			             complete: function ( response ) {

				             var response = response.responseJSON;

				             if ( typeof response == undefined || response.response_code == - 1 ) {

					             jQuery( "#itsec_one_time_malware_scan_submit" ).removeClass( 'button-secondary' ).addClass( 'button-primary' ).attr( 'value', itsec_malware.button_text );

				             } else {

					             var response_data = {
						             action  : 'itsec_malware_get_scan_results_ajax',
						             nonce   : response.nonce,
						             resource: response.resource
					             }

					             var positives = get_report( response_data );

					             if ( positives > 0 ) {
						             window.location.replace( '?page=toplevel_page_itsec_logs&itsec_log_filter=malware' );
					             }

					             jQuery( "#itsec_one_time_malware_scan_submit" ).removeClass( 'button-secondary' ).addClass( 'button-primary' ).attr( 'value', itsec_malware.button_text );

					             if ( positives == 0 ) {

						             if ( itsec_malware.screen.id == 'security_page_toplevel_page_itsec_logs' ) {
							             window.location.replace( '?page=toplevel_page_itsec_logs&itsec_log_filter=malware' );
						             }

						             jQuery( "#itsec_one_time_malware_scan_submit" ).hide();
						             jQuery( "#itsec_malware_scan_status" ).show().find( 'p' ).text( itsec_malware.no_changes );

					             }

				             }

			             }
		             }
		);

	} );

	function get_report( response_data ) {

		var request = jQuery.ajax( {
			                           url     : ajaxurl,
			                           type    : 'POST',
			                           data    : response_data,
			                           dataType: 'json',
			                           async   : false,
			                           complete: function ( response ) {

				                           response = response.responseJSON;

				                           if ( typeof response != 'undefined' && typeof response.positives == 'undefined' ) {

					                           var response_data = {
						                           action  : 'itsec_malware_get_scan_results_ajax',
						                           nonce   : response.nonce,
						                           resource: response.resource
					                           }

					                           return get_report( response_data );

				                           }

			                           }

		                           } ).responseJSON;

		return request.positives;

	}

} );

