DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_duplicator_packages`;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `wp_duplicator_packages` VALUES("1","20150417_les48hdelapige","55310965234f97154150417132349","100","2015-04-17 13:24:03","Cyrille","O:11:\"DUP_Package\":16:{s:2:\"ID\";i:1;s:4:\"Name\";s:23:\"20150417_les48hdelapige\";s:4:\"Hash\";s:29:\"55310965234f97154150417132349\";s:8:\"NameHash\";s:53:\"20150417_les48hdelapige_55310965234f97154150417132349\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:39:\"/home/pigiste/48heures/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://48h.pigiste.org/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150417_les48hdelapige_55310965234f97154150417132349_scan.json\";s:7:\"Runtime\";s:10:\"54.70 sec.\";s:7:\"ExeSize\";s:8:\"316.87KB\";s:7:\"ZipSize\";s:8:\"196.97MB\";s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150417_les48hdelapige_55310965234f97154150417132349_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:22:\"/home/pigiste/48heures\";s:4:\"Size\";i:206533114;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";r:1;s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:67:\"20150417_les48hdelapige_55310965234f97154150417132349_installer.php\";s:4:\"Size\";i:324473;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:23031946;s:4:\"File\";s:66:\"20150417_les48hdelapige_55310965234f97154150417132349_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:106:\"/home/pigiste/48heures/wp-snapshots/tmp/20150417_les48hdelapige_55310965234f97154150417132349_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");


DROP TABLE IF EXISTS `wp_itsec_lockouts`;

CREATE TABLE `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(20) DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(20) DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_log`;

CREATE TABLE `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) NOT NULL DEFAULT '',
  `log_function` varchar(255) NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_host` varchar(20) DEFAULT NULL,
  `log_username` varchar(20) DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) DEFAULT NULL,
  `log_referrer` varchar(255) DEFAULT NULL,
  `log_data` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_temp`;

CREATE TABLE `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(20) DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_layerslider`;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `wp_layerslider` VALUES("1","Slide Home page","{\"properties\":{\"title\":\"Slide Home page\",\"width\":\"100%\",\"height\":\"470\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"hoverbottomnav\":\"on\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"80\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"relativeurls\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2014\\/05\\/cistude_romain_riols.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"7000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2013\\/04\\/Logo48hcyan-01.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"900\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"200\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"20px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"900\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1450\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"250\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\"}\",\"top\":\"187px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/48h.pigiste.org\\/le-programme\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"221px\",\"left\":\"671px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-02.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/48h.pigiste.org\\/sinscrire-aux-48h\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"299px\",\"left\":\"668px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/titres-03.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"http:\\/\\/48h.pigiste.org\\/pratique\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\"}\",\"top\":\"378px\",\"left\":\"666px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\\/wp-content\\/uploads\\/2015\\/03\\/48hVichy-juil14-bandeau1200.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/blancPP-01.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"450\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"119px\",\"left\":\"20px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"\\/wp-content\\/uploads\\/2014\\/04\\/textvichy.png\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"550\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"68\\\\\\\"}\",\"top\":\"348px\",\"left\":\"21px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1428671868","0","0");
INSERT INTO `wp_layerslider` VALUES("2","Why Enfold - Small Header","{\"properties\":{\"title\":\"Why Enfold - Small Header\",\"width\":\"100%\",\"height\":\"150\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"0\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"1\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"#aac98e\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_Layer_1.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1200\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"150\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-18px\",\"left\":\"800px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1300\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"842px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l17.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"350\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-279px\",\"left\":\"951px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"450\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"51px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-22px\",\"left\":\"-107px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"h2\",\"image\":\"\",\"html\":\"Why you should choose\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"650\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"68px\",\"left\":\"214px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"img\",\"image\":\"http:\\/\\/48h.pigiste.org\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Layer_2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"20px\",\"left\":\"684px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1398347374","1398347374","0","0");


DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_newsletter`;

CREATE TABLE `wp_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `surname` varchar(100) NOT NULL DEFAULT '',
  `sex` char(1) NOT NULL DEFAULT 'n',
  `status` char(1) NOT NULL DEFAULT 'S',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `token` varchar(50) NOT NULL DEFAULT '',
  `feed` tinyint(4) NOT NULL DEFAULT '0',
  `feed_time` bigint(20) NOT NULL DEFAULT '0',
  `country` varchar(4) NOT NULL DEFAULT '',
  `list_1` tinyint(4) NOT NULL DEFAULT '0',
  `list_2` tinyint(4) NOT NULL DEFAULT '0',
  `list_3` tinyint(4) NOT NULL DEFAULT '0',
  `list_4` tinyint(4) NOT NULL DEFAULT '0',
  `list_5` tinyint(4) NOT NULL DEFAULT '0',
  `list_6` tinyint(4) NOT NULL DEFAULT '0',
  `list_7` tinyint(4) NOT NULL DEFAULT '0',
  `list_8` tinyint(4) NOT NULL DEFAULT '0',
  `list_9` tinyint(4) NOT NULL DEFAULT '0',
  `list_10` tinyint(4) NOT NULL DEFAULT '0',
  `list_11` tinyint(4) NOT NULL DEFAULT '0',
  `list_12` tinyint(4) NOT NULL DEFAULT '0',
  `list_13` tinyint(4) NOT NULL DEFAULT '0',
  `list_14` tinyint(4) NOT NULL DEFAULT '0',
  `list_15` tinyint(4) NOT NULL DEFAULT '0',
  `list_16` tinyint(4) NOT NULL DEFAULT '0',
  `list_17` tinyint(4) NOT NULL DEFAULT '0',
  `list_18` tinyint(4) NOT NULL DEFAULT '0',
  `list_19` tinyint(4) NOT NULL DEFAULT '0',
  `list_20` tinyint(4) NOT NULL DEFAULT '0',
  `profile_1` varchar(255) NOT NULL DEFAULT '',
  `profile_2` varchar(255) NOT NULL DEFAULT '',
  `profile_3` varchar(255) NOT NULL DEFAULT '',
  `profile_4` varchar(255) NOT NULL DEFAULT '',
  `profile_5` varchar(255) NOT NULL DEFAULT '',
  `profile_6` varchar(255) NOT NULL DEFAULT '',
  `profile_7` varchar(255) NOT NULL DEFAULT '',
  `profile_8` varchar(255) NOT NULL DEFAULT '',
  `profile_9` varchar(255) NOT NULL DEFAULT '',
  `profile_10` varchar(255) NOT NULL DEFAULT '',
  `profile_11` varchar(255) NOT NULL DEFAULT '',
  `profile_12` varchar(255) NOT NULL DEFAULT '',
  `profile_13` varchar(255) NOT NULL DEFAULT '',
  `profile_14` varchar(255) NOT NULL DEFAULT '',
  `profile_15` varchar(255) NOT NULL DEFAULT '',
  `profile_16` varchar(255) NOT NULL DEFAULT '',
  `profile_17` varchar(255) NOT NULL DEFAULT '',
  `profile_18` varchar(255) NOT NULL DEFAULT '',
  `profile_19` varchar(255) NOT NULL DEFAULT '',
  `profile_20` varchar(255) NOT NULL DEFAULT '',
  `referrer` varchar(50) NOT NULL DEFAULT '',
  `http_referer` varchar(255) NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT '0',
  `flow` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter` VALUES("1","paulineburguin@hotmail.fr ","","","n","C","2014-05-07 22:10:12","a6896fa250","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("2","jacson-christel@voila.fr ","","","n","C","2014-05-07 22:10:26","35897a25c8","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("3","henry.castelbou@numericable.fr ","","","n","C","2014-05-07 22:10:34","5fb9736511","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("4","nicolas.jaunet@argus-presse.fr","","","n","C","2014-05-07 22:10:44","6120a0dae4","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("5","manager@mtwevts.com ","","","n","C","2014-05-07 22:10:58","f3504d96fa","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","0","0");
INSERT INTO `wp_newsletter` VALUES("6","max.twa@gmail.com","","","n","C","2014-05-07 22:13:09","2379dc6e8e","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","","","","","","","","","","","","","","","","","","","0","","1","0");


DROP TABLE IF EXISTS `wp_newsletter_emails`;

CREATE TABLE `wp_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` longtext,
  `message_text` longtext,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused') NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `send_on` int(11) NOT NULL DEFAULT '0',
  `track` tinyint(4) NOT NULL DEFAULT '0',
  `editor` tinyint(4) NOT NULL DEFAULT '0',
  `sex` char(1) NOT NULL DEFAULT '',
  `query` text,
  `preferences` text,
  `options` longtext,
  `token` varchar(10) NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_emails` VALUES("1","<!DOCTYPE html>
<html>
    <head>
        <title></title>
        <style>
            * {
                font-family: ;
                font-size: ;
            }
        </style>
    </head>
    <body style=\"font:normal 11px helvetica,sans-serif;\"><table style=\"background-color: #ffffff; width: 600px; background-position: initial initial; background-repeat: initial initial;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
<tbody>
<tr>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">Cet email a &eacute;t&eacute; envoy&eacute; &agrave; {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.</td>
<td style=\"color: #9ab; font: normal 11px helvetica,sans-serif; text-align: center; padding: 10px 0 20px 0;\">&nbsp;</td>
</tr>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">
<table style=\"height: 90px; width: 334px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"20\" align=\"center\">
<tbody>
<tr>
<td style=\"background: #ffffff;\"><a href=\"http://www.48h.pigiste.org\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/Logo48hPP-01.png\" alt=\"\" width=\"382\" height=\"211\" /></a></td>
<td style=\"background: #ffffff;\">
<p><a href=\"http://48h.pigiste.org/le-programme/\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/titres-01.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
<p><a href=\"http://48h.pigiste.org/sinscrire-aux-48h/\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/titres-02.png\" alt=\"\" width=\"223\" height=\"50\" /></a></p>
<p><a href=\"http://48h.pigiste.org/pratique/\"><img src=\"http://48h.pigiste.org/wp-content/uploads/2014/04/titres-03.png\" alt=\"\" width=\"227\" height=\"51\" /></a></p>
</td>
</tr>
</tbody>
</table>
</td>
<td style=\"border: 1px dotted #e1e2e3; border-top: none; border-bottom: 3px solid #e1e2e3; background: #ffffff;\">&nbsp;</td>
</tr>
</tbody>
</table></body></html>","This email requires a modern e-mail reader. You can view the email online here:

{email_url}.

Thank you, Les 48h de la pige
To change your subscription follow:
{profile_url}.","Le programme est enfin publié !","message","2014-05-07 22:04:24","sent","6","6","6","1399492800","1","0","","select * from wp_newsletter where status=\'C\'","","a:5:{s:18:\"preferences_status\";s:1:\"0\";s:11:\"preferences\";N;s:3:\"sex\";N;s:6:\"status\";s:1:\"C\";s:8:\"wp_users\";s:1:\"0\";}","52730d2b3d","0");


DROP TABLE IF EXISTS `wp_newsletter_stats`;

CREATE TABLE `wp_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `email_id` int(11) NOT NULL DEFAULT '0',
  `link_id` int(11) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) NOT NULL DEFAULT '',
  `anchor` varchar(200) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `country` varchar(4) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `wp_newsletter_stats` VALUES("1","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("2","6","1","0","2014-05-07 22:13:37","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("3","6","1","0","2014-05-07 22:13:52","http://48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("4","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("5","6","1","0","2014-05-07 22:15:28","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("6","5","1","0","2014-05-07 22:17:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("7","6","1","0","2014-05-07 22:18:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("8","6","1","0","2014-05-07 22:18:14","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("9","5","1","0","2014-05-07 23:09:03","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("10","2","1","0","2014-05-08 08:57:32","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("11","2","1","0","2014-05-08 08:57:46","http://48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("12","2","1","0","2014-05-08 09:07:45","http://48h.pigiste.org/le-programme/","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("13","5","1","0","2014-05-08 10:03:29","","","88.140.115.66","");
INSERT INTO `wp_newsletter_stats` VALUES("14","2","1","0","2014-05-08 10:28:31","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("15","2","1","0","2014-05-08 10:28:41","","","86.199.145.60","");
INSERT INTO `wp_newsletter_stats` VALUES("16","2","1","0","2014-05-08 10:34:35","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("17","1","1","0","2014-05-08 12:23:30","","","157.55.0.155","");
INSERT INTO `wp_newsletter_stats` VALUES("18","1","1","0","2014-05-08 12:23:31","http://48h.pigiste.org/le-programme/","","86.214.59.246","");
INSERT INTO `wp_newsletter_stats` VALUES("19","2","1","0","2014-05-08 13:11:18","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("20","5","1","0","2014-05-08 14:36:19","","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("21","5","1","0","2014-05-08 14:37:19","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("22","5","1","0","2014-05-08 14:37:22","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("23","5","1","0","2014-05-08 14:37:41","http://48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("24","5","1","0","2014-05-08 14:39:44","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("25","5","1","0","2014-05-08 14:43:29","http://48h.pigiste.org/le-programme/","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("26","5","1","0","2014-05-08 14:45:13","","","78.213.9.145","");
INSERT INTO `wp_newsletter_stats` VALUES("27","2","1","0","2014-05-08 19:31:34","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("28","5","1","0","2014-05-09 00:40:29","http://48h.pigiste.org/le-programme/","","2a01:e34:ed50:9910:a","");
INSERT INTO `wp_newsletter_stats` VALUES("29","2","1","0","2014-05-09 09:08:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("30","2","1","0","2014-05-09 09:29:42","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("31","2","1","0","2014-05-09 10:09:09","","","90.4.234.201","");
INSERT INTO `wp_newsletter_stats` VALUES("32","2","1","0","2014-06-01 12:08:09","","","90.9.60.51","");


DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=117901 DEFAULT CHARSET=utf8;

INSERT INTO `wp_options` VALUES("1","siteurl","http://48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("2","blogname","Les 48h de la pige","yes");
INSERT INTO `wp_options` VALUES("3","blogdescription","Un événement Profession : Pigiste","yes");
INSERT INTO `wp_options` VALUES("4","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES("5","admin_email","max.twa@gmail.com","yes");
INSERT INTO `wp_options` VALUES("6","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("7","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("8","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("9","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("10","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("11","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("17","default_category","1","yes");
INSERT INTO `wp_options` VALUES("18","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("19","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("21","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("22","date_format","j F Y","yes");
INSERT INTO `wp_options` VALUES("23","time_format","G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("24","links_updated_date_format","j F Y G \\h i \\m\\i\\n","yes");
INSERT INTO `wp_options` VALUES("165","widget_tag_cloud","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("166","widget_nav_menu","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("28","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("29","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("31","gzipcompression","0","yes");
INSERT INTO `wp_options` VALUES("32","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("34","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("35","active_plugins","a:10:{i:0;s:19:\"bbpress/bbpress.php\";i:1;s:41:\"better-wp-security/better-wp-security.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"email-users/email-users.php\";i:4;s:41:\"google-maps-widget/google-maps-widget.php\";i:5;s:21:\"newsletter/plugin.php\";i:6;s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";i:7;s:27:\"updraftplus/updraftplus.php\";i:8;s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";i:9;s:21:\"wp-piwik/wp-piwik.php\";}","yes");
INSERT INTO `wp_options` VALUES("36","home","http://48h.pigiste.org","yes");
INSERT INTO `wp_options` VALUES("37","category_base","","yes");
INSERT INTO `wp_options` VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("39","advanced_edit","0","yes");
INSERT INTO `wp_options` VALUES("40","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("41","gmt_offset","1","yes");
INSERT INTO `wp_options` VALUES("42","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("43","recently_edited","a:5:{i:0;s:74:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/includes/error404.php\";i:2;s:60:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/404.php\";i:3;s:62:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/style.css\";i:4;s:66:\"/homez.313/pigiste/48heures/wp-content/plugins/bbpress/bbpress.php\";i:5;s:63:\"/homez.313/pigiste/48heures/wp-content/themes/enfold/footer.php\";}","no");
INSERT INTO `wp_options` VALUES("44","template","enfold","yes");
INSERT INTO `wp_options` VALUES("45","stylesheet","enfold","yes");
INSERT INTO `wp_options` VALUES("46","comment_whitelist","1","yes");
INSERT INTO `wp_options` VALUES("47","blacklist_keys","","no");
INSERT INTO `wp_options` VALUES("48","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("49","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("50","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("51","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("52","db_version","30133","yes");
INSERT INTO `wp_options` VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("54","upload_path","","yes");
INSERT INTO `wp_options` VALUES("55","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("56","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("57","show_on_front","posts","yes");
INSERT INTO `wp_options` VALUES("58","tag_base","","yes");
INSERT INTO `wp_options` VALUES("59","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("60","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("61","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("62","thumbnail_size_w","80","yes");
INSERT INTO `wp_options` VALUES("63","thumbnail_size_h","80","yes");
INSERT INTO `wp_options` VALUES("64","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("65","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("66","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("67","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("68","large_size_w","1030","yes");
INSERT INTO `wp_options` VALUES("69","large_size_h","1030","yes");
INSERT INTO `wp_options` VALUES("70","image_default_link_type","file","yes");
INSERT INTO `wp_options` VALUES("71","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("72","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("73","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("74","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("75","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("76","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("77","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("78","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("79","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("80","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("82","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("83","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("84","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("85","uninstall_plugins","a:2:{s:41:\"google-maps-widget/google-maps-widget.php\";a:2:{i:0;s:3:\"GMW\";i:1;s:9:\"uninstall\";}s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:12:\"on_uninstall\";}}","no");
INSERT INTO `wp_options` VALUES("86","timezone_string","","yes");
INSERT INTO `wp_options` VALUES("87","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES("88","page_on_front","0","yes");
INSERT INTO `wp_options` VALUES("89","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("90","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("91","initial_db_version","26691","yes");
INSERT INTO `wp_options` VALUES("92","wp_user_roles","a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;s:19:\"wp-piwik_read_stats\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"email_users_notify\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;s:17:\"email_user_groups\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:12:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"email_single_user\";b:1;s:20:\"email_multiple_users\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:6:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"email_single_user\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:29:{s:9:\"keep_gate\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:1;s:13:\"delete_forums\";b:1;s:20:\"delete_others_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:1:{s:8:\"spectate\";b:1;}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:0;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:25:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:8:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:19:\"read_private_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:17:\"assign_topic_tags\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("93","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("94","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("95","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("96","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("97","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("98","sidebars_widgets","a:13:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:9:\"sidebar-7\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:1:{i:0;s:18:\"avia_google_maps-5\";}s:10:\"sidebar-10\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:10:\"sidebar-11\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("99","cron","a:11:{i:1429539422;a:1:{s:10:\"newsletter\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"newsletter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1429546316;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1429554660;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1429563525;a:2:{s:14:\"updraft_backup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"updraft_backup_database\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429580560;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1429606952;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429623793;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429624993;a:2:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"itsec_purge_lockouts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1429732938;a:1:{s:25:\"newsletter_check_versions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:17:\"newsletter_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1429805372;a:1:{s:8:\"gmw_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"gmw_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES("114272","updraft_dreamobjects","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("151","recently_activated","a:2:{s:21:\"polylang/polylang.php\";i:1429220309;s:19:\"akismet/akismet.php\";i:1429218125;}","yes");
INSERT INTO `wp_options` VALUES("154","_bbp_private_forums","a:1:{i:0;i:1739;}","yes");
INSERT INTO `wp_options` VALUES("155","_bbp_hidden_forums","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("501","_bbp_forum_slug","forum","yes");
INSERT INTO `wp_options` VALUES("156","_bbp_db_version","250","yes");
INSERT INTO `wp_options` VALUES("157","widget_newsbox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("158","widget_portfoliobox","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("159","widget_avia_socialcount","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("160","widget_avia_combo_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("161","widget_avia_partner_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("162","widget_avia_google_maps","a:3:{i:1;a:0:{}i:5;a:15:{s:5:\"title\";s:84:\"Cette année, rendez-vous sur le Campus Albert Londres à Vichy les 3 et 4 juillet !\";s:14:\"street-address\";s:36:\"Pôle technologique et universitaire\";s:4:\"city\";s:0:\"\";s:5:\"state\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:7:\"country\";s:5:\"VICHY\";s:3:\"lat\";s:8:\"46.11946\";s:3:\"lng\";s:16:\"3.42521320000003\";s:4:\"zoom\";s:2:\"15\";s:4:\"type\";s:7:\"ROADMAP\";s:12:\"directionsto\";s:0:\"\";s:7:\"content\";s:0:\"\";s:4:\"icon\";s:65:\"http://48h.pigiste.org/wp-content/uploads/2014/05/marqueur-01.png\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:5:\"280px\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("163","widget_pages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("164","widget_calendar","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("168","widget_bbp_login_widget","a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:12:\"Se connecter\";s:8:\"register\";s:0:\"\";s:8:\"lostpass\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("117857","_site_transient_timeout_theme_roots","1429539227","yes");
INSERT INTO `wp_options` VALUES("117858","_site_transient_theme_roots","a:2:{s:6:\"enfold\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";}","yes");
INSERT INTO `wp_options` VALUES("114285","updraft_split_every","500","yes");
INSERT INTO `wp_options` VALUES("114286","updraft_dir","updraft","yes");
INSERT INTO `wp_options` VALUES("117871","_transient_timeout_feed_66a70e9599b658d5cc038e8074597e7c","1429581569","no");
INSERT INTO `wp_options` VALUES("117872","_transient_feed_66a70e9599b658d5cc038e8074597e7c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communauté francophone autour du CMS WordPress et son écosystème\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Apr 2015 07:37:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"La problématique des traductions officielles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Mar 2015 08:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7377\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"Merci à WordPress Francophone de m&#8217;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel. Pour la petite histoire, je rédige une seconde version du livre &#171;&#160;Optimiser son référencement WordPress&#160;&#187;, et je suis une nouvelle fois [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6495:\"<p>Merci à WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je rédige une seconde version du livre &laquo;&nbsp;Optimiser son référencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confronté à une problématique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilisé ?</h2>
<p>Théoriquement, la seule et unique réponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la première fois que j&rsquo;ai été confronté à ce problème de traduction a été lorsque mon éditeur m&rsquo;a indiqué que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez étrange, et la question que je me pose à nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilisé par la communauté : Plugin ;</li>
<li>un autre terme utilisé par une partie de la communauté : Module ;</li>
<li>le terme le plus couramment utilisé par certains éditeurs : Plug-in.</li>
</ul>
<p>Pour y répondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la réponse est sans appel : le terme le plus utilisé de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\" /></a></p>
<p>PS : pour avoir les derniers chiffres à jour de l&rsquo;étude, les résultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une différence entre traduction et usage ?</h2>
<p>Cette différence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communauté WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles français utilise de manière naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plutôt que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques complètement différentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxBénard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son référencement WordPress</em>&nbsp;&raquo; est le seul à utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes différents pour désigner une seule et même chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communauté : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilisé par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour désigner cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confronté à un énorme problème d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;être perdus puisque le terme a changé dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et thèmes pouvaient récupérer la valeur de la traduction de cette chaîne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incohérences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous à changer nos appellations. Chaque membre de la communauté devrait alors remplacer de manière systématique sa manière de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en référencement naturel : pourquoi appeler un élément &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorité de personnes utilise un autre terme lors de ses recherches sur le web&#8230;</p>
<p>Je reste donc assez mitigé sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"38\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Mar 2015 06:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7406\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordPress 4.2 beta 2 La 2e beta de WordPress 4.2 (en) est disponible pour les tests. Des nouvelles de l&#8217;équipe de traduction Le WordCamp London a été l&#8217;occasion de parler de la traduction. Avec notamment l&#8217;arrivée d&#8217;une version française de Belgique (en). Nouvelle gestion des équipes de traduction (en). Le guide de la maintenance WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2942:\"<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;équipe de traduction</h3>
<ul>
<li>Le WordCamp London a été l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arrivée d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version française de Belgique (en)</a>.</li>
<li><a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des équipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a été exposée à des failles de sécurité importantes</a>. Réactive, l&rsquo;équipe de développement a publié une version qui corrige les problèmes.</p>
<h3>Pourquoi une agence a abandonné WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise expérience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de Noël</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndrôme Sapin de Noël </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour sécuriser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de sécurité</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Mar 2015 06:38:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"WPMX Day 2015 Le 6 juin prochain se tiendra le WPMX Day&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&#8217;ores et déjà en vente ! C&#8217;est le lendemain du WordCamp Lyon : le mois de juin sera formidable en termes de contenus et propagation d&#8217;idées au sein de la communauté [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3556:\"<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&rsquo;ores et déjà en vente !<br />
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;idées au sein de la communauté WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La première beta de WordPress 4.2 est disponible</a>. Il est rappelé qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de développement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au téléchargement. C&rsquo;est une version de sécurité : mettez à jour !<br />
&#8230;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug côté notifications.</p>
<h3>Une mise à jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise à jour automatique des extensions</a> (en) pour raison de sécurité est mise en place pour les versions supérieures ou égales à WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui ça existe</a> !</p>
<h3>Vulnérabilité dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vulnérabilité a été découverte dans WooCommerce</a> (en) par l&rsquo;équipe de WordFence. L&rsquo;équipe de Woo a rapidement réagit pour colmater la brèche.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&#8230; (en).</p>
<h3>Le guide pour débutant pour héberger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les débutants qui veulent se lancer dans l&rsquo;hébergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Mar 2015 06:39:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Thèmes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"Un guide des communautés WordPress Tom Zsomborgi et son équipe de Kinsta viennent de publier un guide des communautés WordPress à travers le monde. Personnaliser votre page de login Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : PWD WP Login (en). Les hooks des menus de navigation Pour [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3536:\"<h3>Un guide des communautés WordPress</h3>
<p>Tom Zsomborgi et son équipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communautés WordPress</a> à travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aurélien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel à candidature pour héberger l’événement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau répertoire de thèmes et d&rsquo;extensions</h3>
<p>Les répertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">thèmes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont été refondus. (en)</p>
<h3>Et si on écrivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;idée de Siobhan McKeown&#8230; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs à ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">Émilie indique les 8 erreurs</a> à ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t’anime jour et nuit, depuis ton plus jeune âge</em>&#8230; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&#8230; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°253 : WordPress 4.1.1 – WordPress 4.2 – Les communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/g7fUMHJTdiA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Feb 2015 06:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"communauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7388\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"WordPress Francophone : Le changement arrive Si vous l&#8217;avez raté, voici ce qu&#8217;il faut retenir de nos projets immédiats concernant l&#8217;association. WordPress 4.1.1 Cette semaine, la première version mineure de WordPress 4.1 est sortie. Cette 4.1.1 apporte nombre de corrections de bugs (en). Mettez à jour, si vous n&#8217;utilisez pas la mise à jour automatique. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3786:\"<h3>WordPress Francophone : Le changement arrive</h3>
<p>Si vous l&rsquo;avez raté, voici ce qu&rsquo;il faut retenir de <a title=\"L’association WordPress-Francophone : d’où elle vient et où elle va\" href=\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\">nos projets immédiats concernant l&rsquo;association</a>.</p>
<h3>WordPress 4.1.1</h3>
<p>Cette semaine, la première version mineure de WordPress 4.1 est sortie. <a href=\"https://wordpress.org/news/2015/02/wordpress-4-1-1/\">Cette 4.1.1 apporte nombre de corrections de bugs</a> (en). Mettez à jour, si vous n&rsquo;utilisez pas la mise à jour automatique.</p>
<h3>WordPress 4.2 : c&rsquo;est pour bientôt !</h3>
<p>La deadline pour WordPress 4.2 est <a href=\"https://make.wordpress.org/core/2015/02/22/4-2-enhancements-deadline-is-march-10th/http://\">fixée au 10 mars prochain</a> (en).</p>
<h3>Sondage BuddyPress 2015</h3>
<p>Si ce n&rsquo;est déjà fait, répondez à l&rsquo;<a href=\"http://mercime.polldaddy.com/s/2015-buddypress-survey\">enquête 2015 sur BuddyPress</a> (en).</p>
<h3>Les communautés locales en action</h3>
<ul>
<li><a href=\"https://www.facebook.com/events/1729936210565573/?ref=3&amp;ref_newsfeed_story_type=regular\">Meetup Languedoc : Aujourd&rsquo;hui, 24 février à 19 H 00</a></li>
<li><a href=\"http://www.wpinalps.com/#prochaine-rencontre\">WP in Alps : rencontre le 17 mars</a></li>
<li><a href=\"https://medium.com/@quakely/wordcamp-paris-15-310657f1688e\">WordCamp PAris 2015 : review</a> (en)</li>
</ul>
<h3>Beaver Builder 1.4.6 en français</h3>
<p>L&rsquo;annonce a été faite cette semaine sur Twitter, Beaver Builder est enfin disponible en français :</p>
<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/Web18_Paris\">@Web18_Paris</a> <a href=\"https://twitter.com/FrederiqueGame\">@FrederiqueGame</a> <a href=\"https://twitter.com/WordCampParis\">@WordCampParis</a> We just added a French translation in our latest update (1.4.6)!</p>
<p>&mdash; Beaver Builder (@BeaverBuilder) <a href=\"https://twitter.com/BeaverBuilder/status/567431867519860736\">February 16, 2015</a></p></blockquote>
<p><script async src=\"//platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>
<h3>Hexagone.io</h3>
<p><a href=\"https://hexagone.io/\">Une nouvelle plateforme de thèmes 100% française</a>.</p>
<h3>Comment trouver et choisir un thème</h3>
<p><a href=\"http://www.maintpress.com/blog/themes-wordpress-comment-trouver-et-choisir-votre-theme-wordpress/\">Voici des pistes de recherches et de sélection de thème</a> selon MaintPress.</p>
<h3>WP Serveur : le test</h3>
<p>Daniel Roch a <a href=\"http://www.seomix.fr/wp-serveur/\">testé pour vous le nouveau service d&rsquo;hébergement</a> de Fabrice : WP Serveur.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/g7fUMHJTdiA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"L’association WordPress-Francophone : d’où elle vient et où elle va\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BHlyW5QMwoY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Feb 2015 12:47:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Barcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7370\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Nombre d&#8217;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&#8217;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&#8217;un pendant francophone à WordPress.org (forum d&#8217;entraide, traduction, nouvelles, vitrine, Planet, etc.). L&#8217;association a été déclarée le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8950:\"<p>Nombre d&rsquo;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&rsquo;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&rsquo;un pendant francophone à WordPress.org (forum d&rsquo;entraide, traduction, nouvelles, vitrine, Planet, etc.).</p>
<p>L&rsquo;association a été déclarée le 9 juillet 2008 (bientôt 7 ans !), plus de trois ans après le lancement du site lui-même (dont le nom de domaine date du 25 août 2005 &#8212; bientôt 10 ans !), avec l&rsquo;objet suivant :</p>
<blockquote><p>&laquo;&nbsp;promouvoir, directement ou indirectement, le système de publication de contenu WordPress et sa version multiutilisateurs WordPress Mu ; l’association souhaite devenir l’interlocuteur privilégié des utilisateurs particuliers ou professionnels en offrant une représentation francophone de WordPress.&nbsp;&raquo;</p></blockquote>
<div id=\"attachment_7371\" style=\"width: 310px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7371 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/wpfr-asso-300x127.jpg\" alt=\"wpfr-asso-300x127\" width=\"300\" height=\"127\" /><p class=\"wp-caption-text\">Extrait du Journal Officiel du 26 juillet 2008.</p></div>
<p>Dans les faits, l&rsquo;association sert avant tout de façade légale pour le site et son forum, mais également de moyen de financer les barcamps que nous organisons à Paris (<a href=\"http://barcamp.org/w/page/405589/WordCampParis\">à l&rsquo;époque appelés WordCamp</a>) sans devoir passer par une société qui facturerait ces sponsoring. Ainsi, de la même manière que l&rsquo;association <a href=\"http://www.paris-web.fr/\">Paris-Web</a> est un regroupement des personnes qui organisent l&rsquo;évènement Paris Web (sans adhérents autres que les organisateurs), l&rsquo;association WPFR est un regroupement des personnes qui s&rsquo;occupent du site WPFR, de la traduction française de WordPress, et du WordCamp Paris.</p>
<p>Rapidement, nous avons su que nous ne devions pas limiter l&rsquo;association aux seuls membres fondateurs, et nous nous sommes lancés dans un travail de réécriture des statuts de l&rsquo;association, en s&rsquo;inspirant de ceux des autres associations en place : <a href=\"http://afup.org/pages/site/?route=vie-associative-afup/1/statuts-de-l-association-francaise-des-utilisateurs-de-php\">AFUP</a>, <a href=\"http://drupalfr.org/sites/default/files/Statuts-DrupalFF-2012.pdf\">Drupal FR</a>, <a href=\"http://wiki.postgresql.fr/asso:statuts\">PostgrSQLFR</a> et d&rsquo;autres déjà en place. Ce chantier est en discussion interne depuis plusieurs année, et le travail de rédaction est en place depuis avril 2012 (bientôt 3 ans !).</p>
<div id=\"attachment_7372\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7372 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/CaptureWPFRStatusWiki-500x327.png\" alt=\"CaptureWPFRStatusWiki\" width=\"500\" height=\"327\" /><p class=\"wp-caption-text\">Historique du wiki interne de WPFR pour les statuts (manque le règlement intérieur)</p></div>
<p>Le rythme était, pourrait-on dire, tectonique : nous y consacrions du temps&#8230; quand nous en avions. À savoir qu&rsquo;une fois le WordCamp devenu une conférence importante, cet évènement nous prenait le plus gros de notre temps libre consacré à WPFR, avec déjà la gestion du forum et des mails, les hebdos, les traductions, etc. Ajoutons à cela que je (Xavier) suis également co-organisateur de Paris Web, les années passaient vite, et Benoît était le plus dur à la tâche (mercis infinis à lui pour son dévouement inlassable à cette tâche !) &#8212; mais cela restait une tâche réalisée en interne, et pour les observateurs de l&rsquo;écosystème WordPress français, WPFR renvoyait l&rsquo;image d&rsquo;une association figée dans le temps (la v3 du site, Arlésienne s&rsquo;il en est, n&rsquo;a fait qu&rsquo;être repoussée malgré les efforts, au point qu&rsquo;une v4 rapide a failli être mise en place en août 2013, en vain &#8212; merci quand même Amaury !), là où nous voulions depuis des années nous ouvrir aux bonnes volontés.</p>
<p>Les WordCamp Paris et Europe ont été des catalyseurs importants. En mettant en avant des experts venus de toute la France, ou en faisant voyager ensemble des passionnés français lors de la grande réunion européenne, ces deux évènements (et leurs éditions 2013 et 2014) ont permis aux discussions de se lancer entre passionnés, et de faire remonter leurs attentes vis à vis de l&rsquo;association, ou même de monter leur propre association. Ravivée à chaque évènement, la flamme passionnée de ces professionnels attendait depuis trop longtemps une ouverture de l&rsquo;association. Et du côté du staff WPFR, à chaque WordCamp Paris, on se promettait de terminer et présenter ces nouveaux statuts. Lors de l’édition 2015, nous avons même prévu des fiches d’inscription pour les intéressés – et vous étiez nombreux !</p>
<p>Tout cela s&rsquo;est donc cristallisé lors du WordCamp Paris 2015, où la plupart des intéressés se sont retrouvés (soit au sein du staff, soit en orateurs) et ont pu échanger directement avec les membres actuels de l&rsquo;association (Benjamin, Benoît, Thierry et moi-même &#8212; Marie-Aude, vivant au Maroc, n&rsquo;a pas pu faire le déplacement). De critiques frontales à discussions ouvertes, nous avons compris qu&rsquo;il y avait un lourd passif d&rsquo;incompréhension entre ce que le staff voulait faire et la manière dont il était perçu, et qu&rsquo;il était urgent de corriger cela pour le bien de la communauté.</p>
<div id=\"attachment_7373\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57.jpg\"><img class=\"wp-image-7373 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57-500x281.jpg\" alt=\"\" width=\"500\" height=\"281\" /></a><p class=\"wp-caption-text\">Lors de la soirée du WordCamp Paris 2015, là où les discussions sur le sujet de l&rsquo;association ont duré plusieurs heures. Photo par Daniel Roch.</p></div>
<p>Nous avons convenu de travailler ensemble à terminer les statuts de la meilleure manière qui soit. Sur un site P2 privé sur WordPress.com, nous avons fait de belles progressions grâce à la participation de passionnés hors association (Alexandre, Amaury, Aurélien, Daniel, Émilie, Olivier, Frédéric, Grégoire, Jenny, Julien, Julio, et Maxime), et le résultat de ces échanges sera bientôt appliqué.</p>
<p>Afin d&rsquo;entamer cette ouverture de l&rsquo;association, voici la &laquo;&nbsp;roadmap&nbsp;&raquo; que nous nous sommes fixés pour réviser le fonctionnement de WPFR :</p>
<ul>
<li>15 février : finalisation des statuts de l’association.</li>
<li>15 mars : dépôt et publication des nouveaux statuts.</li>
<li>15 avril : communication à la communauté pour les inscriptions (ouverture aux adhérents, professionnels comme amateurs).</li>
<li>15 mai : organisation d’une AGE fondatrice avec le vote et l’élaboration du Bureau, du Conseil d&rsquo;Administration et du Conseil de Surveillance.</li>
</ul>
<p>Une fois le nouveau bureau en place, de nombreux projets seront lancés grâce à cette apport de bonnes volontés, pour le bien de toute la communauté &#8212; et plus que le WordCamp ! Parmi ceux-ci, la refonte du site tant attendant sera lancée (probablement même avant l&rsquo;arrivée du nouveau bureau) afin de renvoyer une image plus professionnelle et communautaire de notre association francophone.</p>
<p>Vous êtes intéressé(e) par l’évolution de l’association et ses futurs statuts ? <a title=\"Contact\" href=\"http://www.wordpress-fr.net/contact/\">Contactez-nous</a> !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BHlyW5QMwoY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"26\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"
		
		
		
		
		
				
		
		
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"L’Hebdo WordPress n°252 : WordCamp Lyon – Traduction – BuddyPress 2.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/TaQkF2Q_zkU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Feb 2015 06:26:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"WordCamp Lyon : c&#8217;est officiel ! C&#8217;est officiel, le 2e WordCamp français du nom sera Lyonnais, il est programmé le 5 juin et les premiers billets sont déjà en vente ! Sondage sur la traduction Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&#8217;est [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4797:\"<h3>WordCamp Lyon : c&rsquo;est officiel !</h3>
<p>C&rsquo;est officiel, le<a href=\"http://lyon.wordcamp.org/2015/\"> 2e WordCamp français du nom sera Lyonnais</a>, il est programmé le 5 juin et les premiers billets sont déjà en vente !</p>
<h3>Sondage sur la traduction</h3>
<p>Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&rsquo;est pas encore toujours utilisée partout. Et vous quel est votre avis sur la <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewform?c=0&amp;w=1\">question </a>?</p>
<h3>WordCamp Paris 2015 : d&rsquo;autres retours</h3>
<ul>
<li><a href=\"http://www.seomix.fr/organiser-un-evenement-wordpress/\">La conférence de Daniel Roch</a></li>
<li><a href=\"http://2015.extend.xiligroup.org/fr/107/wordcamp-paris-2015-quelques-notes/\">Les notes de Michel</a></li>
</ul>
<h3>WordPress 4.2 sera Emoji</h3>
<p>WordPress 4.2 sera le <a href=\"https://make.wordpress.org/core/2015/02/09/emoji-feature-plugin-for-4-2/\">WordPress des Emoji</a> (en) !</p>
<h3>BuddyPress 2.2 : Spumoni</h3>
<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\">BuddyPress 2.2</a> (en) est disponible depuis moins d&rsquo;une semaine, vous pouvez mettre à jour !</p>
<h3>Sécurité WordPress : les extensions pour éviter le pire</h3>
<p>Nicolas Birckel, orateur lors du dernier WordCamp Paris <a href=\"http://www.nicolas-birckel.fr/2015/02/04/securite-wordpress-quels-plugins-pour-anticiper-le-pire/\">nous parle de sécurité et d&rsquo;extensions</a>.</p>
<h3>You are awesome</h3>
<p>J&rsquo;ai retrouvé dans mes marque-pages, un lien que j&rsquo;ai du oublier de publier il y quelques semaines. Il s&rsquo;agit d&rsquo;un article de <a href=\"http://chrislema.com/you-are-awesome-thanks/\">Chris Lema qui remercie une partie de la communauté WordPress</a> (en) qui lui est chère.</p>
<h3>Une favicon facile ?</h3>
<p><a href=\"https://wordpress.org/plugins/pwd-wp-favicon/\">PWD WP Favicon</a> est une extension qui permet d&rsquo;avoir une favicon sur son site WordPress très simplement.</p>
<h3>La réussite de WP Rocket en chiffre</h3>
<p>WP Rocket, le <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\">succès </a>de notre French Team <a href=\"http://blog.wp-rocket.me/transparency-matters/\">expliqué en quelques chiffres</a> (en).</p>
<h3>Human Made acquiert Sennza</h3>
<p>Human Made <a href=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\">vient d&rsquo;acquérir l&rsquo;australien Sennza</a> (en).</p>
<h3>L&rsquo;extension Fancybox cible d&rsquo;une faille Zero-day</h3>
<p><a href=\"http://www.undernews.fr/alertes-securite/vulnerabilite-zero-day-plugin-wordpress-fancybox-for-wordpress.html\">L&rsquo;extension Fancybox s&rsquo;est vu entachée cette semaine d&rsquo;une faille de sécurité </a>grave de type zero-day. Une correction a depuis été apportée.</p>
<h3>Mise à jour du WordPress Reference</h3>
<p>Le fameux guide <a href=\"https://www.dbswebsite.com/design/wordpress-reference/V4/\">WordPress Reference</a> (en) vient de subir une mise à jour.</p>
<h3>Le magazine Programmez! parle WordPress</h3>
<p>Le magazine &laquo;&nbsp;Programmez!&nbsp;&raquo; à paraitre propose quelques pages consacrées à WordPress. Au programme des <a href=\"http://www.programmez.com/magazine/article/tests-unitaires-et-integration-continue-de-projets-wordpress\">tests unitaires </a>et de la<a href=\"http://www.programmez.com/magazine/article/creer-des-plugins-et-des-widgets-pour-wordpress\"> création d&rsquo;extensions</a>.</p>
<p>&nbsp;</p>
<p><em><strong>// Restez connectés&#8230; bientôt une grande annonce de l&rsquo;association WordPress Francophone !</strong></em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/TaQkF2Q_zkU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"L’Hebdo WordPress n°251 : WordCamp Paris – WP Valence – Collectif WP Suisse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/vXxg-7UMZ2c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 06:43:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Commnauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7355\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordCamp Paris 2015 : c&#8217;était il y a 10 jours ! Cela fait déjà 10 jours que les portes du WordCamp Paris ce sont refermées. Mais vous êtes nombreux à en parler encore : Maxime BJ de WP-Spread Les photos d&#8217;Adrian WP Marmite Les 5 conférences préférées de Nicolas Birckel Un instantanée Planet Hoster... et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5341:\"<h3>WordCamp Paris 2015 : c&rsquo;était il y a 10 jours !</h3>
<p>Cela fait déjà 10 jours que les portes du <a href=\"http://2015.paris.wordcamp.org/le-wordcamp-paris-2015-a-ferme-ses-portes-rendez-vous-en-2016/\">WordCamp Paris ce sont refermées</a>. Mais vous êtes nombreux à en parler encore :</p>
<ul>
<li><a href=\"http://www.wp-spread.com/compte-rendu-wordcamp-2015\">Maxime BJ de WP-Spread</a></li>
<li><a href=\"https://www.icloud.com/photostream/fr-fr/#A3GgZLKuGjtl7D\">Les photos d&rsquo;Adrian</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-paris-2015/\">WP Marmite</a></li>
<li><a href=\"http://www.nicolas-birckel.fr/2015/01/26/les-5-conferences-que-jai-apprecie-a-wordcamp-paris-2015/\">Les 5 conférences préférées de Nicolas Birckel </a></li>
<li><a href=\"http://instagram.com/p/yUbRnzRn29/\">Un instantanée</a></li>
<li><a href=\"http://blog.planethoster.net/wordcamp-paris-retour-un-succes/\">Planet Hoster.</a>.. et ses chocolats pour caler les meubles ou aussi pour manger ! ^^&rsquo;</li>
</ul>
<p>&#8230; et quelques conférences :</p>
<ul>
<li><a href=\"http://www.frederiquegame.fr/presentation-de-ma-conference-au-wordpress-camp-paris/\">Frédérique Game</a></li>
<li><a href=\"http://boiteaweb.fr/traduction-wordpress-vous-faites-fausse-route-8518.html\">Julio Potier</a></li>
<li><a href=\"http://fr.slideshare.net/SeoMix/organiser-un-vnement-wordpress-wordcamp-paris-2015\">Daniel Roch</a></li>
<li><a href=\"http://tweetpressfr.github.io/blog/wcparis-2015/#/\">Julien Maury</a></li>
<li><a href=\"http://t.co/h3bo7ByTqy\">Aurélien Denis</a></li>
<li>&#8230; les autres seront bientôt toutes en ligne sur le site du WordCamp et en vidéo bientôt sur wordpress.tv.</li>
</ul>
<p>En attendant, le prochain événement qui compte dans la communauté se déroule ce soir :</p>
<h3>Premier meetup Valence</h3>
<p>La communauté WordPress de Valence organise son <a href=\"www.wp-spread.com/demain-cest-le-premier-meetup-valence\">premier meetup ce soir.</a> Toutes les informations sont sur le <a href=\"http://wpvalence.fr/\">site officiel.</a></p>
<h3>WordPress Suisse</h3>
<p><a href=\"http://collectifwp.ch/\">Un collectif WordPress Suisse</a> a vu le jour en ligne quelques jours avant le WordCamp Paris. Ce groupe est emmené par Patricia, Manuel, Gilles et d&rsquo;autres&#8230; bienvenue !</p>
<h3>WordPress 4.2 est lancé</h3>
<p>WordPress 4.2 a son lead dev : <a href=\"https://make.wordpress.org/core/2015/01/21/drew-jaynes-is-the-4-2-release-lead/\">Drew Jaynes (en).</a>.. et aussi une première ligne de conduite, <a href=\"https://make.wordpress.org/core/2015/01/31/improving-mobile-flow-in-4-2/\">à savoir le mobile</a> (en)&#8230; et aussi le <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-theme-switcher-update/\">personnaliseur de thèmes</a> (en).</p>
<h3>Un nouveau service d&rsquo;hébergement français</h3>
<p>WP-Serveur en termine avec sa période beta pour s&rsquo;ouvrir à la clientèle dès le 9 février 2015. Vous pouvez d&rsquo;ores et déjà <a href=\"https://www.wpserveur.net/\">découvrir les offres et les services sur le site web</a>.</p>
<h3>Quelques sites références WP selon une bloggeuse</h3>
<p><a href=\"http://yesweblog.fr/2015/01/les-sites-references-pour-apprendre-sur-wordpress/\">Quelques avis de bloggeuse</a> sur WordPress&#8230;</p>
<h3>Par Toutatis, un nouveau thème</h3>
<p>Un nouveau thème gratuit et français en plus&#8230; <a href=\"https://www.themesdefrance.fr/theme-wordpress-gratuit-toutatis/\">Toutatis est à découvrir ici</a>.</p>
<h3>Google Analytics et WordPress</h3>
<p>MaintPress explique <a href=\"http://www.maintpress.com/blog/google-analytics-wordpress-tirez-maximum-outil-puissant/\">comment utiliser Google Analytics</a> avec WordPress.</p>
<h3>12 extensions Chrome pour WordPress</h3>
<p>Si vous utilisez Chrome comme navigateur, <a href=\"http://torquemag.io/12-google-chrome-browser-extensions-wordpress-users/\">voici des extensions pour vous</a>. (en)</p>
<h3>Interview de Quentin Ravinet</h3>
<p>WP Marmite <a href=\"http://wpmarmite.com/interview-quentin-ravinet/\">interviewe Quentin Ravinet</a>, développeur de thème s&rsquo;est lancé dans l&rsquo;aventure Themeforest.</p>
<h3>Qu&rsquo;est-ce qu&rsquo;une barre latérale ?</h3>
<p><a href=\"http://wpmarmite.com/sidebar-wordpress/\">WP Marmite vous dit tout </a>!</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/vXxg-7UMZ2c\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"L’Hebdo WordPress n°250 : Je suis Charlie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LSx7EEVudz8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jan 2015 21:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7349\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&#8217;oublions pas ! &#8230; N&#8217;oublions surtout pas cette chance que nous avons [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&rsquo;oublions pas ! &#8230; N&rsquo;oublions surtout pas cette chance que nous avons de pouvoir exprimer nos idées quelles qu&rsquo;elles soient.</p>
<p>Notre communauté existe grâce à cette liberté, WordPress aussi par extension. #JeSuisCharlie #NousSommesCharlie</p>
<p><em><a href=\"http://boiteaweb.fr/je-suis-charlie-8500.html\">Montrez votre soutien grâce à l&rsquo;extension de Julio</a></em>.</p>
<h2>L&rsquo;Hebdo</h2>
<h3>Le WordCamp Paris 2015 c&rsquo;est dans 10 jours</h3>
<p>Eh oui ! Déjà ! &#8230; <a href=\"http://www.nicolas-birckel.fr/2015/01/09/a-la-fin-du-mois-je-serais-a-wordcamp-paris-2015-et-vous/\">Nicolas Birckel en parle</a>. Et vous ?</p>
<h3>BuddyPress 2.2 beta 1</h3>
<p>BuddyPress 2.2 poursuit son développement et <a href=\"https://buddypress.org/2015/01/buddypress-2-2-beta-1/\">sort en beta 1</a> (en).</p>
<h3>Passons à table n°10 : FX Bénard</h3>
<p><a href=\"http://wpmarmite.com/pat-episode-010/\">Interview de FX Bénard</a> par WPMarmite.</p>
<h3>Intégrer Slack dans WordPress</h3>
<p>Voici comment <a href=\"http://www.wpbeginner.com/plugins/how-to-integrate-slack-with-wordpress/\">intégrer Slack dans WordPress</a> (en).</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LSx7EEVudz8\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"L’Hebdo WordPress n°249 : Bonne Année 2015 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/20scgnJiK4c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 06:44:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7343\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"Bonne année 2015 ! Toute l&#8217;équipe de l&#8217;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets. Notre communauté va arroser ses 10 ans d&#8217;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&#8217;est en bonne voie, on croise les [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4689:\"<h2>Bonne année 2015 !</h2>
<p>Toute l&rsquo;équipe de l&rsquo;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets.</p>
<p>Notre communauté va arroser ses 10 ans d&rsquo;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&rsquo;est en bonne voie, on croise les doigts). Le premier événement de l&rsquo;année est bien sur le <a href=\"http://2015.paris.wordcamp.org/\">WordCamp Paris 2015</a> , les 23 et 24 janvier prochains. Suivrons, j&rsquo;espère, plein d&rsquo;autres belles surprises. Restez connectés !</p>
<p>&nbsp;</p>
<h2>Place à l&rsquo;Hebdo !</h2>
<h3>WPMX Session #8</h3>
<p>WPMX, l&rsquo;association WordPress du Sud Ouest, présente sa <a href=\"http://wpchannel.com/meetup-wpmx-8-wordpress-securite/\">8e session consacrée à la sécurité</a> le 15 janvier 2015 en présence de Julio Potier.</p>
<h3>Brute Protect</h3>
<p><a href=\"https://bruteprotect.com/the-jetpack-bloat-myth/\">Brute Protect s&rsquo;explique (en)</a> suite à son rachat par <a href=\"http://ma.tt/2015/01/jetpack-speed/\">Automattic (en)</a>.</p>
<h3>Les choses à faire après l&rsquo;installation de WordPress</h3>
<p>Dès lors que votre site WordPress est installé, <a href=\"http://www.labnol.org/internet/wordpress-optimization-guide/3931/\">pensez à ces quelques étapes</a> ! (en)</p>
<h3>Un peu d&rsquo;histoire</h3>
<p>WordPress a passé la dizaine, faire un peu d&rsquo;<a href=\"http://wptavern.com/historic-wordpress-project-seeks-contributors\">histoire peut être intéressant</a> (en).</p>
<h3>Post format, inconnu et déjà mort ?</h3>
<p><a href=\"http://www.poststat.us/post-formats-looking-back/\">Petite discussion autour des Post Format</a> qui sont sous exploités (en).</p>
<h3>WordPress en 2015</h3>
<p>Noel Tock nous livre sa vision de <a href=\"https://medium.com/@noeltock/wordpress-in-2015-ed6a4674a608\">WordPress en 2015</a> (en).</p>
<h3>6 extensions indispensables</h3>
<p><a href=\"http://www.tanguy-nicolas.com/extensions-indispensables-blog-wordpress/\">Les 6 extensions indispensables</a> selon Tanguy Nicolas.</p>
<h3>L&rsquo;année de WP Marmite</h3>
<p><a href=\"http://wpmarmite.com/recapitulatif-2014-plans-2015/\">WP Marmite est apparu en 2014</a>, voici une rétrospective et les projets à venir.</p>
<h3>Tout savoir le nouveau mode d&rsquo;écriture sans distraction</h3>
<p>Voici tout ce que vous devriez savoir sur <a href=\"http://premium.wpmudev.org/blog/distraction-free-mode-wordpress/\">le nouveau mode d&rsquo;écriture sans distraction</a> (en).</p>
<h3>Le livre WordPress de Christophe Aubry</h3>
<p>WPChannel présente le livre de <a href=\"http://wpchannel.com/wordpress-gerer-site-multi-utilisateur-christophe-aubry/\">Christophe Aubry sur WordPress</a>.</p>
<h3>Les résolutions 2015 de Julio</h3>
<p>Julio prends de bonne résultions 2015 pour WordPress et <a href=\"http://boiteaweb.fr/resolutions-wordpress-2015-dans-vos-developpements-8487.html\">vous les partage</a>.</p>
<h3>Le thème 2015 par Rodrigue</h3>
<p>Rodrigue propose une <a href=\"http://www.cree1site.com/review-du-theme-wordpress-twenty-fifteen/\">revue du thème par défaut &laquo;&nbsp;Twenty Fifteen&nbsp;&raquo;</a>.</p>
<h3>Les commentaires et leurs interactions</h3>
<p>WP Formation fait le tour des <a href=\"http://wpformation.com/commentaires-wordpress-interaction/\">bonnes pratiques en terme de commentaires</a>.</p>
<h3>Genesis : créer son accueil</h3>
<p>Grégoire présente la façon de <a href=\"http://www.gregoirenoyelle.com/genesis-comprendre-creer-page-accueil-wordpress-sur-mesure/\">créer une page d&rsquo;accueil avec Genesis</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/20scgnJiK4c\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:48:\"http://feeds.feedburner.com/WordpressFrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:9:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Mon, 20 Apr 2015 13:47:34 GMT\";s:4:\"date\";s:29:\"Mon, 20 Apr 2015 13:59:29 GMT\";s:7:\"expires\";s:29:\"Mon, 20 Apr 2015 13:59:29 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:11:\"80:quic,p=1\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("7724","_transient__bbp_2a01:e35:2e1e:d280:e4ee:792d:4e43:9768_last_post","1401444151","yes");
INSERT INTO `wp_options` VALUES("502","_bbp_topic_slug","sujet","yes");
INSERT INTO `wp_options` VALUES("503","_bbp_topic_tag_slug","mot-cle","yes");
INSERT INTO `wp_options` VALUES("504","_bbp_view_slug","voir-le-sujet","yes");
INSERT INTO `wp_options` VALUES("505","_bbp_reply_slug","répondre","yes");
INSERT INTO `wp_options` VALUES("506","_bbp_search_slug","rechercher","yes");
INSERT INTO `wp_options` VALUES("507","_bbp_user_slug","utilisateurs","yes");
INSERT INTO `wp_options` VALUES("508","_bbp_topic_archive_slug","sujets","yes");
INSERT INTO `wp_options` VALUES("509","_bbp_reply_archive_slug","réponses","yes");
INSERT INTO `wp_options` VALUES("510","_bbp_user_favs_slug","favoris","yes");
INSERT INTO `wp_options` VALUES("511","_bbp_user_subs_slug","souscrire","yes");
INSERT INTO `wp_options` VALUES("115780","_transient_timeout_wp-piwik_c797cee1930e0d27d2673c178c943ab3","1429954389","no");
INSERT INTO `wp_options` VALUES("99130","_transient_timeout_feed_mod_2fb9572e3d6a42f680e36370936a57ae","1427747214","no");
INSERT INTO `wp_options` VALUES("99131","_transient_feed_mod_2fb9572e3d6a42f680e36370936a57ae","1427704014","no");
INSERT INTO `wp_options` VALUES("117869","_site_transient_timeout_browser_48ce97d67f5c394f5ce1d5ccaf049307","1430143164","yes");
INSERT INTO `wp_options` VALUES("117870","_site_transient_browser_48ce97d67f5c394f5ce1d5ccaf049307","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"37.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("101709","theme_mods_twentyfifteen","a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1427960171;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:18:\"newsletterwidget-2\";i:1;s:22:\"oauth_twitter_widget-2\";}s:9:\"sidebar-1\";a:0:{}s:18:\"orphaned_widgets_1\";a:1:{i:0;s:19:\"bbp_forums_widget-3\";}s:18:\"orphaned_widgets_2\";a:1:{i:0;s:18:\"googlemapswidget-2\";}s:18:\"orphaned_widgets_3\";a:0:{}s:18:\"orphaned_widgets_4\";a:1:{i:0;s:18:\"bbp_login_widget-2\";}s:18:\"orphaned_widgets_5\";a:1:{i:0;s:19:\"bbp_topics_widget-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES("117877","_transient_timeout_feed_mod_1835d2eaaf967b5cddcf4dbccdcaeab9","1429581577","no");
INSERT INTO `wp_options` VALUES("117878","_transient_feed_mod_1835d2eaaf967b5cddcf4dbccdcaeab9","1429538377","no");
INSERT INTO `wp_options` VALUES("99146","_site_transient_timeout_browser_6405adb15b203b9da650c82d6da703bc","1428309245","yes");
INSERT INTO `wp_options` VALUES("99147","_site_transient_browser_6405adb15b203b9da650c82d6da703bc","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:5:\"5.0.6\";s:10:\"update_url\";s:28:\"http://www.apple.com/safari/\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/safari.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/safari.png\";s:15:\"current_version\";s:1:\"5\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("114268","updraft_encryptionphrase","","yes");
INSERT INTO `wp_options` VALUES("114269","updraft_service","ftp","yes");
INSERT INTO `wp_options` VALUES("114270","updraft_s3","a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114271","updraft_ftp","a:4:{s:4:\"host\";s:22:\"ftp.cluster003.ovh.net\";s:4:\"user\";s:7:\"pigiste\";s:4:\"pass\";s:9:\"piges2014\";s:4:\"path\";s:20:\"48heures_sauvegardes\";}","yes");
INSERT INTO `wp_options` VALUES("99268","can_compress_scripts","0","yes");
INSERT INTO `wp_options` VALUES("99228","_transient__bbp_112.111.184.211_last_posted","1427711663","yes");
INSERT INTO `wp_options` VALUES("99247","_transient__bbp_117.169.1.15_last_posted","1427713385","yes");
INSERT INTO `wp_options` VALUES("99254","_transient__bbp_120.203.149.104_last_posted","1427714156","yes");
INSERT INTO `wp_options` VALUES("60280","_transient__bbp_118.244.255.72_last_posted","1423090281","yes");
INSERT INTO `wp_options` VALUES("44078","_transient__bbp_62.210.91.186_last_posted","1420523537","yes");
INSERT INTO `wp_options` VALUES("44155","_transient__bbp_46.161.41.31_last_posted","1420039318","yes");
INSERT INTO `wp_options` VALUES("80475","_transient__bbp_183.220.195.144_last_posted","1425622388","yes");
INSERT INTO `wp_options` VALUES("80517","_transient__bbp_124.205.129.97_last_posted","1425632059","yes");
INSERT INTO `wp_options` VALUES("81205","_transient__bbp_118.97.129.26_last_posted","1425946347","yes");
INSERT INTO `wp_options` VALUES("114274","updraft_cloudfiles","a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114275","updraft_bitcasa","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114276","updraft_copycom","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114277","updraft_openstack","a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("114278","updraft_googledrive","a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}","yes");
INSERT INTO `wp_options` VALUES("114279","updraft_sftp_settings","","yes");
INSERT INTO `wp_options` VALUES("114280","updraft_webdav_settings","","yes");
INSERT INTO `wp_options` VALUES("114281","updraft_ssl_nossl","0","yes");
INSERT INTO `wp_options` VALUES("114282","updraft_log_syslog","0","yes");
INSERT INTO `wp_options` VALUES("114283","updraft_ssl_useservercerts","0","yes");
INSERT INTO `wp_options` VALUES("114284","updraft_ssl_disableverify","0","yes");
INSERT INTO `wp_options` VALUES("44604","_transient__bbp_46.161.41.34_last_posted","1427715262","yes");
INSERT INTO `wp_options` VALUES("47095","_transient__bbp_118.97.195.42_last_posted","1420695170","yes");
INSERT INTO `wp_options` VALUES("59878","_transient__bbp_94.23.200.91_last_posted","1423043475","yes");
INSERT INTO `wp_options` VALUES("65286","_transient__bbp_218.204.141.204_last_posted","1426315447","yes");
INSERT INTO `wp_options` VALUES("48118","_transient__bbp_222.77.203.168_last_posted","1420893501","yes");
INSERT INTO `wp_options` VALUES("48299","_transient__bbp_74.91.20.250_last_posted","1420929729","yes");
INSERT INTO `wp_options` VALUES("49887","_transient__bbp_219.93.183.102_last_posted","1423806568","yes");
INSERT INTO `wp_options` VALUES("50283","_transient__bbp_27.159.225.139_last_posted","1421389418","yes");
INSERT INTO `wp_options` VALUES("50518","_transient__bbp_121.205.244.37_last_posted","1421443204","yes");
INSERT INTO `wp_options` VALUES("51199","_transient__bbp_203.144.144.162_last_posted","1421618332","yes");
INSERT INTO `wp_options` VALUES("51473","_transient__bbp_192.3.34.98_last_posted","1422106978","yes");
INSERT INTO `wp_options` VALUES("68434","_transient__bbp_183.222.152.174_last_posted","1423981537","yes");
INSERT INTO `wp_options` VALUES("68532","_transient__bbp_114.255.183.174_last_posted","1424435586","yes");
INSERT INTO `wp_options` VALUES("52528","_transient__bbp_195.154.181.152_last_posted","1427715152","yes");
INSERT INTO `wp_options` VALUES("52729","_transient__bbp_110.89.37.30_last_posted","1421979198","yes");
INSERT INTO `wp_options` VALUES("52763","_transient__bbp_27.159.225.207_last_posted","1421986737","yes");
INSERT INTO `wp_options` VALUES("55617","_transient__bbp_94.23.11.68_last_posted","1423752012","yes");
INSERT INTO `wp_options` VALUES("55999","_transient__bbp_37.57.231.241_last_posted","1423316577","yes");
INSERT INTO `wp_options` VALUES("56000","_transient__bbp_46.118.127.156_last_posted","1423212605","yes");
INSERT INTO `wp_options` VALUES("56818","_transient__bbp_198.204.252.211_last_posted","1425266094","yes");
INSERT INTO `wp_options` VALUES("56998","_transient__bbp_190.41.100.17_last_posted","1422682180","yes");
INSERT INTO `wp_options` VALUES("57317","_transient__bbp_104.194.28.210_last_posted","1422714916","yes");
INSERT INTO `wp_options` VALUES("57547","_transient__bbp_31.184.238.187_last_posted","1422748425","yes");
INSERT INTO `wp_options` VALUES("58022","_transient__bbp_60.9.141.66_last_posted","1422810885","yes");
INSERT INTO `wp_options` VALUES("58304","_transient__bbp_177.223.0.26_last_posted","1422846724","yes");
INSERT INTO `wp_options` VALUES("58344","_transient__bbp_76.164.202.114_last_posted","1422852498","yes");
INSERT INTO `wp_options` VALUES("59179","_transient__bbp_95.37.148.100_last_posted","1422960496","yes");
INSERT INTO `wp_options` VALUES("59361","_transient__bbp_218.104.239.12_last_posted","1426555022","yes");
INSERT INTO `wp_options` VALUES("59371","_transient__bbp_46.161.41.199_last_posted","1423068333","yes");
INSERT INTO `wp_options` VALUES("59491","_transient__bbp_114.44.209.214_last_posted","1422998088","yes");
INSERT INTO `wp_options` VALUES("59546","_transient__bbp_198.27.66.79_last_posted","1425787831","yes");
INSERT INTO `wp_options` VALUES("113906","itsec_data","a:5:{s:5:\"build\";i:4036;s:20:\"activation_timestamp\";i:1429192993;s:17:\"already_supported\";b:0;s:15:\"setup_completed\";b:1;s:18:\"tooltips_dismissed\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("113907","itsec_global","a:24:{s:11:\"write_files\";b:1;s:18:\"notification_email\";a:1:{i:0;s:20:\"cyrille@venerque.net\";}s:12:\"digest_email\";b:1;s:12:\"backup_email\";a:1:{i:0;s:20:\"cyrille@venerque.net\";}s:15:\"lockout_message\";s:14:\"error - erreur\";s:20:\"user_lockout_message\";s:158:\"You have been locked out due to too many invalid login attempts.
Vous avez été bloquée suite à un trop grand nombre de tentatives de connexion invalides.\";s:25:\"community_lockout_message\";s:153:\"Your IP address has been flagged as a threat by the iThemes Security network.
Votre adresse IP a été marquée comme une menace par iThemes sécurité.\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:1:{i:0;s:13:\"78.206.68.131\";}s:19:\"email_notifications\";b:1;s:8:\"log_type\";i:2;s:12:\"log_rotation\";i:14;s:12:\"log_location\";s:63:\"/home/pigiste/48heures/wp-content/uploads/ithemes-security/logs\";s:14:\"allow_tracking\";b:1;s:11:\"did_upgrade\";b:0;s:10:\"nginx_file\";s:33:\"/home/pigiste/48heures/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:8:\"log_info\";s:21:\"les-48h-de-la-pige-QJ\";s:9:\"lock_file\";b:0;s:14:\"proxy_override\";b:0;s:14:\"hide_admin_bar\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113908","itsec_initials","a:3:{s:5:\"login\";b:0;s:5:\"admin\";b:0;s:11:\"file_editor\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("16530","_transient__bbp_82.230.168.8_last_posted","1404140205","yes");
INSERT INTO `wp_options` VALUES("17154","_transient__bbp_90.8.46.50_last_posted","1403889121","yes");
INSERT INTO `wp_options` VALUES("17064","_transient__bbp_92.149.9.100_last_posted","1403880354","yes");
INSERT INTO `wp_options` VALUES("17578","_transient__bbp_90.61.162.114_last_posted","1403952777","yes");
INSERT INTO `wp_options` VALUES("17638","_transient__bbp_213.111.4.73_last_posted","1403963158","yes");
INSERT INTO `wp_options` VALUES("18570","_transient__bbp_37.163.65.189_last_posted","1404132532","yes");
INSERT INTO `wp_options` VALUES("18587","_transient__bbp_90.83.121.65_last_posted","1404222127","yes");
INSERT INTO `wp_options` VALUES("18733","_transient__bbp_82.226.37.175_last_posted","1404149336","yes");
INSERT INTO `wp_options` VALUES("18814","_transient__bbp_31.39.169.47_last_posted","1404157140","yes");
INSERT INTO `wp_options` VALUES("19091","_transient__bbp_78.250.64.139_last_posted","1404197517","yes");
INSERT INTO `wp_options` VALUES("19258","_transient__bbp_84.103.193.190_last_posted","1404215558","yes");
INSERT INTO `wp_options` VALUES("3492","_transient__bbp_82.247.140.57_last_posted","1401864189","yes");
INSERT INTO `wp_options` VALUES("38628","_transient__bbp_94.23.59.169_last_posted","1418617334","yes");
INSERT INTO `wp_options` VALUES("38894","_transient__bbp_27.159.211.141_last_posted","1417774064","yes");
INSERT INTO `wp_options` VALUES("39808","_transient__bbp_62.210.82.82_last_posted","1418507363","yes");
INSERT INTO `wp_options` VALUES("13315","_transient__bbp_78.127.17.164_last_posted","1402914057","yes");
INSERT INTO `wp_options` VALUES("13337","_transient__bbp_198.147.19.2_last_posted","1404293672","yes");
INSERT INTO `wp_options` VALUES("13370","_transient__bbp_82.233.72.204_last_posted","1403132586","yes");
INSERT INTO `wp_options` VALUES("7883","_transient__bbp_82.224.188.52_last_posted","1401712310","yes");
INSERT INTO `wp_options` VALUES("7884","_transient__bbp_82.254.176.76_last_posted","1401715515","yes");
INSERT INTO `wp_options` VALUES("7903","_transient__bbp_78.206.68.131_last_posted","1404210992","yes");
INSERT INTO `wp_options` VALUES("7908","_transient__bbp_92.150.170.112_last_posted","1401811615","yes");
INSERT INTO `wp_options` VALUES("13509","_transient__bbp_84.100.218.48_last_posted","1403275532","yes");
INSERT INTO `wp_options` VALUES("13848","_transient__bbp_90.55.15.115_last_posted","1403365456","yes");
INSERT INTO `wp_options` VALUES("13775","_transient__bbp_78.123.29.27_last_posted","1403349667","yes");
INSERT INTO `wp_options` VALUES("14117","_transient__bbp_78.239.128.36_last_posted","1403427818","yes");
INSERT INTO `wp_options` VALUES("14578","_transient__bbp_78.113.57.88_last_posted","1403516858","yes");
INSERT INTO `wp_options` VALUES("14582","_transient__bbp_109.30.200.11_last_posted","1403517292","yes");
INSERT INTO `wp_options` VALUES("15127","_transient__bbp_109.10.28.239_last_posted","1403594034","yes");
INSERT INTO `wp_options` VALUES("38547","_transient__bbp_120.37.238.71_last_posted","1417603897","yes");
INSERT INTO `wp_options` VALUES("62161","_transient__bbp_183.62.60.100_last_posted","1426639085","yes");
INSERT INTO `wp_options` VALUES("62171","_transient__bbp_121.31.5.182_last_posted","1426235563","yes");
INSERT INTO `wp_options` VALUES("62172","_transient__bbp_88.150.136.178_last_posted","1427683163","yes");
INSERT INTO `wp_options` VALUES("62188","_transient__bbp_218.206.83.89_last_posted","1427343280","yes");
INSERT INTO `wp_options` VALUES("62210","_transient__bbp_190.201.61.95_last_posted","1423315302","yes");
INSERT INTO `wp_options` VALUES("62223","_transient__bbp_190.204.197.229_last_posted","1423518386","yes");
INSERT INTO `wp_options` VALUES("62233","_transient__bbp_101.71.27.27_last_posted","1423631092","yes");
INSERT INTO `wp_options` VALUES("62246","_transient__bbp_60.191.205.70_last_posted","1424416238","yes");
INSERT INTO `wp_options` VALUES("62268","_transient__bbp_104.230.38.176_last_posted","1423320747","yes");
INSERT INTO `wp_options` VALUES("62281","_transient__bbp_183.220.105.140_last_posted","1423322009","yes");
INSERT INTO `wp_options` VALUES("62285","_transient__bbp_111.13.55.3_last_posted","1427155185","yes");
INSERT INTO `wp_options` VALUES("62334","_transient__bbp_120.203.149.162_last_posted","1427416008","yes");
INSERT INTO `wp_options` VALUES("62347","_transient__bbp_101.71.27.120_last_posted","1427714260","yes");
INSERT INTO `wp_options` VALUES("62366","_transient__bbp_117.135.250.68_last_posted","1423406217","yes");
INSERT INTO `wp_options` VALUES("62385","_transient__bbp_218.204.89.114_last_posted","1423333046","yes");
INSERT INTO `wp_options` VALUES("62405","_transient__bbp_113.207.130.182_last_posted","1423836199","yes");
INSERT INTO `wp_options` VALUES("62427","_transient__bbp_117.169.1.70_last_posted","1426431527","yes");
INSERT INTO `wp_options` VALUES("62443","_transient__bbp_183.220.198.22_last_posted","1423378481","yes");
INSERT INTO `wp_options` VALUES("62444","_transient__bbp_151.236.242.8_last_posted","1423338527","yes");
INSERT INTO `wp_options` VALUES("62478","_transient__bbp_180.166.69.1_last_posted","1427368461","yes");
INSERT INTO `wp_options` VALUES("62488","_transient__bbp_190.198.108.145_last_posted","1423658248","yes");
INSERT INTO `wp_options` VALUES("62498","_transient__bbp_61.53.143.179_last_posted","1426873836","yes");
INSERT INTO `wp_options` VALUES("62541","_transient__bbp_123.30.189.246_last_posted","1423488818","yes");
INSERT INTO `wp_options` VALUES("62566","_transient__bbp_201.210.36.230_last_posted","1423352814","yes");
INSERT INTO `wp_options` VALUES("62585","_transient__bbp_219.93.183.93_last_posted","1427633439","yes");
INSERT INTO `wp_options` VALUES("62586","_transient__bbp_190.78.171.12_last_posted","1423354630","yes");
INSERT INTO `wp_options` VALUES("62632","_transient__bbp_177.0.118.245_last_posted","1424401588","yes");
INSERT INTO `wp_options` VALUES("62638","_transient__bbp_113.207.130.166_last_posted","1425610154","yes");
INSERT INTO `wp_options` VALUES("62648","_transient__bbp_117.177.240.29_last_posted","1427603066","yes");
INSERT INTO `wp_options` VALUES("62664","_transient__bbp_175.44.9.27_last_posted","1423362295","yes");
INSERT INTO `wp_options` VALUES("25328","_transient__bbp_85.28.10.73_last_posted","1405506750","yes");
INSERT INTO `wp_options` VALUES("25497","_transient__bbp_41.231.53.43_last_posted","1405571465","yes");
INSERT INTO `wp_options` VALUES("25684","_transient__bbp_5.79.73.142_last_posted","1406245602","yes");
INSERT INTO `wp_options` VALUES("25695","_transient__bbp_46.165.225.198_last_posted","1405651297","yes");
INSERT INTO `wp_options` VALUES("25915","_transient__bbp_95.211.192.231_last_posted","1406152488","yes");
INSERT INTO `wp_options` VALUES("480","_bbp_edit_lock","5","yes");
INSERT INTO `wp_options` VALUES("481","_bbp_throttle_time","10","yes");
INSERT INTO `wp_options` VALUES("482","_bbp_allow_anonymous","0","yes");
INSERT INTO `wp_options` VALUES("483","_bbp_allow_global_access","1","yes");
INSERT INTO `wp_options` VALUES("484","_bbp_default_role","bbp_participant","yes");
INSERT INTO `wp_options` VALUES("485","_bbp_allow_revisions","1","yes");
INSERT INTO `wp_options` VALUES("486","_bbp_enable_favorites","1","yes");
INSERT INTO `wp_options` VALUES("487","_bbp_enable_subscriptions","1","yes");
INSERT INTO `wp_options` VALUES("488","_bbp_allow_topic_tags","1","yes");
INSERT INTO `wp_options` VALUES("489","_bbp_allow_search","1","yes");
INSERT INTO `wp_options` VALUES("490","_bbp_use_wp_editor","1","yes");
INSERT INTO `wp_options` VALUES("491","_bbp_use_autoembed","1","yes");
INSERT INTO `wp_options` VALUES("492","_bbp_thread_replies_depth","2","yes");
INSERT INTO `wp_options` VALUES("493","_bbp_allow_threaded_replies","0","yes");
INSERT INTO `wp_options` VALUES("494","_bbp_topics_per_page","15","yes");
INSERT INTO `wp_options` VALUES("495","_bbp_replies_per_page","15","yes");
INSERT INTO `wp_options` VALUES("496","_bbp_topics_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("497","_bbp_replies_per_rss_page","25","yes");
INSERT INTO `wp_options` VALUES("498","_bbp_root_slug","forum","yes");
INSERT INTO `wp_options` VALUES("499","_bbp_include_root","1","yes");
INSERT INTO `wp_options` VALUES("500","_bbp_show_on_root","forums","yes");
INSERT INTO `wp_options` VALUES("147","db_upgraded","","yes");
INSERT INTO `wp_options` VALUES("8625","_transient__bbp_88.180.124.214_last_posted","1403734526","yes");
INSERT INTO `wp_options` VALUES("9719","_transient__bbp_178.137.163.60_last_posted","1402175272","yes");
INSERT INTO `wp_options` VALUES("10222","_transient__bbp_82.249.73.117_last_posted","1402322808","yes");
INSERT INTO `wp_options` VALUES("65797","_transient__bbp_190.207.166.78_last_posted","1423704946","yes");
INSERT INTO `wp_options` VALUES("63724","_transient__bbp_60.5.252.76_last_posted","1425364951","yes");
INSERT INTO `wp_options` VALUES("63734","_transient__bbp_115.28.85.240_last_posted","1427018133","yes");
INSERT INTO `wp_options` VALUES("827","_transient__bbp_78.213.9.145_last_posted","1399558712","yes");
INSERT INTO `wp_options` VALUES("861","widget_newsletterwidget","a:2:{i:2;a:2:{s:5:\"title\";s:36:\"Inscrivez vous à notre newsletter !\";s:4:\"text\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("117883","_transient_timeout_plugin_slugs","1429624778","no");
INSERT INTO `wp_options` VALUES("117884","_transient_plugin_slugs","a:12:{i:0;s:19:\"akismet/akismet.php\";i:1;s:19:\"bbpress/bbpress.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"email-users/email-users.php\";i:4;s:41:\"google-maps-widget/google-maps-widget.php\";i:5;s:41:\"better-wp-security/better-wp-security.php\";i:6;s:21:\"newsletter/plugin.php\";i:7;s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";i:8;s:21:\"polylang/polylang.php\";i:9;s:27:\"updraftplus/updraftplus.php\";i:10;s:21:\"wp-piwik/wp-piwik.php\";i:11;s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";}","no");
INSERT INTO `wp_options` VALUES("99276","newsletter_diagnostic_cron_calls","a:300:{i:0;i:1429448864;i:1;i:1429449367;i:2;i:1429449493;i:3;i:1429449795;i:4;i:1429450110;i:5;i:1429450485;i:6;i:1429450647;i:7;i:1429451035;i:8;i:1429451322;i:9;i:1429451554;i:10;i:1429451926;i:11;i:1429452242;i:12;i:1429452427;i:13;i:1429452798;i:14;i:1429453127;i:15;i:1429453333;i:16;i:1429453623;i:17;i:1429453981;i:18;i:1429454405;i:19;i:1429454679;i:20;i:1429454880;i:21;i:1429455265;i:22;i:1429455477;i:23;i:1429455895;i:24;i:1429456030;i:25;i:1429456494;i:26;i:1429456847;i:27;i:1429457105;i:28;i:1429457288;i:29;i:1429457676;i:30;i:1429457866;i:31;i:1429458127;i:32;i:1429458482;i:33;i:1429458738;i:34;i:1429459219;i:35;i:1429459325;i:36;i:1429459623;i:37;i:1429459938;i:38;i:1429460265;i:39;i:1429460564;i:40;i:1429460941;i:41;i:1429461216;i:42;i:1429461606;i:43;i:1429461840;i:44;i:1429462226;i:45;i:1429462332;i:46;i:1429462888;i:47;i:1429463075;i:48;i:1429463466;i:49;i:1429463543;i:50;i:1429463974;i:51;i:1429464203;i:52;i:1429464424;i:53;i:1429464774;i:54;i:1429465136;i:55;i:1429465364;i:56;i:1429465768;i:57;i:1429465979;i:58;i:1429466356;i:59;i:1429466598;i:60;i:1429466997;i:61;i:1429467129;i:62;i:1429467676;i:63;i:1429467885;i:64;i:1429468086;i:65;i:1429468260;i:66;i:1429468487;i:67;i:1429468645;i:68;i:1429468924;i:69;i:1429469383;i:70;i:1429469708;i:71;i:1429469863;i:72;i:1429470173;i:73;i:1429470455;i:74;i:1429470966;i:75;i:1429471131;i:76;i:1429471561;i:77;i:1429471670;i:78;i:1429471968;i:79;i:1429472459;i:80;i:1429472751;i:81;i:1429472857;i:82;i:1429473146;i:83;i:1429473477;i:84;i:1429473740;i:85;i:1429474032;i:86;i:1429474377;i:87;i:1429474634;i:88;i:1429475010;i:89;i:1429475324;i:90;i:1429475606;i:91;i:1429475849;i:92;i:1429476180;i:93;i:1429476430;i:94;i:1429476734;i:95;i:1429477082;i:96;i:1429477223;i:97;i:1429477490;i:98;i:1429477647;i:99;i:1429477943;i:100;i:1429478329;i:101;i:1429478787;i:102;i:1429478956;i:103;i:1429479193;i:104;i:1429479522;i:105;i:1429479801;i:106;i:1429480052;i:107;i:1429480450;i:108;i:1429480776;i:109;i:1429480943;i:110;i:1429481308;i:111;i:1429481716;i:112;i:1429481979;i:113;i:1429482279;i:114;i:1429482432;i:115;i:1429482976;i:116;i:1429483104;i:117;i:1429483377;i:118;i:1429483654;i:119;i:1429483922;i:120;i:1429484234;i:121;i:1429484546;i:122;i:1429484922;i:123;i:1429485356;i:124;i:1429485509;i:125;i:1429485868;i:126;i:1429486105;i:127;i:1429486379;i:128;i:1429486795;i:129;i:1429486946;i:130;i:1429487561;i:131;i:1429488003;i:132;i:1429488159;i:133;i:1429488443;i:134;i:1429488748;i:135;i:1429489035;i:136;i:1429489413;i:137;i:1429489718;i:138;i:1429490050;i:139;i:1429490377;i:140;i:1429490586;i:141;i:1429490842;i:142;i:1429491135;i:143;i:1429491434;i:144;i:1429491801;i:145;i:1429492260;i:146;i:1429492423;i:147;i:1429492724;i:148;i:1429492724;i:149;i:1429493134;i:150;i:1429493430;i:151;i:1429493544;i:152;i:1429493831;i:153;i:1429494334;i:154;i:1429494431;i:155;i:1429494784;i:156;i:1429495079;i:157;i:1429495328;i:158;i:1429495682;i:159;i:1429495947;i:160;i:1429496270;i:161;i:1429496647;i:162;i:1429496825;i:163;i:1429497360;i:164;i:1429497459;i:165;i:1429497737;i:166;i:1429498156;i:167;i:1429498356;i:168;i:1429498703;i:169;i:1429499287;i:170;i:1429499675;i:171;i:1429499985;i:172;i:1429500136;i:173;i:1429500613;i:174;i:1429501038;i:175;i:1429501329;i:176;i:1429501673;i:177;i:1429501939;i:178;i:1429502333;i:179;i:1429502616;i:180;i:1429502938;i:181;i:1429503168;i:182;i:1429503429;i:183;i:1429503803;i:184;i:1429504317;i:185;i:1429504429;i:186;i:1429504622;i:187;i:1429504942;i:188;i:1429505224;i:189;i:1429505562;i:190;i:1429505935;i:191;i:1429506172;i:192;i:1429506464;i:193;i:1429506793;i:194;i:1429507062;i:195;i:1429507392;i:196;i:1429507626;i:197;i:1429507995;i:198;i:1429508419;i:199;i:1429508524;i:200;i:1429508830;i:201;i:1429509278;i:202;i:1429509475;i:203;i:1429509740;i:204;i:1429510116;i:205;i:1429510327;i:206;i:1429510862;i:207;i:1429510983;i:208;i:1429511245;i:209;i:1429511698;i:210;i:1429511981;i:211;i:1429512191;i:212;i:1429512479;i:213;i:1429512915;i:214;i:1429513045;i:215;i:1429513431;i:216;i:1429513840;i:217;i:1429514011;i:218;i:1429514227;i:219;i:1429514677;i:220;i:1429514836;i:221;i:1429515124;i:222;i:1429515492;i:223;i:1429515898;i:224;i:1429516137;i:225;i:1429516648;i:226;i:1429516933;i:227;i:1429517430;i:228;i:1429517673;i:229;i:1429517921;i:230;i:1429518353;i:231;i:1429518459;i:232;i:1429518735;i:233;i:1429519143;i:234;i:1429519484;i:235;i:1429519949;i:236;i:1429520387;i:237;i:1429520553;i:238;i:1429521033;i:239;i:1429521141;i:240;i:1429521529;i:241;i:1429521727;i:242;i:1429522175;i:243;i:1429522348;i:244;i:1429522810;i:245;i:1429523092;i:246;i:1429523314;i:247;i:1429523540;i:248;i:1429523868;i:249;i:1429524125;i:250;i:1429524500;i:251;i:1429524951;i:252;i:1429525058;i:253;i:1429525432;i:254;i:1429525736;i:255;i:1429525964;i:256;i:1429526360;i:257;i:1429526533;i:258;i:1429526835;i:259;i:1429527161;i:260;i:1429527464;i:261;i:1429527789;i:262;i:1429528045;i:263;i:1429528369;i:264;i:1429528707;i:265;i:1429528939;i:266;i:1429529226;i:267;i:1429529605;i:268;i:1429529886;i:269;i:1429530141;i:270;i:1429530439;i:271;i:1429530857;i:272;i:1429531224;i:273;i:1429531339;i:274;i:1429531692;i:275;i:1429532092;i:276;i:1429532315;i:277;i:1429532538;i:278;i:1429532930;i:279;i:1429533370;i:280;i:1429533726;i:281;i:1429534032;i:282;i:1429534351;i:283;i:1429534662;i:284;i:1429534938;i:285;i:1429535361;i:286;i:1429535561;i:287;i:1429535966;i:288;i:1429536227;i:289;i:1429536428;i:290;i:1429536828;i:291;i:1429537263;i:292;i:1429537425;i:293;i:1429537734;i:294;i:1429537948;i:295;i:1429538342;i:296;i:1429538526;i:297;i:1429538627;i:298;i:1429538830;i:299;i:1429539130;}","no");
INSERT INTO `wp_options` VALUES("99285","wpmm_settings","a:3:{s:7:\"general\";a:10:{s:6:\"status\";i:1;s:11:\"bypass_bots\";i:0;s:12:\"backend_role\";s:13:\"administrator\";s:13:\"frontend_role\";s:13:\"administrator\";s:11:\"meta_robots\";i:0;s:11:\"redirection\";s:0:\"\";s:7:\"exclude\";a:3:{i:0;s:4:\"feed\";i:1;s:8:\"wp-login\";i:2;s:5:\"login\";}s:6:\"notice\";i:1;s:10:\"admin_link\";i:0;s:11:\"status_date\";s:19:\"2015-04-18 10:59:24\";}s:6:\"design\";a:10:{s:5:\"title\";s:16:\"Mode Maintenance\";s:7:\"heading\";s:16:\"Mode Maintenance\";s:13:\"heading_color\";s:7:\"#ffffff\";s:4:\"text\";s:223:\"<p>Le site des 48h de la Pige fait peau neuve pour son édition 2015 qui se tiendra les 2 et 3 juillet à Strasbourg.</p>
<p>Très bientôt, vous retrouverez ici toutes les infos pour y participer. Un peu de patience !</p>\";s:10:\"text_color\";s:7:\"#1e73be\";s:7:\"bg_type\";s:10:\"predefined\";s:8:\"bg_color\";s:0:\"\";s:9:\"bg_custom\";s:0:\"\";s:13:\"bg_predefined\";s:7:\"bg4.jpg\";s:10:\"custom_css\";a:3:{s:13:\"heading_color\";s:28:\".wrap h1 { color: #ffffff; }\";s:10:\"text_color\";s:28:\".wrap h2 { color: #1e73be; }\";s:6:\"bg_url\";s:180:\".background { background: url(http://48h.pigiste.org/wp-content/plugins/wp-maintenance-mode/assets/images/backgrounds/bg4.jpg) no-repeat center top fixed; background-size: cover; }\";}}s:7:\"modules\";a:22:{s:16:\"countdown_status\";i:0;s:15:\"countdown_start\";s:19:\"2015-03-30 11:34:16\";s:17:\"countdown_details\";a:3:{s:4:\"days\";s:2:\"10\";s:5:\"hours\";s:1:\"1\";s:7:\"minutes\";s:1:\"0\";}s:15:\"countdown_color\";s:0:\"\";s:16:\"subscribe_status\";i:0;s:14:\"subscribe_text\";s:30:\"Me notifier quand c\\\'est prêt\";s:20:\"subscribe_text_color\";s:0:\"\";s:13:\"social_status\";i:0;s:13:\"social_target\";i:1;s:13:\"social_github\";s:0:\"\";s:15:\"social_dribbble\";s:0:\"\";s:14:\"social_twitter\";s:0:\"\";s:15:\"social_facebook\";s:0:\"\";s:16:\"social_pinterest\";s:0:\"\";s:14:\"social_google+\";s:0:\"\";s:15:\"social_linkedin\";s:0:\"\";s:14:\"contact_status\";i:0;s:13:\"contact_email\";s:17:\"max.twa@gmail.com\";s:15:\"contact_effects\";s:20:\"move_top|move_bottom\";s:9:\"ga_status\";i:0;s:7:\"ga_code\";s:0:\"\";s:10:\"custom_css\";a:0:{}}}","yes");
INSERT INTO `wp_options` VALUES("167","widget_akismet_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("129","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1398350987;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}}}}","yes");
INSERT INTO `wp_options` VALUES("130","current_theme","Enfold","yes");
INSERT INTO `wp_options` VALUES("131","theme_mods_enfold","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:5:\"avia3\";i:33;s:4:\"avia\";i:33;}}","yes");
INSERT INTO `wp_options` VALUES("132","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("133","enfold_layerslider_activated","1","yes");
INSERT INTO `wp_options` VALUES("134","shop_catalog_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("135","shop_single_image_size","a:3:{s:5:\"width\";i:450;s:6:\"height\";i:999;s:4:\"crop\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("136","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("137","avia_woocommerce_column_count","3","yes");
INSERT INTO `wp_options` VALUES("138","avia_woocommerce_product_count","15","yes");
INSERT INTO `wp_options` VALUES("139","woocommerce_single_image_crop","no","yes");
INSERT INTO `wp_options` VALUES("114978","_transient_timeout_avia_theme_latest_version","1429881009","no");
INSERT INTO `wp_options` VALUES("114979","_transient_avia_theme_latest_version","<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<notifier version=\"1.0\">
 <LatestVersion>
  <version>1.3</version>
 </LatestVersion>
 <PreviousVersions>
 </PreviousVersions>
</notifier>
","no");
INSERT INTO `wp_options` VALUES("142","enfold_woo_settings_enabled","1","yes");
INSERT INTO `wp_options` VALUES("143","avia_options_enfold","a:1:{s:4:\"avia\";a:94:{s:17:\"avia-nonce-import\";s:10:\"947b4125f1\";s:9:\"frontpage\";s:3:\"734\";s:9:\"undefined\";s:32:\"header_setting::{contains}social\";s:8:\"blogpage\";s:0:\"\";s:4:\"logo\";s:69:\"http://48h.pigiste.org/wp-content/uploads/2013/04/48hbyPP-300x158.png\";s:7:\"favicon\";s:64:\"http://48h.pigiste.org/wp-content/uploads/2013/04/favicon-01.png\";s:9:\"analytics\";s:0:\"\";s:12:\"color_scheme\";s:11:\"Black-White\";s:14:\"google_webfont\";s:17:\"Open Sans:400,600\";s:12:\"default_font\";s:17:\"Open Sans:400,600\";s:16:\"color-body_style\";s:9:\"stretched\";s:16:\"color-body_color\";s:7:\"#333333\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:13:\"center center\";s:17:\"color-body_repeat\";s:6:\"repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#1bbce9\";s:31:\"colorset-header_color-secondary\";s:7:\"#1bbce9\";s:27:\"colorset-header_color-color\";s:7:\"#333333\";s:28:\"colorset-header_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:13:\"center center\";s:28:\"colorset-header_color-repeat\";s:6:\"repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#000000\";s:29:\"colorset-main_color-secondary\";s:7:\"#666666\";s:25:\"colorset-main_color-color\";s:7:\"#666666\";s:26:\"colorset-main_color-border\";s:7:\"#e1e1e1\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:13:\"center center\";s:26:\"colorset-main_color-repeat\";s:6:\"repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#111111\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#222222\";s:32:\"colorset-alternate_color-primary\";s:7:\"#000000\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#bdbdbd\";s:30:\"colorset-alternate_color-color\";s:7:\"#888888\";s:31:\"colorset-alternate_color-border\";s:7:\"#333333\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:13:\"center center\";s:31:\"colorset-alternate_color-repeat\";s:6:\"repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#000000\";s:25:\"colorset-footer_color-bg2\";s:7:\"#222222\";s:29:\"colorset-footer_color-primary\";s:7:\"#aaaaaa\";s:31:\"colorset-footer_color-secondary\";s:7:\"#ffffff\";s:27:\"colorset-footer_color-color\";s:7:\"#aaaaaa\";s:28:\"colorset-footer_color-border\";s:7:\"#555555\";s:25:\"colorset-footer_color-img\";s:0:\"\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:13:\"center center\";s:28:\"colorset-footer_color-repeat\";s:6:\"repeat\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#333333\";s:25:\"colorset-socket_color-bg2\";s:7:\"#000000\";s:29:\"colorset-socket_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-socket_color-secondary\";s:7:\"#eeeeee\";s:27:\"colorset-socket_color-color\";s:7:\"#eeeeee\";s:28:\"colorset-socket_color-border\";s:7:\"#333333\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:13:\"center center\";s:28:\"colorset-socket_color-repeat\";s:6:\"repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:9:\"quick_css\";s:8:\"[nolink]\";s:17:\"responsive_layout\";s:10:\"responsive\";s:15:\"websave_windows\";s:6:\"active\";s:10:\"blog_style\";s:10:\"single-big\";s:17:\"single_post_style\";s:10:\"single-big\";s:15:\"iconfont_upload\";s:0:\"\";s:14:\"header_setting\";s:12:\"fixed_header\";s:5:\"phone\";s:0:\"\";s:12:\"social_icons\";a:4:{i:0;a:2:{s:11:\"social_icon\";s:8:\"facebook\";s:16:\"social_icon_link\";s:34:\"https://www.facebook.com/kriesi.at\";}i:1;a:2:{s:11:\"social_icon\";s:7:\"twitter\";s:16:\"social_icon_link\";s:1:\"#\";}i:2;a:2:{s:11:\"social_icon\";s:5:\"skype\";s:16:\"social_icon_link\";s:0:\"\";}i:3;a:2:{s:11:\"social_icon\";s:4:\"mail\";s:16:\"social_icon_link\";s:0:\"\";}}s:17:\"header_searchicon\";s:17:\"header_searchicon\";s:11:\"header_menu\";s:16:\"mobile_drop_down\";s:14:\"archive_layout\";s:8:\"fullsize\";s:11:\"blog_layout\";s:8:\"fullsize\";s:13:\"single_layout\";s:8:\"fullsize\";s:11:\"page_layout\";s:8:\"fullsize\";s:19:\"smartphones_sidebar\";s:8:\"disabled\";s:16:\"page_nesting_nav\";s:8:\"disabled\";s:22:\"display_widgets_socket\";s:15:\"nofooterwidgets\";s:14:\"footer_columns\";s:1:\"2\";s:9:\"copyright\";s:89:\"&copy; Les 48h de la pige 2014 - Un &eacute;v&eacute;nement Profession : Pigiste [nolink]\";s:16:\"updates_username\";s:0:\"\";s:15:\"updates_api_key\";s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("202","avia_permalink_settings","a:2:{s:24:\"portfolio_permalink_base\";s:14:\"portfolio-item\";s:31:\"portfolio_entries_taxonomy_base\";s:17:\"portfolio_entries\";}","yes");
INSERT INTO `wp_options` VALUES("204","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("200","_transient_twentyfourteen_category_count","5","yes");
INSERT INTO `wp_options` VALUES("145","avia_stylesheet_dir_writableenfold","true","yes");
INSERT INTO `wp_options` VALUES("146","avia_stylesheet_existsenfold","true","yes");
INSERT INTO `wp_options` VALUES("169","widget_bbp_views_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("170","widget_bbp_search_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("171","widget_bbp_forums_widget","a:3:{i:1;a:0:{}i:3;a:2:{s:5:\"title\";s:6:\"Forums\";s:12:\"parent_forum\";s:3:\"any\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("172","widget_bbp_topics_widget","a:3:{i:1;a:0:{}i:2;a:6:{s:5:\"title\";s:15:\"Sujets récents\";s:8:\"order_by\";s:7:\"newness\";s:12:\"parent_forum\";s:3:\"any\";s:9:\"show_date\";b:0;s:9:\"show_user\";b:0;s:9:\"max_shown\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("173","widget_bbp_replies_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("174","widget_bbp_stats_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("194","shop_order_status_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114419","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("254","portfolio_entries_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("193","product_cat_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("203","avia_rewrite_flush","1","yes");
INSERT INTO `wp_options` VALUES("114418","_transient_pll_languages_list","a:2:{i:0;a:20:{s:7:\"term_id\";i:44;s:4:\"name\";s:9:\"Français\";s:4:\"slug\";s:2:\"fr\";s:10:\"term_group\";s:1:\"0\";s:16:\"term_taxonomy_id\";i:44;s:8:\"taxonomy\";s:8:\"language\";s:11:\"description\";s:5:\"fr_FR\";s:6:\"parent\";s:1:\"0\";s:5:\"count\";i:220;s:10:\"tl_term_id\";i:45;s:19:\"tl_term_taxonomy_id\";i:45;s:8:\"tl_count\";i:14;s:6:\"locale\";R:9;s:6:\"is_rtl\";i:0;s:8:\"flag_url\";s:66:\"http://48h.pigiste.org/wp-content/plugins/polylang/flags/fr_FR.png\";s:4:\"flag\";s:798:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAGzSURBVHjaYiyeepkBBv79+Zfnx/f379+fP38CyT9//jAyMiq5GP77wvDnJ8MfoAIGBoAAYgGqC7STApL///3/9++/pCTv////Qdz/QO4/IMna0vf/z+9/v379//37bUUTQACBNDD8Z/j87fffvyAVX79+/Q8GQDbQeKA9fM+e/Pv18/+vnwzCIkBLAAKQOAY5AIAwCEv4/4PddNUm3ji0QJyxW3rgzE0iLfqDGr2oYuu0l54AYvnz5x9Q6d+/QPQfyAQqAin9B3EOyG1A1UDj//36zfjr1y8GBoAAFI9BDgAwCMIw+P8Ho3GDO6XQ0l4MN8b2kUwYaLszqgKM/KHcDXwBxAJUD3TJ779A8h9Q5D8SAHoARP36+Rfo41+/mcA2AAQQy49ff0Cu//MPpAeI/0FdA1QNYYNVA/3wmwEYVgwMAAHE8uPHH5BqoD1//gJJLADoJKDS378Z//wFhhJAALF8A3rizz8uTmYg788fJkj4QOKREQyYxSWBhjEC/fcXZANAALF8+/anbcHlHz9+ffvx58uPX9KckkCn/gby/wLd8uvHjx96k+cD1UGiGQgAAgwA7q17ZpsMdUQAAAAASUVORK5CYII=\" title=\"Français\" alt=\"Français\" />\";s:8:\"home_url\";s:26:\"http://48h.pigiste.org/fr/\";s:10:\"search_url\";s:26:\"http://48h.pigiste.org/fr/\";s:4:\"host\";N;s:5:\"mo_id\";s:5:\"19724\";}i:1;a:20:{s:7:\"term_id\";i:60;s:4:\"name\";s:7:\"English\";s:4:\"slug\";s:2:\"en\";s:10:\"term_group\";s:1:\"0\";s:16:\"term_taxonomy_id\";i:60;s:8:\"taxonomy\";s:8:\"language\";s:11:\"description\";s:5:\"en_GB\";s:6:\"parent\";s:1:\"0\";s:5:\"count\";i:0;s:10:\"tl_term_id\";i:61;s:19:\"tl_term_taxonomy_id\";i:61;s:8:\"tl_count\";i:0;s:6:\"locale\";R:29;s:6:\"is_rtl\";i:0;s:8:\"flag_url\";s:66:\"http://48h.pigiste.org/wp-content/plugins/polylang/flags/en_GB.png\";s:4:\"flag\";s:866:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAflJREFUeNpinDRzn5qN3uFDt16+YWBg+Pv339+KGN0rbVP+//2rW5tf0Hfy/2+mr99+yKpyOl3Ydt8njEWIn8f9zj639NC7j78eP//8739GVUUhNUNuhl8//ysKeZrJ/v7z10Zb2PTQTIY1XZO2Xmfad+f7XgkXxuUrVB6cjPVXef78JyMjA8PFuwyX7gAZj97+T2e9o3d4BWNp84K1NzubTjAB3fH0+fv6N3qP/ir9bW6ozNQCijB8/8zw/TuQ7r4/ndvN5mZgkpPXiis3Pv34+ZPh5t23//79Rwehof/9/NDEgMrOXHvJcrllgpoRN8PFOwy/fzP8+gUlgZI/f/5xcPj/69e/37//AUX+/mXRkN555gsOG2xt/5hZQMwF4r9///75++f3nz8nr75gSms82jfvQnT6zqvXPjC8e/srJQHo9P9fvwNtAHmG4f8zZ6dDc3bIyM2LTNlsbtfM9OPHH3FhtqUz3eXX9H+cOy9ZMB2o6t/Pn0DHMPz/b+2wXGTvPlPGFxdcD+mZyjP8+8MUE6sa7a/xo6Pykn1s4zdzIZ6///8zMGpKM2pKAB0jqy4UE7/msKat6Jw5mafrsxNtWZ6/fjvNLW29qv25pQd///n+5+/fxDDVbcc//P/zx/36m5Ub9zL8+7t66yEROcHK7q5bldMBAgwADcRBCuVLfoEAAAAASUVORK5CYII=\" title=\"English\" alt=\"English\" />\";s:8:\"home_url\";s:26:\"http://48h.pigiste.org/en/\";s:10:\"search_url\";s:26:\"http://48h.pigiste.org/en/\";s:4:\"host\";N;s:5:\"mo_id\";s:5:\"19725\";}}","yes");
INSERT INTO `wp_options` VALUES("115773","_transient_wp-piwik_e052f9c7d6ed4e95312323c77c10b126","a:1:{i:0;a:16:{s:6:\"idsite\";s:1:\"1\";s:4:\"name\";s:18:\"Les 48h de la pige\";s:8:\"main_url\";s:22:\"http://48h.pigiste.org\";s:10:\"ts_created\";s:19:\"2015-04-18 09:17:37\";s:9:\"ecommerce\";s:1:\"0\";s:10:\"sitesearch\";s:1:\"1\";s:29:\"sitesearch_keyword_parameters\";s:0:\"\";s:30:\"sitesearch_category_parameters\";s:0:\"\";s:8:\"timezone\";s:12:\"Europe/Paris\";s:8:\"currency\";s:3:\"USD\";s:12:\"excluded_ips\";s:0:\"\";s:19:\"excluded_parameters\";s:0:\"\";s:20:\"excluded_user_agents\";s:0:\"\";s:5:\"group\";s:0:\"\";s:4:\"type\";s:7:\"website\";s:17:\"keep_url_fragment\";s:1:\"0\";}}","no");
INSERT INTO `wp_options` VALUES("115768","wp-piwik_global-settings","a:53:{s:8:\"revision\";i:98004;s:19:\"plugin_display_name\";s:8:\"WP-Piwik\";s:17:\"add_tracking_code\";s:1:\"1\";s:20:\"last_settings_update\";i:1429349694;s:11:\"piwik_token\";s:32:\"f163552e3666f8d9aee17ad583dec6cb\";s:9:\"piwik_url\";s:25:\"http://piwik.pigiste.org/\";s:10:\"piwik_path\";s:0:\"\";s:10:\"piwik_mode\";s:4:\"http\";s:15:\"piwik_useragent\";s:3:\"php\";s:22:\"piwik_useragent_string\";s:8:\"WP-Piwik\";s:18:\"connection_timeout\";i:5;s:16:\"dashboard_widget\";b:0;s:15:\"dashboard_chart\";b:0;s:13:\"dashboard_seo\";b:0;s:9:\"stats_seo\";b:0;s:18:\"capability_stealth\";a:0:{}s:21:\"capability_read_stats\";a:1:{s:13:\"administrator\";b:1;}s:14:\"piwik_shortcut\";b:0;s:12:\"default_date\";s:9:\"yesterday\";s:16:\"auto_site_config\";s:1:\"1\";s:9:\"track_404\";b:0;s:12:\"track_search\";b:0;s:10:\"track_mode\";i:0;s:10:\"track_post\";b:0;s:11:\"track_proxy\";b:0;s:11:\"track_admin\";b:0;s:10:\"track_feed\";b:0;s:15:\"track_feed_goal\";s:0:\"\";s:18:\"track_feed_revenue\";s:0:\"\";s:19:\"track_feed_campaign\";s:4:\"feed\";s:22:\"track_feed_addcampaign\";b:0;s:12:\"track_cdnurl\";s:0:\"\";s:15:\"track_cdnurlssl\";s:0:\"\";s:14:\"track_noscript\";b:0;s:18:\"track_nojavascript\";b:0;s:18:\"track_codeposition\";s:6:\"footer\";s:17:\"track_datacfasync\";b:0;s:12:\"track_across\";b:0;s:18:\"track_across_alias\";b:0;s:13:\"limit_cookies\";b:0;s:21:\"limit_cookies_visitor\";i:1209600;s:21:\"limit_cookies_session\";i:0;s:20:\"add_post_annotations\";b:0;s:18:\"add_customvars_box\";s:1:\"1\";s:17:\"disable_timelimit\";b:0;s:18:\"disable_ssl_verify\";b:0;s:15:\"disable_cookies\";b:0;s:23:\"add_download_extensions\";s:0:\"\";s:14:\"force_protocol\";s:0:\"\";s:7:\"toolbar\";b:0;s:10:\"shortcodes\";b:0;s:5:\"cache\";s:1:\"1\";s:13:\"perpost_stats\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("115750","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1429358328","yes");
INSERT INTO `wp_options` VALUES("115751","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","a:40:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"4916\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3078\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3022\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2529\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2346\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"1892\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1729\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1680\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"1678\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1676\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1612\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1609\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1505\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1322\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1276\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1175\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1171\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1083\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1079\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:3:\"918\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:3:\"905\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:3:\"874\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"843\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"837\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"794\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"758\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"748\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"709\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:3:\"700\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"692\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"682\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"657\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"649\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"642\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"642\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"623\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"620\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"605\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"600\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"593\";}}","yes");
INSERT INTO `wp_options` VALUES("212","gmw_options","a:4:{s:13:\"first_version\";s:4:\"1.60\";s:13:\"first_install\";i:1398358539;s:13:\"last_tracking\";i:1429204176;s:14:\"allow_tracking\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("213","widget_googlemapswidget","a:2:{i:2;a:22:{s:5:\"title\";s:47:\"Rendez-vous au campus Albert Londres à Vichy !\";s:7:\"address\";s:43:\"Pôle technologique et universitaire, Vichy\";s:15:\"thumb_pin_color\";s:4:\"gray\";s:14:\"thumb_pin_size\";s:7:\"default\";s:11:\"thumb_width\";i:500;s:12:\"thumb_height\";i:300;s:10:\"thumb_zoom\";s:2:\"13\";s:10:\"thumb_type\";s:7:\"roadmap\";s:15:\"thumb_link_type\";s:8:\"lightbox\";s:10:\"thumb_link\";s:0:\"\";s:12:\"thumb_header\";s:0:\"\";s:12:\"thumb_footer\";s:0:\"\";s:16:\"thumb_new_colors\";b:1;s:14:\"lightbox_width\";i:600;s:15:\"lightbox_height\";i:400;s:13:\"lightbox_type\";s:1:\"m\";s:13:\"lightbox_zoom\";s:2:\"14\";s:15:\"lightbox_bubble\";b:1;s:14:\"lightbox_title\";b:0;s:15:\"lightbox_header\";s:0:\"\";s:15:\"lightbox_footer\";s:0:\"\";s:13:\"lightbox_skin\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("599","newsletter_main_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("600","newsletter","a:26:{s:12:\"profile_text\";s:104:\"{profile_form}<p>To cancel your subscription, <a href=\'{unsubscription_confirm_url}\'>click here</a>.</p>\";s:10:\"error_text\";s:173:\"<p>This subscription can\'t be completed, sorry. The email address is blocked or already subscribed. You should contact the owner to unlock that email address. Thank you.</p>\";s:22:\"already_confirmed_text\";s:99:\"<p>This email address is already subscribed, anyway a welcome email has been resent. Thank you.</p>\";s:18:\"subscribe_wp_users\";s:1:\"0\";s:17:\"subscription_text\";s:19:\"{subscription_form}\";s:17:\"confirmation_text\";s:167:\"<p>Votre demande d\'inscription est enregistr&eacute;e. Merci ! Un e-mail de confirmation vous a été envoyé. V&eacute;rifier &eacute;galement votre dossier spam.</p>\";s:20:\"confirmation_subject\";s:66:\"Inscription &agrave; la lettre d&prime;information de {blog_title}\";s:20:\"confirmation_message\";s:517:\"<p>Bonjour {name}!</p>
<p>Vous recevez cet e-mail car nous avons enregistr&eacute; une demande d&prime;inscription &agrave; la lettre d&prime;infrmation de {blog_title}.
Merci de confirmer votre inscription en cliquant sur le lien suivant : <a href=\"{subscription_confirm_url}\"><strong>je confirme mon inscription.</strong></a>.
Si le lien ne fonctionne pas, merci d\'utiliser cette adresse :</p>
<p>{subscription_confirm_url}</p>
<p>Ignorez ce message si vous n\'avez pas effectué de demande.</p>
<p>Merci !</p>\";s:14:\"confirmed_text\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:17:\"confirmed_subject\";s:17:\"Bienvenue, {name}\";s:17:\"confirmed_message\";s:54:\"<p>Votre inscription est confirm&eacute;e. Merci !</p>\";s:19:\"unsubscription_text\";s:160:\"<p>&Ecirc;tes-vous certain de vouloir vous d&eacute;sinscrire de la lettre d&prime;information de {blog_title} ? <a href=\"{unsubscription_confirm_url}\">Oui</a>.\";s:17:\"unsubscribed_text\";s:153:\"<p>Vous n&prime;&ecirc;tes plus abonn&eacute; &agrave; la lettre d\'information de {blog_title}. Merci de nous avoir suivi et &agrave; bient&ocirc;t !</p>\";s:20:\"unsubscribed_subject\";s:18:\"Au revoir {name} !\";s:20:\"unsubscribed_message\";s:108:\"<p>Cet email confirme votre désinscription à notre newsletter<br>
<a href=\'{blog_url}\'>{blog_url}</a></p>\";s:14:\"noconfirmation\";s:1:\"0\";s:3:\"url\";s:0:\"\";s:8:\"novisual\";s:1:\"0\";s:6:\"notify\";s:1:\"0\";s:12:\"notify_email\";s:0:\"\";s:16:\"confirmation_url\";s:0:\"\";s:13:\"confirmed_url\";s:0:\"\";s:18:\"confirmed_tracking\";s:0:\"\";s:13:\"profile_saved\";s:0:\"\";s:24:\"subscribe_wp_users_label\";s:0:\"\";s:10:\"wp_welcome\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("214","avia_sidebars","a:5:{i:0;s:10:\"Google Map\";i:1;s:10:\"Live Tweet\";i:2;s:7:\"Contact\";i:3;s:11:\"Login forum\";i:4;s:13:\"Recent topics\";}","yes");
INSERT INTO `wp_options` VALUES("262","widget_oauth_twitter_widget","a:2:{i:2;a:12:{s:4:\"user\";s:6:\"pigist\";s:5:\"count\";s:0:\"\";s:11:\"widgetTitle\";s:0:\"\";s:12:\"widgetFooter\";s:0:\"\";s:16:\"oAuthAccessToken\";s:0:\"\";s:22:\"oAuthAccessTokenSecret\";s:0:\"\";s:11:\"consumerKey\";s:0:\"\";s:14:\"consumerSecret\";s:0:\"\";s:17:\"showTwitterIconTF\";b:0;s:16:\"showProfilePicTF\";b:0;s:15:\"showTweetTimeTF\";b:0;s:16:\"includeRepliesTF\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("263","_transient_random_seed","6f1e45737d1e459ca3f57f79ddb06668","yes");
INSERT INTO `wp_options` VALUES("99286","wpmm_version","2.0.3","yes");
INSERT INTO `wp_options` VALUES("114265","updraft_interval_increments","","yes");
INSERT INTO `wp_options` VALUES("114266","updraft_retain","8","yes");
INSERT INTO `wp_options` VALUES("114267","updraft_retain_db","20","yes");
INSERT INTO `wp_options` VALUES("562","_transient__bbp_2a01:e34:ed50:9910:c08c:8ed3:d3f9:8470_last_post","1399455139","yes");
INSERT INTO `wp_options` VALUES("597","newsletter_logger_secret","5180c642","yes");
INSERT INTO `wp_options` VALUES("598","newsletter_main","a:20:{s:12:\"sender_email\";s:26:\"newsletter@48h.pigiste.org\";s:11:\"sender_name\";s:18:\"Les 48h de la pige\";s:11:\"return_path\";N;s:8:\"reply_to\";s:23:\"raphaelbaldos@gmail.com\";s:12:\"contract_key\";s:0:\"\";s:13:\"scheduler_max\";s:3:\"100\";s:6:\"editor\";s:1:\"0\";s:7:\"api_key\";s:10:\"186aecbfd3\";s:3:\"css\";s:0:\"\";s:25:\"content_transfer_encoding\";s:0:\"\";s:12:\"smtp_enabled\";s:1:\"0\";s:9:\"smtp_host\";s:0:\"\";s:9:\"smtp_port\";s:0:\"\";s:11:\"smtp_secure\";s:0:\"\";s:9:\"smtp_user\";s:0:\"\";s:9:\"smtp_pass\";s:0:\"\";s:15:\"smtp_test_email\";s:0:\"\";s:8:\"lock_ids\";s:0:\"\";s:8:\"lock_url\";s:0:\"\";s:12:\"lock_message\";s:107:\"This content is protected, only newsletter subscribers can access it. Subscribe now!

{subscription_form}\";}","yes");
INSERT INTO `wp_options` VALUES("602","newsletter_subscription_version","1.1.2","yes");
INSERT INTO `wp_options` VALUES("603","newsletter_emails","a:12:{s:5:\"theme\";s:10:\"vimeo-like\";s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("604","newsletter_emails_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("605","newsletter_emails_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("606","newsletter_users","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("607","newsletter_users_version","1.0.4","yes");
INSERT INTO `wp_options` VALUES("608","newsletter_statistics","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("609","newsletter_statistics_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("610","newsletter_feed","a:2:{s:5:\"theme\";s:7:\"default\";s:12:\"subscription\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("611","newsletter_feed_theme_default","a:0:{}","no");
INSERT INTO `wp_options` VALUES("612","newsletter_feed_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("601","newsletter_profile","a:61:{s:5:\"email\";s:5:\"Email\";s:11:\"email_error\";s:24:\"The email is not correct\";s:4:\"name\";s:4:\"Name\";s:10:\"name_error\";s:23:\"The name is not correct\";s:11:\"name_status\";i:0;s:10:\"name_rules\";i:0;s:7:\"surname\";s:9:\"Last name\";s:13:\"surname_error\";s:28:\"The last name is not correct\";s:14:\"surname_status\";i:0;s:3:\"sex\";s:3:\"I\'m\";s:7:\"privacy\";s:51:\"Subscribing I accept the privacy rules of this site\";s:13:\"privacy_error\";s:37:\"You must accept the privacy statement\";s:14:\"privacy_status\";i:0;s:9:\"subscribe\";s:9:\"Subscribe\";s:4:\"save\";s:4:\"Save\";s:12:\"title_female\";s:4:\"Mrs.\";s:10:\"title_male\";s:3:\"Mr.\";s:10:\"title_none\";s:4:\"Dear\";s:8:\"sex_male\";s:3:\"Man\";s:10:\"sex_female\";s:5:\"Woman\";s:8:\"sex_none\";s:4:\"None\";s:13:\"list_1_status\";i:0;s:13:\"list_2_status\";i:0;s:13:\"list_3_status\";i:0;s:13:\"list_4_status\";i:0;s:13:\"list_5_status\";i:0;s:13:\"list_6_status\";i:0;s:13:\"list_7_status\";i:0;s:13:\"list_8_status\";i:0;s:13:\"list_9_status\";i:0;s:14:\"list_10_status\";i:0;s:14:\"list_11_status\";i:0;s:14:\"list_12_status\";i:0;s:14:\"list_13_status\";i:0;s:14:\"list_14_status\";i:0;s:14:\"list_15_status\";i:0;s:14:\"list_16_status\";i:0;s:14:\"list_17_status\";i:0;s:14:\"list_18_status\";i:0;s:14:\"list_19_status\";i:0;s:14:\"list_20_status\";i:0;s:16:\"profile_1_status\";i:0;s:16:\"profile_2_status\";i:0;s:16:\"profile_3_status\";i:0;s:16:\"profile_4_status\";i:0;s:16:\"profile_5_status\";i:0;s:16:\"profile_6_status\";i:0;s:16:\"profile_7_status\";i:0;s:16:\"profile_8_status\";i:0;s:16:\"profile_9_status\";i:0;s:17:\"profile_10_status\";i:0;s:17:\"profile_11_status\";i:0;s:17:\"profile_12_status\";i:0;s:17:\"profile_13_status\";i:0;s:17:\"profile_14_status\";i:0;s:17:\"profile_15_status\";i:0;s:17:\"profile_16_status\";i:0;s:17:\"profile_17_status\";i:0;s:17:\"profile_18_status\";i:0;s:17:\"profile_19_status\";i:0;s:17:\"profile_20_status\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("624","newsletter_emails_theme_vimeo-like","a:11:{s:15:\"theme_max_posts\";s:1:\"1\";s:17:\"theme_pre_message\";s:151:\"Cet email a été envoyé à {email} car vous en avez fait la demande <a href=\"{profile_url}\">Cliquez-ici pour ne plus recevoir de nos nouvelles !</a>.\";s:15:\"theme_read_more\";s:10:\"Découvrir\";s:20:\"theme_social_disable\";s:1:\"1\";s:14:\"theme_facebook\";s:0:\"\";s:13:\"theme_twitter\";s:0:\"\";s:15:\"theme_pinterest\";s:0:\"\";s:16:\"theme_googleplus\";s:0:\"\";s:14:\"theme_linkedin\";s:0:\"\";s:12:\"theme_tumblr\";s:0:\"\";s:13:\"theme_youtube\";s:0:\"\";}","no");
INSERT INTO `wp_options` VALUES("617","newsletter_feed_available_version","1.2.2","yes");
INSERT INTO `wp_options` VALUES("616","newsletter_reports_available_version","1.0.7","yes");
INSERT INTO `wp_options` VALUES("618","newsletter_followup_available_version","1.1.1","yes");
INSERT INTO `wp_options` VALUES("619","newsletter_facebook_available_version","1.1.3","yes");
INSERT INTO `wp_options` VALUES("620","newsletter_sendgrid_available_version","1.1.0","yes");
INSERT INTO `wp_options` VALUES("621","newsletter_popup_available_version","1.0.5","yes");
INSERT INTO `wp_options` VALUES("622","newsletter_mandrill_available_version","1.1.2","yes");
INSERT INTO `wp_options` VALUES("623","newsletter_mailjet_available_version","1.0.0","yes");
INSERT INTO `wp_options` VALUES("919","auto_core_update_notified","a:4:{s:4:\"type\";s:6:\"manual\";s:5:\"email\";s:17:\"max.twa@gmail.com\";s:7:\"version\";s:5:\"4.0.1\";s:9:\"timestamp\";i:1416530671;}","yes");
INSERT INTO `wp_options` VALUES("99151","_site_transient_timeout_browser_664efc36c93685cc0a4b220f6b21652f","1428309676","yes");
INSERT INTO `wp_options` VALUES("99152","_site_transient_browser_664efc36c93685cc0a4b220f6b21652f","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:5:\"6.1.6\";s:10:\"update_url\";s:28:\"http://www.apple.com/safari/\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/safari.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/safari.png\";s:15:\"current_version\";s:1:\"5\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("61039","_transient__bbp_218.204.140.212_last_posted","1426733724","yes");
INSERT INTO `wp_options` VALUES("99375","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1429537431;s:7:\"checked\";a:2:{s:6:\"enfold\";s:5:\"2.4.5\";s:13:\"twentyfifteen\";s:3:\"1.0\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("11140","_transient__bbp_81.65.161.8_last_posted","1402822926","yes");
INSERT INTO `wp_options` VALUES("11199","_transient__bbp_90.28.60.18_last_posted","1402498697","yes");
INSERT INTO `wp_options` VALUES("11337","_transient__bbp_2.10.234.105_last_posted","1402516429","yes");
INSERT INTO `wp_options` VALUES("8069","_transient__bbp_82.249.237.149_last_posted","1401881839","yes");
INSERT INTO `wp_options` VALUES("114264","updraft_interval_database","daily","yes");
INSERT INTO `wp_options` VALUES("115781","_transient_wp-piwik_c797cee1930e0d27d2673c178c943ab3","a:1:{i:0;a:16:{s:6:\"idsite\";s:1:\"1\";s:4:\"name\";s:18:\"Les 48h de la pige\";s:8:\"main_url\";s:22:\"http://48h.pigiste.org\";s:10:\"ts_created\";s:19:\"2015-04-18 09:17:37\";s:9:\"ecommerce\";s:1:\"0\";s:10:\"sitesearch\";s:1:\"1\";s:29:\"sitesearch_keyword_parameters\";s:0:\"\";s:30:\"sitesearch_category_parameters\";s:0:\"\";s:8:\"timezone\";s:12:\"Europe/Paris\";s:8:\"currency\";s:3:\"USD\";s:12:\"excluded_ips\";s:0:\"\";s:19:\"excluded_parameters\";s:0:\"\";s:20:\"excluded_user_agents\";s:0:\"\";s:5:\"group\";s:0:\"\";s:4:\"type\";s:7:\"website\";s:17:\"keep_url_fragment\";s:1:\"0\";}}","no");
INSERT INTO `wp_options` VALUES("114263","updraft_interval","daily","yes");
INSERT INTO `wp_options` VALUES("113893","_site_transient_timeout_browser_4e23a6000876e66a7ec0dd24366f9a45","1429797250","yes");
INSERT INTO `wp_options` VALUES("113894","_site_transient_browser_4e23a6000876e66a7ec0dd24366f9a45","a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"37.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("40309","_transient__bbp_117.26.252.17_last_posted","1418119364","yes");
INSERT INTO `wp_options` VALUES("65300","_transient__bbp_82.211.201.188_last_posted","1424791982","yes");
INSERT INTO `wp_options` VALUES("99262","WPLANG","fr_FR","yes");
INSERT INTO `wp_options` VALUES("99374","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.1.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.1.1\";s:7:\"version\";s:5:\"4.1.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1429537426;s:15:\"version_checked\";s:5:\"4.1.1\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("65316","_transient__bbp_59.61.79.124_last_posted","1427185641","yes");
INSERT INTO `wp_options` VALUES("63774","_transient__bbp_183.221.217.205_last_posted","1423484161","yes");
INSERT INTO `wp_options` VALUES("63814","_transient__bbp_176.31.138.187_last_posted","1427123537","yes");
INSERT INTO `wp_options` VALUES("63845","_transient__bbp_62.109.17.73_last_posted","1424851235","yes");
INSERT INTO `wp_options` VALUES("63898","_transient__bbp_183.220.105.76_last_posted","1423492753","yes");
INSERT INTO `wp_options` VALUES("63965","_transient__bbp_183.222.159.219_last_posted","1423502784","yes");
INSERT INTO `wp_options` VALUES("63978","_transient__bbp_190.198.160.73_last_posted","1423953689","yes");
INSERT INTO `wp_options` VALUES("64007","_transient__bbp_186.95.25.190_last_posted","1423507591","yes");
INSERT INTO `wp_options` VALUES("64026","_transient__bbp_117.21.193.1_last_posted","1423509348","yes");
INSERT INTO `wp_options` VALUES("64030","_transient__bbp_186.95.95.24_last_posted","1423509729","yes");
INSERT INTO `wp_options` VALUES("64058","_transient__bbp_183.223.218.51_last_posted","1423513012","yes");
INSERT INTO `wp_options` VALUES("64074","_transient__bbp_58.252.72.179_last_posted","1427347476","yes");
INSERT INTO `wp_options` VALUES("64108","_transient__bbp_186.95.245.156_last_posted","1423518355","yes");
INSERT INTO `wp_options` VALUES("64127","_transient__bbp_186.91.89.55_last_posted","1423520405","yes");
INSERT INTO `wp_options` VALUES("64146","_transient__bbp_5.153.59.141_last_posted","1423523293","yes");
INSERT INTO `wp_options` VALUES("64147","_transient__bbp_202.106.169.228_last_posted","1423523304","yes");
INSERT INTO `wp_options` VALUES("64169","_transient__bbp_183.218.63.59_last_posted","1427190438","yes");
INSERT INTO `wp_options` VALUES("64170","_transient__bbp_186.93.9.74_last_posted","1423953122","yes");
INSERT INTO `wp_options` VALUES("64189","_transient__bbp_175.43.20.95_last_posted","1427701755","yes");
INSERT INTO `wp_options` VALUES("64190","_transient__bbp_134.208.39.180_last_posted","1423745464","yes");
INSERT INTO `wp_options` VALUES("64212","_transient__bbp_117.173.20.148_last_posted","1423530695","yes");
INSERT INTO `wp_options` VALUES("64262","_transient__bbp_118.201.155.68_last_posted","1423535895","yes");
INSERT INTO `wp_options` VALUES("64287","_transient__bbp_223.85.81.185_last_posted","1423538149","yes");
INSERT INTO `wp_options` VALUES("64291","_transient__bbp_218.78.210.190_last_posted","1427393513","yes");
INSERT INTO `wp_options` VALUES("64337","_transient__bbp_203.192.10.66_last_posted","1426248807","yes");
INSERT INTO `wp_options` VALUES("64362","_transient__bbp_111.10.49.29_last_posted","1423546001","yes");
INSERT INTO `wp_options` VALUES("64378","_transient__bbp_49.4.180.70_last_posted","1423547753","yes");
INSERT INTO `wp_options` VALUES("64419","_transient__bbp_117.173.22.54_last_posted","1423552271","yes");
INSERT INTO `wp_options` VALUES("64420","_transient__bbp_183.220.105.71_last_posted","1423552419","yes");
INSERT INTO `wp_options` VALUES("64463","_transient__bbp_183.224.1.12_last_posted","1426953680","yes");
INSERT INTO `wp_options` VALUES("64467","_transient__bbp_58.214.5.226_last_posted","1427593816","yes");
INSERT INTO `wp_options` VALUES("64468","_transient__bbp_201.243.195.187_last_posted","1423557249","yes");
INSERT INTO `wp_options` VALUES("64487","_transient__bbp_117.21.193.2_last_posted","1423559619","yes");
INSERT INTO `wp_options` VALUES("64545","_transient__bbp_183.222.152.201_last_posted","1423565496","yes");
INSERT INTO `wp_options` VALUES("64621","_transient__bbp_223.86.68.253_last_posted","1423573827","yes");
INSERT INTO `wp_options` VALUES("64622","_transient__bbp_183.224.1.13_last_posted","1427062896","yes");
INSERT INTO `wp_options` VALUES("64638","_transient__bbp_123.110.131.167_last_posted","1423575526","yes");
INSERT INTO `wp_options` VALUES("64642","_transient__bbp_61.57.90.29_last_posted","1423575571","yes");
INSERT INTO `wp_options` VALUES("64671","_transient__bbp_200.124.225.76_last_posted","1423579150","yes");
INSERT INTO `wp_options` VALUES("64690","_transient__bbp_183.220.198.87_last_posted","1423580720","yes");
INSERT INTO `wp_options` VALUES("64727","_transient__bbp_183.178.197.181_last_posted","1423586052","yes");
INSERT INTO `wp_options` VALUES("64731","_transient__bbp_211.141.130.96_last_posted","1427363376","yes");
INSERT INTO `wp_options` VALUES("64808","_transient__bbp_190.202.173.94_last_posted","1424324464","yes");
INSERT INTO `wp_options` VALUES("64854","_transient__bbp_186.91.59.144_last_posted","1423599087","yes");
INSERT INTO `wp_options` VALUES("64864","_transient__bbp_140.123.124.150_last_posted","1423600593","yes");
INSERT INTO `wp_options` VALUES("64973","_transient__bbp_78.36.205.18_last_posted","1423926395","yes");
INSERT INTO `wp_options` VALUES("65027","_transient__bbp_213.114.238.64_last_posted","1423619954","yes");
INSERT INTO `wp_options` VALUES("64990","_transient__bbp_200.90.84.103_last_posted","1423615480","yes");
INSERT INTO `wp_options` VALUES("65067","_transient__bbp_130.255.61.211_last_posted","1426153245","yes");
INSERT INTO `wp_options` VALUES("65074","_transient__bbp_115.43.17.163_last_posted","1423625345","yes");
INSERT INTO `wp_options` VALUES("65081","_transient__bbp_117.173.21.247_last_posted","1423626226","yes");
INSERT INTO `wp_options` VALUES("65100","_transient__bbp_183.203.208.179_last_posted","1427114867","yes");
INSERT INTO `wp_options` VALUES("65110","_transient__bbp_223.86.67.235_last_posted","1423630541","yes");
INSERT INTO `wp_options` VALUES("65141","_transient__bbp_142.4.212.20_last_posted","1423633689","yes");
INSERT INTO `wp_options` VALUES("65203","_transient__bbp_121.243.51.107_last_posted","1424294478","yes");
INSERT INTO `wp_options` VALUES("65243","_transient__bbp_86.122.124.11_last_posted","1424800833","yes");
INSERT INTO `wp_options` VALUES("65247","_transient__bbp_175.44.9.93_last_posted","1423644985","yes");
INSERT INTO `wp_options` VALUES("65266","_transient__bbp_124.158.222.231_last_posted","1423647172","yes");
INSERT INTO `wp_options` VALUES("65279","_transient__bbp_203.187.230.251_last_posted","1423648922","yes");
INSERT INTO `wp_options` VALUES("62671","_transient__bbp_201.209.55.116_last_posted","1423363061","yes");
INSERT INTO `wp_options` VALUES("62684","_transient__bbp_117.169.1.184_last_posted","1423364747","yes");
INSERT INTO `wp_options` VALUES("62685","_transient__bbp_222.45.196.46_last_posted","1427228064","yes");
INSERT INTO `wp_options` VALUES("62698","_transient__bbp_188.132.226.2_last_posted","1427408701","yes");
INSERT INTO `wp_options` VALUES("62714","_transient__bbp_117.169.1.9_last_posted","1426489903","yes");
INSERT INTO `wp_options` VALUES("62727","_transient__bbp_91.72.220.218_last_posted","1425697863","yes");
INSERT INTO `wp_options` VALUES("62737","_transient__bbp_119.46.91.234_last_posted","1425398255","yes");
INSERT INTO `wp_options` VALUES("62769","_transient__bbp_111.85.83.61_last_posted","1423374114","yes");
INSERT INTO `wp_options` VALUES("62782","_transient__bbp_117.135.250.51_last_posted","1423464650","yes");
INSERT INTO `wp_options` VALUES("62806","_transient__bbp_222.45.196.45_last_posted","1427253592","yes");
INSERT INTO `wp_options` VALUES("62819","_transient__bbp_120.202.249.204_last_posted","1426210500","yes");
INSERT INTO `wp_options` VALUES("62835","_transient__bbp_117.173.16.88_last_posted","1423380177","yes");
INSERT INTO `wp_options` VALUES("62854","_transient__bbp_120.236.148.113_last_posted","1427367257","yes");
INSERT INTO `wp_options` VALUES("62885","_transient__bbp_183.203.208.173_last_posted","1427469566","yes");
INSERT INTO `wp_options` VALUES("62917","_transient__bbp_195.154.211.26_last_posted","1423389098","yes");
INSERT INTO `wp_options` VALUES("62945","_transient__bbp_118.163.151.173_last_posted","1423497740","yes");
INSERT INTO `wp_options` VALUES("62952","_transient__bbp_117.169.1.6_last_posted","1423392642","yes");
INSERT INTO `wp_options` VALUES("62983","_transient__bbp_2001:41d0:52:cff::5f2_last_posted","1423971770","yes");
INSERT INTO `wp_options` VALUES("62993","_transient__bbp_117.173.21.157_last_posted","1423396479","yes");
INSERT INTO `wp_options` VALUES("63015","_transient__bbp_202.107.233.85_last_posted","1427059269","yes");
INSERT INTO `wp_options` VALUES("63028","_transient__bbp_211.152.50.70_last_posted","1423399975","yes");
INSERT INTO `wp_options` VALUES("63044","_transient__bbp_223.86.215.243_last_posted","1423402087","yes");
INSERT INTO `wp_options` VALUES("63073","_transient__bbp_211.77.5.41_last_posted","1423404810","yes");
INSERT INTO `wp_options` VALUES("63110","_transient__bbp_67.215.230.82_last_posted","1424299940","yes");
INSERT INTO `wp_options` VALUES("63180","_transient__bbp_183.220.105.75_last_posted","1423446392","yes");
INSERT INTO `wp_options` VALUES("63218","_transient__bbp_117.173.21.174_last_posted","1423420569","yes");
INSERT INTO `wp_options` VALUES("63243","_transient__bbp_190.199.56.226_last_posted","1423423207","yes");
INSERT INTO `wp_options` VALUES("63256","_transient__bbp_2001:41d0:51:1::4ae_last_posted","1427284453","yes");
INSERT INTO `wp_options` VALUES("63266","_transient__bbp_121.14.138.50_last_posted","1427331668","yes");
INSERT INTO `wp_options` VALUES("63303","_transient__bbp_58.61.29.233_last_posted","1427701412","yes");
INSERT INTO `wp_options` VALUES("63316","_transient__bbp_223.86.216.104_last_posted","1423431394","yes");
INSERT INTO `wp_options` VALUES("63335","_transient__bbp_117.177.240.39_last_posted","1425998413","yes");
INSERT INTO `wp_options` VALUES("63351","_transient__bbp_117.177.141.32_last_posted","1423434873","yes");
INSERT INTO `wp_options` VALUES("63364","_transient__bbp_180.176.175.13_last_posted","1423969343","yes");
INSERT INTO `wp_options` VALUES("63413","_transient__bbp_190.36.7.211_last_posted","1423441346","yes");
INSERT INTO `wp_options` VALUES("63435","_transient__bbp_117.177.147.5_last_posted","1423443784","yes");
INSERT INTO `wp_options` VALUES("63454","_transient__bbp_198.50.195.97_last_posted","1423445401","yes");
INSERT INTO `wp_options` VALUES("63499","_transient__bbp_182.254.129.68_last_posted","1427707518","yes");
INSERT INTO `wp_options` VALUES("63536","_transient__bbp_183.203.208.171_last_posted","1427377983","yes");
INSERT INTO `wp_options` VALUES("63552","_transient__bbp_183.222.152.237_last_posted","1423460200","yes");
INSERT INTO `wp_options` VALUES("63574","_transient__bbp_220.135.237.167_last_posted","1423458802","yes");
INSERT INTO `wp_options` VALUES("63608","_transient__bbp_58.240.238.218_last_posted","1427629356","yes");
INSERT INTO `wp_options` VALUES("63644","_transient__bbp_117.174.206.120_last_posted","1423466398","yes");
INSERT INTO `wp_options` VALUES("63660","_transient__bbp_198.12.76.168_last_posted","1423468158","yes");
INSERT INTO `wp_options` VALUES("63670","_transient__bbp_182.235.39.76_last_posted","1423469279","yes");
INSERT INTO `wp_options` VALUES("63705","_transient__bbp_185.54.4.198_last_posted","1427157855","yes");
INSERT INTO `wp_options` VALUES("117881","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1429581578","no");
INSERT INTO `wp_options` VALUES("117882","_transient_feed_mod_b9388c83948825c1edaef0d856b7b109","1429538378","no");
INSERT INTO `wp_options` VALUES("114247","updraft_dropbox","a:5:{s:6:\"appkey\";N;s:6:\"secret\";N;s:6:\"folder\";N;s:16:\"tk_request_token\";N;s:15:\"tk_access_token\";N;}","yes");
INSERT INTO `wp_options` VALUES("61119","_transient__bbp_27.187.214.135_last_posted","1423558690","yes");
INSERT INTO `wp_options` VALUES("62122","_transient__bbp_183.223.204.203_last_posted","1423306394","yes");
INSERT INTO `wp_options` VALUES("62129","_transient__bbp_183.223.204.170_last_posted","1423306974","yes");
INSERT INTO `wp_options` VALUES("61970","_transient__bbp_220.160.142.85_last_posted","1423289423","yes");
INSERT INTO `wp_options` VALUES("62136","_transient__bbp_1.34.191.236_last_posted","1423438192","yes");
INSERT INTO `wp_options` VALUES("65320","_transient__bbp_119.147.91.21_last_posted","1424623878","yes");
INSERT INTO `wp_options` VALUES("65324","_transient__bbp_197.234.70.162_last_posted","1423653821","yes");
INSERT INTO `wp_options` VALUES("65361","_transient__bbp_184.161.53.102_last_posted","1423658428","yes");
INSERT INTO `wp_options` VALUES("65371","_transient__bbp_175.44.25.7_last_posted","1423659301","yes");
INSERT INTO `wp_options` VALUES("65384","_transient__bbp_85.154.230.162_last_posted","1423896271","yes");
INSERT INTO `wp_options` VALUES("65405","_transient__bbp_119.28.3.200_last_posted","1427312712","yes");
INSERT INTO `wp_options` VALUES("65412","_transient__bbp_198.50.211.54_last_posted","1424726189","yes");
INSERT INTO `wp_options` VALUES("65452","_transient__bbp_59.125.78.183_last_posted","1423667953","yes");
INSERT INTO `wp_options` VALUES("65504","_transient__bbp_31.170.237.202_last_posted","1423673095","yes");
INSERT INTO `wp_options` VALUES("65526","_transient__bbp_186.88.112.128_last_posted","1423675328","yes");
INSERT INTO `wp_options` VALUES("65588","_transient__bbp_61.156.3.166_last_posted","1427331944","yes");
INSERT INTO `wp_options` VALUES("65607","_transient__bbp_58.215.185.46_last_posted","1426048419","yes");
INSERT INTO `wp_options` VALUES("65633","_transient__bbp_114.80.182.132_last_posted","1427320526","yes");
INSERT INTO `wp_options` VALUES("65661","_transient__bbp_213.238.175.29_last_posted","1423689222","yes");
INSERT INTO `wp_options` VALUES("65692","_transient__bbp_190.73.122.109_last_posted","1423693088","yes");
INSERT INTO `wp_options` VALUES("65708","_transient__bbp_186.91.41.139_last_posted","1423694879","yes");
INSERT INTO `wp_options` VALUES("65748","_transient__bbp_123.249.34.12_last_posted","1426496721","yes");
INSERT INTO `wp_options` VALUES("65764","_transient__bbp_190.77.234.101_last_posted","1423701773","yes");
INSERT INTO `wp_options` VALUES("65786","_transient__bbp_117.169.1.90_last_posted","1425543123","yes");
INSERT INTO `wp_options` VALUES("65787","_transient__bbp_61.184.192.42_last_posted","1426052769","yes");
INSERT INTO `wp_options` VALUES("65883","_transient__bbp_186.90.101.187_last_posted","1423714491","yes");
INSERT INTO `wp_options` VALUES("65917","_transient__bbp_83.128.239.152_last_posted","1423718760","yes");
INSERT INTO `wp_options` VALUES("65957","_transient__bbp_219.93.183.103_last_posted","1424569561","yes");
INSERT INTO `wp_options` VALUES("66005","_transient__bbp_200.109.192.122_last_posted","1423727268","yes");
INSERT INTO `wp_options` VALUES("66012","_transient__bbp_124.123.42.207_last_posted","1423727795","yes");
INSERT INTO `wp_options` VALUES("66019","_transient__bbp_222.45.196.17_last_posted","1425622293","yes");
INSERT INTO `wp_options` VALUES("66041","_transient__bbp_60.251.242.122_last_posted","1423731208","yes");
INSERT INTO `wp_options` VALUES("66139","_transient__bbp_91.202.26.170_last_posted","1423907217","yes");
INSERT INTO `wp_options` VALUES("66222","_transient__bbp_183.222.154.85_last_posted","1423748946","yes");
INSERT INTO `wp_options` VALUES("66286","_transient__bbp_27.147.158.188_last_posted","1423755211","yes");
INSERT INTO `wp_options` VALUES("66296","_transient__bbp_190.37.76.22_last_posted","1423755880","yes");
INSERT INTO `wp_options` VALUES("66297","_transient__bbp_41.222.206.51_last_posted","1423756061","yes");
INSERT INTO `wp_options` VALUES("66329","_transient__bbp_14.199.236.214_last_posted","1423758971","yes");
INSERT INTO `wp_options` VALUES("66330","_transient__bbp_218.29.130.91_last_posted","1423817871","yes");
INSERT INTO `wp_options` VALUES("66352","_transient__bbp_178.249.14.19_last_posted","1425096771","yes");
INSERT INTO `wp_options` VALUES("66451","_transient__bbp_183.222.159.19_last_posted","1423778061","yes");
INSERT INTO `wp_options` VALUES("66477","_transient__bbp_117.169.1.140_last_posted","1427665713","yes");
INSERT INTO `wp_options` VALUES("66456","_transient__bbp_175.44.4.147_last_posted","1423771491","yes");
INSERT INTO `wp_options` VALUES("66598","_transient__bbp_211.141.130.245_last_posted","1426884835","yes");
INSERT INTO `wp_options` VALUES("66611","_transient__bbp_117.169.1.101_last_posted","1424306359","yes");
INSERT INTO `wp_options` VALUES("66615","_transient__bbp_117.169.1.186_last_posted","1424246247","yes");
INSERT INTO `wp_options` VALUES("66634","_transient__bbp_117.176.55.50_last_posted","1423789769","yes");
INSERT INTO `wp_options` VALUES("66657","_transient__bbp_117.177.240.37_last_posted","1423791971","yes");
INSERT INTO `wp_options` VALUES("66730","_transient__bbp_111.9.234.220_last_posted","1423799636","yes");
INSERT INTO `wp_options` VALUES("66734","_transient__bbp_103.224.81.170_last_posted","1423799769","yes");
INSERT INTO `wp_options` VALUES("66756","_transient__bbp_183.222.157.169_last_posted","1423802300","yes");
INSERT INTO `wp_options` VALUES("66805","_transient__bbp_210.119.81.109_last_posted","1423807063","yes");
INSERT INTO `wp_options` VALUES("66853","_transient__bbp_211.141.133.100_last_posted","1427280189","yes");
INSERT INTO `wp_options` VALUES("66890","_transient__bbp_183.222.161.233_last_posted","1423815475","yes");
INSERT INTO `wp_options` VALUES("66955","_transient__bbp_37.59.36.198_last_posted","1427070754","yes");
INSERT INTO `wp_options` VALUES("67040","_transient__bbp_84.253.75.6_last_posted","1425757379","yes");
INSERT INTO `wp_options` VALUES("67059","_transient__bbp_89.39.12.57_last_posted","1423833868","yes");
INSERT INTO `wp_options` VALUES("67112","_transient__bbp_183.222.153.115_last_posted","1423839065","yes");
INSERT INTO `wp_options` VALUES("67185","_transient__bbp_117.173.21.206_last_posted","1423863304","yes");
INSERT INTO `wp_options` VALUES("67213","_transient__bbp_91.207.9.154_last_posted","1427585936","yes");
INSERT INTO `wp_options` VALUES("67214","_transient__bbp_218.191.141.226_last_posted","1423848751","yes");
INSERT INTO `wp_options` VALUES("67215","_transient__bbp_183.223.209.106_last_posted","1423848793","yes");
INSERT INTO `wp_options` VALUES("67234","_transient__bbp_119.6.78.39_last_posted","1423850939","yes");
INSERT INTO `wp_options` VALUES("67264","_transient__bbp_91.207.9.146_last_posted","1427567831","yes");
INSERT INTO `wp_options` VALUES("67268","_transient__bbp_111.10.146.209_last_posted","1423853619","yes");
INSERT INTO `wp_options` VALUES("67290","_transient__bbp_222.59.246.38_last_posted","1426957728","yes");
INSERT INTO `wp_options` VALUES("67342","_transient__bbp_5.226.86.83_last_posted","1427038600","yes");
INSERT INTO `wp_options` VALUES("67349","_transient__bbp_212.68.51.58_last_posted","1427574943","yes");
INSERT INTO `wp_options` VALUES("67446","_transient__bbp_117.173.200.199_last_posted","1423870623","yes");
INSERT INTO `wp_options` VALUES("67468","_transient__bbp_186.94.38.207_last_posted","1423872699","yes");
INSERT INTO `wp_options` VALUES("67499","_transient__bbp_89.39.12.71_last_posted","1423875724","yes");
INSERT INTO `wp_options` VALUES("67518","_transient__bbp_42.121.105.155_last_posted","1427363750","yes");
INSERT INTO `wp_options` VALUES("67589","_transient__bbp_117.173.20.16_last_posted","1423885144","yes");
INSERT INTO `wp_options` VALUES("67605","_transient__bbp_117.169.1.224_last_posted","1423887406","yes");
INSERT INTO `wp_options` VALUES("67703","_transient__bbp_117.173.61.138_last_posted","1423898391","yes");
INSERT INTO `wp_options` VALUES("67725","_transient__bbp_183.227.217.186_last_posted","1423900493","yes");
INSERT INTO `wp_options` VALUES("67825","_transient__bbp_159.224.171.1_last_posted","1423911435","yes");
INSERT INTO `wp_options` VALUES("67929","_transient__bbp_190.77.198.216_last_posted","1423922893","yes");
INSERT INTO `wp_options` VALUES("68047","_transient__bbp_83.87.193.246_last_posted","1423935932","yes");
INSERT INTO `wp_options` VALUES("68089","_transient__bbp_116.236.216.116_last_posted","1427342670","yes");
INSERT INTO `wp_options` VALUES("77356","_transient__bbp_2602:306:3077:2e60:388c:b7a7:65fb:9df9_last_post","1425177854","yes");
INSERT INTO `wp_options` VALUES("79379","_transient__bbp_117.169.1.154_last_posted","1427713792","yes");
INSERT INTO `wp_options` VALUES("68317","_transient__bbp_183.222.153.127_last_posted","1423967365","yes");
INSERT INTO `wp_options` VALUES("68372","_transient__bbp_103.38.18.112_last_posted","1423974200","yes");
INSERT INTO `wp_options` VALUES("68376","_transient__bbp_117.175.109.62_last_posted","1423974440","yes");
INSERT INTO `wp_options` VALUES("68481","_transient__bbp_186.93.20.57_last_posted","1423988338","yes");
INSERT INTO `wp_options` VALUES("68503","_transient__bbp_61.70.81.30_last_posted","1423990681","yes");
INSERT INTO `wp_options` VALUES("68507","_transient__bbp_183.222.154.113_last_posted","1423990838","yes");
INSERT INTO `wp_options` VALUES("68527","_transient__bbp_58.252.167.103_last_posted","1424835135","yes");
INSERT INTO `wp_options` VALUES("68550","_transient__bbp_85.15.176.223_last_posted","1426188772","yes");
INSERT INTO `wp_options` VALUES("68581","_transient__bbp_211.141.230.23_last_posted","1423999501","yes");
INSERT INTO `wp_options` VALUES("68624","_transient__bbp_121.12.120.246_last_posted","1424795621","yes");
INSERT INTO `wp_options` VALUES("68686","_transient__bbp_117.169.1.67_last_posted","1424330164","yes");
INSERT INTO `wp_options` VALUES("68696","_transient__bbp_223.86.79.23_last_posted","1424012083","yes");
INSERT INTO `wp_options` VALUES("68712","_transient__bbp_117.177.147.84_last_posted","1424013520","yes");
INSERT INTO `wp_options` VALUES("68719","_transient__bbp_54.225.192.171_last_posted","1424014061","yes");
INSERT INTO `wp_options` VALUES("68744","_transient__bbp_117.166.18.126_last_posted","1424018459","yes");
INSERT INTO `wp_options` VALUES("68754","_transient__bbp_117.169.1.91_last_posted","1426473069","yes");
INSERT INTO `wp_options` VALUES("68761","_transient__bbp_111.10.145.76_last_posted","1424019996","yes");
INSERT INTO `wp_options` VALUES("68795","_transient__bbp_117.169.1.131_last_posted","1425405027","yes");
INSERT INTO `wp_options` VALUES("68805","_transient__bbp_117.169.1.228_last_posted","1424458580","yes");
INSERT INTO `wp_options` VALUES("68814","_transient__bbp_117.169.1.124_last_posted","1424025312","yes");
INSERT INTO `wp_options` VALUES("68848","_transient__bbp_117.169.1.240_last_posted","1425680780","yes");
INSERT INTO `wp_options` VALUES("68888","_transient__bbp_183.222.159.83_last_posted","1424439396","yes");
INSERT INTO `wp_options` VALUES("68901","_transient__bbp_190.203.41.179_last_posted","1424034825","yes");
INSERT INTO `wp_options` VALUES("68908","_transient__bbp_2001:41d0:51:1::12b7_last_posted","1425930171","yes");
INSERT INTO `wp_options` VALUES("68930","_transient__bbp_117.169.1.96_last_posted","1424038907","yes");
INSERT INTO `wp_options` VALUES("68937","_transient__bbp_190.205.117.229_last_posted","1424039667","yes");
INSERT INTO `wp_options` VALUES("68968","_transient__bbp_117.169.1.35_last_posted","1424044184","yes");
INSERT INTO `wp_options` VALUES("68978","_transient__bbp_117.169.1.209_last_posted","1424044892","yes");
INSERT INTO `wp_options` VALUES("68979","_transient__bbp_183.223.213.83_last_posted","1424044925","yes");
INSERT INTO `wp_options` VALUES("68992","_transient__bbp_117.169.1.106_last_posted","1427575561","yes");
INSERT INTO `wp_options` VALUES("69017","_transient__bbp_117.169.1.17_last_posted","1424128950","yes");
INSERT INTO `wp_options` VALUES("69024","_transient__bbp_112.19.112.30_last_posted","1424049949","yes");
INSERT INTO `wp_options` VALUES("69025","_transient__bbp_198.204.255.10_last_posted","1424050150","yes");
INSERT INTO `wp_options` VALUES("69042","_transient__bbp_117.169.1.166_last_posted","1427565431","yes");
INSERT INTO `wp_options` VALUES("69070","_transient__bbp_117.169.1.220_last_posted","1424147656","yes");
INSERT INTO `wp_options` VALUES("69077","_transient__bbp_112.19.127.235_last_posted","1424055858","yes");
INSERT INTO `wp_options` VALUES("69090","_transient__bbp_117.166.243.239_last_posted","1424255223","yes");
INSERT INTO `wp_options` VALUES("69115","_transient__bbp_117.169.1.117_last_posted","1424207596","yes");
INSERT INTO `wp_options` VALUES("69119","_transient__bbp_183.220.246.236_last_posted","1424061512","yes");
INSERT INTO `wp_options` VALUES("69126","_transient__bbp_117.169.1.49_last_posted","1427591351","yes");
INSERT INTO `wp_options` VALUES("69157","_transient__bbp_117.169.1.150_last_posted","1427491865","yes");
INSERT INTO `wp_options` VALUES("69161","_transient__bbp_117.169.1.180_last_posted","1424416427","yes");
INSERT INTO `wp_options` VALUES("69181","_transient__bbp_117.169.1.171_last_posted","1427491856","yes");
INSERT INTO `wp_options` VALUES("69206","_transient__bbp_117.169.1.200_last_posted","1424330378","yes");
INSERT INTO `wp_options` VALUES("69207","_transient__bbp_221.178.85.27_last_posted","1424119440","yes");
INSERT INTO `wp_options` VALUES("69217","_transient__bbp_221.178.119.54_last_posted","1424074517","yes");
INSERT INTO `wp_options` VALUES("69224","_transient__bbp_117.169.1.230_last_posted","1427482389","yes");
INSERT INTO `wp_options` VALUES("69252","_transient__bbp_223.86.68.109_last_posted","1424174279","yes");
INSERT INTO `wp_options` VALUES("69259","_transient__bbp_117.169.1.210_last_posted","1427491901","yes");
INSERT INTO `wp_options` VALUES("69269","_transient__bbp_117.169.1.217_last_posted","1427622796","yes");
INSERT INTO `wp_options` VALUES("69291","_transient__bbp_117.169.1.149_last_posted","1425479791","yes");
INSERT INTO `wp_options` VALUES("69334","_transient__bbp_183.220.106.80_last_posted","1424092657","yes");
INSERT INTO `wp_options` VALUES("69338","_transient__bbp_183.223.204.74_last_posted","1424093190","yes");
INSERT INTO `wp_options` VALUES("69349","_transient__bbp_188.94.168.30_last_posted","1424094579","yes");
INSERT INTO `wp_options` VALUES("69383","_transient__bbp_183.223.215.135_last_posted","1424098885","yes");
INSERT INTO `wp_options` VALUES("69393","_transient__bbp_27.2.207.156_last_posted","1424100870","yes");
INSERT INTO `wp_options` VALUES("69424","_transient__bbp_117.169.1.28_last_posted","1425587731","yes");
INSERT INTO `wp_options` VALUES("69425","_transient__bbp_2400:6180:0:d0::370:a001_last_posted","1424105220","yes");
INSERT INTO `wp_options` VALUES("70122","_transient__bbp_117.169.1.71_last_posted","1426533834","yes");
INSERT INTO `wp_options` VALUES("69468","_transient__bbp_117.169.1.75_last_posted","1427559299","yes");
INSERT INTO `wp_options` VALUES("69503","_transient__bbp_117.169.1.159_last_posted","1426688464","yes");
INSERT INTO `wp_options` VALUES("69510","_transient__bbp_117.169.1.221_last_posted","1427520418","yes");
INSERT INTO `wp_options` VALUES("69565","_transient__bbp_117.169.1.145_last_posted","1426501939","yes");
INSERT INTO `wp_options` VALUES("69584","_transient__bbp_211.141.130.56_last_posted","1427606837","yes");
INSERT INTO `wp_options` VALUES("69588","_transient__bbp_117.169.1.44_last_posted","1427606935","yes");
INSERT INTO `wp_options` VALUES("69592","_transient__bbp_175.44.24.170_last_posted","1424129222","yes");
INSERT INTO `wp_options` VALUES("69632","_transient__bbp_39.182.11.190_last_posted","1424137089","yes");
INSERT INTO `wp_options` VALUES("69652","_transient__bbp_117.173.22.223_last_posted","1424140700","yes");
INSERT INTO `wp_options` VALUES("69668","_transient__bbp_117.169.1.206_last_posted","1427498679","yes");
INSERT INTO `wp_options` VALUES("69690","_transient__bbp_117.169.1.185_last_posted","1426630069","yes");
INSERT INTO `wp_options` VALUES("69709","_transient__bbp_123.110.134.102_last_posted","1424149698","yes");
INSERT INTO `wp_options` VALUES("69731","_transient__bbp_117.169.1.24_last_posted","1424153364","yes");
INSERT INTO `wp_options` VALUES("69735","_transient__bbp_54.191.182.62_last_posted","1424153938","yes");
INSERT INTO `wp_options` VALUES("69739","_transient__bbp_117.169.1.55_last_posted","1424154016","yes");
INSERT INTO `wp_options` VALUES("69762","_transient__bbp_117.169.1.164_last_posted","1427497132","yes");
INSERT INTO `wp_options` VALUES("69787","_transient__bbp_117.169.1.18_last_posted","1424159546","yes");
INSERT INTO `wp_options` VALUES("69806","_transient__bbp_117.169.1.161_last_posted","1426529038","yes");
INSERT INTO `wp_options` VALUES("69846","_transient__bbp_42.82.90.105_last_posted","1424166429","yes");
INSERT INTO `wp_options` VALUES("69886","_transient__bbp_118.244.255.13_last_posted","1427237439","yes");
INSERT INTO `wp_options` VALUES("69890","_transient__bbp_110.247.28.102_last_posted","1424306196","yes");
INSERT INTO `wp_options` VALUES("69897","_transient__bbp_119.188.94.145_last_posted","1424619559","yes");
INSERT INTO `wp_options` VALUES("69925","_transient__bbp_117.169.1.218_last_posted","1426578168","yes");
INSERT INTO `wp_options` VALUES("69950","_transient__bbp_177.124.164.10_last_posted","1424340293","yes");
INSERT INTO `wp_options` VALUES("69994","_transient__bbp_190.201.35.47_last_posted","1424186203","yes");
INSERT INTO `wp_options` VALUES("70019","_transient__bbp_39.64.64.68_last_posted","1424830636","yes");
INSERT INTO `wp_options` VALUES("70023","_transient__bbp_117.169.1.107_last_posted","1424189796","yes");
INSERT INTO `wp_options` VALUES("70075","_transient__bbp_54.207.199.79_last_posted","1424195746","yes");
INSERT INTO `wp_options` VALUES("70098","_transient__bbp_190.38.1.230_last_posted","1424197993","yes");
INSERT INTO `wp_options` VALUES("70120","_transient__bbp_123.125.19.44_last_posted","1427025807","yes");
INSERT INTO `wp_options` VALUES("70121","_transient__bbp_117.169.1.205_last_posted","1427568956","yes");
INSERT INTO `wp_options` VALUES("70171","_transient__bbp_117.169.1.214_last_posted","1426364096","yes");
INSERT INTO `wp_options` VALUES("70220","_transient__bbp_117.169.1.68_last_posted","1427626760","yes");
INSERT INTO `wp_options` VALUES("70221","_transient__bbp_183.222.157.216_last_posted","1424213282","yes");
INSERT INTO `wp_options` VALUES("70261","_transient__bbp_117.169.1.136_last_posted","1425335179","yes");
INSERT INTO `wp_options` VALUES("70283","_transient__bbp_49.4.167.139_last_posted","1424989951","yes");
INSERT INTO `wp_options` VALUES("70321","_transient__bbp_190.37.228.237_last_posted","1424225426","yes");
INSERT INTO `wp_options` VALUES("70337","_transient__bbp_183.220.128.68_last_posted","1424227719","yes");
INSERT INTO `wp_options` VALUES("70374","_transient__bbp_203.110.169.108_last_posted","1425792287","yes");
INSERT INTO `wp_options` VALUES("70390","_transient__bbp_190.198.153.24_last_posted","1424234436","yes");
INSERT INTO `wp_options` VALUES("70412","_transient__bbp_178.211.164.146_last_posted","1424238157","yes");
INSERT INTO `wp_options` VALUES("70413","_transient__bbp_117.169.1.114_last_posted","1424238196","yes");
INSERT INTO `wp_options` VALUES("70445","_transient__bbp_117.169.1.151_last_posted","1427671569","yes");
INSERT INTO `wp_options` VALUES("70449","_transient__bbp_117.169.1.237_last_posted","1424243939","yes");
INSERT INTO `wp_options` VALUES("70453","_transient__bbp_117.175.62.50_last_posted","1424244077","yes");
INSERT INTO `wp_options` VALUES("70490","_transient__bbp_112.26.162.4_last_posted","1424248837","yes");
INSERT INTO `wp_options` VALUES("70497","_transient__bbp_117.169.1.215_last_posted","1425603241","yes");
INSERT INTO `wp_options` VALUES("70498","_transient__bbp_117.169.1.195_last_posted","1425265335","yes");
INSERT INTO `wp_options` VALUES("70551","_transient__bbp_54.187.174.193_last_posted","1424255395","yes");
INSERT INTO `wp_options` VALUES("70585","_transient__bbp_111.9.232.44_last_posted","1424335451","yes");
INSERT INTO `wp_options` VALUES("70619","_transient__bbp_183.223.214.131_last_posted","1424266281","yes");
INSERT INTO `wp_options` VALUES("70645","_transient__bbp_190.206.226.87_last_posted","1424270592","yes");
INSERT INTO `wp_options` VALUES("70649","_transient__bbp_183.222.155.241_last_posted","1424270847","yes");
INSERT INTO `wp_options` VALUES("70695","_transient__bbp_117.169.1.118_last_posted","1427282916","yes");
INSERT INTO `wp_options` VALUES("70702","_transient__bbp_124.205.129.99_last_posted","1425890558","yes");
INSERT INTO `wp_options` VALUES("70712","_transient__bbp_117.169.1.129_last_posted","1427547602","yes");
INSERT INTO `wp_options` VALUES("70740","_transient__bbp_218.204.141.92_last_posted","1427026628","yes");
INSERT INTO `wp_options` VALUES("70750","_transient__bbp_117.169.1.79_last_posted","1424283784","yes");
INSERT INTO `wp_options` VALUES("70785","_transient__bbp_112.26.162.16_last_posted","1424735085","yes");
INSERT INTO `wp_options` VALUES("70792","_transient__bbp_117.169.1.37_last_posted","1427495257","yes");
INSERT INTO `wp_options` VALUES("70796","_transient__bbp_117.169.1.211_last_posted","1427613776","yes");
INSERT INTO `wp_options` VALUES("70827","_transient__bbp_117.169.1.187_last_posted","1425375077","yes");
INSERT INTO `wp_options` VALUES("70873","_transient__bbp_199.167.228.36_last_posted","1426721406","yes");
INSERT INTO `wp_options` VALUES("70895","_transient__bbp_117.169.1.199_last_posted","1427473110","yes");
INSERT INTO `wp_options` VALUES("70902","_transient__bbp_201.211.248.133_last_posted","1424306452","yes");
INSERT INTO `wp_options` VALUES("70937","_transient__bbp_201.210.61.127_last_posted","1424311841","yes");
INSERT INTO `wp_options` VALUES("70938","_transient__bbp_188.143.233.145_last_posted","1424409793","yes");
INSERT INTO `wp_options` VALUES("70945","_transient__bbp_190.77.173.65_last_posted","1424312522","yes");
INSERT INTO `wp_options` VALUES("70973","_transient__bbp_175.111.39.9_last_posted","1424318079","yes");
INSERT INTO `wp_options` VALUES("70980","_transient__bbp_117.169.1.169_last_posted","1427620355","yes");
INSERT INTO `wp_options` VALUES("71008","_transient__bbp_183.228.73.248_last_posted","1424323888","yes");
INSERT INTO `wp_options` VALUES("71094","_transient__bbp_123.241.107.14_last_posted","1424335826","yes");
INSERT INTO `wp_options` VALUES("71095","_transient__bbp_117.169.1.147_last_posted","1426400100","yes");
INSERT INTO `wp_options` VALUES("71156","_transient__bbp_183.220.246.254_last_posted","1424345355","yes");
INSERT INTO `wp_options` VALUES("71160","_transient__bbp_111.9.232.128_last_posted","1424345810","yes");
INSERT INTO `wp_options` VALUES("71191","_transient__bbp_190.204.245.249_last_posted","1424350535","yes");
INSERT INTO `wp_options` VALUES("71229","_transient__bbp_190.205.155.190_last_posted","1424355223","yes");
INSERT INTO `wp_options` VALUES("71269","_transient__bbp_94.213.182.96_last_posted","1424360212","yes");
INSERT INTO `wp_options` VALUES("71273","_transient__bbp_190.77.187.97_last_posted","1424360482","yes");
INSERT INTO `wp_options` VALUES("71277","_transient__bbp_186.93.188.79_last_posted","1424361193","yes");
INSERT INTO `wp_options` VALUES("71397","_transient__bbp_117.177.240.33_last_posted","1425597020","yes");
INSERT INTO `wp_options` VALUES("71312","_transient__bbp_117.169.1.130_last_posted","1424461074","yes");
INSERT INTO `wp_options` VALUES("71398","_transient__bbp_117.169.1.189_last_posted","1427604223","yes");
INSERT INTO `wp_options` VALUES("71399","_transient__bbp_190.202.228.48_last_posted","1424376002","yes");
INSERT INTO `wp_options` VALUES("71406","_transient__bbp_190.37.103.131_last_posted","1424376545","yes");
INSERT INTO `wp_options` VALUES("71461","_transient__bbp_183.220.244.148_last_posted","1424386395","yes");
INSERT INTO `wp_options` VALUES("71462","_transient__bbp_106.158.16.3_last_posted","1424386438","yes");
INSERT INTO `wp_options` VALUES("71493","_transient__bbp_117.169.1.121_last_posted","1424391361","yes");
INSERT INTO `wp_options` VALUES("71494","_transient__bbp_1.34.66.148_last_posted","1424391575","yes");
INSERT INTO `wp_options` VALUES("71501","_transient__bbp_117.169.1.125_last_posted","1424391929","yes");
INSERT INTO `wp_options` VALUES("71526","_transient__bbp_117.175.34.253_last_posted","1424396470","yes");
INSERT INTO `wp_options` VALUES("71527","_transient__bbp_111.72.95.133_last_posted","1424396538","yes");
INSERT INTO `wp_options` VALUES("71536","_transient__bbp_223.72.142.130_last_posted","1425088385","yes");
INSERT INTO `wp_options` VALUES("71567","_transient__bbp_78.41.115.145_last_posted","1424401814","yes");
INSERT INTO `wp_options` VALUES("71592","_transient__bbp_183.220.246.144_last_posted","1424406286","yes");
INSERT INTO `wp_options` VALUES("71602","_transient__bbp_190.207.19.91_last_posted","1424406972","yes");
INSERT INTO `wp_options` VALUES("71627","_transient__bbp_54.87.79.103_last_posted","1424411264","yes");
INSERT INTO `wp_options` VALUES("71628","_transient__bbp_183.222.156.194_last_posted","1424411379","yes");
INSERT INTO `wp_options` VALUES("71654","_transient__bbp_120.210.75.11_last_posted","1424416126","yes");
INSERT INTO `wp_options` VALUES("71658","_transient__bbp_124.166.242.221_last_posted","1424943792","yes");
INSERT INTO `wp_options` VALUES("71683","_transient__bbp_120.131.70.214_last_posted","1425096962","yes");
INSERT INTO `wp_options` VALUES("71705","_transient__bbp_175.183.1.127_last_posted","1424425915","yes");
INSERT INTO `wp_options` VALUES("71733","_transient__bbp_77.43.143.31_last_posted","1424430609","yes");
INSERT INTO `wp_options` VALUES("71758","_transient__bbp_118.244.190.34_last_posted","1425842373","yes");
INSERT INTO `wp_options` VALUES("71762","_transient__bbp_145.118.111.106_last_posted","1424434889","yes");
INSERT INTO `wp_options` VALUES("71845","_transient__bbp_190.39.107.85_last_posted","1424449100","yes");
INSERT INTO `wp_options` VALUES("71849","_transient__bbp_176.108.160.253_last_posted","1424500614","yes");
INSERT INTO `wp_options` VALUES("71859","_transient__bbp_115.236.59.194_last_posted","1424709048","yes");
INSERT INTO `wp_options` VALUES("71891","_transient__bbp_190.198.48.32_last_posted","1424458400","yes");
INSERT INTO `wp_options` VALUES("71913","_transient__bbp_200.223.155.35_last_posted","1424462951","yes");
INSERT INTO `wp_options` VALUES("71939","_transient__bbp_186.88.214.160_last_posted","1424466549","yes");
INSERT INTO `wp_options` VALUES("71918","_transient__bbp_190.207.176.189_last_posted","1424463326","yes");
INSERT INTO `wp_options` VALUES("71946","_transient__bbp_190.77.6.57_last_posted","1424467717","yes");
INSERT INTO `wp_options` VALUES("71950","_transient__bbp_190.207.146.158_last_posted","1424467992","yes");
INSERT INTO `wp_options` VALUES("71987","_transient__bbp_117.177.147.161_last_posted","1424472760","yes");
INSERT INTO `wp_options` VALUES("71988","_transient__bbp_190.199.146.168_last_posted","1424472852","yes");
INSERT INTO `wp_options` VALUES("72010","_transient__bbp_183.203.208.163_last_posted","1427707937","yes");
INSERT INTO `wp_options` VALUES("72035","_transient__bbp_190.79.211.20_last_posted","1424482005","yes");
INSERT INTO `wp_options` VALUES("72036","_transient__bbp_186.91.75.50_last_posted","1424482041","yes");
INSERT INTO `wp_options` VALUES("72040","_transient__bbp_197.231.248.92_last_posted","1424891924","yes");
INSERT INTO `wp_options` VALUES("72069","_transient__bbp_190.77.129.131_last_posted","1424486815","yes");
INSERT INTO `wp_options` VALUES("72070","_transient__bbp_103.4.144.102_last_posted","1424486974","yes");
INSERT INTO `wp_options` VALUES("72095","_transient__bbp_202.62.65.78_last_posted","1425855858","yes");
INSERT INTO `wp_options` VALUES("72123","_transient__bbp_200.198.193.144_last_posted","1424496125","yes");
INSERT INTO `wp_options` VALUES("72124","_transient__bbp_117.173.20.129_last_posted","1424496182","yes");
INSERT INTO `wp_options` VALUES("72128","_transient__bbp_115.43.4.68_last_posted","1425186783","yes");
INSERT INTO `wp_options` VALUES("72151","_transient__bbp_37.187.129.166_last_posted","1424500502","yes");
INSERT INTO `wp_options` VALUES("72173","_transient__bbp_111.13.136.56_last_posted","1425519358","yes");
INSERT INTO `wp_options` VALUES("72177","_transient__bbp_112.19.125.106_last_posted","1424505165","yes");
INSERT INTO `wp_options` VALUES("72184","_transient__bbp_183.223.204.163_last_posted","1424509173","yes");
INSERT INTO `wp_options` VALUES("72188","_transient__bbp_183.224.1.56_last_posted","1427388314","yes");
INSERT INTO `wp_options` VALUES("72205","_transient__bbp_31.3.244.10_last_posted","1424513384","yes");
INSERT INTO `wp_options` VALUES("72209","_transient__bbp_119.14.107.213_last_posted","1424513485","yes");
INSERT INTO `wp_options` VALUES("72225","_transient__bbp_117.174.201.135_last_posted","1424670593","yes");
INSERT INTO `wp_options` VALUES("72241","_transient__bbp_62.245.45.50_last_posted","1424521398","yes");
INSERT INTO `wp_options` VALUES("72245","_transient__bbp_87.252.230.142_last_posted","1424521520","yes");
INSERT INTO `wp_options` VALUES("72246","_transient__bbp_194.63.140.147_last_posted","1424521598","yes");
INSERT INTO `wp_options` VALUES("72250","_transient__bbp_183.222.159.228_last_posted","1424521850","yes");
INSERT INTO `wp_options` VALUES("72306","_transient__bbp_106.37.236.144_last_posted","1424534551","yes");
INSERT INTO `wp_options` VALUES("73111","_transient__bbp_124.207.129.166_last_posted","1426866117","yes");
INSERT INTO `wp_options` VALUES("72268","_transient__bbp_163.30.45.100_last_posted","1424526204","yes");
INSERT INTO `wp_options` VALUES("72337","_transient__bbp_27.254.141.10_last_posted","1424538839","yes");
INSERT INTO `wp_options` VALUES("72341","_transient__bbp_59.125.78.181_last_posted","1424539004","yes");
INSERT INTO `wp_options` VALUES("72357","_transient__bbp_117.166.21.106_last_posted","1424543090","yes");
INSERT INTO `wp_options` VALUES("72419","_transient__bbp_192.227.220.47_last_posted","1424552198","yes");
INSERT INTO `wp_options` VALUES("72435","_transient__bbp_223.86.66.251_last_posted","1424555853","yes");
INSERT INTO `wp_options` VALUES("72460","_transient__bbp_95.56.192.75_last_posted","1424758494","yes");
INSERT INTO `wp_options` VALUES("72518","_transient__bbp_93.174.90.30_last_posted","1424568472","yes");
INSERT INTO `wp_options` VALUES("72522","_transient__bbp_118.244.190.32_last_posted","1424782400","yes");
INSERT INTO `wp_options` VALUES("72554","_transient__bbp_182.118.23.7_last_posted","1427653639","yes");
INSERT INTO `wp_options` VALUES("72579","_transient__bbp_117.177.240.40_last_posted","1427137697","yes");
INSERT INTO `wp_options` VALUES("72583","_transient__bbp_117.173.21.128_last_posted","1424577203","yes");
INSERT INTO `wp_options` VALUES("72593","_transient__bbp_223.86.66.191_last_posted","1424678732","yes");
INSERT INTO `wp_options` VALUES("72615","_transient__bbp_201.210.88.149_last_posted","1424581446","yes");
INSERT INTO `wp_options` VALUES("72619","_transient__bbp_183.220.247.138_last_posted","1424581531","yes");
INSERT INTO `wp_options` VALUES("72632","_transient__bbp_117.173.121.169_last_posted","1424582991","yes");
INSERT INTO `wp_options` VALUES("72682","_transient__bbp_2001:41d0:52:800::607_last_posted","1425504430","yes");
INSERT INTO `wp_options` VALUES("72707","_transient__bbp_2001:4b98:dc0:45:216:3eff:fefa:4e62_last_posted","1424594030","yes");
INSERT INTO `wp_options` VALUES("72723","_transient__bbp_212.4.97.117_last_posted","1424595320","yes");
INSERT INTO `wp_options` VALUES("72745","_transient__bbp_183.222.156.2_last_posted","1424598275","yes");
INSERT INTO `wp_options` VALUES("72809","_transient__bbp_117.177.144.240_last_posted","1424606204","yes");
INSERT INTO `wp_options` VALUES("72840","_transient__bbp_117.177.240.30_last_posted","1424610328","yes");
INSERT INTO `wp_options` VALUES("72844","_transient__bbp_212.12.12.165_last_posted","1424610769","yes");
INSERT INTO `wp_options` VALUES("72879","_transient__bbp_89.107.114.160_last_posted","1425017447","yes");
INSERT INTO `wp_options` VALUES("72904","_transient__bbp_183.223.213.241_last_posted","1424619430","yes");
INSERT INTO `wp_options` VALUES("72938","_transient__bbp_186.94.173.26_last_posted","1424623591","yes");
INSERT INTO `wp_options` VALUES("72939","_transient__bbp_183.222.158.100_last_posted","1424623763","yes");
INSERT INTO `wp_options` VALUES("72974","_transient__bbp_112.19.13.167_last_posted","1424628120","yes");
INSERT INTO `wp_options` VALUES("73021","_transient__bbp_183.222.156.250_last_posted","1424638952","yes");
INSERT INTO `wp_options` VALUES("73028","_transient__bbp_183.228.69.20_last_posted","1424640281","yes");
INSERT INTO `wp_options` VALUES("73035","_transient__bbp_111.248.132.80_last_posted","1424642904","yes");
INSERT INTO `wp_options` VALUES("73039","_transient__bbp_190.72.160.68_last_posted","1424700077","yes");
INSERT INTO `wp_options` VALUES("73067","_transient__bbp_54.198.153.225_last_posted","1424648954","yes");
INSERT INTO `wp_options` VALUES("73118","_transient__bbp_54.167.83.163_last_posted","1424657272","yes");
INSERT INTO `wp_options` VALUES("74913","_transient__bbp_115.28.238.147_last_posted","1425821475","yes");
INSERT INTO `wp_options` VALUES("73122","_transient__bbp_183.136.135.153_last_posted","1427133203","yes");
INSERT INTO `wp_options` VALUES("73123","_transient__bbp_180.177.86.46_last_posted","1424657606","yes");
INSERT INTO `wp_options` VALUES("73187","_transient__bbp_117.177.240.66_last_posted","1424666196","yes");
INSERT INTO `wp_options` VALUES("73212","_transient__bbp_183.220.241.192_last_posted","1424670384","yes");
INSERT INTO `wp_options` VALUES("73259","_transient__bbp_111.9.232.64_last_posted","1424678170","yes");
INSERT INTO `wp_options` VALUES("73287","_transient__bbp_202.106.182.248_last_posted","1427269446","yes");
INSERT INTO `wp_options` VALUES("73328","_transient__bbp_123.195.4.150_last_posted","1424691083","yes");
INSERT INTO `wp_options` VALUES("73427","_transient__bbp_183.222.157.101_last_posted","1424704652","yes");
INSERT INTO `wp_options` VALUES("73458","_transient__bbp_200.84.235.176_last_posted","1424708855","yes");
INSERT INTO `wp_options` VALUES("73483","_transient__bbp_118.244.190.38_last_posted","1425004221","yes");
INSERT INTO `wp_options` VALUES("73487","_transient__bbp_115.29.8.107_last_posted","1427073643","yes");
INSERT INTO `wp_options` VALUES("73494","_transient__bbp_201.211.148.75_last_posted","1424714132","yes");
INSERT INTO `wp_options` VALUES("73520","_transient__bbp_200.84.203.122_last_posted","1424717130","yes");
INSERT INTO `wp_options` VALUES("73557","_transient__bbp_134.100.127.214_last_posted","1424721990","yes");
INSERT INTO `wp_options` VALUES("73615","_transient__bbp_119.2.47.91_last_posted","1424730594","yes");
INSERT INTO `wp_options` VALUES("73619","_transient__bbp_182.18.158.110_last_posted","1424955758","yes");
INSERT INTO `wp_options` VALUES("73626","_transient__bbp_183.222.157.126_last_posted","1424731736","yes");
INSERT INTO `wp_options` VALUES("73660","_transient__bbp_187.50.138.205_last_posted","1424735659","yes");
INSERT INTO `wp_options` VALUES("73737","_transient__bbp_85.17.155.77_last_posted","1424744624","yes");
INSERT INTO `wp_options` VALUES("73774","_transient__bbp_112.19.124.72_last_posted","1424748745","yes");
INSERT INTO `wp_options` VALUES("73802","_transient__bbp_36.231.40.143_last_posted","1424752730","yes");
INSERT INTO `wp_options` VALUES("73867","_transient__bbp_117.139.28.252_last_posted","1424760950","yes");
INSERT INTO `wp_options` VALUES("73913","_transient__bbp_183.222.153.227_last_posted","1424766858","yes");
INSERT INTO `wp_options` VALUES("73938","_transient__bbp_186.89.240.232_last_posted","1424769603","yes");
INSERT INTO `wp_options` VALUES("73939","_transient__bbp_62.212.89.117_last_posted","1424769605","yes");
INSERT INTO `wp_options` VALUES("73943","_transient__bbp_211.157.180.62_last_posted","1424769627","yes");
INSERT INTO `wp_options` VALUES("73956","_transient__bbp_119.40.94.195_last_posted","1424861986","yes");
INSERT INTO `wp_options` VALUES("73993","_transient__bbp_117.174.206.229_last_posted","1424775726","yes");
INSERT INTO `wp_options` VALUES("74033","_transient__bbp_183.220.240.34_last_posted","1424844489","yes");
INSERT INTO `wp_options` VALUES("74089","_transient__bbp_183.220.246.164_last_posted","1424791219","yes");
INSERT INTO `wp_options` VALUES("74174","_transient__bbp_183.220.244.32_last_posted","1424796464","yes");
INSERT INTO `wp_options` VALUES("74287","_transient__bbp_183.223.174.68_last_posted","1424808768","yes");
INSERT INTO `wp_options` VALUES("74297","_transient__bbp_222.39.87.140_last_posted","1425594179","yes");
INSERT INTO `wp_options` VALUES("74322","_transient__bbp_37.187.101.28_last_posted","1427207975","yes");
INSERT INTO `wp_options` VALUES("74338","_transient__bbp_114.112.91.97_last_posted","1427520180","yes");
INSERT INTO `wp_options` VALUES("74366","_transient__bbp_186.92.12.58_last_posted","1424818289","yes");
INSERT INTO `wp_options` VALUES("74379","_transient__bbp_186.93.167.91_last_posted","1424819613","yes");
INSERT INTO `wp_options` VALUES("74401","_transient__bbp_201.219.182.202_last_posted","1424822667","yes");
INSERT INTO `wp_options` VALUES("74417","_transient__bbp_156.17.194.36_last_posted","1424824203","yes");
INSERT INTO `wp_options` VALUES("74436","_transient__bbp_117.139.28.156_last_posted","1424826384","yes");
INSERT INTO `wp_options` VALUES("74478","_transient__bbp_223.86.67.241_last_posted","1424832727","yes");
INSERT INTO `wp_options` VALUES("74578","_transient__bbp_117.177.226.103_last_posted","1424842634","yes");
INSERT INTO `wp_options` VALUES("74603","_transient__bbp_176.114.249.253_last_posted","1425008873","yes");
INSERT INTO `wp_options` VALUES("74614","_transient__bbp_177.66.76.92_last_posted","1424846880","yes");
INSERT INTO `wp_options` VALUES("74627","_transient__bbp_183.222.159.150_last_posted","1424848625","yes");
INSERT INTO `wp_options` VALUES("74670","_transient__bbp_176.108.160.241_last_posted","1424854366","yes");
INSERT INTO `wp_options` VALUES("74699","_transient__bbp_123.240.5.32_last_posted","1424964445","yes");
INSERT INTO `wp_options` VALUES("74842","_transient__bbp_118.244.190.37_last_posted","1425934825","yes");
INSERT INTO `wp_options` VALUES("74916","_transient__bbp_183.203.208.166_last_posted","1427343243","yes");
INSERT INTO `wp_options` VALUES("74944","_transient__bbp_122.117.237.149_last_posted","1424887559","yes");
INSERT INTO `wp_options` VALUES("74945","_transient__bbp_83.99.156.232_last_posted","1424887746","yes");
INSERT INTO `wp_options` VALUES("75021","_transient__bbp_183.220.241.228_last_posted","1424896365","yes");
INSERT INTO `wp_options` VALUES("80419","_transient__bbp_42.51.132.239_last_posted","1427090045","yes");
INSERT INTO `wp_options` VALUES("74957","_transient__bbp_182.234.74.161_last_posted","1424889068","yes");
INSERT INTO `wp_options` VALUES("75064","_transient__bbp_213.138.115.18_last_posted","1425850043","yes");
INSERT INTO `wp_options` VALUES("75104","_transient__bbp_190.78.110.254_last_posted","1424905067","yes");
INSERT INTO `wp_options` VALUES("75241","_transient__bbp_222.45.196.19_last_posted","1427043497","yes");
INSERT INTO `wp_options` VALUES("75260","_transient__bbp_212.16.104.33_last_posted","1424922775","yes");
INSERT INTO `wp_options` VALUES("75282","_transient__bbp_58.246.199.122_last_posted","1424925303","yes");
INSERT INTO `wp_options` VALUES("75301","_transient__bbp_137.117.176.132_last_posted","1424927181","yes");
INSERT INTO `wp_options` VALUES("75448","_transient__bbp_117.173.21.148_last_posted","1425013575","yes");
INSERT INTO `wp_options` VALUES("75470","_transient__bbp_58.23.233.7_last_posted","1424945025","yes");
INSERT INTO `wp_options` VALUES("75492","_transient__bbp_85.183.206.188_last_posted","1426123852","yes");
INSERT INTO `wp_options` VALUES("75565","_transient__bbp_111.9.232.155_last_posted","1424956580","yes");
INSERT INTO `wp_options` VALUES("75690","_transient__bbp_117.177.147.56_last_posted","1424973275","yes");
INSERT INTO `wp_options` VALUES("75839","_transient__bbp_183.220.106.164_last_posted","1424990970","yes");
INSERT INTO `wp_options` VALUES("75888","_transient__bbp_117.174.192.25_last_posted","1424996148","yes");
INSERT INTO `wp_options` VALUES("75916","_transient__bbp_117.177.45.157_last_posted","1424999461","yes");
INSERT INTO `wp_options` VALUES("75996","_transient__bbp_218.204.118.236_last_posted","1425008555","yes");
INSERT INTO `wp_options` VALUES("76006","_transient__bbp_221.228.248.248_last_posted","1425009733","yes");
INSERT INTO `wp_options` VALUES("76108","_transient__bbp_193.110.157.151_last_posted","1426743009","yes");
INSERT INTO `wp_options` VALUES("76157","_transient__bbp_217.12.214.70_last_posted","1425027860","yes");
INSERT INTO `wp_options` VALUES("76188","_transient__bbp_117.175.110.186_last_posted","1425031625","yes");
INSERT INTO `wp_options` VALUES("76222","_transient__bbp_112.18.184.92_last_posted","1425036213","yes");
INSERT INTO `wp_options` VALUES("76238","_transient__bbp_178.217.25.138_last_posted","1425193649","yes");
INSERT INTO `wp_options` VALUES("76298","_transient__bbp_114.255.183.173_last_posted","1425045026","yes");
INSERT INTO `wp_options` VALUES("76299","_transient__bbp_183.220.241.254_last_posted","1425045230","yes");
INSERT INTO `wp_options` VALUES("76366","_transient__bbp_222.55.9.21_last_posted","1425054193","yes");
INSERT INTO `wp_options` VALUES("76385","_transient__bbp_117.175.11.105_last_posted","1425056180","yes");
INSERT INTO `wp_options` VALUES("76462","_transient__bbp_183.220.244.160_last_posted","1425067255","yes");
INSERT INTO `wp_options` VALUES("76511","_transient__bbp_46.238.120.2_last_posted","1425074974","yes");
INSERT INTO `wp_options` VALUES("76590","_transient__bbp_119.97.164.48_last_posted","1426035643","yes");
INSERT INTO `wp_options` VALUES("76640","_transient__bbp_117.175.59.150_last_posted","1425091397","yes");
INSERT INTO `wp_options` VALUES("76647","_transient__bbp_183.224.1.29_last_posted","1425092640","yes");
INSERT INTO `wp_options` VALUES("76775","_transient__bbp_112.19.6.97_last_posted","1425108729","yes");
INSERT INTO `wp_options` VALUES("76855","_transient__bbp_94.247.25.162_last_posted","1427395233","yes");
INSERT INTO `wp_options` VALUES("76856","_transient__bbp_219.140.175.71_last_posted","1425445458","yes");
INSERT INTO `wp_options` VALUES("76944","_transient__bbp_183.223.204.189_last_posted","1425130098","yes");
INSERT INTO `wp_options` VALUES("77051","_transient__bbp_183.222.152.116_last_posted","1425142638","yes");
INSERT INTO `wp_options` VALUES("77138","_transient__bbp_117.173.20.168_last_posted","1425152612","yes");
INSERT INTO `wp_options` VALUES("77255","_transient__bbp_183.222.157.23_last_posted","1425167695","yes");
INSERT INTO `wp_options` VALUES("80410","_transient__bbp_190.158.241.146_last_posted","1425577456","yes");
INSERT INTO `wp_options` VALUES("77408","_transient__bbp_117.177.147.9_last_posted","1425184854","yes");
INSERT INTO `wp_options` VALUES("77512","_transient__bbp_145.100.91.12_last_posted","1425197366","yes");
INSERT INTO `wp_options` VALUES("77567","_transient__bbp_200.16.119.246_last_posted","1425203661","yes");
INSERT INTO `wp_options` VALUES("77679","_transient__bbp_112.18.183.163_last_posted","1425216523","yes");
INSERT INTO `wp_options` VALUES("77683","_transient__bbp_112.18.74.33_last_posted","1425216750","yes");
INSERT INTO `wp_options` VALUES("77715","_transient__bbp_109.184.192.49_last_posted","1425219958","yes");
INSERT INTO `wp_options` VALUES("77716","_transient__bbp_223.16.0.191_last_posted","1425219969","yes");
INSERT INTO `wp_options` VALUES("77732","_transient__bbp_117.173.22.149_last_posted","1425222862","yes");
INSERT INTO `wp_options` VALUES("77736","_transient__bbp_183.222.81.213_last_posted","1425222975","yes");
INSERT INTO `wp_options` VALUES("77749","_transient__bbp_200.109.60.223_last_posted","1425225250","yes");
INSERT INTO `wp_options` VALUES("77780","_transient__bbp_117.174.203.187_last_posted","1425228883","yes");
INSERT INTO `wp_options` VALUES("77796","_transient__bbp_183.223.199.160_last_posted","1425230928","yes");
INSERT INTO `wp_options` VALUES("77824","_transient__bbp_117.169.1.115_last_posted","1426404158","yes");
INSERT INTO `wp_options` VALUES("77828","_transient__bbp_223.87.183.31_last_posted","1425234450","yes");
INSERT INTO `wp_options` VALUES("77839","_transient__bbp_117.169.1.51_last_posted","1425521640","yes");
INSERT INTO `wp_options` VALUES("77852","_transient__bbp_104.207.134.21_last_posted","1425237812","yes");
INSERT INTO `wp_options` VALUES("77868","_transient__bbp_183.220.244.251_last_posted","1425239872","yes");
INSERT INTO `wp_options` VALUES("77869","_transient__bbp_183.228.239.25_last_posted","1425239983","yes");
INSERT INTO `wp_options` VALUES("77882","_transient__bbp_117.169.1.74_last_posted","1427648967","yes");
INSERT INTO `wp_options` VALUES("77892","_transient__bbp_223.86.219.186_last_posted","1425243417","yes");
INSERT INTO `wp_options` VALUES("77911","_transient__bbp_111.10.38.21_last_posted","1425245257","yes");
INSERT INTO `wp_options` VALUES("77912","_transient__bbp_182.155.112.152_last_posted","1425245316","yes");
INSERT INTO `wp_options` VALUES("77931","_transient__bbp_210.32.33.183_last_posted","1425721389","yes");
INSERT INTO `wp_options` VALUES("77947","_transient__bbp_200.109.139.197_last_posted","1425249310","yes");
INSERT INTO `wp_options` VALUES("77969","_transient__bbp_117.169.1.26_last_posted","1425251406","yes");
INSERT INTO `wp_options` VALUES("77973","_transient__bbp_117.169.1.56_last_posted","1427690128","yes");
INSERT INTO `wp_options` VALUES("77986","_transient__bbp_117.169.1.181_last_posted","1427647803","yes");
INSERT INTO `wp_options` VALUES("78002","_transient__bbp_111.9.133.115_last_posted","1425255323","yes");
INSERT INTO `wp_options` VALUES("78021","_transient__bbp_175.182.130.236_last_posted","1425257412","yes");
INSERT INTO `wp_options` VALUES("78059","_transient__bbp_117.139.46.180_last_posted","1425261317","yes");
INSERT INTO `wp_options` VALUES("78081","_transient__bbp_111.10.195.193_last_posted","1425263518","yes");
INSERT INTO `wp_options` VALUES("78082","_transient__bbp_186.93.5.63_last_posted","1425263621","yes");
INSERT INTO `wp_options` VALUES("78110","_transient__bbp_117.166.53.233_last_posted","1425267611","yes");
INSERT INTO `wp_options` VALUES("78132","_transient__bbp_117.169.1.69_last_posted","1425270053","yes");
INSERT INTO `wp_options` VALUES("78133","_transient__bbp_183.226.55.23_last_posted","1425270057","yes");
INSERT INTO `wp_options` VALUES("78146","_transient__bbp_112.44.204.29_last_posted","1425271983","yes");
INSERT INTO `wp_options` VALUES("78168","_transient__bbp_117.169.1.179_last_posted","1426622766","yes");
INSERT INTO `wp_options` VALUES("78187","_transient__bbp_183.131.144.204_last_posted","1427701707","yes");
INSERT INTO `wp_options` VALUES("78201","_transient__bbp_117.169.1.4_last_posted","1425353897","yes");
INSERT INTO `wp_options` VALUES("78211","_transient__bbp_117.169.1.167_last_posted","1427438671","yes");
INSERT INTO `wp_options` VALUES("78233","_transient__bbp_183.220.247.117_last_posted","1425283063","yes");
INSERT INTO `wp_options` VALUES("78234","_transient__bbp_183.223.40.153_last_posted","1425283117","yes");
INSERT INTO `wp_options` VALUES("78250","_transient__bbp_112.44.5.99_last_posted","1425284519","yes");
INSERT INTO `wp_options` VALUES("78281","_transient__bbp_117.174.217.157_last_posted","1425289885","yes");
INSERT INTO `wp_options` VALUES("78291","_transient__bbp_117.169.1.80_last_posted","1425290749","yes");
INSERT INTO `wp_options` VALUES("78329","_transient__bbp_112.19.128.40_last_posted","1425296730","yes");
INSERT INTO `wp_options` VALUES("78330","_transient__bbp_36.233.171.115_last_posted","1425296896","yes");
INSERT INTO `wp_options` VALUES("78364","_transient__bbp_117.176.55.62_last_posted","1425301341","yes");
INSERT INTO `wp_options` VALUES("78383","_transient__bbp_117.166.55.146_last_posted","1425303666","yes");
INSERT INTO `wp_options` VALUES("78432","_transient__bbp_223.85.80.199_last_posted","1425308788","yes");
INSERT INTO `wp_options` VALUES("78487","_transient__bbp_117.172.222.13_last_posted","1425315673","yes");
INSERT INTO `wp_options` VALUES("78494","_transient__bbp_111.197.163.250_last_posted","1425317111","yes");
INSERT INTO `wp_options` VALUES("78504","_transient__bbp_223.85.19.165_last_posted","1425317837","yes");
INSERT INTO `wp_options` VALUES("78545","_transient__bbp_117.169.1.54_last_posted","1426721712","yes");
INSERT INTO `wp_options` VALUES("78558","_transient__bbp_66.154.208.24_last_posted","1426095711","yes");
INSERT INTO `wp_options` VALUES("78562","_transient__bbp_117.169.1.77_last_posted","1425323530","yes");
INSERT INTO `wp_options` VALUES("78593","_transient__bbp_190.37.161.112_last_posted","1425327952","yes");
INSERT INTO `wp_options` VALUES("78603","_transient__bbp_117.173.203.33_last_posted","1425329272","yes");
INSERT INTO `wp_options` VALUES("78607","_transient__bbp_117.166.23.247_last_posted","1425399193","yes");
INSERT INTO `wp_options` VALUES("78644","_transient__bbp_117.169.1.7_last_posted","1427544969","yes");
INSERT INTO `wp_options` VALUES("78660","_transient__bbp_117.169.1.45_last_posted","1427665774","yes");
INSERT INTO `wp_options` VALUES("78664","_transient__bbp_117.168.13.84_last_posted","1425335496","yes");
INSERT INTO `wp_options` VALUES("78771","_transient__bbp_117.169.1.207_last_posted","1425457592","yes");
INSERT INTO `wp_options` VALUES("78817","_transient__bbp_117.168.35.100_last_posted","1425353362","yes");
INSERT INTO `wp_options` VALUES("78872","_transient__bbp_223.85.22.119_last_posted","1425359848","yes");
INSERT INTO `wp_options` VALUES("78879","_transient__bbp_117.169.1.194_last_posted","1426487760","yes");
INSERT INTO `wp_options` VALUES("78883","_transient__bbp_183.222.166.80_last_posted","1425361098","yes");
INSERT INTO `wp_options` VALUES("78957","_transient__bbp_223.85.80.143_last_posted","1425369271","yes");
INSERT INTO `wp_options` VALUES("78961","_transient__bbp_117.169.1.201_last_posted","1425369552","yes");
INSERT INTO `wp_options` VALUES("78965","_transient__bbp_117.169.1.157_last_posted","1427446521","yes");
INSERT INTO `wp_options` VALUES("79050","_transient__bbp_117.169.1.165_last_posted","1426561544","yes");
INSERT INTO `wp_options` VALUES("79128","_transient__bbp_183.222.153.59_last_posted","1425392713","yes");
INSERT INTO `wp_options` VALUES("79207","_transient__bbp_117.169.1.197_last_posted","1427474908","yes");
INSERT INTO `wp_options` VALUES("79211","_transient__bbp_117.169.1.234_last_posted","1425404063","yes");
INSERT INTO `wp_options` VALUES("79255","_transient__bbp_221.226.2.254_last_posted","1426321603","yes");
INSERT INTO `wp_options` VALUES("79301","_transient__bbp_118.114.98.57_last_posted","1425415711","yes");
INSERT INTO `wp_options` VALUES("79305","_transient__bbp_218.65.219.172_last_posted","1425816245","yes");
INSERT INTO `wp_options` VALUES("79333","_transient__bbp_117.166.41.245_last_posted","1425421145","yes");
INSERT INTO `wp_options` VALUES("79334","_transient__bbp_112.19.125.38_last_posted","1425421215","yes");
INSERT INTO `wp_options` VALUES("79339","_transient__bbp_117.169.1.241_last_posted","1425421423","yes");
INSERT INTO `wp_options` VALUES("79419","_transient__bbp_117.169.1.98_last_posted","1425432584","yes");
INSERT INTO `wp_options` VALUES("79478","_transient__bbp_23.106.176.176_last_posted","1425438628","yes");
INSERT INTO `wp_options` VALUES("79482","_transient__bbp_116.228.80.186_last_posted","1426971832","yes");
INSERT INTO `wp_options` VALUES("79486","_transient__bbp_117.169.1.137_last_posted","1426455607","yes");
INSERT INTO `wp_options` VALUES("79665","_transient__bbp_117.169.1.100_last_posted","1425457933","yes");
INSERT INTO `wp_options` VALUES("79669","_transient__bbp_178.151.98.102_last_posted","1425458158","yes");
INSERT INTO `wp_options` VALUES("79760","_transient__bbp_117.173.22.77_last_posted","1425468838","yes");
INSERT INTO `wp_options` VALUES("79770","_transient__bbp_183.223.216.56_last_posted","1425469602","yes");
INSERT INTO `wp_options` VALUES("79807","_transient__bbp_198.23.250.31_last_posted","1425474388","yes");
INSERT INTO `wp_options` VALUES("79851","_transient__bbp_222.45.194.122_last_posted","1425928525","yes");
INSERT INTO `wp_options` VALUES("79891","_transient__bbp_123.155.152.61_last_posted","1425485186","yes");
INSERT INTO `wp_options` VALUES("79895","_transient__bbp_117.169.1.128_last_posted","1426530954","yes");
INSERT INTO `wp_options` VALUES("79905","_transient__bbp_46.229.139.77_last_posted","1426882429","yes");
INSERT INTO `wp_options` VALUES("79933","_transient__bbp_117.169.1.204_last_posted","1427506138","yes");
INSERT INTO `wp_options` VALUES("79937","_transient__bbp_117.175.98.141_last_posted","1425491418","yes");
INSERT INTO `wp_options` VALUES("79944","_transient__bbp_117.169.1.225_last_posted","1425616271","yes");
INSERT INTO `wp_options` VALUES("79976","_transient__bbp_117.169.1.188_last_posted","1427587794","yes");
INSERT INTO `wp_options` VALUES("79989","_transient__bbp_192.99.73.116_last_posted","1425498516","yes");
INSERT INTO `wp_options` VALUES("80023","_transient__bbp_117.166.246.80_last_posted","1425502343","yes");
INSERT INTO `wp_options` VALUES("80069","_transient__bbp_117.169.1.50_last_posted","1425508113","yes");
INSERT INTO `wp_options` VALUES("80106","_transient__bbp_59.78.160.246_last_posted","1425513618","yes");
INSERT INTO `wp_options` VALUES("80107","_transient__bbp_95.168.217.24_last_posted","1427005313","yes");
INSERT INTO `wp_options` VALUES("80144","_transient__bbp_117.148.53.144_last_posted","1425519317","yes");
INSERT INTO `wp_options` VALUES("80182","_transient__bbp_111.10.49.98_last_posted","1425525120","yes");
INSERT INTO `wp_options` VALUES("80219","_transient__bbp_183.203.208.164_last_posted","1427107463","yes");
INSERT INTO `wp_options` VALUES("80266","_transient__bbp_117.169.1.10_last_posted","1425537216","yes");
INSERT INTO `wp_options` VALUES("80401","_transient__bbp_183.220.128.52_last_posted","1425558907","yes");
INSERT INTO `wp_options` VALUES("80402","_transient__bbp_112.19.134.45_last_posted","1425559258","yes");
INSERT INTO `wp_options` VALUES("80408","_transient__bbp_186.101.13.213_last_posted","1425939456","yes");
INSERT INTO `wp_options` VALUES("80411","_transient__bbp_117.177.147.204_last_posted","1425579528","yes");
INSERT INTO `wp_options` VALUES("80417","_transient__bbp_222.161.213.77_last_posted","1425944014","yes");
INSERT INTO `wp_options` VALUES("80418","_transient__bbp_117.177.240.64_last_posted","1426002531","yes");
INSERT INTO `wp_options` VALUES("80420","_transient__bbp_112.19.221.255_last_posted","1425596285","yes");
INSERT INTO `wp_options` VALUES("80421","_transient__bbp_117.169.1.61_last_posted","1426779484","yes");
INSERT INTO `wp_options` VALUES("96862","_transient__bbp_196.201.218.202_last_posted","1427671513","yes");
INSERT INTO `wp_options` VALUES("97156","_transient__bbp_117.169.1.29_last_posted","1427516371","yes");
INSERT INTO `wp_options` VALUES("80433","_transient__bbp_117.169.1.168_last_posted","1426710681","yes");
INSERT INTO `wp_options` VALUES("80443","_transient__bbp_124.205.129.100_last_posted","1425617503","yes");
INSERT INTO `wp_options` VALUES("80632","_transient__bbp_14.18.234.131_last_posted","1426676795","yes");
INSERT INTO `wp_options` VALUES("80642","_transient__bbp_49.65.226.178_last_posted","1425646662","yes");
INSERT INTO `wp_options` VALUES("80658","_transient__bbp_182.73.213.58_last_posted","1425648167","yes");
INSERT INTO `wp_options` VALUES("80734","_transient__bbp_210.211.99.70_last_posted","1426282650","yes");
INSERT INTO `wp_options` VALUES("80880","_transient__bbp_183.221.217.19_last_posted","1425672254","yes");
INSERT INTO `wp_options` VALUES("88062","_transient__bbp_177.223.48.132_last_posted","1426558261","yes");
INSERT INTO `wp_options` VALUES("88117","_transient__bbp_2001:da8:e000:1410:214:5eff:fe2b:9a9d_last_poste","1427246588","yes");
INSERT INTO `wp_options` VALUES("88367","_transient__bbp_128.199.129.237_last_posted","1426593264","yes");
INSERT INTO `wp_options` VALUES("80974","_transient__bbp_2001:4800:7813:516:4dab:7174:ff04:fbda_last_post","1425916392","yes");
INSERT INTO `wp_options` VALUES("81081","_transient__bbp_117.169.1.156_last_posted","1425695911","yes");
INSERT INTO `wp_options` VALUES("81187","_transient__bbp_183.220.71.235_last_posted","1425709548","yes");
INSERT INTO `wp_options` VALUES("81259","_transient__bbp_112.0.158.219_last_posted","1425718573","yes");
INSERT INTO `wp_options` VALUES("81281","_transient__bbp_37.187.97.36_last_posted","1427192227","yes");
INSERT INTO `wp_options` VALUES("81297","_transient__bbp_58.251.78.71_last_posted","1425957986","yes");
INSERT INTO `wp_options` VALUES("81325","_transient__bbp_223.85.99.79_last_posted","1425727239","yes");
INSERT INTO `wp_options` VALUES("81408","_transient__bbp_111.10.90.144_last_posted","1425738657","yes");
INSERT INTO `wp_options` VALUES("81463","_transient__bbp_213.211.132.220_last_posted","1425747013","yes");
INSERT INTO `wp_options` VALUES("81491","_transient__bbp_113.106.94.57_last_posted","1426329309","yes");
INSERT INTO `wp_options` VALUES("81498","_transient__bbp_117.173.21.88_last_posted","1425751338","yes");
INSERT INTO `wp_options` VALUES("81581","_transient__bbp_117.173.20.108_last_posted","1425761819","yes");
INSERT INTO `wp_options` VALUES("81642","_transient__bbp_223.87.191.55_last_posted","1425769587","yes");
INSERT INTO `wp_options` VALUES("81803","_transient__bbp_61.153.209.18_last_posted","1425787553","yes");
INSERT INTO `wp_options` VALUES("81890","_transient__bbp_177.0.118.244_last_posted","1426131899","yes");
INSERT INTO `wp_options` VALUES("82189","_transient__bbp_183.220.245.216_last_posted","1425832893","yes");
INSERT INTO `wp_options` VALUES("82241","_transient__bbp_94.247.179.116_last_posted","1425838913","yes");
INSERT INTO `wp_options` VALUES("82255","_transient__bbp_173.255.115.54_last_posted","1425840014","yes");
INSERT INTO `wp_options` VALUES("82286","_transient__bbp_78.22.24.121_last_posted","1425843558","yes");
INSERT INTO `wp_options` VALUES("82410","_transient__bbp_117.169.1.20_last_posted","1425858300","yes");
INSERT INTO `wp_options` VALUES("82420","_transient__bbp_183.221.220.10_last_posted","1425859192","yes");
INSERT INTO `wp_options` VALUES("82457","_transient__bbp_201.48.207.146_last_posted","1425863307","yes");
INSERT INTO `wp_options` VALUES("82464","_transient__bbp_49.74.88.8_last_posted","1425863914","yes");
INSERT INTO `wp_options` VALUES("82490","_transient__bbp_221.212.46.11_last_posted","1425866712","yes");
INSERT INTO `wp_options` VALUES("82503","_transient__bbp_117.166.65.75_last_posted","1425867849","yes");
INSERT INTO `wp_options` VALUES("82529","_transient__bbp_121.17.105.69_last_posted","1426140008","yes");
INSERT INTO `wp_options` VALUES("82520","_transient__bbp_183.228.73.122_last_posted","1425870589","yes");
INSERT INTO `wp_options` VALUES("82608","_transient__bbp_211.139.80.180_last_posted","1425882600","yes");
INSERT INTO `wp_options` VALUES("82710","_transient__bbp_175.44.27.177_last_posted","1425894983","yes");
INSERT INTO `wp_options` VALUES("82783","_transient__bbp_117.177.240.36_last_posted","1426904510","yes");
INSERT INTO `wp_options` VALUES("82966","_transient__bbp_117.177.240.34_last_posted","1425998317","yes");
INSERT INTO `wp_options` VALUES("82985","_transient__bbp_117.166.43.229_last_posted","1425928997","yes");
INSERT INTO `wp_options` VALUES("83052","_transient__bbp_138.0.253.43_last_posted","1426705308","yes");
INSERT INTO `wp_options` VALUES("83131","_transient__bbp_131.229.80.59_last_posted","1425950549","yes");
INSERT INTO `wp_options` VALUES("83244","_transient__bbp_124.207.175.91_last_posted","1425966627","yes");
INSERT INTO `wp_options` VALUES("83273","_transient__bbp_46.31.213.122_last_posted","1425970691","yes");
INSERT INTO `wp_options` VALUES("83301","_transient__bbp_211.157.180.58_last_posted","1426275104","yes");
INSERT INTO `wp_options` VALUES("83404","_transient__bbp_124.207.129.160_last_posted","1425988744","yes");
INSERT INTO `wp_options` VALUES("83438","_transient__bbp_175.44.4.142_last_posted","1425992571","yes");
INSERT INTO `wp_options` VALUES("83442","_transient__bbp_89.175.89.22_last_posted","1425993340","yes");
INSERT INTO `wp_options` VALUES("83555","_transient__bbp_138.0.253.18_last_posted","1426006732","yes");
INSERT INTO `wp_options` VALUES("83562","_transient__bbp_14.147.121.178_last_posted","1426007802","yes");
INSERT INTO `wp_options` VALUES("83649","_transient__bbp_89.31.147.68_last_posted","1426028107","yes");
INSERT INTO `wp_options` VALUES("83743","_transient__bbp_183.221.8.163_last_posted","1426029048","yes");
INSERT INTO `wp_options` VALUES("83804","_transient__bbp_59.78.160.244_last_posted","1426814664","yes");
INSERT INTO `wp_options` VALUES("83811","_transient__bbp_195.178.94.39_last_posted","1426036465","yes");
INSERT INTO `wp_options` VALUES("83840","_transient__bbp_180.250.44.162_last_posted","1426039795","yes");
INSERT INTO `wp_options` VALUES("83841","_transient__bbp_111.10.49.65_last_posted","1426039846","yes");
INSERT INTO `wp_options` VALUES("83918","_transient__bbp_183.222.162.181_last_posted","1426048118","yes");
INSERT INTO `wp_options` VALUES("83922","_transient__bbp_114.111.167.215_last_posted","1426048478","yes");
INSERT INTO `wp_options` VALUES("84029","_transient__bbp_120.202.249.196_last_posted","1426061613","yes");
INSERT INTO `wp_options` VALUES("84102","_transient__bbp_117.177.147.96_last_posted","1426070674","yes");
INSERT INTO `wp_options` VALUES("84169","_transient__bbp_116.51.12.146_last_posted","1426079439","yes");
INSERT INTO `wp_options` VALUES("84170","_transient__bbp_124.200.52.16_last_posted","1426758676","yes");
INSERT INTO `wp_options` VALUES("84214","_transient__bbp_114.111.167.210_last_posted","1427695612","yes");
INSERT INTO `wp_options` VALUES("84336","_transient__bbp_109.163.234.8_last_posted","1426099452","yes");
INSERT INTO `wp_options` VALUES("84364","_transient__bbp_184.105.239.95_last_posted","1426102965","yes");
INSERT INTO `wp_options` VALUES("84455","_transient__bbp_117.169.1.86_last_posted","1426113064","yes");
INSERT INTO `wp_options` VALUES("84825","_transient__bbp_222.45.195.34_last_posted","1427255114","yes");
INSERT INTO `wp_options` VALUES("84850","_transient__bbp_183.224.1.55_last_posted","1426158113","yes");
INSERT INTO `wp_options` VALUES("84857","_transient__bbp_93.120.179.174_last_posted","1426475885","yes");
INSERT INTO `wp_options` VALUES("84864","_transient__bbp_198.99.224.134_last_posted","1426159152","yes");
INSERT INTO `wp_options` VALUES("84941","_transient__bbp_173.182.188.48_last_posted","1426168221","yes");
INSERT INTO `wp_options` VALUES("84975","_transient__bbp_183.230.53.97_last_posted","1426172819","yes");
INSERT INTO `wp_options` VALUES("85042","_transient__bbp_223.4.21.184_last_posted","1426180087","yes");
INSERT INTO `wp_options` VALUES("85098","_transient__bbp_117.139.28.51_last_posted","1427085960","yes");
INSERT INTO `wp_options` VALUES("85159","_transient__bbp_183.220.158.16_last_posted","1426193369","yes");
INSERT INTO `wp_options` VALUES("85241","_transient__bbp_117.177.240.65_last_posted","1427036097","yes");
INSERT INTO `wp_options` VALUES("85260","_transient__bbp_59.78.160.247_last_posted","1426205363","yes");
INSERT INTO `wp_options` VALUES("85273","_transient__bbp_117.169.1.138_last_posted","1427039855","yes");
INSERT INTO `wp_options` VALUES("85317","_transient__bbp_216.218.216.194_last_posted","1426211163","yes");
INSERT INTO `wp_options` VALUES("85351","_transient__bbp_77.247.181.162_last_posted","1426215582","yes");
INSERT INTO `wp_options` VALUES("85391","_transient__bbp_60.206.239.195_last_posted","1426220387","yes");
INSERT INTO `wp_options` VALUES("85612","_transient__bbp_2a01:4f8:d12:3cf::2_last_posted","1426247208","yes");
INSERT INTO `wp_options` VALUES("85689","_transient__bbp_117.177.141.4_last_posted","1426256936","yes");
INSERT INTO `wp_options` VALUES("85744","_transient__bbp_155.133.18.152_last_posted","1426405725","yes");
INSERT INTO `wp_options` VALUES("85748","_transient__bbp_23.95.71.12_last_posted","1426263603","yes");
INSERT INTO `wp_options` VALUES("85948","_transient__bbp_183.222.152.87_last_posted","1426286422","yes");
INSERT INTO `wp_options` VALUES("85964","_transient__bbp_183.222.182.172_last_posted","1426288511","yes");
INSERT INTO `wp_options` VALUES("85995","_transient__bbp_117.169.1.155_last_posted","1426457839","yes");
INSERT INTO `wp_options` VALUES("86008","_transient__bbp_114.111.166.249_last_posted","1426293706","yes");
INSERT INTO `wp_options` VALUES("86058","_transient__bbp_177.0.118.247_last_posted","1427400666","yes");
INSERT INTO `wp_options` VALUES("86095","_transient__bbp_117.177.240.67_last_posted","1426303636","yes");
INSERT INTO `wp_options` VALUES("86202","_transient__bbp_118.244.255.12_last_posted","1426316826","yes");
INSERT INTO `wp_options` VALUES("86263","_transient__bbp_69.197.186.210_last_posted","1427203774","yes");
INSERT INTO `wp_options` VALUES("86418","_transient__bbp_111.10.59.80_last_posted","1426344198","yes");
INSERT INTO `wp_options` VALUES("86437","_transient__bbp_117.166.246.52_last_posted","1426453210","yes");
INSERT INTO `wp_options` VALUES("86456","_transient__bbp_123.204.186.209_last_posted","1426349049","yes");
INSERT INTO `wp_options` VALUES("86490","_transient__bbp_117.174.197.245_last_posted","1426352882","yes");
INSERT INTO `wp_options` VALUES("86491","_transient__bbp_117.175.110.228_last_posted","1426353022","yes");
INSERT INTO `wp_options` VALUES("86504","_transient__bbp_183.209.236.8_last_posted","1426355735","yes");
INSERT INTO `wp_options` VALUES("86520","_transient__bbp_117.169.1.40_last_posted","1426357551","yes");
INSERT INTO `wp_options` VALUES("86534","_transient__bbp_111.10.91.210_last_posted","1426358969","yes");
INSERT INTO `wp_options` VALUES("86544","_transient__bbp_117.169.1.127_last_posted","1427572680","yes");
INSERT INTO `wp_options` VALUES("86551","_transient__bbp_117.166.107.139_last_posted","1426363225","yes");
INSERT INTO `wp_options` VALUES("86573","_transient__bbp_117.169.1.176_last_posted","1426801149","yes");
INSERT INTO `wp_options` VALUES("86586","_transient__bbp_117.169.1.141_last_posted","1426368804","yes");
INSERT INTO `wp_options` VALUES("86590","_transient__bbp_117.139.28.43_last_posted","1426369548","yes");
INSERT INTO `wp_options` VALUES("86624","_transient__bbp_117.169.1.34_last_posted","1427499031","yes");
INSERT INTO `wp_options` VALUES("86631","_transient__bbp_112.18.177.83_last_posted","1426375564","yes");
INSERT INTO `wp_options` VALUES("86635","_transient__bbp_91.229.20.73_last_posted","1427641668","yes");
INSERT INTO `wp_options` VALUES("86657","_transient__bbp_117.169.1.89_last_posted","1426522887","yes");
INSERT INTO `wp_options` VALUES("86664","_transient__bbp_117.169.1.19_last_posted","1427707874","yes");
INSERT INTO `wp_options` VALUES("86699","_transient__bbp_183.228.198.248_last_posted","1426387917","yes");
INSERT INTO `wp_options` VALUES("86715","_transient__bbp_183.223.17.189_last_posted","1426389518","yes");
INSERT INTO `wp_options` VALUES("86752","_transient__bbp_111.10.193.181_last_posted","1426396764","yes");
INSERT INTO `wp_options` VALUES("86784","_transient__bbp_218.197.204.212_last_posted","1426402051","yes");
INSERT INTO `wp_options` VALUES("86788","_transient__bbp_117.169.1.177_last_posted","1426429048","yes");
INSERT INTO `wp_options` VALUES("86834","_transient__bbp_213.119.37.145_last_posted","1426409013","yes");
INSERT INTO `wp_options` VALUES("86886","_transient__bbp_223.86.6.219_last_posted","1426416310","yes");
INSERT INTO `wp_options` VALUES("86905","_transient__bbp_210.14.152.121_last_posted","1427343242","yes");
INSERT INTO `wp_options` VALUES("86933","_transient__bbp_117.177.171.215_last_posted","1426421271","yes");
INSERT INTO `wp_options` VALUES("87016","_transient__bbp_117.169.1.94_last_posted","1426431562","yes");
INSERT INTO `wp_options` VALUES("87083","_transient__bbp_117.166.67.82_last_posted","1426439244","yes");
INSERT INTO `wp_options` VALUES("87131","_transient__bbp_39.184.24.101_last_posted","1426444273","yes");
INSERT INTO `wp_options` VALUES("87171","_transient__bbp_117.176.1.64_last_posted","1426448859","yes");
INSERT INTO `wp_options` VALUES("87211","_transient__bbp_117.169.1.229_last_posted","1426453446","yes");
INSERT INTO `wp_options` VALUES("87263","_transient__bbp_117.169.1.65_last_posted","1426715940","yes");
INSERT INTO `wp_options` VALUES("87267","_transient__bbp_117.169.1.135_last_posted","1426460094","yes");
INSERT INTO `wp_options` VALUES("87283","_transient__bbp_2607:5300:100:200::153e_last_posted","1427354742","yes");
INSERT INTO `wp_options` VALUES("87302","_transient__bbp_117.177.147.145_last_posted","1426464166","yes");
INSERT INTO `wp_options` VALUES("87321","_transient__bbp_212.144.224.58_last_posted","1426466353","yes");
INSERT INTO `wp_options` VALUES("87365","_transient__bbp_117.169.1.25_last_posted","1426470893","yes");
INSERT INTO `wp_options` VALUES("87399","_transient__bbp_117.169.1.198_last_posted","1426475248","yes");
INSERT INTO `wp_options` VALUES("87442","_transient__bbp_103.249.101.120_last_posted","1426480314","yes");
INSERT INTO `wp_options` VALUES("87446","_transient__bbp_117.169.1.58_last_posted","1427432750","yes");
INSERT INTO `wp_options` VALUES("87462","_transient__bbp_37.239.46.74_last_posted","1427689673","yes");
INSERT INTO `wp_options` VALUES("87469","_transient__bbp_95.37.138.250_last_posted","1427180484","yes");
INSERT INTO `wp_options` VALUES("87482","_transient__bbp_112.19.126.69_last_posted","1426485460","yes");
INSERT INTO `wp_options` VALUES("87502","_transient__bbp_222.45.16.102_last_posted","1426742855","yes");
INSERT INTO `wp_options` VALUES("87614","_transient__bbp_117.169.1.226_last_posted","1426503251","yes");
INSERT INTO `wp_options` VALUES("87660","_transient__bbp_117.169.1.60_last_posted","1427513001","yes");
INSERT INTO `wp_options` VALUES("87661","_transient__bbp_39.184.16.127_last_posted","1426508768","yes");
INSERT INTO `wp_options` VALUES("87677","_transient__bbp_117.169.1.116_last_posted","1426510628","yes");
INSERT INTO `wp_options` VALUES("87746","_transient__bbp_112.19.126.209_last_posted","1426518096","yes");
INSERT INTO `wp_options` VALUES("87828","_transient__bbp_223.85.96.89_last_posted","1426529282","yes");
INSERT INTO `wp_options` VALUES("87872","_transient__bbp_117.175.60.14_last_posted","1426535138","yes");
INSERT INTO `wp_options` VALUES("87906","_transient__bbp_183.221.147.78_last_posted","1426539808","yes");
INSERT INTO `wp_options` VALUES("87916","_transient__bbp_183.203.208.172_last_posted","1427367289","yes");
INSERT INTO `wp_options` VALUES("87956","_transient__bbp_117.166.227.86_last_posted","1426545783","yes");
INSERT INTO `wp_options` VALUES("114273","updraft_s3generic","a:4:{s:8:\"endpoint\";s:0:\"\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("90755","_transient__bbp_83.103.150.72_last_posted","1426851821","yes");
INSERT INTO `wp_options` VALUES("88228","_transient__bbp_183.222.153.95_last_posted","1426578105","yes");
INSERT INTO `wp_options` VALUES("88244","_transient__bbp_117.166.119.226_last_posted","1426579703","yes");
INSERT INTO `wp_options` VALUES("88347","_transient__bbp_117.169.1.48_last_posted","1426591389","yes");
INSERT INTO `wp_options` VALUES("88348","_transient__bbp_117.169.1.78_last_posted","1427404556","yes");
INSERT INTO `wp_options` VALUES("88416","_transient__bbp_111.23.58.46_last_posted","1427326136","yes");
INSERT INTO `wp_options` VALUES("99122","_site_transient_timeout_browser_c917cbcbdbc2b619466b4aeb270ad980","1428308808","yes");
INSERT INTO `wp_options` VALUES("99123","_site_transient_browser_c917cbcbdbc2b619466b4aeb270ad980","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"36.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("99128","_transient_timeout_feed_2fb9572e3d6a42f680e36370936a57ae","1427747214","no");
INSERT INTO `wp_options` VALUES("99129","_transient_feed_2fb9572e3d6a42f680e36370936a57ae","a:4:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:303:\"
    
    
    
    
    
    
    
  
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WordPress Francophone : Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/planet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:9:\"alternate\";s:4:\"type\";s:9:\"text/html\";s:4:\"href\";s:35:\"http://www.wordpress-fr.net/planet/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:20:\"application/atom+xml\";s:4:\"href\";s:54:\"http://feeds.feedburner.com/WordpressFrancophonePlanet\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"2015-03-30T10:19:31Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Author\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:5:\"entry\";a:20:{i:0;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WP Formation : En juin 2015, faites le plein de WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wpformation.com/juin-2015-plein-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://wpformation.com/juin-2015-plein-de-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-30T08:00:30+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WPFormation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1320:\"<div>
<p><img width=\"300\" height=\"236\" src=\"http://wpformation.com/wp-content/uploads/2015/03/wc-lyon-2015-300x236.jpg\" class=\"attachment-medium wp-post-image\" alt=\"wordcamp Lyon 2015\" style=\"float: right; margin:0 0 10px 10px;\">Il est des mois comme cela ou les &eacute;v&eacute;nements WordPress se bousculent... En juin 2015, il y aura 2 &eacute;v&eacute;nements WordPress &agrave; 1&nbsp;jour d&rsquo;intervalle.&nbsp;Il s\'agit du premier WordCamp Lyon&nbsp;le 05 juin 2015 et&nbsp;du&nbsp;WPMX Day 2015 le 06 juin 2015 &agrave; Biarritz. &nbsp; 1er WordCamp LYON La premi&egrave;re &eacute;dition du WordCamp Lyon aura lieu le 5 [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/juin-2015-plein-de-wordpress/\">En juin 2015, faites le plein de WordPress</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Grégoire Noyelle : ACF Pro :: Ajouter des pages d’options WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://www.gregoirenoyelle.com/acf-pro-utiliser-ajouter-pages-options-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:80:\"http://www.gregoirenoyelle.com/acf-pro-utiliser-ajouter-pages-options-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-30T07:00:55+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:779:\"<div>Dans ce tutoriel, nous verrons comment utiliser le Add-on Options Page du plugin Advanced Custom Fields (ACF) avec le th&egrave;me par d&eacute;faut Twenty Fifteen. Pr&eacute;sentation de l&rsquo;add-on Options page est r&eacute;serv&eacute; pour ajouter de nouvelles options dans votre back-office. Celles-ci seront accessibles par l&rsquo;administrateur du futur site. Applications possibles Tous les champs ACF sont disponibles ...<p>Cet article a &eacute;t&eacute; publi&eacute; le 30 mars 2015 par <a href=\"http://www.gregoirenoyelle.com/\">Gr&eacute;goire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"http://www.gregoirenoyelle.com/acf-pro-utiliser-ajouter-pages-options-wordpress/\">ACF Pro :: Ajouter des pages d&rsquo;options WordPress</a>.</p>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"SEOMix : Nouvelle session de formation « WordPress et SEO »\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.seomix.fr/nouvelle-session-formation-wordpress-et-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:65:\"http://www.seomix.fr/nouvelle-session-formation-wordpress-et-seo/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-26T08:00:27+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:2325:\"<div>
<div><img width=\"250\" height=\"250\" src=\"http://www.seomix.fr/wp-content/uploads/2011/05/banniere-seomix-250x250.png\" class=\"attachment-thumb-250-250-true wp-post-image\" alt=\"SeoMix\"></div>SeoMix lance une nouvelle date de formation \"WordPress et R&eacute;f&eacute;rencement naturel\". Ne ratez pas cette occasion d\'am&eacute;liorer vos connaissances !<p><strong>Acc&eacute;dez &agrave; l\'article original :</strong> <a href=\"http://www.seomix.fr/nouvelle-session-formation-wordpress-et-seo/\">Nouvelle session de formation &laquo;&nbsp;WordPress et SEO&nbsp;&raquo;</a>.</p>
    <p><strong>Voici le d&eacute;but du contenu :</strong> Une toute nouvelle session de la formation WordPress et SEO vient d&rsquo;&ecirc;tre ajout&eacute;e. Je r&eacute;it&egrave;re cette ann&eacute;e l&rsquo;op&eacute;ration qui avait si bien fonctionn&eacute; l&rsquo;ann&eacute;e derni&egrave;re, et dont les retours des participants avaient &eacute;t&eacute; excellents. Si vous voulez r&eacute;ellement savoir optimiser le SEO de ce CMS, sautez sur l&rsquo;occasion ! Plan de formation Voici les grandes th&eacute;matiques qui seront abord&eacute;es lors de cette journ&eacute;e : Avant-propos sur le r&eacute;f&eacute;rencement naturel Les contenus et la Structure La popularit&eacute; L&rsquo;aspect technique 2- Auditer son site WordPress Que regarder en premier ? Les outils externes Les outils internes Le suivi des erreurs, du trafic et du positionnement L&rsquo;analyse sp&eacute;cifique de WordPress lors de l&rsquo;audit Comment corriger son site ? 3- La s&eacute;curit&eacute; de son site L&rsquo;impact en r&eacute;f&eacute;rencement Les utilisateurs Les plugins Les backups 4- Les r&eacute;glages de WordPress G&eacute;n&eacute;ral &Eacute;criture Lecture Discussion M&eacute;dias Permaliens 5- Les plugins de r&eacute;f&eacute;rence Yoast WordPress SEO Redirection Broken Link Checker WP Sitemap Page YARPP WP Page-Navi SX no Pagination 6- Les th&egrave;mes Pourquoi s&rsquo;en m&eacute;fier La duplication de contenus (DUST) La duplication de liens Les contenus pauvres Les erreurs du header Le concept des hooks Maillage interne et structure en silos 7- Performance, ergonomie et optimisation SEO&hellip;</p>
<hr>
<img src=\"http://feeds.feedburner.com/~r/seomix-wordpress/~4/J9I81Jrq2KU\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WP Formation : Par où commencer pour auditer votre WordPress ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wpformation.com/auditer-votre-site-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://wpformation.com/auditer-votre-site-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-26T07:09:01+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Pierrepack Sébastien\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1323:\"<div>
<p><img width=\"300\" height=\"200\" src=\"http://wpformation.com/wp-content/uploads/2015/03/Audit-wordpress-300x200.jpg\" class=\"attachment-medium wp-post-image\" alt=\"Audit WordPress\" style=\"float: right; margin:0 0 10px 10px;\">Parmi tous les outils SEO du web, il en existe quelques-uns qui sortent du lot comme &eacute;crit dans plusieurs articles en mati&egrave;re de r&eacute;f&eacute;rencement. Ce concept ne fait pas tout. Voil&agrave; pourquoi, aujourd\'hui, je publie quelques astuces pour influencer ou plus directement et de mani&egrave;re b&eacute;n&eacute;fique votre tendance SEO. &nbsp; Se tenir au courant des [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/auditer-votre-site-wordpress/\">Par o&ugrave; commencer pour auditer votre WordPress ?</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WordPress Francophone : La problématique des traductions officielles\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-25T09:07:35+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:6942:\"<div>
<p>Merci &agrave; WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une probl&eacute;matique tr&egrave;s sp&eacute;cifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je r&eacute;dige une seconde version du livre &laquo;&nbsp;Optimiser son r&eacute;f&eacute;rencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confront&eacute; &agrave; une probl&eacute;matique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilis&eacute; ?</h2>
<p>Th&eacute;oriquement, la seule et unique r&eacute;ponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la premi&egrave;re fois que j&rsquo;ai &eacute;t&eacute; confront&eacute; &agrave; ce probl&egrave;me de traduction a &eacute;t&eacute; lorsque mon &eacute;diteur m&rsquo;a indiqu&eacute; que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez &eacute;trange, et la question que je me pose &agrave; nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilis&eacute; par la communaut&eacute; : Plugin ;</li>
<li>un autre terme utilis&eacute; par une partie de la communaut&eacute; : Moudule ;</li>
<li>le terme le plus couramment utilis&eacute; par certains &eacute;diteurs : Plug-in.</li>
</ul>
<p>Pour y r&eacute;pondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la r&eacute;ponse est sans appel : le terme le plus utilis&eacute; de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\"></a></p>
<p>PS : pour avoir les derniers chiffres &agrave; jour de l&rsquo;&eacute;tude, les r&eacute;sultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une diff&eacute;rence entre traduction et usage ?</h2>
<p>Cette diff&eacute;rence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communaut&eacute; WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles fran&ccedil;ais utilise de mani&egrave;re naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plut&ocirc;t que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques compl&egrave;tement diff&eacute;rentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxB&eacute;nard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son r&eacute;f&eacute;rencement WordPress</em>&nbsp;&raquo; est le seul &agrave; utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes diff&eacute;rents pour d&eacute;signer une seule et m&ecirc;me chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communaut&eacute; : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilis&eacute; par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour d&eacute;signer cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confront&eacute; &agrave; un &eacute;norme probl&egrave;me d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;&ecirc;tre perdus puisque le terme a chang&eacute; dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et th&egrave;mes pouvaient r&eacute;cup&eacute;rer la valeur de la traduction de cette cha&icirc;ne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incoh&eacute;rences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous &agrave; changer nos appellations. Chaque membre de la communaut&eacute; devrait alors remplacer de mani&egrave;re syst&eacute;matique sa mani&egrave;re de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en r&eacute;f&eacute;rencement naturel : pourquoi appeler un &eacute;l&eacute;ment &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorit&eacute; de personnes utilise un autre terme lors de ses recherches sur le web&hellip;</p>
<p>Je reste donc assez mitig&eacute; sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"BoiteAWeb : WordCamp Lyon 2015 : 5 juin 2015, La plateforme\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://boiteaweb.fr/wordcamp-lyon-5-juin-2015-la-plateforme-8562.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:69:\"http://boiteaweb.fr/wordcamp-lyon-5-juin-2015-la-plateforme-8562.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-24T16:00:28+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:494:\"<div>Dans quelques&nbsp;semaines d&eacute;butera&nbsp;la premi&egrave;re &eacute;dition du WordCamp Lyon ! Th&eacute;oriquement, il fera beau&nbsp;et&nbsp;chaud, toute leur &eacute;quipe de volontaire accueillera le public et les orateurs avec entrain&nbsp;pour partager avec vous la premi&egrave;re &laquo; croisi&egrave;re WordPress &raquo; &agrave; bord de la Plateforme. En attendant il reste pas mal&nbsp;de travail et, en parlant des orateurs,&nbsp;un appel &agrave; tous [&hellip;]</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"BoiteAWeb : Enquête 2015 AFUP et Human Coders : Les salaires de l’IT en France\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://boiteaweb.fr/enquete-2015-afup-human-coders-8560.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:60:\"http://boiteaweb.fr/enquete-2015-afup-human-coders-8560.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-24T10:48:25+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"<div>L\'AFUP lance la troisi&egrave;me &eacute;dition du barom&egrave;tre des salaires du PHP en France.</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WordPress Francophone : L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-24T07:52:23+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:3077:\"<div>
<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;&eacute;quipe de traduction</h3>
<ul>
<li>Le WordCamp London a &eacute;t&eacute; l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arriv&eacute;e d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version fran&ccedil;aise de Belgique (en)</a>.</li>
<li>
<a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des &eacute;quipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a &eacute;t&eacute; expos&eacute;e &agrave; des failles de s&eacute;curit&eacute; importantes</a>. R&eacute;active, l&rsquo;&eacute;quipe de d&eacute;veloppement a publi&eacute; une version qui corrige les probl&egrave;mes.</p>
<h3>Pourquoi une agence a abandonn&eacute; WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise exp&eacute;rience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de No&euml;l</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndr&ocirc;me Sapin de No&euml;l </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour s&eacute;curiser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de s&eacute;curit&eacute;</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"L\'écho des plugins WordPress : Project Force Field\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://www.echodesplugins.li-an.fr/plugins/project-force-field/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:63:\"http://www.echodesplugins.li-an.fr/plugins/project-force-field/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-22T08:47:07+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"<div>Trompez les agresseurs sur le lien de login</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WordPress Francophone : L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-17T07:38:32+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:3783:\"<div>
<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&hellip; Un grand &eacute;v&eacute;nement WordPress qui aura lieu &agrave; Biarritz. Les billets sont d&rsquo;ores et d&eacute;j&agrave; en vente !<br>
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;id&eacute;es au sein de la communaut&eacute; WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La premi&egrave;re beta de WordPress 4.2 est disponible</a>. Il est rappel&eacute; qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de d&eacute;veloppement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au t&eacute;l&eacute;chargement. C&rsquo;est une version de s&eacute;curit&eacute; : mettez &agrave; jour !<br>
&hellip;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug c&ocirc;t&eacute; notifications.</p>
<h3>Une mise &agrave; jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise &agrave; jour automatique des extensions</a> (en) pour raison de s&eacute;curit&eacute; est mise en place pour les versions sup&eacute;rieures ou &eacute;gales &agrave; WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui &ccedil;a existe</a> !</p>
<h3>Vuln&eacute;rabilit&eacute; dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vuln&eacute;rabilit&eacute; a &eacute;t&eacute; d&eacute;couverte dans WooCommerce</a> (en) par l&rsquo;&eacute;quipe de WordFence. L&rsquo;&eacute;quipe de Woo a rapidement r&eacute;agit pour colmater la br&egrave;che.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&hellip; (en).</p>
<h3>Le guide pour d&eacute;butant pour h&eacute;berger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les d&eacute;butants qui veulent se lancer dans l&rsquo;h&eacute;bergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"L\'écho des plugins WordPress : Changez rapidement la nature de vos billets\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://www.echodesplugins.li-an.fr/plugins/post-type-switcher/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:62:\"http://www.echodesplugins.li-an.fr/plugins/post-type-switcher/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-13T18:07:38+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Li-An\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"<div>Deux plugins qui permettent de modifier le type de vos billets</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WP Formation : Comment s’assurer que votre site est SEO-Friendly\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wpformation.com/comment-sassurer-que-votre-site-est-seo-friendly/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:72:\"http://wpformation.com/comment-sassurer-que-votre-site-est-seo-friendly/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-13T07:12:21+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Pierrepack Sébastien\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1374:\"<div>
<p><img width=\"300\" height=\"120\" src=\"http://wpformation.com/wp-content/uploads/2015/03/audit-seo-woorank-300x120.png\" class=\"attachment-medium wp-post-image\" alt=\"audit seo woorank\" style=\"float: right; margin:0 0 10px 10px;\">En r&eacute;ponse &agrave; une remarque en commentaire sur cet article, j\'ai d&eacute;cid&eacute;, aujourd\'hui de m\'atteler &agrave; la pr&eacute;sentation de Woorank. &nbsp; Analyser, pas &agrave; pas, les pages de votre site M&ecirc;me si Woorank est limit&eacute; dans son offre gratuite, cet outil SEO en ligne offre beaucoup de donn&eacute;es pertinentes pour am&eacute;liorer votre site.&nbsp;Je vous sugg&egrave;re [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/comment-sassurer-que-votre-site-est-seo-friendly/\">Comment s&rsquo;assurer que votre site est SEO-Friendly</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WordPress Francophone : L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-10T07:39:49+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:3661:\"<div>
<h3>Un guide des communaut&eacute;s WordPress</h3>
<p>Tom Zsomborgi et son &eacute;quipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communaut&eacute;s WordPress</a> &agrave; travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aur&eacute;lien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel &agrave; candidature pour h&eacute;berger l&rsquo;&eacute;v&eacute;nement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau r&eacute;pertoire de th&egrave;mes et d&rsquo;extensions</h3>
<p>Les r&eacute;pertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">th&egrave;mes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont &eacute;t&eacute; refondus. (en)</p>
<h3>Et si on &eacute;crivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;id&eacute;e de Siobhan McKeown&hellip; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs &agrave; ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">&Eacute;milie indique les 8 erreurs</a> &agrave; ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t&rsquo;anime jour et nuit, depuis ton plus jeune &acirc;ge</em>&hellip; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&hellip; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></a>
</div>
<img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Grégoire Noyelle : WordPress :: Masquer les sous-menus de votre back-office\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://www.gregoirenoyelle.com/wordpress-masquer-menus-back-office/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:67:\"http://www.gregoirenoyelle.com/wordpress-masquer-menus-back-office/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-09T07:01:16+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:763:\"<div>Dans ce tutoriel, nous verrons comment masquer des &eacute;l&eacute;ments de votre sous-menu, dans le back-office de WordPress. Masquer un &eacute;l&eacute;ment du menu D&rsquo;abord, je vais me concentrer sur la barre lat&eacute;rale de l&rsquo;administration WordPress. Les &eacute;l&eacute;ments de premier niveau ont souvent des classes ou des identifiants. J&rsquo;aurais donc pu me d&eacute;brouiller avec une feuille de ...<p>Cet article a &eacute;t&eacute; publi&eacute; le 9 mars 2015 par <a href=\"http://www.gregoirenoyelle.com/\">Gr&eacute;goire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"http://www.gregoirenoyelle.com/wordpress-masquer-menus-back-office/\">WordPress :: Masquer les sous-menus de votre back-office</a>.</p>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"wabeo : Un délai pour mettre à jour automatiquement les plugins\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/JTcZ44oQJd0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/JTcZ44oQJd0/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-06T09:20:15+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Willy Bahuaud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:605:\"<div>
<p>Depuis la version 3.7 de WordPress nous avons la possibilit&eacute; de mettre &agrave; jour automatiquement WordPress et ses modules. Et si on attendait quelques jours avant d\'appliquer une mise &agrave; jour de mani&egrave;re automatique ? Voyons comment proc&eacute;der...</p>
<hr>
Voir <a rel=\"nofollow\" href=\"http://wabeo.fr/delai-mise-a-jour-plugins/\">Un d&eacute;lai pour mettre &agrave; jour automatiquement les plugins</a> directement sur <a rel=\"nofollow\" href=\"http://wabeo.fr/\">wabeo</a><img src=\"http://feeds.feedburner.com/~r/Wabeo/~4/JTcZ44oQJd0\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"BoiteAWeb : Happiness bar 2 : Du multisite en locale\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://boiteaweb.fr/happiness-bar-2-du-multisite-en-locale-8531.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:68:\"http://boiteaweb.fr/happiness-bar-2-du-multisite-en-locale-8531.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-05T21:55:36+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:445:\"<div>Samedi 24 janvier se d&eacute;roulait la seconde journ&eacute;e du WordCamp Paris 2015. Comme en 2014 et comme la veille, je tenais le Happiness Bar accompagn&eacute; de Alex Concha et d&rsquo;autres b&eacute;n&eacute;voles d&eacute;sireux d&rsquo;aider les visiteurs. J&rsquo;ai encore eu une question technique qui a &eacute;t&eacute; r&eacute;solue avec un seul hook. Lilou multisite &laquo;&nbsp;Dans un multisite, tous [&hellip;]</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"BoiteAWeb : ++$boiteaweb; : Le site en version 5.0\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://boiteaweb.fr/version-5-8555.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:39:\"http://boiteaweb.fr/version-5-8555.html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-04T21:38:50+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:403:\"<div>Pouf pouf hop comme &ccedil;a vite fait, une petite v5 du site. J&rsquo;attendais le th&egrave;me TwentyFifteen pour cette V5, je l&rsquo;ai test&eacute; et finalement, non. J&rsquo;ai alors cherch&eacute; un autre th&egrave;me gratuit, j&rsquo;ai trouv&eacute; que Eighties mettais bien en valeur les animaux en HD, alors j&rsquo;ai dis banco. Sur le fond rien ne change, toujours [&hellip;]</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WordPress Channel : Supprimer le slug d’une taxonomie sous WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:56:\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-04T16:29:18+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:817:\"<div>
<p>Les custom taxonomies ou taxonomies personnalis&eacute;es offrent la possibilit&eacute; de cr&eacute;er des filtres suppl&eacute;mentaires afin de classer vos contenus aussi bien en back-office qu&rsquo;en front-office. Nativement, elles rajoutent un mot-cl&eacute; dans l&rsquo;URL qui rallongent inutilement les URLs et qui n&rsquo;a bien souvent que peu de sens pour les moteurs de recherche. Cette astuce vous explique&hellip;</p>
<p><a rel=\"nofollow\" href=\"http://wpchannel.com/author/aurelien-denis/\">Aur&eacute;lien Denis</a> - <a rel=\"nofollow\" href=\"http://wpchannel.com/\">WordPress Channel - Tutoriels, th&egrave;mes &amp; plugins WordPress</a> - <a rel=\"nofollow\" href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\">Supprimer le slug d&rsquo;une taxonomie sous WordPress</a></p>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"wabeo : Les hooks des menus de navigation de WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/GpkNl8fwI0k/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:52:\"http://feedproxy.google.com/~r/Wabeo/~3/GpkNl8fwI0k/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-02T10:59:42+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Willy Bahuaud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:454:\"<div>
<p>Suite au tutoriel pour customiser les menus avec les walkers, voici un article expliquant comment personnaliser les menus en utilisant les hooks de WordPress</p>
<hr>
Voir <a rel=\"nofollow\" href=\"http://wabeo.fr/hook-nav-menus/\">Les hooks des menus de navigation de WordPress</a> directement sur <a rel=\"nofollow\" href=\"http://wabeo.fr/\">wabeo</a><img src=\"http://feeds.feedburner.com/~r/Wabeo/~4/GpkNl8fwI0k\" height=\"1\" width=\"1\" alt=\"\">
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:68:\"
        
        
        
        
        
        
        
    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WP Formation : Trouver gratuitement un maximum de vos backlinks !\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wpformation.com/trouver-gratuitement-un-maximum-de-vos-backlinks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:9:\"alternate\";s:4:\"href\";s:72:\"http://wpformation.com/trouver-gratuitement-un-maximum-de-vos-backlinks/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2015-03-02T08:00:17+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Pierrepack Sébastien\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:1365:\"<div>
<p><img width=\"300\" height=\"150\" src=\"http://wpformation.com/wp-content/uploads/2015/02/Majestic-SEO-300x150.jpg\" class=\"attachment-medium wp-post-image\" alt=\"Majestic-SEO\" style=\"float: right; margin:0 0 10px 10px;\">Dans un pr&eacute;c&eacute;dent article, j\'ai &eacute;voqu&eacute; l\'outil d\'analyse de liens pointant vers un site : SEO Cleaner. Vous vous &ecirc;tes sans doute pos&eacute; la question : comment obtenir la liste la plus compl&egrave;te de backlinks&nbsp;&agrave; moindre co&ucirc;t ? Pour ce faire, je vous pr&eacute;sente aujourd\'hui&nbsp;l\'outil Majestic SEO. Une r&eacute;f&eacute;rence dans le domaine ! &nbsp; Attention, [&hellip;]</p>
<hr>
<a rel=\"nofollow\" href=\"http://wpformation.com/trouver-gratuitement-un-maximum-de-vos-backlinks/\">Trouver gratuitement un maximum de vos backlinks !</a> est un article de <a title=\"Formation WordPress Ecommerce\" href=\"http://wpformation.com/\">WP Formation</a><br><a href=\"http://wpformation.com/formation-wordpress/\">Formation WordPress</a> &amp; <a href=\"http://wpformation.com/formation-woocommerce-e-commerce/\">WooCommerce</a> - Retrouvez-moi sur <a title=\"Ajouter sur Facebook\" href=\"http://www.facebook.com/wpformation\">Facebook</a> - <a title=\"Suivre sur Twitter\" href=\"http://twitter.com/wpformation\">Twitter</a> - <a href=\"http://plus.google.com/+FabriceDucarme/\">Google+</a><br>
</div>\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:26:\"wordpressfrancophoneplanet\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Mon, 30 Mar 2015 08:19:32 GMT\";s:4:\"date\";s:29:\"Mon, 30 Mar 2015 08:26:54 GMT\";s:7:\"expires\";s:29:\"Mon, 30 Mar 2015 08:26:54 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:13:\"80:quic,p=0.5\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("88458","_transient__bbp_117.169.1.227_last_posted","1427659783","yes");
INSERT INTO `wp_options` VALUES("88558","_transient__bbp_202.75.216.235_last_posted","1427240880","yes");
INSERT INTO `wp_options` VALUES("88565","_transient__bbp_183.221.147.105_last_posted","1426612124","yes");
INSERT INTO `wp_options` VALUES("88575","_transient__bbp_121.9.232.237_last_posted","1427203209","yes");
INSERT INTO `wp_options` VALUES("88603","_transient__bbp_183.222.154.64_last_posted","1426616441","yes");
INSERT INTO `wp_options` VALUES("88630","_transient__bbp_117.169.1.191_last_posted","1427683415","yes");
INSERT INTO `wp_options` VALUES("99258","_site_transient_timeout_browser_fb7e73d137e6cd6d4a2ec6775f80507c","1428319299","yes");
INSERT INTO `wp_options` VALUES("99259","_site_transient_browser_fb7e73d137e6cd6d4a2ec6775f80507c","a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"36.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("88934","_transient__bbp_117.169.1.46_last_posted","1426653648","yes");
INSERT INTO `wp_options` VALUES("88965","_transient__bbp_203.100.80.81_last_posted","1426658127","yes");
INSERT INTO `wp_options` VALUES("89031","_transient__bbp_59.58.162.141_last_posted","1427005183","yes");
INSERT INTO `wp_options` VALUES("89032","_transient__bbp_31.207.64.110_last_posted","1426664720","yes");
INSERT INTO `wp_options` VALUES("88665","_transient__bbp_183.203.208.170_last_posted","1427324589","yes");
INSERT INTO `wp_options` VALUES("88683","_transient__bbp_103.249.101.129_last_posted","1426623518","yes");
INSERT INTO `wp_options` VALUES("88777","_transient__bbp_117.166.45.243_last_posted","1426633599","yes");
INSERT INTO `wp_options` VALUES("88784","_transient__bbp_134.60.39.36_last_posted","1426634219","yes");
INSERT INTO `wp_options` VALUES("88839","_transient__bbp_117.166.58.99_last_posted","1426645366","yes");
INSERT INTO `wp_options` VALUES("88874","_transient__bbp_211.141.130.186_last_posted","1427568260","yes");
INSERT INTO `wp_options` VALUES("88878","_transient__bbp_39.188.122.98_last_posted","1426645597","yes");
INSERT INTO `wp_options` VALUES("88915","_transient__bbp_117.166.229.79_last_posted","1426651778","yes");
INSERT INTO `wp_options` VALUES("89091","_transient__bbp_36.250.174.6_last_posted","1426670374","yes");
INSERT INTO `wp_options` VALUES("89152","_transient__bbp_121.9.232.202_last_posted","1426676357","yes");
INSERT INTO `wp_options` VALUES("89216","_transient__bbp_82.139.114.74_last_posted","1426682675","yes");
INSERT INTO `wp_options` VALUES("89284","_transient__bbp_183.222.157.47_last_posted","1426688842","yes");
INSERT INTO `wp_options` VALUES("89461","_transient__bbp_217.12.24.130_last_posted","1427022279","yes");
INSERT INTO `wp_options` VALUES("89514","_transient__bbp_2607:5300:100:200::1073_last_posted","1426710673","yes");
INSERT INTO `wp_options` VALUES("89524","_transient__bbp_82.199.193.209_last_posted","1426711417","yes");
INSERT INTO `wp_options` VALUES("89567","_transient__bbp_201.243.185.159_last_posted","1426715854","yes");
INSERT INTO `wp_options` VALUES("89598","_transient__bbp_101.30.202.71_last_posted","1426955976","yes");
INSERT INTO `wp_options` VALUES("89629","_transient__bbp_223.86.78.125_last_posted","1426722623","yes");
INSERT INTO `wp_options` VALUES("89666","_transient__bbp_121.9.232.201_last_posted","1426726946","yes");
INSERT INTO `wp_options` VALUES("89722","_transient__bbp_117.169.1.196_last_posted","1426732087","yes");
INSERT INTO `wp_options` VALUES("89810","_transient__bbp_112.19.11.96_last_posted","1426808973","yes");
INSERT INTO `wp_options` VALUES("89814","_transient__bbp_193.201.224.26_last_posted","1426747597","yes");
INSERT INTO `wp_options` VALUES("89868","_transient__bbp_178.248.24.26_last_posted","1427065718","yes");
INSERT INTO `wp_options` VALUES("89908","_transient__bbp_114.111.166.251_last_posted","1427125705","yes");
INSERT INTO `wp_options` VALUES("89912","_transient__bbp_117.169.1.219_last_posted","1426753681","yes");
INSERT INTO `wp_options` VALUES("89958","_transient__bbp_117.166.64.192_last_posted","1426759526","yes");
INSERT INTO `wp_options` VALUES("89992","_transient__bbp_117.173.23.193_last_posted","1426763491","yes");
INSERT INTO `wp_options` VALUES("90041","_transient__bbp_183.203.208.165_last_posted","1427203265","yes");
INSERT INTO `wp_options` VALUES("90045","_transient__bbp_111.1.91.137_last_posted","1427620290","yes");
INSERT INTO `wp_options` VALUES("90104","_transient__bbp_183.203.208.174_last_posted","1427060168","yes");
INSERT INTO `wp_options` VALUES("90183","_transient__bbp_117.175.99.223_last_posted","1426915196","yes");
INSERT INTO `wp_options` VALUES("90184","_transient__bbp_67.58.38.246_last_posted","1427265112","yes");
INSERT INTO `wp_options` VALUES("90212","_transient__bbp_210.101.131.227_last_posted","1427425414","yes");
INSERT INTO `wp_options` VALUES("90216","_transient__bbp_117.173.21.74_last_posted","1426788936","yes");
INSERT INTO `wp_options` VALUES("90284","_transient__bbp_121.9.232.193_last_posted","1427141538","yes");
INSERT INTO `wp_options` VALUES("90324","_transient__bbp_183.203.208.162_last_posted","1427138225","yes");
INSERT INTO `wp_options` VALUES("90643","_transient__bbp_94.183.153.191_last_posted","1426838494","yes");
INSERT INTO `wp_options` VALUES("90686","_transient__bbp_183.26.229.146_last_posted","1426843477","yes");
INSERT INTO `wp_options` VALUES("90702","_transient__bbp_183.221.220.217_last_posted","1426846933","yes");
INSERT INTO `wp_options` VALUES("90742","_transient__bbp_85.105.197.216_last_posted","1426850976","yes");
INSERT INTO `wp_options` VALUES("90768","_transient__bbp_202.154.179.58_last_posted","1427620444","yes");
INSERT INTO `wp_options` VALUES("90793","_transient__bbp_92.242.59.6_last_posted","1426855980","yes");
INSERT INTO `wp_options` VALUES("90818","_transient__bbp_101.4.136.66_last_posted","1427280333","yes");
INSERT INTO `wp_options` VALUES("90844","_transient__bbp_117.166.222.243_last_posted","1426861045","yes");
INSERT INTO `wp_options` VALUES("90854","_transient__bbp_223.82.137.37_last_posted","1426861731","yes");
INSERT INTO `wp_options` VALUES("91023","_transient__bbp_177.66.241.4_last_posted","1426881519","yes");
INSERT INTO `wp_options` VALUES("95261","_transient__bbp_121.9.232.169_last_posted","1427335372","yes");
INSERT INTO `wp_options` VALUES("90968","_transient__bbp_186.233.116.90_last_posted","1427384780","yes");
INSERT INTO `wp_options` VALUES("91099","_transient__bbp_223.86.64.28_last_posted","1426889496","yes");
INSERT INTO `wp_options` VALUES("91184","_transient__bbp_77.247.181.163_last_posted","1426899295","yes");
INSERT INTO `wp_options` VALUES("91197","_transient__bbp_117.173.21.136_last_posted","1426924685","yes");
INSERT INTO `wp_options` VALUES("91232","_transient__bbp_173.192.79.55_last_posted","1426911471","yes");
INSERT INTO `wp_options` VALUES("91254","_transient__bbp_187.95.34.3_last_posted","1426907209","yes");
INSERT INTO `wp_options` VALUES("91282","_transient__bbp_183.220.244.162_last_posted","1426910823","yes");
INSERT INTO `wp_options` VALUES("91310","_transient__bbp_107.6.12.37_last_posted","1427426349","yes");
INSERT INTO `wp_options` VALUES("91366","_transient__bbp_88.159.52.39_last_posted","1426919830","yes");
INSERT INTO `wp_options` VALUES("91385","_transient__bbp_97.88.124.52_last_posted","1426921850","yes");
INSERT INTO `wp_options` VALUES("91419","_transient__bbp_222.45.196.53_last_posted","1426926390","yes");
INSERT INTO `wp_options` VALUES("91448","_transient__bbp_61.154.127.136_last_posted","1427077227","yes");
INSERT INTO `wp_options` VALUES("91449","_transient__bbp_117.177.226.169_last_posted","1426930926","yes");
INSERT INTO `wp_options` VALUES("91507","_transient__bbp_114.34.42.94_last_posted","1426938188","yes");
INSERT INTO `wp_options` VALUES("91508","_transient__bbp_112.228.71.217_last_posted","1426938337","yes");
INSERT INTO `wp_options` VALUES("91524","_transient__bbp_210.57.208.14_last_posted","1426940045","yes");
INSERT INTO `wp_options` VALUES("91528","_transient__bbp_111.10.199.174_last_posted","1426940315","yes");
INSERT INTO `wp_options` VALUES("91587","_transient__bbp_117.177.147.142_last_posted","1426947149","yes");
INSERT INTO `wp_options` VALUES("91663","_transient__bbp_222.45.212.130_last_posted","1427294804","yes");
INSERT INTO `wp_options` VALUES("91715","_transient__bbp_5.135.158.101_last_posted","1426961252","yes");
INSERT INTO `wp_options` VALUES("91765","_transient__bbp_117.176.56.2_last_posted","1426967529","yes");
INSERT INTO `wp_options` VALUES("91868","_transient__bbp_183.203.208.168_last_posted","1427201847","yes");
INSERT INTO `wp_options` VALUES("91923","_transient__bbp_112.45.179.194_last_posted","1426987788","yes");
INSERT INTO `wp_options` VALUES("92000","_transient__bbp_117.177.103.145_last_posted","1426998117","yes");
INSERT INTO `wp_options` VALUES("92086","_transient__bbp_78.41.100.202_last_posted","1427009559","yes");
INSERT INTO `wp_options` VALUES("92105","_transient__bbp_117.175.110.170_last_posted","1427011738","yes");
INSERT INTO `wp_options` VALUES("92115","_transient__bbp_112.228.18.132_last_posted","1427013210","yes");
INSERT INTO `wp_options` VALUES("92152","_transient__bbp_121.9.232.166_last_posted","1427018058","yes");
INSERT INTO `wp_options` VALUES("92165","_transient__bbp_46.126.46.181_last_posted","1427197157","yes");
INSERT INTO `wp_options` VALUES("92172","_transient__bbp_91.121.113.76_last_posted","1427021304","yes");
INSERT INTO `wp_options` VALUES("92251","_transient__bbp_183.221.220.28_last_posted","1427031705","yes");
INSERT INTO `wp_options` VALUES("92310","_transient__bbp_185.14.28.27_last_posted","1427175022","yes");
INSERT INTO `wp_options` VALUES("92353","_transient__bbp_111.10.139.58_last_posted","1427044156","yes");
INSERT INTO `wp_options` VALUES("92412","_transient__bbp_183.203.208.169_last_posted","1427051204","yes");
INSERT INTO `wp_options` VALUES("92440","_transient__bbp_18.239.0.155_last_posted","1427054890","yes");
INSERT INTO `wp_options` VALUES("92531","_transient__bbp_85.226.63.243_last_posted","1427434654","yes");
INSERT INTO `wp_options` VALUES("92559","_transient__bbp_60.191.39.252_last_posted","1427069106","yes");
INSERT INTO `wp_options` VALUES("92596","_transient__bbp_121.9.232.194_last_posted","1427073316","yes");
INSERT INTO `wp_options` VALUES("92609","_transient__bbp_222.68.250.2_last_posted","1427074517","yes");
INSERT INTO `wp_options` VALUES("92668","_transient__bbp_117.169.1.216_last_posted","1427081452","yes");
INSERT INTO `wp_options` VALUES("92778","_transient__bbp_195.4.128.175_last_posted","1427180237","yes");
INSERT INTO `wp_options` VALUES("92785","_transient__bbp_117.176.55.84_last_posted","1427095061","yes");
INSERT INTO `wp_options` VALUES("92807","_transient__bbp_112.228.40.26_last_posted","1427097734","yes");
INSERT INTO `wp_options` VALUES("92853","_transient__bbp_114.111.167.208_last_posted","1427102569","yes");
INSERT INTO `wp_options` VALUES("92869","_transient__bbp_147.83.143.44_last_posted","1427103889","yes");
INSERT INTO `wp_options` VALUES("93006","_transient__bbp_159.255.169.4_last_posted","1427196465","yes");
INSERT INTO `wp_options` VALUES("93052","_transient__bbp_134.249.53.36_last_posted","1427715011","yes");
INSERT INTO `wp_options` VALUES("93053","_transient__bbp_46.118.123.80_last_posted","1427715158","yes");
INSERT INTO `wp_options` VALUES("93176","_transient__bbp_218.207.54.112_last_posted","1427136394","yes");
INSERT INTO `wp_options` VALUES("93252","_transient__bbp_183.223.208.98_last_posted","1427143726","yes");
INSERT INTO `wp_options` VALUES("93331","_transient__bbp_87.98.250.222_last_posted","1427151409","yes");
INSERT INTO `wp_options` VALUES("93362","_transient__bbp_80.149.233.237_last_posted","1427154172","yes");
INSERT INTO `wp_options` VALUES("93372","_transient__bbp_193.109.166.219_last_posted","1427155128","yes");
INSERT INTO `wp_options` VALUES("93455","_transient__bbp_117.173.20.141_last_posted","1427162787","yes");
INSERT INTO `wp_options` VALUES("93471","_transient__bbp_94.180.36.205_last_posted","1427163910","yes");
INSERT INTO `wp_options` VALUES("93526","_transient__bbp_183.61.240.126_last_posted","1427376048","yes");
INSERT INTO `wp_options` VALUES("93569","_transient__bbp_78.152.116.238_last_posted","1427173484","yes");
INSERT INTO `wp_options` VALUES("93719","_transient__bbp_93.120.205.110_last_posted","1427214235","yes");
INSERT INTO `wp_options` VALUES("93729","_transient__bbp_223.86.208.18_last_posted","1427188706","yes");
INSERT INTO `wp_options` VALUES("93821","_transient__bbp_112.228.25.167_last_posted","1427240782","yes");
INSERT INTO `wp_options` VALUES("93834","_transient__bbp_222.45.85.210_last_posted","1427562231","yes");
INSERT INTO `wp_options` VALUES("93911","_transient__bbp_23.96.16.159_last_posted","1427205941","yes");
INSERT INTO `wp_options` VALUES("93930","_transient__bbp_85.25.103.119_last_posted","1427207637","yes");
INSERT INTO `wp_options` VALUES("94241","_transient__bbp_197.231.221.211_last_posted","1427237078","yes");
INSERT INTO `wp_options` VALUES("94507","_transient__bbp_112.19.125.247_last_posted","1427263052","yes");
INSERT INTO `wp_options` VALUES("94517","_transient__bbp_117.173.238.196_last_posted","1427263677","yes");
INSERT INTO `wp_options` VALUES("94562","_transient__bbp_221.130.124.91_last_posted","1427267785","yes");
INSERT INTO `wp_options` VALUES("94681","_transient__bbp_89.169.0.122_last_posted","1427279318","yes");
INSERT INTO `wp_options` VALUES("94760","_transient__bbp_120.15.33.201_last_posted","1427287133","yes");
INSERT INTO `wp_options` VALUES("94761","_transient__bbp_121.9.232.197_last_posted","1427287305","yes");
INSERT INTO `wp_options` VALUES("94865","_transient__bbp_112.19.9.18_last_posted","1427297045","yes");
INSERT INTO `wp_options` VALUES("94944","_transient__bbp_213.1.221.206_last_posted","1427304979","yes");
INSERT INTO `wp_options` VALUES("94951","_transient__bbp_37.57.231.112_last_posted","1427305467","yes");
INSERT INTO `wp_options` VALUES("95124","_transient__bbp_178.252.87.75_last_posted","1427322390","yes");
INSERT INTO `wp_options` VALUES("95200","_transient__bbp_36.248.170.217_last_posted","1427329767","yes");
INSERT INTO `wp_options` VALUES("95256","_transient__bbp_117.177.240.32_last_posted","1427334841","yes");
INSERT INTO `wp_options` VALUES("95294","_transient__bbp_183.221.191.97_last_posted","1427338652","yes");
INSERT INTO `wp_options` VALUES("95415","_transient__bbp_117.166.1.71_last_posted","1427350414","yes");
INSERT INTO `wp_options` VALUES("95422","_transient__bbp_200.220.195.42_last_posted","1427351054","yes");
INSERT INTO `wp_options` VALUES("95472","_transient__bbp_74.208.7.207_last_posted","1427355215","yes");
INSERT INTO `wp_options` VALUES("95479","_transient__bbp_84.107.88.151_last_posted","1427355798","yes");
INSERT INTO `wp_options` VALUES("95561","_transient__bbp_200.24.220.253_last_posted","1427364030","yes");
INSERT INTO `wp_options` VALUES("95619","_transient__bbp_195.154.188.41_last_posted","1427592327","yes");
INSERT INTO `wp_options` VALUES("95641","_transient__bbp_54.69.43.14_last_posted","1427371726","yes");
INSERT INTO `wp_options` VALUES("95645","_transient__bbp_183.220.71.40_last_posted","1427372039","yes");
INSERT INTO `wp_options` VALUES("95685","_transient__bbp_80.112.136.116_last_posted","1427376134","yes");
INSERT INTO `wp_options` VALUES("95738","_transient__bbp_183.222.156.66_last_posted","1427380878","yes");
INSERT INTO `wp_options` VALUES("95745","_transient__bbp_109.184.213.149_last_posted","1427381298","yes");
INSERT INTO `wp_options` VALUES("95852","_transient__bbp_182.92.240.197_last_posted","1427391872","yes");
INSERT INTO `wp_options` VALUES("96002","_transient__bbp_117.169.1.64_last_posted","1427406285","yes");
INSERT INTO `wp_options` VALUES("96027","_transient__bbp_117.173.238.89_last_posted","1427408597","yes");
INSERT INTO `wp_options` VALUES("96080","_transient__bbp_117.169.1.47_last_posted","1427413733","yes");
INSERT INTO `wp_options` VALUES("96044","_transient__bbp_117.169.1.11_last_posted","1427410371","yes");
INSERT INTO `wp_options` VALUES("96102","_transient__bbp_117.169.1.144_last_posted","1427416016","yes");
INSERT INTO `wp_options` VALUES("96161","_transient__bbp_88.159.216.98_last_posted","1427421207","yes");
INSERT INTO `wp_options` VALUES("96162","_transient__bbp_167.160.116.88_last_posted","1427421458","yes");
INSERT INTO `wp_options` VALUES("96187","_transient__bbp_117.174.192.238_last_posted","1427423640","yes");
INSERT INTO `wp_options` VALUES("96188","_transient__bbp_117.166.236.247_last_posted","1427423650","yes");
INSERT INTO `wp_options` VALUES("96316","_transient__bbp_111.10.144.188_last_posted","1427436250","yes");
INSERT INTO `wp_options` VALUES("96350","_transient__bbp_46.151.53.31_last_posted","1427487029","yes");
INSERT INTO `wp_options` VALUES("96266","_transient__bbp_211.141.130.105_last_posted","1427461820","yes");
INSERT INTO `wp_options` VALUES("96402","_transient__bbp_117.169.1.109_last_posted","1427444235","yes");
INSERT INTO `wp_options` VALUES("96427","_transient__bbp_49.212.220.47_last_posted","1427509184","yes");
INSERT INTO `wp_options` VALUES("96437","_transient__bbp_112.44.88.103_last_posted","1427447448","yes");
INSERT INTO `wp_options` VALUES("96537","_transient__bbp_117.169.1.236_last_posted","1427695487","yes");
INSERT INTO `wp_options` VALUES("96553","_transient__bbp_59.144.8.141_last_posted","1427458910","yes");
INSERT INTO `wp_options` VALUES("96581","_transient__bbp_117.169.1.190_last_posted","1427461421","yes");
INSERT INTO `wp_options` VALUES("96622","_transient__bbp_117.169.1.108_last_posted","1427465267","yes");
INSERT INTO `wp_options` VALUES("96641","_transient__bbp_223.86.120.197_last_posted","1427466944","yes");
INSERT INTO `wp_options` VALUES("96657","_transient__bbp_58.23.19.164_last_posted","1427468351","yes");
INSERT INTO `wp_options` VALUES("96670","_transient__bbp_80.93.24.144_last_posted","1427469674","yes");
INSERT INTO `wp_options` VALUES("96743","_transient__bbp_117.135.250.69_last_posted","1427476858","yes");
INSERT INTO `wp_options` VALUES("96747","_transient__bbp_211.157.180.56_last_posted","1427672545","yes");
INSERT INTO `wp_options` VALUES("96824","_transient__bbp_117.166.4.250_last_posted","1427484288","yes");
INSERT INTO `wp_options` VALUES("96884","_transient__bbp_183.221.162.63_last_posted","1427489980","yes");
INSERT INTO `wp_options` VALUES("96972","_transient__bbp_211.142.197.91_last_posted","1427499027","yes");
INSERT INTO `wp_options` VALUES("97006","_transient__bbp_117.176.244.103_last_posted","1427502336","yes");
INSERT INTO `wp_options` VALUES("97043","_transient__bbp_117.169.1.97_last_posted","1427505865","yes");
INSERT INTO `wp_options` VALUES("97096","_transient__bbp_46.151.53.37_last_posted","1427529687","yes");
INSERT INTO `wp_options` VALUES("97121","_transient__bbp_117.132.14.219_last_posted","1427689554","yes");
INSERT INTO `wp_options` VALUES("97122","_transient__bbp_183.203.208.197_last_posted","1427587392","yes");
INSERT INTO `wp_options` VALUES("97332","_transient__bbp_190.166.56.211_last_posted","1427533478","yes");
INSERT INTO `wp_options` VALUES("97345","_transient__bbp_77.174.132.47_last_posted","1427534577","yes");
INSERT INTO `wp_options` VALUES("97412","_transient__bbp_211.23.248.21_last_posted","1427708545","yes");
INSERT INTO `wp_options` VALUES("97449","_transient__bbp_196.201.218.203_last_posted","1427600160","yes");
INSERT INTO `wp_options` VALUES("97481","_transient__bbp_125.161.83.96_last_posted","1427548442","yes");
INSERT INTO `wp_options` VALUES("97558","_transient__bbp_122.94.164.62_last_posted","1427555646","yes");
INSERT INTO `wp_options` VALUES("97619","_transient__bbp_117.169.1.158_last_posted","1427561630","yes");
INSERT INTO `wp_options` VALUES("97626","_transient__bbp_112.12.151.136_last_posted","1427562309","yes");
INSERT INTO `wp_options` VALUES("97663","_transient__bbp_117.169.1.111_last_posted","1427565981","yes");
INSERT INTO `wp_options` VALUES("97690","_transient__bbp_46.151.53.46_last_posted","1427568096","yes");
INSERT INTO `wp_options` VALUES("97766","_transient__bbp_39.188.84.150_last_posted","1427575487","yes");
INSERT INTO `wp_options` VALUES("97827","_transient__bbp_5.79.68.161_last_posted","1427581523","yes");
INSERT INTO `wp_options` VALUES("97864","_transient__bbp_213.114.232.2_last_posted","1427584966","yes");
INSERT INTO `wp_options` VALUES("97892","_transient__bbp_117.169.1.99_last_posted","1427587565","yes");
INSERT INTO `wp_options` VALUES("97961","_transient__bbp_117.166.74.211_last_posted","1427593965","yes");
INSERT INTO `wp_options` VALUES("98001","_transient__bbp_211.141.130.114_last_posted","1427597662","yes");
INSERT INTO `wp_options` VALUES("98165","_transient__bbp_160.228.152.4_last_posted","1427613544","yes");
INSERT INTO `wp_options` VALUES("98193","_transient__bbp_117.21.192.134_last_posted","1427616205","yes");
INSERT INTO `wp_options` VALUES("98260","_transient__bbp_183.203.208.178_last_posted","1427622780","yes");
INSERT INTO `wp_options` VALUES("98300","_transient__bbp_117.169.1.104_last_posted","1427626864","yes");
INSERT INTO `wp_options` VALUES("98301","_transient__bbp_114.111.167.209_last_posted","1427626889","yes");
INSERT INTO `wp_options` VALUES("98368","_transient__bbp_111.206.1.198_last_posted","1427633492","yes");
INSERT INTO `wp_options` VALUES("98407","_transient__bbp_195.154.189.155_last_posted","1427712726","yes");
INSERT INTO `wp_options` VALUES("98473","_transient__bbp_211.141.130.108_last_posted","1427642859","yes");
INSERT INTO `wp_options` VALUES("98520","_transient__bbp_123.233.147.86_last_posted","1427702025","yes");
INSERT INTO `wp_options` VALUES("98554","_transient__bbp_195.154.188.74_last_posted","1427650437","yes");
INSERT INTO `wp_options` VALUES("98599","_transient__bbp_114.32.254.106_last_posted","1427654231","yes");
INSERT INTO `wp_options` VALUES("98612","_transient__bbp_204.152.202.195_last_posted","1427655290","yes");
INSERT INTO `wp_options` VALUES("98658","_transient__bbp_117.169.1.14_last_posted","1427659872","yes");
INSERT INTO `wp_options` VALUES("98668","_transient__bbp_120.203.149.110_last_posted","1427660630","yes");
INSERT INTO `wp_options` VALUES("98675","_transient__bbp_210.133.103.162_last_posted","1427661357","yes");
INSERT INTO `wp_options` VALUES("98727","_transient__bbp_195.154.211.220_last_posted","1427666336","yes");
INSERT INTO `wp_options` VALUES("98788","_transient__bbp_207.91.10.234_last_posted","1427672567","yes");
INSERT INTO `wp_options` VALUES("98966","_transient__bbp_116.77.128.68_last_posted","1427689423","yes");
INSERT INTO `wp_options` VALUES("99027","_transient__bbp_117.169.1.30_last_posted","1427695566","yes");
INSERT INTO `wp_options` VALUES("99031","_transient__bbp_37.9.184.190_last_posted","1427695703","yes");
INSERT INTO `wp_options` VALUES("99038","_transient__bbp_202.195.161.28_last_posted","1427696348","yes");
INSERT INTO `wp_options` VALUES("99104","_transient__bbp_183.224.99.148_last_posted","1427702408","yes");
INSERT INTO `wp_options` VALUES("117873","_transient_timeout_feed_mod_66a70e9599b658d5cc038e8074597e7c","1429581569","no");
INSERT INTO `wp_options` VALUES("117874","_transient_feed_mod_66a70e9599b658d5cc038e8074597e7c","1429538369","no");
INSERT INTO `wp_options` VALUES("117885","_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51","1429581578","no");
INSERT INTO `wp_options` VALUES("117875","_transient_timeout_feed_1835d2eaaf967b5cddcf4dbccdcaeab9","1429581577","no");
INSERT INTO `wp_options` VALUES("117876","_transient_feed_1835d2eaaf967b5cddcf4dbccdcaeab9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://www.wordpress-fr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"La communauté francophone autour du CMS WordPress et son écosystème\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Apr 2015 07:37:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"La problématique des traductions officielles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/nhFl_mTTaWE/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Mar 2015 08:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7377\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"Merci à WordPress Francophone de m&#8217;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel. Pour la petite histoire, je rédige une seconde version du livre &#171;&#160;Optimiser son référencement WordPress&#160;&#187;, et je suis une nouvelle fois [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6597:\"<p>Merci à WordPress Francophone de m&rsquo;accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel.</p>
<p>Pour la petite histoire, je rédige une seconde version du livre &laquo;&nbsp;Optimiser son référencement WordPress&nbsp;&raquo;, et je suis une nouvelle fois confronté à une problématique de traduction toute simple : doit-on dire &laquo;&nbsp;Plugin&nbsp;&raquo;, &laquo;&nbsp;Plug-in&nbsp;&raquo;, &laquo;&nbsp;Module&nbsp;&raquo; ou &laquo;&nbsp;Extension&nbsp;&raquo; ?</p>
<h2>Quel terme est le plus utilisé ?</h2>
<p>Théoriquement, la seule et unique réponse est &laquo;&nbsp;Extension&nbsp;&raquo;, car c&rsquo;est le terme officiel dans la traduction de WordPress. Dans l&rsquo;administration de votre site, vous avez bien un menu &laquo;&nbsp;Extensions&nbsp;&raquo;, et non pas un menu &laquo;&nbsp;Plugins.</p>
<p>A vrai dire, la première fois que j&rsquo;ai été confronté à ce problème de traduction a été lorsque mon éditeur m&rsquo;a indiqué que je devais parler de &laquo;&nbsp;plug-in&nbsp;&raquo; dans le livre, terme qui est pour eux la traduction officielle pour tout CMS et outil confondu. L&rsquo;utilisation de cette appellation avec un tiret est assez étrange, et la question que je me pose à nouveau est donc assez simple. Doit-on utiliser :</p>
<ul>
<li>le terme officiel de WordPress : Extension ;</li>
<li>le terme le plus souvent utilisé par la communauté : Plugin ;</li>
<li>un autre terme utilisé par une partie de la communauté : Module ;</li>
<li>le terme le plus couramment utilisé par certains éditeurs : Plug-in.</li>
</ul>
<p>Pour y répondre, nous avons fait <a href=\"http://goo.gl/forms/QxdLW0t7IT\">un petit sondage en ligne</a>, et la réponse est sans appel : le terme le plus utilisé de loin est bien &laquo;&nbsp;Plugin&nbsp;&raquo; :</p>
<p><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress.jpg\"><img class=\"aligncenter size-large wp-image-7379\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/traduction-plugin-wordpress-500x268.jpg\" alt=\"Traduction de Plugin ou Extension\" width=\"500\" height=\"268\" /></a></p>
<p>PS : pour avoir les derniers chiffres à jour de l&rsquo;étude, les résultats sont <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewanalytics?usp=form_confirm\">ici</a>.</p>
<h2>Pourquoi une différence entre traduction et usage ?</h2>
<p>Cette différence entre la traduction officielle et l&rsquo;usage le plus courant provient de plusieurs choses :</p>
<ul>
<li>&laquo;&nbsp;Plugin&nbsp;&raquo; est le terme anglais, et une grande partie de la communauté WordPress mondiale parle anglais. Il est donc assez facile et naturel de reprendre le terme anglophone sans le traduire.</li>
<li>De nombreux sites et articles français utilise de manière naturelle le terme &laquo;&nbsp;Plugin&nbsp;&raquo; plutôt que &laquo;&nbsp;Extension&nbsp;&raquo; (moi le premier).</li>
</ul>
<p>C&rsquo;est assez marrant d&rsquo;ailleurs de voir des pratiques complètement différentes en fonction des sites ou livres. Par exemple :</p>
<ul>
<li>Le livre &laquo;&nbsp;<em>WordPress 3 pour un blogueur efficace</em>&nbsp;&raquo; et les sites WordPress Francophone et FxBénard utilisent bien le terme officiel &laquo;&nbsp;Extension&nbsp;&raquo; ;</li>
<li>Le livre &laquo;&nbsp;<em>Optimiser son référencement WordPress</em>&nbsp;&raquo; est le seul à utiliser &laquo;&nbsp;Plug-in&nbsp;&raquo; ;</li>
<li>Les sites Geekpress, WPChannel, WPMarmite, WPRocket, BoiteAWeb, SeoMix, Wabeo ou encore ScreenFeed utilisent &laquo;&nbsp;Plugin&nbsp;&raquo;.</li>
</ul>
<p>On se retrouve donc avec des sites et ouvrages communautaires utilisant des termes différents pour désigner une seule et même chose.</p>
<h2>Doit-on changer nos pratiques ?</h2>
<p>Cet article a un but simple et j&rsquo;aimerais avoir les avis de toute la communauté : doit-on modifier une traduction officielle ou pas ?</p>
<p>La logique de base voudrait que l&rsquo;on change le terme par celui le plus utilisé par chacun. Nous n&rsquo;aurions alors qu&rsquo;un seul terme pour désigner cet aspect de WordPress, rendant ainsi plus explicite pour tous l&rsquo;administration du CMS ou encore la lecture d&rsquo;articles et de tutoriels.</p>
<p>Le hic, c&rsquo;est que si jamais on modifiait cette traduction, on se retrouverait confronté à un énorme problème d&rsquo;ergonomie : lors du changement, un certains nombre d&rsquo;utilisateurs risqueraient d&rsquo;être perdus puisque le terme a changé dans l&rsquo;interface d&rsquo;administration. Pire encore, d&rsquo;autres plugins et thèmes pouvaient récupérer la valeur de la traduction de cette chaîne pour l&rsquo;utiliser ailleurs, ce qui lors du changement pourrait provoquer certaines incohérences.</p>
<p>L&rsquo;autre solution, c&rsquo;est de nous forcer nous à changer nos appellations. Chaque membre de la communauté devrait alors remplacer de manière systématique sa manière de nommer les &laquo;&nbsp;modules&nbsp;&raquo; de WordPress. Mais vient alors ma vision de consultant en référencement naturel : pourquoi appeler un élément &laquo;&nbsp;Extension&nbsp;&raquo; si une plus grande majorité de personnes utilise un autre terme lors de ses recherches sur le web&#8230;</p>
<p>Je reste donc assez mitigé sur le sujet. Et vous, quel est votre avis ?</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=HP8wb-DawIU:ldwY5DxtbyI:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/HP8wb-DawIU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/nhFl_mTTaWE\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"38\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:65:\"http://www.wordpress-fr.net/2015/03/25/problematique-traductions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/KJsEy-lwkw0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Mar 2015 06:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7406\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"WordPress 4.2 beta 2 La 2e beta de WordPress 4.2 (en) est disponible pour les tests. Des nouvelles de l&#8217;équipe de traduction Le WordCamp London a été l&#8217;occasion de parler de la traduction. Avec notamment l&#8217;arrivée d&#8217;une version française de Belgique (en). Nouvelle gestion des équipes de traduction (en). Le guide de la maintenance WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3044:\"<h3>WordPress 4.2 beta 2</h3>
<p>La<a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-2/\"> 2e beta de WordPress 4.2</a> (en) est disponible pour les tests.</p>
<h3>Des nouvelles de l&rsquo;équipe de traduction</h3>
<ul>
<li>Le WordCamp London a été l&rsquo;occasion de parler de la traduction. Avec notamment l&rsquo;arrivée d&rsquo;une <a href=\"https://make.wordpress.org/polyglots/2015/03/20/polyglots-team-wordcamp-london-contributor-day\">version française de Belgique (en)</a>.</li>
<li><a href=\"https://make.wordpress.org/polyglots/2015/03/19/per-project-permissions-for-translation-editors-previously-validators\">Nouvelle gestion des équipes de traduction (en)</a>.</li>
</ul>
<h3>Le guide de la maintenance WordPress</h3>
<p>MaintPress propose <a href=\"http://www.maintpress.com/blog/maintenance-wordpress-guide/\">un guide de la maintenance avec WordPress</a>.</p>
<h3>Des failles dans WPML</h3>
<p>L&rsquo;<a href=\"http://www.zdnet.fr/actualites/plugin-wpml-400000-sites-exposes-a-des-failles-sur-wordpress-39816484.htm\">extension WPML a été exposée à des failles de sécurité importantes</a>. Réactive, l&rsquo;équipe de développement a publié une version qui corrige les problèmes.</p>
<h3>Pourquoi une agence a abandonné WordPress ?</h3>
<p>Un retour de Thierry sur une <a href=\"http://www.wp-pro.fr/pourquoi-une-agence-a-abandonne-wordpress/\">mauvaise expérience avec WordPress</a>.</p>
<h3>Le syndrome du sapin de Noël</h3>
<p>Un article qui m&rsquo;a fait plaisir et que je ne saurai que trop recommander ! <a href=\"http://wpmarmite.com/syndrome-sapin-de-noel/\">Le syndrôme Sapin de Noël </a>vous connaissez ? un site qui brille de 1000 feux n&rsquo;est pas toujours une bonne chose, lisez cet article vous verrez !</p>
<h3>10 conseils pour sécuriser son site WordPress</h3>
<p>Le JDN propose <a href=\"http://www.journaldunet.com/solutions/dsi/securiser-son-wordpress/\">10 conseils de sécurité</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=9nrX3qezB3Y:ko9TM8Tx8sU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/9nrX3qezB3Y\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/KJsEy-lwkw0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:94:\"http://www.wordpress-fr.net/2015/03/24/lhebdo-wordpress-n256-wordpress-4-2-traduction-astuces/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/9nrX3qezB3Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/Nxk3eqWFjXU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Mar 2015 06:38:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"WPMX Day 2015 Le 6 juin prochain se tiendra le WPMX Day&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&#8217;ores et déjà en vente ! C&#8217;est le lendemain du WordCamp Lyon : le mois de juin sera formidable en termes de contenus et propagation d&#8217;idées au sein de la communauté [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3658:\"<h3>WPMX Day 2015</h3>
<p><a href=\"http://2015.wpmx.org/\">Le 6 juin prochain se tiendra le WPMX Day</a>&#8230; Un grand événement WordPress qui aura lieu à Biarritz. Les billets sont d&rsquo;ores et déjà en vente !<br />
C&rsquo;est le lendemain du <a href=\"http://lyon.wordcamp.org/2015/\">WordCamp Lyon</a> : le mois de juin sera formidable en termes de contenus et propagation d&rsquo;idées au sein de la communauté WordPress de France !</p>
<h3>WordPress 4.2 beta 1</h3>
<p><a href=\"http://wptavern.com/wordpress-4-2-beta-1-now-available-for-testing\">La première beta de WordPress 4.2 est disponible</a>. Il est rappelé qu&rsquo;il s&rsquo;agit d&rsquo;une <a href=\"https://wordpress.org/news/2015/03/wordpress-4-2-beta-1/\">version de développement</a>. On fait attention donc !!</p>
<h3>bbPress 2.5.5 est disponible</h3>
<p><a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-5-security-release/\">L&rsquo;outil de forum bbPress 2.5.5</a> (en) est disponible au téléchargement. C&rsquo;est une version de sécurité : mettez à jour !<br />
&#8230;et depuis hier soir, c&rsquo;est <a href=\"https://bbpress.org/blog/2015/03/bbpress-2-5-6-maintenance-release/\">la version 2.5.6 qui est disponible</a>, qui est une version de maintenance corrigeant un bug côté notifications.</p>
<h3>Une mise à jour automatique des extensions</h3>
<p><a href=\"https://make.wordpress.org/plugins/2015/03/14/plugin-automatic-security-updates/\">Une mise à jour automatique des extensions</a> (en) pour raison de sécurité est mise en place pour les versions supérieures ou égales à WordPress 3.7.</p>
<h3>Optimiser la taille des images</h3>
<p>Une extension qui permet d&rsquo;optimiser les images ? <a href=\"http://philippe.scoffoni.net/optimiser-taille-images-site-web-tynipng-wordpress/\">Oui ça existe</a> !</p>
<h3>Vulnérabilité dans WooCommerce</h3>
<p><a href=\"http://www.wordfence.com/blog/2015/03/woocommerce-sql-injection-vulnerability/\">Une vulnérabilité a été découverte dans WooCommerce</a> (en) par l&rsquo;équipe de WordFence. L&rsquo;équipe de Woo a rapidement réagit pour colmater la brèche.</p>
<h3>Une extension WordPress est-elle une startup ?</h3>
<p>Voici l&rsquo;<a href=\"http://wptavern.com/is-a-wordpress-plugin-a-startup\">histoire de Peter Suhm </a>et de son extension&#8230; (en).</p>
<h3>Le guide pour débutant pour héberger un site</h3>
<p>WP Marmite propose un <a href=\"http://wpmarmite.com/hebergement-wordpress/\">guide pour les débutants qui veulent se lancer dans l&rsquo;hébergement</a> de leur site WordPress.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=GMhxpMYAvwU:7Q0l6THM5gk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/GMhxpMYAvwU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/Nxk3eqWFjXU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:105:\"http://www.wordpress-fr.net/2015/03/17/lhebdo-wordpress-n255-wpmx-day-wordpress-4-2-beta-1-bbpress-2-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/GMhxpMYAvwU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°254 : Le guide des communautés – Astuces – Répertoires\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/odATT589tL4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Mar 2015 06:39:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Astuces\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Thèmes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"Un guide des communautés WordPress Tom Zsomborgi et son équipe de Kinsta viennent de publier un guide des communautés WordPress à travers le monde. Personnaliser votre page de login Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : PWD WP Login (en). Les hooks des menus de navigation Pour [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3638:\"<h3>Un guide des communautés WordPress</h3>
<p>Tom Zsomborgi et son équipe de Kinsta viennent de publier un <a href=\"https://kinsta.com/learn/wordpress-communities-around-the-world/\">guide des communautés WordPress</a> à travers le monde.</p>
<h3>Personnaliser votre page de login</h3>
<p>Cette extension est faite pour vous, si vous souhaitez personnaliser votre page de connexion : <a href=\"https://wordpress.org/plugins/pwd-wp-login/\">PWD WP Login (en)</a>.</p>
<h3>Les hooks des menus de navigation</h3>
<p><a href=\"http://wabeo.fr/hook-nav-menus/\">Pour personnaliser les menus par des hooks</a>, c&rsquo;est simple ! Suivez le guide.</p>
<h3>Supprimer le slug d&rsquo;une taxonomie</h3>
<p>Aurélien explique comment<a href=\"http://wpchannel.com/supprimer-slug-taxonomie-wordpress/\"> supprimer le slug d&rsquo;une taxonomie</a>.</p>
<h3>Proposer votre ville pour le WordCamp Europe 2016</h3>
<p>WordCamp Europe lance son appel à candidature pour héberger l’événement 2016. <a href=\"http://europe.wordcamp.org/2015/apply-to-host-wordcamp-europe-2016-wceu/\">Proposez votre ville (en)</a> !</p>
<h3>Un nouveau répertoire de thèmes et d&rsquo;extensions</h3>
<p>Les répertoires de <a href=\"http://wptavern.com/wordpress-theme-directory-launches-new-design\">thèmes </a>et d&rsquo;<a href=\"http://wptavern.com/wordpress-plugin-directory-launches-new-design\">extensions </a>officiels ont été refondus. (en)</p>
<h3>Et si on écrivait un livre sur WordPress</h3>
<p>C&rsquo;est l&rsquo;idée de Siobhan McKeown&#8230; <a href=\"https://github.com/WordPress/book\">et c&rsquo;est sur Github</a>.</p>
<h3>8 erreurs à ne pas commettre lors de la mise en ligne d&rsquo;un site</h3>
<p><a href=\"http://www.wp-pro.fr/les-8-gaffes-a-ne-pas-commettre-lors-de-la-mise-en-ligne-dun-site-wordpress/\">Émilie indique les 8 erreurs</a> à ne pas commettre lors de la mise en ligne d&rsquo;un site WordPress.</p>
<h3>MadmoiZelle recrute !</h3>
<p><em>La passion du code t’anime jour et nuit, depuis ton plus jeune âge</em>&#8230; <a href=\"http://www.madmoizelle.com/madmoizelle-lead-developpeuse-eur-wordpress-322219\">alors postule</a> !</p>
<h3>Le guide gratuit pour pas se faire avoir sur themeforest</h3>
<p>WP Marmite lance le guide<a href=\"http://wpmarmite.com/guide-themeforest/\"> pour utiliser Themeforest</a>.</p>
<h3>Les failles de la semaine</h3>
<p>WP Serveur donne <a href=\"https://www.wpserveur.net/failles-de-securite-wordpress-semaine-11/\">quelques failles de la semaine</a>&#8230; attention donc !</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=yUEEJn9_3ak:bNjq33L-Hzk:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/yUEEJn9_3ak\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/odATT589tL4\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/03/10/lhebdo-wordpress-n254-le-guide-des-communautes-astuces-repertoires/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/yUEEJn9_3ak/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"L’Hebdo WordPress n°253 : WordPress 4.1.1 – WordPress 4.2 – Les communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/TbIvObIyepg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Feb 2015 06:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"communauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7388\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"WordPress Francophone : Le changement arrive Si vous l&#8217;avez raté, voici ce qu&#8217;il faut retenir de nos projets immédiats concernant l&#8217;association. WordPress 4.1.1 Cette semaine, la première version mineure de WordPress 4.1 est sortie. Cette 4.1.1 apporte nombre de corrections de bugs (en). Mettez à jour, si vous n&#8217;utilisez pas la mise à jour automatique. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3888:\"<h3>WordPress Francophone : Le changement arrive</h3>
<p>Si vous l&rsquo;avez raté, voici ce qu&rsquo;il faut retenir de <a title=\"L’association WordPress-Francophone : d’où elle vient et où elle va\" href=\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\">nos projets immédiats concernant l&rsquo;association</a>.</p>
<h3>WordPress 4.1.1</h3>
<p>Cette semaine, la première version mineure de WordPress 4.1 est sortie. <a href=\"https://wordpress.org/news/2015/02/wordpress-4-1-1/\">Cette 4.1.1 apporte nombre de corrections de bugs</a> (en). Mettez à jour, si vous n&rsquo;utilisez pas la mise à jour automatique.</p>
<h3>WordPress 4.2 : c&rsquo;est pour bientôt !</h3>
<p>La deadline pour WordPress 4.2 est <a href=\"https://make.wordpress.org/core/2015/02/22/4-2-enhancements-deadline-is-march-10th/http://\">fixée au 10 mars prochain</a> (en).</p>
<h3>Sondage BuddyPress 2015</h3>
<p>Si ce n&rsquo;est déjà fait, répondez à l&rsquo;<a href=\"http://mercime.polldaddy.com/s/2015-buddypress-survey\">enquête 2015 sur BuddyPress</a> (en).</p>
<h3>Les communautés locales en action</h3>
<ul>
<li><a href=\"https://www.facebook.com/events/1729936210565573/?ref=3&amp;ref_newsfeed_story_type=regular\">Meetup Languedoc : Aujourd&rsquo;hui, 24 février à 19 H 00</a></li>
<li><a href=\"http://www.wpinalps.com/#prochaine-rencontre\">WP in Alps : rencontre le 17 mars</a></li>
<li><a href=\"https://medium.com/@quakely/wordcamp-paris-15-310657f1688e\">WordCamp PAris 2015 : review</a> (en)</li>
</ul>
<h3>Beaver Builder 1.4.6 en français</h3>
<p>L&rsquo;annonce a été faite cette semaine sur Twitter, Beaver Builder est enfin disponible en français :</p>
<blockquote class=\"twitter-tweet\" width=\"550\"><p><a href=\"https://twitter.com/Web18_Paris\">@Web18_Paris</a> <a href=\"https://twitter.com/FrederiqueGame\">@FrederiqueGame</a> <a href=\"https://twitter.com/WordCampParis\">@WordCampParis</a> We just added a French translation in our latest update (1.4.6)!</p>
<p>&mdash; Beaver Builder (@BeaverBuilder) <a href=\"https://twitter.com/BeaverBuilder/status/567431867519860736\">February 16, 2015</a></p></blockquote>
<p><script async src=\"//platform.twitter.com/widgets.js\" charset=\"utf-8\"></script></p>
<h3>Hexagone.io</h3>
<p><a href=\"https://hexagone.io/\">Une nouvelle plateforme de thèmes 100% française</a>.</p>
<h3>Comment trouver et choisir un thème</h3>
<p><a href=\"http://www.maintpress.com/blog/themes-wordpress-comment-trouver-et-choisir-votre-theme-wordpress/\">Voici des pistes de recherches et de sélection de thème</a> selon MaintPress.</p>
<h3>WP Serveur : le test</h3>
<p>Daniel Roch a <a href=\"http://www.seomix.fr/wp-serveur/\">testé pour vous le nouveau service d&rsquo;hébergement</a> de Fabrice : WP Serveur.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=g7fUMHJTdiA:Ma825OCvrww:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/g7fUMHJTdiA\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/TbIvObIyepg\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/24/lhebdo-wordpress-n253-wordpress-4-1-1-wordpress-4-2-les-communautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/g7fUMHJTdiA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"L’association WordPress-Francophone : d’où elle vient et où elle va\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/A_tvnBn7-wc/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Feb 2015 12:47:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Barcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7370\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Nombre d&#8217;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&#8217;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&#8217;un pendant francophone à WordPress.org (forum d&#8217;entraide, traduction, nouvelles, vitrine, Planet, etc.). L&#8217;association a été déclarée le [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Xavier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9052:\"<p>Nombre d&rsquo;entre vous ne le savent pas, mais le site WordPress-fr.net est géré par l&rsquo;Association des Utilisateurs Francophones de WordPress, ou WordPress-Francophone pour faire plus court (voire WPFR), association à but non lucratif (loi 1901) créée pour disposer d&rsquo;un pendant francophone à WordPress.org (forum d&rsquo;entraide, traduction, nouvelles, vitrine, Planet, etc.).</p>
<p>L&rsquo;association a été déclarée le 9 juillet 2008 (bientôt 7 ans !), plus de trois ans après le lancement du site lui-même (dont le nom de domaine date du 25 août 2005 &#8212; bientôt 10 ans !), avec l&rsquo;objet suivant :</p>
<blockquote><p>&laquo;&nbsp;promouvoir, directement ou indirectement, le système de publication de contenu WordPress et sa version multiutilisateurs WordPress Mu ; l’association souhaite devenir l’interlocuteur privilégié des utilisateurs particuliers ou professionnels en offrant une représentation francophone de WordPress.&nbsp;&raquo;</p></blockquote>
<div id=\"attachment_7371\" style=\"width: 310px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7371 size-full\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/wpfr-asso-300x127.jpg\" alt=\"wpfr-asso-300x127\" width=\"300\" height=\"127\" /><p class=\"wp-caption-text\">Extrait du Journal Officiel du 26 juillet 2008.</p></div>
<p>Dans les faits, l&rsquo;association sert avant tout de façade légale pour le site et son forum, mais également de moyen de financer les barcamps que nous organisons à Paris (<a href=\"http://barcamp.org/w/page/405589/WordCampParis\">à l&rsquo;époque appelés WordCamp</a>) sans devoir passer par une société qui facturerait ces sponsoring. Ainsi, de la même manière que l&rsquo;association <a href=\"http://www.paris-web.fr/\">Paris-Web</a> est un regroupement des personnes qui organisent l&rsquo;évènement Paris Web (sans adhérents autres que les organisateurs), l&rsquo;association WPFR est un regroupement des personnes qui s&rsquo;occupent du site WPFR, de la traduction française de WordPress, et du WordCamp Paris.</p>
<p>Rapidement, nous avons su que nous ne devions pas limiter l&rsquo;association aux seuls membres fondateurs, et nous nous sommes lancés dans un travail de réécriture des statuts de l&rsquo;association, en s&rsquo;inspirant de ceux des autres associations en place : <a href=\"http://afup.org/pages/site/?route=vie-associative-afup/1/statuts-de-l-association-francaise-des-utilisateurs-de-php\">AFUP</a>, <a href=\"http://drupalfr.org/sites/default/files/Statuts-DrupalFF-2012.pdf\">Drupal FR</a>, <a href=\"http://wiki.postgresql.fr/asso:statuts\">PostgrSQLFR</a> et d&rsquo;autres déjà en place. Ce chantier est en discussion interne depuis plusieurs année, et le travail de rédaction est en place depuis avril 2012 (bientôt 3 ans !).</p>
<div id=\"attachment_7372\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-7372 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/CaptureWPFRStatusWiki-500x327.png\" alt=\"CaptureWPFRStatusWiki\" width=\"500\" height=\"327\" /><p class=\"wp-caption-text\">Historique du wiki interne de WPFR pour les statuts (manque le règlement intérieur)</p></div>
<p>Le rythme était, pourrait-on dire, tectonique : nous y consacrions du temps&#8230; quand nous en avions. À savoir qu&rsquo;une fois le WordCamp devenu une conférence importante, cet évènement nous prenait le plus gros de notre temps libre consacré à WPFR, avec déjà la gestion du forum et des mails, les hebdos, les traductions, etc. Ajoutons à cela que je (Xavier) suis également co-organisateur de Paris Web, les années passaient vite, et Benoît était le plus dur à la tâche (mercis infinis à lui pour son dévouement inlassable à cette tâche !) &#8212; mais cela restait une tâche réalisée en interne, et pour les observateurs de l&rsquo;écosystème WordPress français, WPFR renvoyait l&rsquo;image d&rsquo;une association figée dans le temps (la v3 du site, Arlésienne s&rsquo;il en est, n&rsquo;a fait qu&rsquo;être repoussée malgré les efforts, au point qu&rsquo;une v4 rapide a failli être mise en place en août 2013, en vain &#8212; merci quand même Amaury !), là où nous voulions depuis des années nous ouvrir aux bonnes volontés.</p>
<p>Les WordCamp Paris et Europe ont été des catalyseurs importants. En mettant en avant des experts venus de toute la France, ou en faisant voyager ensemble des passionnés français lors de la grande réunion européenne, ces deux évènements (et leurs éditions 2013 et 2014) ont permis aux discussions de se lancer entre passionnés, et de faire remonter leurs attentes vis à vis de l&rsquo;association, ou même de monter leur propre association. Ravivée à chaque évènement, la flamme passionnée de ces professionnels attendait depuis trop longtemps une ouverture de l&rsquo;association. Et du côté du staff WPFR, à chaque WordCamp Paris, on se promettait de terminer et présenter ces nouveaux statuts. Lors de l’édition 2015, nous avons même prévu des fiches d’inscription pour les intéressés – et vous étiez nombreux !</p>
<p>Tout cela s&rsquo;est donc cristallisé lors du WordCamp Paris 2015, où la plupart des intéressés se sont retrouvés (soit au sein du staff, soit en orateurs) et ont pu échanger directement avec les membres actuels de l&rsquo;association (Benjamin, Benoît, Thierry et moi-même &#8212; Marie-Aude, vivant au Maroc, n&rsquo;a pas pu faire le déplacement). De critiques frontales à discussions ouvertes, nous avons compris qu&rsquo;il y avait un lourd passif d&rsquo;incompréhension entre ce que le staff voulait faire et la manière dont il était perçu, et qu&rsquo;il était urgent de corriger cela pour le bien de la communauté.</p>
<div id=\"attachment_7373\" style=\"width: 510px\" class=\"wp-caption aligncenter\"><a href=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57.jpg\"><img class=\"wp-image-7373 size-large\" src=\"http://www.wordpress-fr.net/wp-content/uploads/2015/02/B8ETwTmIgAAp-57-500x281.jpg\" alt=\"\" width=\"500\" height=\"281\" /></a><p class=\"wp-caption-text\">Lors de la soirée du WordCamp Paris 2015, là où les discussions sur le sujet de l&rsquo;association ont duré plusieurs heures. Photo par Daniel Roch.</p></div>
<p>Nous avons convenu de travailler ensemble à terminer les statuts de la meilleure manière qui soit. Sur un site P2 privé sur WordPress.com, nous avons fait de belles progressions grâce à la participation de passionnés hors association (Alexandre, Amaury, Aurélien, Daniel, Émilie, Olivier, Frédéric, Grégoire, Jenny, Julien, Julio, et Maxime), et le résultat de ces échanges sera bientôt appliqué.</p>
<p>Afin d&rsquo;entamer cette ouverture de l&rsquo;association, voici la &laquo;&nbsp;roadmap&nbsp;&raquo; que nous nous sommes fixés pour réviser le fonctionnement de WPFR :</p>
<ul>
<li>15 février : finalisation des statuts de l’association.</li>
<li>15 mars : dépôt et publication des nouveaux statuts.</li>
<li>15 avril : communication à la communauté pour les inscriptions (ouverture aux adhérents, professionnels comme amateurs).</li>
<li>15 mai : organisation d’une AGE fondatrice avec le vote et l’élaboration du Bureau, du Conseil d&rsquo;Administration et du Conseil de Surveillance.</li>
</ul>
<p>Une fois le nouveau bureau en place, de nombreux projets seront lancés grâce à cette apport de bonnes volontés, pour le bien de toute la communauté &#8212; et plus que le WordCamp ! Parmi ceux-ci, la refonte du site tant attendant sera lancée (probablement même avant l&rsquo;arrivée du nouveau bureau) afin de renvoyer une image plus professionnelle et communautaire de notre association francophone.</p>
<p>Vous êtes intéressé(e) par l’évolution de l’association et ses futurs statuts ? <a title=\"Contact\" href=\"http://www.wordpress-fr.net/contact/\">Contactez-nous</a> !</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BHlyW5QMwoY:hraS_rnTJ24:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BHlyW5QMwoY\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/A_tvnBn7-wc\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"26\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.wordpress-fr.net/2015/02/13/lassociation-wordpress-francophone-dou-elle-vient-et-ou-elle-va/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BHlyW5QMwoY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"
		
		
		
		
		
				
		
		
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"L’Hebdo WordPress n°252 : WordCamp Lyon – Traduction – BuddyPress 2.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/d4xirCr8u6U/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Feb 2015 06:26:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:8:\"wordcamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7365\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"WordCamp Lyon : c&#8217;est officiel ! C&#8217;est officiel, le 2e WordCamp français du nom sera Lyonnais, il est programmé le 5 juin et les premiers billets sont déjà en vente ! Sondage sur la traduction Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&#8217;est [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4899:\"<h3>WordCamp Lyon : c&rsquo;est officiel !</h3>
<p>C&rsquo;est officiel, le<a href=\"http://lyon.wordcamp.org/2015/\"> 2e WordCamp français du nom sera Lyonnais</a>, il est programmé le 5 juin et les premiers billets sont déjà en vente !</p>
<h3>Sondage sur la traduction</h3>
<p>Daniel Roch se pose une question parmi les plus importantes&#8230; et même si la traduction officielle existe déjà, elle n&rsquo;est pas encore toujours utilisée partout. Et vous quel est votre avis sur la <a href=\"https://docs.google.com/forms/d/1NC6jUscKtuYXBaeFS6pmzjw-TpbI7RZzPqcfHVflBS0/viewform?c=0&amp;w=1\">question </a>?</p>
<h3>WordCamp Paris 2015 : d&rsquo;autres retours</h3>
<ul>
<li><a href=\"http://www.seomix.fr/organiser-un-evenement-wordpress/\">La conférence de Daniel Roch</a></li>
<li><a href=\"http://2015.extend.xiligroup.org/fr/107/wordcamp-paris-2015-quelques-notes/\">Les notes de Michel</a></li>
</ul>
<h3>WordPress 4.2 sera Emoji</h3>
<p>WordPress 4.2 sera le <a href=\"https://make.wordpress.org/core/2015/02/09/emoji-feature-plugin-for-4-2/\">WordPress des Emoji</a> (en) !</p>
<h3>BuddyPress 2.2 : Spumoni</h3>
<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\">BuddyPress 2.2</a> (en) est disponible depuis moins d&rsquo;une semaine, vous pouvez mettre à jour !</p>
<h3>Sécurité WordPress : les extensions pour éviter le pire</h3>
<p>Nicolas Birckel, orateur lors du dernier WordCamp Paris <a href=\"http://www.nicolas-birckel.fr/2015/02/04/securite-wordpress-quels-plugins-pour-anticiper-le-pire/\">nous parle de sécurité et d&rsquo;extensions</a>.</p>
<h3>You are awesome</h3>
<p>J&rsquo;ai retrouvé dans mes marque-pages, un lien que j&rsquo;ai du oublier de publier il y quelques semaines. Il s&rsquo;agit d&rsquo;un article de <a href=\"http://chrislema.com/you-are-awesome-thanks/\">Chris Lema qui remercie une partie de la communauté WordPress</a> (en) qui lui est chère.</p>
<h3>Une favicon facile ?</h3>
<p><a href=\"https://wordpress.org/plugins/pwd-wp-favicon/\">PWD WP Favicon</a> est une extension qui permet d&rsquo;avoir une favicon sur son site WordPress très simplement.</p>
<h3>La réussite de WP Rocket en chiffre</h3>
<p>WP Rocket, le <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\">succès </a>de notre French Team <a href=\"http://blog.wp-rocket.me/transparency-matters/\">expliqué en quelques chiffres</a> (en).</p>
<h3>Human Made acquiert Sennza</h3>
<p>Human Made <a href=\"http://wptavern.com/human-made-acquires-australian-based-wordpress-agency-sennza\">vient d&rsquo;acquérir l&rsquo;australien Sennza</a> (en).</p>
<h3>L&rsquo;extension Fancybox cible d&rsquo;une faille Zero-day</h3>
<p><a href=\"http://www.undernews.fr/alertes-securite/vulnerabilite-zero-day-plugin-wordpress-fancybox-for-wordpress.html\">L&rsquo;extension Fancybox s&rsquo;est vu entachée cette semaine d&rsquo;une faille de sécurité </a>grave de type zero-day. Une correction a depuis été apportée.</p>
<h3>Mise à jour du WordPress Reference</h3>
<p>Le fameux guide <a href=\"https://www.dbswebsite.com/design/wordpress-reference/V4/\">WordPress Reference</a> (en) vient de subir une mise à jour.</p>
<h3>Le magazine Programmez! parle WordPress</h3>
<p>Le magazine &laquo;&nbsp;Programmez!&nbsp;&raquo; à paraitre propose quelques pages consacrées à WordPress. Au programme des <a href=\"http://www.programmez.com/magazine/article/tests-unitaires-et-integration-continue-de-projets-wordpress\">tests unitaires </a>et de la<a href=\"http://www.programmez.com/magazine/article/creer-des-plugins-et-des-widgets-pour-wordpress\"> création d&rsquo;extensions</a>.</p>
<p>&nbsp;</p>
<p><em><strong>// Restez connectés&#8230; bientôt une grande annonce de l&rsquo;association WordPress Francophone !</strong></em></p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=TaQkF2Q_zkU:e7aDOxYsXRE:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/TaQkF2Q_zkU\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/d4xirCr8u6U\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:101:\"http://www.wordpress-fr.net/2015/02/10/lhebdo-wordpress-n252-wordcamp-lyon-traduction-buddypress-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/TaQkF2Q_zkU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:54:\"
		
		
		
		
		
				
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"L’Hebdo WordPress n°251 : WordCamp Paris – WP Valence – Collectif WP Suisse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/FwIaDMiQ8vo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Feb 2015 06:43:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"Développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Commnauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:13:\"WordPress 4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7355\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordCamp Paris 2015 : c&#8217;était il y a 10 jours ! Cela fait déjà 10 jours que les portes du WordCamp Paris ce sont refermées. Mais vous êtes nombreux à en parler encore : Maxime BJ de WP-Spread Les photos d&#8217;Adrian WP Marmite Les 5 conférences préférées de Nicolas Birckel Un instantanée Planet Hoster... et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5443:\"<h3>WordCamp Paris 2015 : c&rsquo;était il y a 10 jours !</h3>
<p>Cela fait déjà 10 jours que les portes du <a href=\"http://2015.paris.wordcamp.org/le-wordcamp-paris-2015-a-ferme-ses-portes-rendez-vous-en-2016/\">WordCamp Paris ce sont refermées</a>. Mais vous êtes nombreux à en parler encore :</p>
<ul>
<li><a href=\"http://www.wp-spread.com/compte-rendu-wordcamp-2015\">Maxime BJ de WP-Spread</a></li>
<li><a href=\"https://www.icloud.com/photostream/fr-fr/#A3GgZLKuGjtl7D\">Les photos d&rsquo;Adrian</a></li>
<li><a href=\"http://wpmarmite.com/wordcamp-paris-2015/\">WP Marmite</a></li>
<li><a href=\"http://www.nicolas-birckel.fr/2015/01/26/les-5-conferences-que-jai-apprecie-a-wordcamp-paris-2015/\">Les 5 conférences préférées de Nicolas Birckel </a></li>
<li><a href=\"http://instagram.com/p/yUbRnzRn29/\">Un instantanée</a></li>
<li><a href=\"http://blog.planethoster.net/wordcamp-paris-retour-un-succes/\">Planet Hoster.</a>.. et ses chocolats pour caler les meubles ou aussi pour manger ! ^^&rsquo;</li>
</ul>
<p>&#8230; et quelques conférences :</p>
<ul>
<li><a href=\"http://www.frederiquegame.fr/presentation-de-ma-conference-au-wordpress-camp-paris/\">Frédérique Game</a></li>
<li><a href=\"http://boiteaweb.fr/traduction-wordpress-vous-faites-fausse-route-8518.html\">Julio Potier</a></li>
<li><a href=\"http://fr.slideshare.net/SeoMix/organiser-un-vnement-wordpress-wordcamp-paris-2015\">Daniel Roch</a></li>
<li><a href=\"http://tweetpressfr.github.io/blog/wcparis-2015/#/\">Julien Maury</a></li>
<li><a href=\"http://t.co/h3bo7ByTqy\">Aurélien Denis</a></li>
<li>&#8230; les autres seront bientôt toutes en ligne sur le site du WordCamp et en vidéo bientôt sur wordpress.tv.</li>
</ul>
<p>En attendant, le prochain événement qui compte dans la communauté se déroule ce soir :</p>
<h3>Premier meetup Valence</h3>
<p>La communauté WordPress de Valence organise son <a href=\"www.wp-spread.com/demain-cest-le-premier-meetup-valence\">premier meetup ce soir.</a> Toutes les informations sont sur le <a href=\"http://wpvalence.fr/\">site officiel.</a></p>
<h3>WordPress Suisse</h3>
<p><a href=\"http://collectifwp.ch/\">Un collectif WordPress Suisse</a> a vu le jour en ligne quelques jours avant le WordCamp Paris. Ce groupe est emmené par Patricia, Manuel, Gilles et d&rsquo;autres&#8230; bienvenue !</p>
<h3>WordPress 4.2 est lancé</h3>
<p>WordPress 4.2 a son lead dev : <a href=\"https://make.wordpress.org/core/2015/01/21/drew-jaynes-is-the-4-2-release-lead/\">Drew Jaynes (en).</a>.. et aussi une première ligne de conduite, <a href=\"https://make.wordpress.org/core/2015/01/31/improving-mobile-flow-in-4-2/\">à savoir le mobile</a> (en)&#8230; et aussi le <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-theme-switcher-update/\">personnaliseur de thèmes</a> (en).</p>
<h3>Un nouveau service d&rsquo;hébergement français</h3>
<p>WP-Serveur en termine avec sa période beta pour s&rsquo;ouvrir à la clientèle dès le 9 février 2015. Vous pouvez d&rsquo;ores et déjà <a href=\"https://www.wpserveur.net/\">découvrir les offres et les services sur le site web</a>.</p>
<h3>Quelques sites références WP selon une bloggeuse</h3>
<p><a href=\"http://yesweblog.fr/2015/01/les-sites-references-pour-apprendre-sur-wordpress/\">Quelques avis de bloggeuse</a> sur WordPress&#8230;</p>
<h3>Par Toutatis, un nouveau thème</h3>
<p>Un nouveau thème gratuit et français en plus&#8230; <a href=\"https://www.themesdefrance.fr/theme-wordpress-gratuit-toutatis/\">Toutatis est à découvrir ici</a>.</p>
<h3>Google Analytics et WordPress</h3>
<p>MaintPress explique <a href=\"http://www.maintpress.com/blog/google-analytics-wordpress-tirez-maximum-outil-puissant/\">comment utiliser Google Analytics</a> avec WordPress.</p>
<h3>12 extensions Chrome pour WordPress</h3>
<p>Si vous utilisez Chrome comme navigateur, <a href=\"http://torquemag.io/12-google-chrome-browser-extensions-wordpress-users/\">voici des extensions pour vous</a>. (en)</p>
<h3>Interview de Quentin Ravinet</h3>
<p>WP Marmite <a href=\"http://wpmarmite.com/interview-quentin-ravinet/\">interviewe Quentin Ravinet</a>, développeur de thème s&rsquo;est lancé dans l&rsquo;aventure Themeforest.</p>
<h3>Qu&rsquo;est-ce qu&rsquo;une barre latérale ?</h3>
<p><a href=\"http://wpmarmite.com/sidebar-wordpress/\">WP Marmite vous dit tout </a>!</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=vXxg-7UMZ2c:VIsMNlXhRZ4:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/vXxg-7UMZ2c\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/FwIaDMiQ8vo\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:107:\"http://www.wordpress-fr.net/2015/02/03/lhebdo-wordpress-n251-wordcamp-paris-wp-valence-collectif-wp-suisse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/vXxg-7UMZ2c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"
		
		
		
		
		
				
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"L’Hebdo WordPress n°250 : Je suis Charlie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/dpw1jMQN_tw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jan 2015 21:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7349\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&#8217;oublions pas ! &#8230; N&#8217;oublions surtout pas cette chance que nous avons [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2589:\"<p>La semaine passée a été marquée par une actualité bien triste, celle du massacre de journalistes et de dessinateurs du célèbre Charlie Hebdo, de policiers, mais aussi de gens qui ont eu le malheur de se trouver au mauvais endroit au mauvais moment&#8230; N&rsquo;oublions pas ! &#8230; N&rsquo;oublions surtout pas cette chance que nous avons de pouvoir exprimer nos idées quelles qu&rsquo;elles soient.</p>
<p>Notre communauté existe grâce à cette liberté, WordPress aussi par extension. #JeSuisCharlie #NousSommesCharlie</p>
<p><em><a href=\"http://boiteaweb.fr/je-suis-charlie-8500.html\">Montrez votre soutien grâce à l&rsquo;extension de Julio</a></em>.</p>
<h2>L&rsquo;Hebdo</h2>
<h3>Le WordCamp Paris 2015 c&rsquo;est dans 10 jours</h3>
<p>Eh oui ! Déjà ! &#8230; <a href=\"http://www.nicolas-birckel.fr/2015/01/09/a-la-fin-du-mois-je-serais-a-wordcamp-paris-2015-et-vous/\">Nicolas Birckel en parle</a>. Et vous ?</p>
<h3>BuddyPress 2.2 beta 1</h3>
<p>BuddyPress 2.2 poursuit son développement et <a href=\"https://buddypress.org/2015/01/buddypress-2-2-beta-1/\">sort en beta 1</a> (en).</p>
<h3>Passons à table n°10 : FX Bénard</h3>
<p><a href=\"http://wpmarmite.com/pat-episode-010/\">Interview de FX Bénard</a> par WPMarmite.</p>
<h3>Intégrer Slack dans WordPress</h3>
<p>Voici comment <a href=\"http://www.wpbeginner.com/plugins/how-to-integrate-slack-with-wordpress/\">intégrer Slack dans WordPress</a> (en).</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=LSx7EEVudz8:uiNzUjFREj8:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/LSx7EEVudz8\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/dpw1jMQN_tw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:77:\"http://www.wordpress-fr.net/2015/01/13/lhebdo-wordpress-n250-je-suis-charlie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/LSx7EEVudz8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"L’Hebdo WordPress n°249 : Bonne Année 2015 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://feedproxy.google.com/~r/feedburner/cjgL/~3/vn9uES3y6lo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Jan 2015 06:44:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Brèves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:12:\"communautés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:5:\"Hebdo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://www.wordpress-fr.net/?p=7343\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"Bonne année 2015 ! Toute l&#8217;équipe de l&#8217;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets. Notre communauté va arroser ses 10 ans d&#8217;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&#8217;est en bonne voie, on croise les [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Benoît\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4791:\"<h2>Bonne année 2015 !</h2>
<p>Toute l&rsquo;équipe de l&rsquo;association WordPress-Francophone vous souhaite une excellente année 2015 pleine de joie, de bonheur et de réussite dans vos projets.</p>
<p>Notre communauté va arroser ses 10 ans d&rsquo;existence cet été. Nous avons donc quelques arlésiennes que nous aimerions enfin sortir des cartons (c&rsquo;est en bonne voie, on croise les doigts). Le premier événement de l&rsquo;année est bien sur le <a href=\"http://2015.paris.wordcamp.org/\">WordCamp Paris 2015</a> , les 23 et 24 janvier prochains. Suivrons, j&rsquo;espère, plein d&rsquo;autres belles surprises. Restez connectés !</p>
<p>&nbsp;</p>
<h2>Place à l&rsquo;Hebdo !</h2>
<h3>WPMX Session #8</h3>
<p>WPMX, l&rsquo;association WordPress du Sud Ouest, présente sa <a href=\"http://wpchannel.com/meetup-wpmx-8-wordpress-securite/\">8e session consacrée à la sécurité</a> le 15 janvier 2015 en présence de Julio Potier.</p>
<h3>Brute Protect</h3>
<p><a href=\"https://bruteprotect.com/the-jetpack-bloat-myth/\">Brute Protect s&rsquo;explique (en)</a> suite à son rachat par <a href=\"http://ma.tt/2015/01/jetpack-speed/\">Automattic (en)</a>.</p>
<h3>Les choses à faire après l&rsquo;installation de WordPress</h3>
<p>Dès lors que votre site WordPress est installé, <a href=\"http://www.labnol.org/internet/wordpress-optimization-guide/3931/\">pensez à ces quelques étapes</a> ! (en)</p>
<h3>Un peu d&rsquo;histoire</h3>
<p>WordPress a passé la dizaine, faire un peu d&rsquo;<a href=\"http://wptavern.com/historic-wordpress-project-seeks-contributors\">histoire peut être intéressant</a> (en).</p>
<h3>Post format, inconnu et déjà mort ?</h3>
<p><a href=\"http://www.poststat.us/post-formats-looking-back/\">Petite discussion autour des Post Format</a> qui sont sous exploités (en).</p>
<h3>WordPress en 2015</h3>
<p>Noel Tock nous livre sa vision de <a href=\"https://medium.com/@noeltock/wordpress-in-2015-ed6a4674a608\">WordPress en 2015</a> (en).</p>
<h3>6 extensions indispensables</h3>
<p><a href=\"http://www.tanguy-nicolas.com/extensions-indispensables-blog-wordpress/\">Les 6 extensions indispensables</a> selon Tanguy Nicolas.</p>
<h3>L&rsquo;année de WP Marmite</h3>
<p><a href=\"http://wpmarmite.com/recapitulatif-2014-plans-2015/\">WP Marmite est apparu en 2014</a>, voici une rétrospective et les projets à venir.</p>
<h3>Tout savoir le nouveau mode d&rsquo;écriture sans distraction</h3>
<p>Voici tout ce que vous devriez savoir sur <a href=\"http://premium.wpmudev.org/blog/distraction-free-mode-wordpress/\">le nouveau mode d&rsquo;écriture sans distraction</a> (en).</p>
<h3>Le livre WordPress de Christophe Aubry</h3>
<p>WPChannel présente le livre de <a href=\"http://wpchannel.com/wordpress-gerer-site-multi-utilisateur-christophe-aubry/\">Christophe Aubry sur WordPress</a>.</p>
<h3>Les résolutions 2015 de Julio</h3>
<p>Julio prends de bonne résultions 2015 pour WordPress et <a href=\"http://boiteaweb.fr/resolutions-wordpress-2015-dans-vos-developpements-8487.html\">vous les partage</a>.</p>
<h3>Le thème 2015 par Rodrigue</h3>
<p>Rodrigue propose une <a href=\"http://www.cree1site.com/review-du-theme-wordpress-twenty-fifteen/\">revue du thème par défaut &laquo;&nbsp;Twenty Fifteen&nbsp;&raquo;</a>.</p>
<h3>Les commentaires et leurs interactions</h3>
<p>WP Formation fait le tour des <a href=\"http://wpformation.com/commentaires-wordpress-interaction/\">bonnes pratiques en terme de commentaires</a>.</p>
<h3>Genesis : créer son accueil</h3>
<p>Grégoire présente la façon de <a href=\"http://www.gregoirenoyelle.com/genesis-comprendre-creer-page-accueil-wordpress-sur-mesure/\">créer une page d&rsquo;accueil avec Genesis</a>.</p>
<div class=\"feedflare\">
<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=20scgnJiK4c:vZsob7YiHnU:gIN9vFwOqvQ\" border=\"0\"></img></a>
</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/20scgnJiK4c\" height=\"1\" width=\"1\" alt=\"\"/><img src=\"http://feeds.feedburner.com/~r/feedburner/cjgL/~4/vn9uES3y6lo\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:2:{i:0;a:5:{s:4:\"data\";s:78:\"http://www.wordpress-fr.net/2015/01/06/lhebdo-wordpress-n249-bonne-annee-2015/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/20scgnJiK4c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:15:\"feedburner/cjgl\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:18:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:96:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:21:\"Subscribe with Feedly\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:80:\"http://feedly.com/#subscription/feed/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:42:\"http://s3.feedly.com/feedburner/feedly.png\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:11;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:72:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/feedburner/cjgL\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:12;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:95:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:44:\"http://www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:13;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:14;a:5:{s:4:\"data\";s:34:\"Subscribe with The Free Dictionary\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:103:\"http://www.thefreedictionary.com/_/hp/AddRSS.aspx?http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://img.tfd.com/hp/addToTheFreeDictionary.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:15;a:5:{s:4:\"data\";s:28:\"Subscribe with Bitty Browser\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:115:\"http://www.bitty.com/manual/?contenttype=rssfeed&contentvalue=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:48:\"http://www.bitty.com/img/bittychicklet_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:16;a:5:{s:4:\"data\";s:28:\"Subscribe with Podcast Ready\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:107:\"http://www.podcastready.com/oneclick_bookmark.php?url=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:58:\"http://www.podcastready.com/images/podcastready_button.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:17;a:5:{s:4:\"data\";s:29:\"Subscribe with Daily Rotation\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:97:\"http://www.dailyrotation.com/index.php?feed=http%3A%2F%2Ffeeds.feedburner.com%2Ffeedburner%2FcjgL\";s:3:\"src\";s:40:\"http://www.dailyrotation.com/rss-dr2.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:43:\"http://feeds.feedburner.com/feedburner/cjgL\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:13:\"last-modified\";s:29:\"Mon, 20 Apr 2015 12:44:16 GMT\";s:4:\"date\";s:29:\"Mon, 20 Apr 2015 13:59:37 GMT\";s:7:\"expires\";s:29:\"Mon, 20 Apr 2015 13:59:37 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:18:\"alternate-protocol\";s:11:\"80:quic,p=1\";s:13:\"accept-ranges\";s:4:\"none\";s:4:\"vary\";s:15:\"Accept-Encoding\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("117879","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1429581578","no");
INSERT INTO `wp_options` VALUES("117880","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
	
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"
		
		
		
		
		
		
				

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		

	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Apr 2015 13:45:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast&#039;s WordPress SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"The easiest, most effective way to secure WordPress in seconds.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2572@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WP Smush\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-smushit/#post-7936\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Dec 2008 00:00:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"7936@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Reduce image file sizes, improve performance and boost your SEO using the free WPMU DEV WordPress Smush API.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alex Dunae\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"50539@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Displays Google Analytics reports and real-time statistics in your WordPress Dashboard. Inserts the latest tracking code in every page of your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"49521@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Broken Link Checker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/broken-link-checker/#post-2441\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 08 Oct 2007 21:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2441@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"This plugin will check your posts, comments and other content for broken links and missing images, and notify you if any are found.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Janis Elsts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2316@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"MailChimp for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/mailchimp-for-wp/#post-54377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Jun 2013 17:32:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"54377@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The best MailChimp plugin to get more email subscribers. Easily add MailChimp sign-up forms and sign-up checkboxes to your WordPress site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Danny van Kooten\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"EWWW Image Optimizer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/ewww-image-optimizer/#post-38780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Jun 2012 19:30:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38780@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Reduce file sizes for images in WordPress including NextGEN, GRAND FlAGallery and more using lossless/lossy methods and image format conversion.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"nosilver4u\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 12 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26607@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"25254@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"51888@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/buddypress/#post-10314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Apr 2009 17:48:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"10314@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"BuddyPress helps you run any kind of social network on your WordPress, with member profiles, activity streams, user groups, messaging, and more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andy Peatling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"ManageWP Worker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/worker/#post-24528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Feb 2011 13:06:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"24528@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"ManageWP is the ultimate WordPress productivity tool, allowing you to efficiently manage your websites.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vladimir Prelovac\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38058@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26907@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"solarissmoke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WPtouch Mobile Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wptouch/#post-5468\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 May 2008 04:58:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"5468@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Make your WordPress website mobile-friendly with just a few clicks.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"BraveNewCode Inc.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Share Buttons by AddToAny\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/add-to-any/#post-498\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Mar 2007 23:08:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"498@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"Share buttons for WordPress including AddToAny&#039;s universal sharing button, Facebook, Twitter, Google+, Pinterest, WhatsApp and many more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"micropat\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ninja Forms\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/ninja-forms/#post-33147\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2011 18:11:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"33147@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"Forms created with a simple drag and drop interface. Contact forms, Email collection forms, or any other form you want on your WordPress site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"kstover\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WP Retina 2x\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wp-retina-2x/#post-39551\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Jun 2012 11:25:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"39551@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Make your website look beautiful and crisp on Retina / High DPI displays.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Jordy Meow\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 20 Apr 2015 13:59:38 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Fri, 09 Mar 2007 22:11:30 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20140424132021\";}","no");
INSERT INTO `wp_options` VALUES("108747","_site_transient_timeout_browser_d731389443c1dc79df25aeea8fbd3f27","1429275611","yes");
INSERT INTO `wp_options` VALUES("108748","_site_transient_browser_d731389443c1dc79df25aeea8fbd3f27","a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:5:\"8.0.3\";s:10:\"update_url\";s:28:\"http://www.apple.com/safari/\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/safari.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/safari.png\";s:15:\"current_version\";s:1:\"5\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("117891","_site_transient_timeout_itsec_upload_dir","1429625214","yes");
INSERT INTO `wp_options` VALUES("117892","_site_transient_itsec_upload_dir","a:6:{s:4:\"path\";s:49:\"/home/pigiste/48heures/wp-content/uploads/2015/04\";s:3:\"url\";s:49:\"http://48h.pigiste.org/wp-content/uploads/2015/04\";s:6:\"subdir\";s:8:\"/2015/04\";s:7:\"basedir\";s:41:\"/home/pigiste/48heures/wp-content/uploads\";s:7:\"baseurl\";s:41:\"http://48h.pigiste.org/wp-content/uploads\";s:5:\"error\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113910","itsec_ipcheck","a:4:{s:17:\"optin-brute-force\";s:1:\"1\";s:7:\"api_ban\";b:1;s:7:\"api_key\";s:32:\"F3VcyPwndUeR62i6lj6dEi54gny7K94o\";s:5:\"api_s\";s:128:\"uAZ92bmH9Q2Buj5l4z5eYSy3d4dvh1x2D502q7Z6k0kWfdFz3BGBXf0408M5QKcRWaJi7o0jqe77FL8h57rnRCeLzp0z24f5cWSq4T2MKmX3wr8Y1W40mCi4vhe9MJ0K\";}","yes");
INSERT INTO `wp_options` VALUES("113911","itsec_four_oh_four","a:5:{s:7:\"enabled\";b:1;s:12:\"check_period\";i:5;s:15:\"error_threshold\";i:20;s:10:\"white_list\";a:9:{i:0;s:12:\"/favicon.ico\";i:1;s:11:\"/robots.txt\";i:2;s:21:\"/apple-touch-icon.png\";i:3;s:33:\"/apple-touch-icon-precomposed.png\";i:4;s:17:\"/wp-content/cache\";i:5;s:18:\"/browserconfig.xml\";i:6;s:16:\"/crossdomain.xml\";i:7;s:11:\"/labels.rdf\";i:8;s:27:\"/trafficbasedsspsitemap.xml\";}s:5:\"types\";a:5:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".gif\";i:4;s:4:\".css\";}}","yes");
INSERT INTO `wp_options` VALUES("113912","itsec_away_mode","a:4:{s:7:\"enabled\";b:1;s:4:\"type\";i:1;s:5:\"start\";i:1429230600;s:3:\"end\";i:1429336800;}","yes");
INSERT INTO `wp_options` VALUES("113913","itsec_ban_users","a:4:{s:7:\"default\";b:1;s:7:\"enabled\";b:1;s:9:\"host_list\";a:0:{}s:10:\"agent_list\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES("113915","itsec_brute_force","a:5:{s:7:\"enabled\";b:1;s:17:\"max_attempts_host\";i:5;s:17:\"max_attempts_user\";i:10;s:12:\"check_period\";i:5;s:14:\"auto_ban_admin\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("113916","itsec_backup","a:9:{s:9:\"all_sites\";b:1;s:6:\"method\";i:0;s:8:\"location\";s:66:\"/home/pigiste/48heures/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:20;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1429452993;}","yes");
INSERT INTO `wp_options` VALUES("113917","itsec_file_change","a:9:{s:6:\"method\";b:1;s:9:\"file_list\";a:1:{i:0;s:0:\"\";}s:5:\"types\";a:6:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".log\";i:4;s:3:\".mo\";i:5;s:3:\".po\";}s:5:\"email\";b:1;s:12:\"notify_admin\";b:1;s:7:\"enabled\";b:0;s:5:\"split\";b:0;s:10:\"last_chunk\";b:0;s:8:\"last_run\";i:1429116552;}","yes");
INSERT INTO `wp_options` VALUES("113918","itsec_hide_backend","a:7:{s:7:\"enabled\";b:1;s:4:\"slug\";s:5:\"porte\";s:12:\"theme_compat\";b:1;s:17:\"theme_compat_slug\";s:9:\"not_found\";s:16:\"post_logout_slug\";s:0:\"\";s:12:\"show-tooltip\";b:0;s:8:\"register\";s:15:\"wp-register.php\";}","yes");
INSERT INTO `wp_options` VALUES("113919","itsec_malware","a:2:{s:7:\"enabled\";b:1;s:7:\"api_key\";s:64:\"41989a8a898c77c889af9274298782a51133e7532f6075a5ddcf630bb245f642\";}","yes");
INSERT INTO `wp_options` VALUES("113920","itsec_ssl","a:3:{s:8:\"frontend\";i:0;s:5:\"login\";b:0;s:5:\"admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113922","itsec_strong_passwords","a:2:{s:7:\"enabled\";b:1;s:4:\"roll\";s:11:\"contributor\";}","yes");
INSERT INTO `wp_options` VALUES("113923","itsec_tweaks","a:22:{s:13:\"protect_files\";b:1;s:18:\"directory_browsing\";b:1;s:15:\"request_methods\";b:1;s:24:\"suspicious_query_strings\";b:1;s:17:\"write_permissions\";b:1;s:11:\"uploads_php\";b:1;s:13:\"generator_tag\";b:1;s:18:\"wlwmanifest_header\";b:1;s:14:\"edituri_header\";b:1;s:12:\"comment_spam\";b:1;s:14:\"random_version\";b:1;s:14:\"disable_xmlrpc\";i:2;s:12:\"login_errors\";b:1;s:21:\"force_unique_nicename\";b:1;s:27:\"disable_unused_author_pages\";b:1;s:22:\"non_english_characters\";b:0;s:16:\"long_url_strings\";b:0;s:13:\"theme_updates\";b:0;s:14:\"plugin_updates\";b:0;s:12:\"core_updates\";b:0;s:11:\"file_editor\";b:0;s:11:\"safe_jquery\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("113937","itsec_message_queue","a:2:{s:9:\"last_sent\";i:1429539205;s:8:\"messages\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("117062","_site_transient_timeout_itsec_random_version","1429544882","yes");
INSERT INTO `wp_options` VALUES("114014","itsec_jquery_version","1.11.1","yes");
INSERT INTO `wp_options` VALUES("117063","_site_transient_itsec_random_version","266","yes");
INSERT INTO `wp_options` VALUES("114047","itsec_salts","1429199122","yes");
INSERT INTO `wp_options` VALUES("115770","_transient_timeout_wp-piwik_50236c5ab9e75968c4639513990cca3b","1429953693","no");
INSERT INTO `wp_options` VALUES("115771","_transient_wp-piwik_50236c5ab9e75968c4639513990cca3b","2.12.1","no");
INSERT INTO `wp_options` VALUES("114985","duplicator_settings","a:10:{s:7:\"version\";s:6:\"0.5.16\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("114986","duplicator_version_plugin","0.5.16","yes");
INSERT INTO `wp_options` VALUES("114287","updraft_email","","yes");
INSERT INTO `wp_options` VALUES("114288","updraft_report_warningsonly","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114289","updraft_report_wholebackup","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("114290","updraft_autobackup_default","0","yes");
INSERT INTO `wp_options` VALUES("114291","updraft_delete_local","1","yes");
INSERT INTO `wp_options` VALUES("114292","updraft_debug_mode","0","yes");
INSERT INTO `wp_options` VALUES("114293","updraft_extradbs","","yes");
INSERT INTO `wp_options` VALUES("114294","updraft_backupdb_nonwp","0","yes");
INSERT INTO `wp_options` VALUES("114295","updraft_include_plugins","1","yes");
INSERT INTO `wp_options` VALUES("114296","updraft_include_themes","1","yes");
INSERT INTO `wp_options` VALUES("114297","updraft_include_uploads","1","yes");
INSERT INTO `wp_options` VALUES("114298","updraft_include_others","1","yes");
INSERT INTO `wp_options` VALUES("114299","updraft_include_wpcore","0","yes");
INSERT INTO `wp_options` VALUES("114300","updraft_include_wpcore_exclude","","yes");
INSERT INTO `wp_options` VALUES("114301","updraft_include_more","0","yes");
INSERT INTO `wp_options` VALUES("114302","updraft_include_more_path","","yes");
INSERT INTO `wp_options` VALUES("114303","updraft_include_uploads_exclude","backup*,*backups,backwpup*,wp-clone","yes");
INSERT INTO `wp_options` VALUES("114304","updraft_include_others_exclude","upgrade,cache,updraft,backup*,*backups","yes");
INSERT INTO `wp_options` VALUES("114305","updraft_starttime_files","13:20","yes");
INSERT INTO `wp_options` VALUES("114306","updraft_starttime_db","13:20","yes");
INSERT INTO `wp_options` VALUES("114307","updraft_startday_files","0","yes");
INSERT INTO `wp_options` VALUES("114308","updraft_startday_db","0","yes");
INSERT INTO `wp_options` VALUES("114322","updraft_backup_history","a:3:{i:1429477224;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-plugins.zip\";}s:12:\"plugins-size\";i:15650832;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-uploads.zip\";}s:12:\"uploads-size\";i:178379269;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-others.zip\";}s:11:\"others-size\";i:818833;s:2:\"db\";s:60:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-db.gz\";s:7:\"db-size\";i:280284;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"2f88e29091ba21ec4394f4f4435d686ed0344d90\";s:7:\"themes0\";s:40:\"fb660568b74865d7d64e882e190a3efd4c075cbc\";s:8:\"uploads0\";s:40:\"f167e74075c27d33f8ebe1da058835a094eacddc\";s:7:\"others0\";s:40:\"b82da5c1164311d2ebd6d9c7b9b9cc64d11883f0\";s:3:\"db0\";s:40:\"4e1b245e7800ad54d446bfa132a08e48af1f6c93\";}}s:5:\"nonce\";s:12:\"9ac539449cd0\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429390758;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-18-2159_Les_48h_de_la_pige_1ec97fa8b6a2-plugins.zip\";}s:12:\"plugins-size\";i:15650832;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-18-2159_Les_48h_de_la_pige_1ec97fa8b6a2-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-18-2159_Les_48h_de_la_pige_1ec97fa8b6a2-uploads.zip\";}s:12:\"uploads-size\";i:178104489;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-18-2159_Les_48h_de_la_pige_1ec97fa8b6a2-others.zip\";}s:11:\"others-size\";i:818833;s:2:\"db\";s:60:\"backup_2015-04-18-2159_Les_48h_de_la_pige_1ec97fa8b6a2-db.gz\";s:7:\"db-size\";i:280127;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"2107d2ee6c899bbb340eb3ae4f7d9f1d7a81861e\";s:7:\"themes0\";s:40:\"6da70272ea13f345b2c713ba1a8cb3f874ac7d8e\";s:8:\"uploads0\";s:40:\"366db8744b9ac5cc26cdb3f29dd1e1b7a6295636\";s:7:\"others0\";s:40:\"5c28e1b342757fca0b4bf86b01667354cda0a603\";s:3:\"db0\";s:40:\"9d2c65f6c4ebaa308879955f4e30e3046a66e6eb\";}}s:5:\"nonce\";s:12:\"1ec97fa8b6a2\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}i:1429304325;a:13:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-17-2158_Les_48h_de_la_pige_0407f0f27386-plugins.zip\";}s:12:\"plugins-size\";i:15076515;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-17-2158_Les_48h_de_la_pige_0407f0f27386-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-17-2158_Les_48h_de_la_pige_0407f0f27386-uploads.zip\";}s:12:\"uploads-size\";i:177828420;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-17-2158_Les_48h_de_la_pige_0407f0f27386-others.zip\";}s:11:\"others-size\";i:818833;s:2:\"db\";s:60:\"backup_2015-04-17-2158_Les_48h_de_la_pige_0407f0f27386-db.gz\";s:7:\"db-size\";i:3351692;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"cfbcc1f3418cf3289e033907721a3f38ea24b656\";s:7:\"themes0\";s:40:\"7f80ef2d7074506df5baf9d32b0db6018ffd435c\";s:8:\"uploads0\";s:40:\"6bda93184cbbdd220090bf1a2e1345802424b42f\";s:7:\"others0\";s:40:\"3469001f14d484d6a8275bbabcd76612b10209bd\";s:3:\"db0\";s:40:\"adc1383819c1aa6137e7f0f4c24fcf2c671ed592\";}}s:5:\"nonce\";s:12:\"0407f0f27386\";s:7:\"service\";a:1:{i:0;s:3:\"ftp\";}}}","yes");
INSERT INTO `wp_options` VALUES("114314","updraft_lastmessage","La sauvegarde s\'est correctement effectué et est complète (avr 19 22:01:22)","yes");
INSERT INTO `wp_options` VALUES("114315","updraftplus_unlocked_fd","1","yes");
INSERT INTO `wp_options` VALUES("114316","updraftplus_last_lock_time_fd","2015-04-19 21:00:24","yes");
INSERT INTO `wp_options` VALUES("114317","updraftplus_semaphore_fd","0","yes");
INSERT INTO `wp_options` VALUES("114344","mailusers_copy_sender","false","yes");
INSERT INTO `wp_options` VALUES("114345","mailusers_add_x_mailer_header","false","yes");
INSERT INTO `wp_options` VALUES("114346","mailusers_omit_display_names","false","yes");
INSERT INTO `wp_options` VALUES("114347","mailusers_footer","<h5 style=\"border-top: 1px solid #eee;\">Powered by <a href=\"http://wordpress.org/plugins/email-users/\">Email Users</a>.</h5>","yes");
INSERT INTO `wp_options` VALUES("114348","mailusers_debug","false","yes");
INSERT INTO `wp_options` VALUES("114349","mailusers_base64_encode","false","yes");
INSERT INTO `wp_options` VALUES("114350","mailusers_dashboard_widgets","true","yes");
INSERT INTO `wp_options` VALUES("114342","mailusers_shortcode_processing","false","yes");
INSERT INTO `wp_options` VALUES("114343","mailusers_from_sender_exclude","true","yes");
INSERT INTO `wp_options` VALUES("114321","updraftplus_semaphore_","0","yes");
INSERT INTO `wp_options` VALUES("114341","mailusers_no_role_filter","false","yes");
INSERT INTO `wp_options` VALUES("114319","updraftplus_unlocked_","1","yes");
INSERT INTO `wp_options` VALUES("114320","updraftplus_last_lock_time_","2015-04-16 20:58:50","yes");
INSERT INTO `wp_options` VALUES("114331","mailusers_default_mail_format","html","yes");
INSERT INTO `wp_options` VALUES("114332","mailusers_default_sort_users_by","none","yes");
INSERT INTO `wp_options` VALUES("114333","mailusers_max_bcc_recipients","0","yes");
INSERT INTO `wp_options` VALUES("114334","mailusers_from_sender_name_override","","yes");
INSERT INTO `wp_options` VALUES("114335","mailusers_from_sender_address_override","","yes");
INSERT INTO `wp_options` VALUES("114336","mailusers_send_bounces_to_address_override","","yes");
INSERT INTO `wp_options` VALUES("114337","mailusers_user_settings_table_rows","20","yes");
INSERT INTO `wp_options` VALUES("114338","mailusers_default_notifications","true","yes");
INSERT INTO `wp_options` VALUES("114339","mailusers_default_mass_email","true","yes");
INSERT INTO `wp_options` VALUES("114340","mailusers_default_user_control","true","yes");
INSERT INTO `wp_options` VALUES("115772","_transient_timeout_wp-piwik_e052f9c7d6ed4e95312323c77c10b126","1429954143","no");
INSERT INTO `wp_options` VALUES("114323","updraft_last_backup","a:5:{s:11:\"backup_time\";i:1429477224;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:66:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-plugins.zip\";}s:12:\"plugins-size\";i:15650832;s:6:\"themes\";a:1:{i:0;s:65:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-themes.zip\";}s:11:\"themes-size\";i:7796814;s:7:\"uploads\";a:1:{i:0;s:66:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-uploads.zip\";}s:12:\"uploads-size\";i:178379269;s:6:\"others\";a:1:{i:0;s:65:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-others.zip\";}s:11:\"others-size\";i:818833;s:2:\"db\";s:60:\"backup_2015-04-19-2200_Les_48h_de_la_pige_9ac539449cd0-db.gz\";s:7:\"db-size\";i:280284;s:9:\"checksums\";a:1:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"2f88e29091ba21ec4394f4f4435d686ed0344d90\";s:7:\"themes0\";s:40:\"fb660568b74865d7d64e882e190a3efd4c075cbc\";s:8:\"uploads0\";s:40:\"f167e74075c27d33f8ebe1da058835a094eacddc\";s:7:\"others0\";s:40:\"b82da5c1164311d2ebd6d9c7b9b9cc64d11883f0\";s:3:\"db0\";s:40:\"4e1b245e7800ad54d446bfa132a08e48af1f6c93\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"9ac539449cd0\";}","yes");
INSERT INTO `wp_options` VALUES("115769","wp-piwik_settings","a:6:{s:4:\"name\";s:18:\"Les 48h de la pige\";s:13:\"tracking_code\";s:513:\"<!-- Piwik -->
<script type=\"text/javascript\">
  var _paq = _paq || [];
  _paq.push([\'trackPageView\']);
  _paq.push([\'enableLinkTracking\']);
  (function() {
    var u=\"//piwik.pigiste.org/\";
    _paq.push([\'setTrackerUrl\', u+\'piwik.php\']);
    _paq.push([\'setSiteId\', 1]);
    var d=document, g=d.createElement(\'script\'), s=d.getElementsByTagName(\'script\')[0];
    g.type=\'text/javascript\'; g.async=true; g.defer=true; g.src=u+\'piwik.js\'; s.parentNode.insertBefore(g,s);
  })();
</script>
<!-- End Piwik Code -->
\";s:7:\"site_id\";i:1;s:25:\"last_tracking_code_update\";i:1429349694;s:18:\"dashboard_revision\";i:0;s:13:\"noscript_code\";s:105:\"<noscript><p><img src=\"//piwik.pigiste.org/piwik.php?idsite=1\" style=\"border:0;\" alt=\"\" /></p></noscript>\";}","yes");
INSERT INTO `wp_options` VALUES("114330","mailusers_default_body","<p>Bonjour, </p><p>J\'aimerais attirer votre attention sur un nouvel article publi&eacute; sur le blog (voir infos ci-dessous). J\'esp&egrave;re que vous le trouverez int&eacute;ressant.</p><p>Cordialement,</p><p>%FROM_NAME%</p><hr><p><strong>%POST_TITLE%</strong></p><p>%POST_EXCERPT%</p><ul><li>Lien vers l\'article : <a href=\"%POST_URL%\">%POST_URL%</a></li><li>Lien vers %BLOG_NAME%: <a href=\"%BLOG_URL%\">%BLOG_URL%</a></li></ul>","yes");
INSERT INTO `wp_options` VALUES("114329","mailusers_default_subject","[%BLOG_NAME%] A post of interest: \"%POST_TITLE%\"","yes");
INSERT INTO `wp_options` VALUES("114397","polylang","a:12:{s:7:\"browser\";i:1;s:7:\"rewrite\";i:1;s:12:\"hide_default\";i:0;s:10:\"force_lang\";i:0;s:13:\"redirect_lang\";i:0;s:13:\"media_support\";i:1;s:4:\"sync\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}s:7:\"domains\";a:0:{}s:7:\"version\";s:5:\"1.7.3\";s:12:\"default_lang\";s:2:\"fr\";}","yes");
INSERT INTO `wp_options` VALUES("114328","mailusers_version","4.7.1","yes");
INSERT INTO `wp_options` VALUES("114987","duplicator_ui_view_state","a:4:{s:14:\"dup-wpnotice01\";b:1;s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:27:\"dup-settings-diag-srv-panel\";s:1:\"0\";s:28:\"dup-settings-diag-opts-panel\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("114988","duplicator_package_active","O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150417_les48hdelapige\";s:4:\"Hash\";s:29:\"55310965234f97154150417132349\";s:8:\"NameHash\";s:53:\"20150417_les48hdelapige_55310965234f97154150417132349\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:39:\"/home/pigiste/48heures/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://48h.pigiste.org/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150417_les48hdelapige_55310965234f97154150417132349_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:22:\"/home/pigiste/48heures\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150417_les48hdelapige\";s:4:\"Hash\";s:29:\"55310965234f97154150417132349\";s:8:\"NameHash\";s:53:\"20150417_les48hdelapige_55310965234f97154150417132349\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:39:\"/home/pigiste/48heures/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://48h.pigiste.org/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:30;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}","yes");
INSERT INTO `wp_options` VALUES("117859","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1429537429;s:8:\"response\";a:1:{s:21:\"newsletter/plugin.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"8171\";s:4:\"slug\";s:10:\"newsletter\";s:6:\"plugin\";s:21:\"newsletter/plugin.php\";s:11:\"new_version\";s:5:\"3.7.5\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/newsletter/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/plugin/newsletter.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:11:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.1.zip\";}s:19:\"bbpress/bbpress.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"11780\";s:4:\"slug\";s:7:\"bbpress\";s:6:\"plugin\";s:19:\"bbpress/bbpress.php\";s:11:\"new_version\";s:5:\"2.5.6\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/bbpress/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.6.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.16\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.16.zip\";}s:27:\"email-users/email-users.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"580\";s:4:\"slug\";s:11:\"email-users\";s:6:\"plugin\";s:27:\"email-users/email-users.php\";s:11:\"new_version\";s:5:\"4.7.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/email-users/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/email-users.4.7.1.zip\";}s:41:\"google-maps-widget/google-maps-widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33487\";s:4:\"slug\";s:18:\"google-maps-widget\";s:6:\"plugin\";s:41:\"google-maps-widget/google-maps-widget.php\";s:11:\"new_version\";s:4:\"2.30\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/google-maps-widget/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/google-maps-widget.2.30.zip\";}s:41:\"better-wp-security/better-wp-security.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"18308\";s:4:\"slug\";s:18:\"better-wp-security\";s:6:\"plugin\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"new_version\";s:6:\"4.6.13\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/better-wp-security/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/better-wp-security.4.6.13.zip\";}s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41825\";s:4:\"slug\";s:28:\"oauth-twitter-sidebar-widget\";s:6:\"plugin\";s:53:\"oauth-twitter-sidebar-widget/oauth_twitter_widget.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/oauth-twitter-sidebar-widget/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/oauth-twitter-sidebar-widget.zip\";}s:21:\"polylang/polylang.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25780\";s:4:\"slug\";s:8:\"polylang\";s:6:\"plugin\";s:21:\"polylang/polylang.php\";s:11:\"new_version\";s:5:\"1.7.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/polylang/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/polylang.1.7.3.zip\";}s:27:\"updraftplus/updraftplus.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"31679\";s:4:\"slug\";s:11:\"updraftplus\";s:6:\"plugin\";s:27:\"updraftplus/updraftplus.php\";s:11:\"new_version\";s:6:\"1.9.63\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/updraftplus/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/updraftplus.1.9.63.zip\";}s:21:\"wp-piwik/wp-piwik.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"8459\";s:4:\"slug\";s:8:\"wp-piwik\";s:6:\"plugin\";s:21:\"wp-piwik/wp-piwik.php\";s:11:\"new_version\";s:8:\"0.9.9.18\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/wp-piwik/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/wp-piwik.0.9.9.18.zip\";}s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"13204\";s:4:\"slug\";s:19:\"wp-maintenance-mode\";s:6:\"plugin\";s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";s:11:\"new_version\";s:5:\"2.0.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/wp-maintenance-mode/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/wp-maintenance-mode.2.0.3.zip\";}}}","yes");
INSERT INTO `wp_options` VALUES("115657","rewrite_rules","a:160:{s:8:\"forum/?$\";s:25:\"index.php?post_type=forum\";s:38:\"forum/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:33:\"forum/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:25:\"forum/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=forum&paged=$matches[1]\";s:9:\"sujets/?$\";s:25:\"index.php?post_type=topic\";s:39:\"sujets/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:34:\"sujets/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:26:\"sujets/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=topic&paged=$matches[1]\";s:27:\"forum/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:27:\"forum/sujet/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:31:\"forum/répondre/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:29:\"forum/mot-cle/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:54:\"forum/utilisateurs/([^/]+)/sujets/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:57:\"forum/utilisateurs/([^/]+)/réponses/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:55:\"forum/utilisateurs/([^/]+)/favoris/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:57:\"forum/utilisateurs/([^/]+)/souscrire/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:36:\"forum/utilisateurs/([^/]+)/sujets/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:39:\"forum/utilisateurs/([^/]+)/réponses/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:37:\"forum/utilisateurs/([^/]+)/favoris/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:39:\"forum/utilisateurs/([^/]+)/souscrire/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:34:\"forum/utilisateurs/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:29:\"forum/utilisateurs/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:48:\"forum/voir-le-sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:35:\"forum/voir-le-sujet/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:30:\"forum/voir-le-sujet/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:37:\"forum/rechercher/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:19:\"forum/rechercher/?$\";s:20:\"index.php?bbp_search\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"forum/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"forum/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"forum/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"forum/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"forum/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"forum/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:50:\"forum/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:45:\"forum/forum/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:38:\"forum/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:45:\"forum/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:30:\"forum/forum/(.+?)(/[0-9]+)?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:39:\"forum/sujet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"forum/sujet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"forum/sujet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"forum/sujet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"forum/sujet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"forum/sujet/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:52:\"forum/sujet/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:47:\"forum/sujet/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:40:\"forum/sujet/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:47:\"forum/sujet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:32:\"forum/sujet/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:28:\"forum/sujet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"forum/sujet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"forum/sujet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"forum/sujet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"forum/sujet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"forum/répondre/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"forum/répondre/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"forum/répondre/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"forum/répondre/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"forum/répondre/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"forum/répondre/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:44:\"forum/répondre/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:51:\"forum/répondre/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:36:\"forum/répondre/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:32:\"forum/répondre/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"forum/répondre/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"forum/répondre/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"forum/répondre/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"forum/répondre/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"forum/mot-cle/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:49:\"forum/mot-cle/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:42:\"forum/mot-cle/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:24:\"forum/mot-cle/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:45:\"forum/rechercher/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?bbp_search=$matches[1]&paged=$matches[2]\";s:27:\"forum/rechercher/([^/]+)/?$\";s:32:\"index.php?bbp_search=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)(/[0-9]+)?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"portfolio_entries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:53:\"portfolio_entries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:46:\"portfolio_entries/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?portfolio_entries=$matches[1]&paged=$matches[2]\";s:28:\"portfolio_entries/([^/]+)/?$\";s:39:\"index.php?portfolio_entries=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO `wp_options` VALUES("114373","_site_transient_timeout_available_translations","1429230297","yes");
INSERT INTO `wp_options` VALUES("114374","_site_transient_available_translations","a:54:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-01 13:21:43\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:15:41\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:19:26\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:22:49\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:24:48\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:30:22\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:32:23\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:34:24\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:38:25\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-15 12:48:44\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:44:26\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:46:15\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:42:35\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:48:12\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:54:32\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:56:31\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 14:50:12\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-04 19:47:01\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.0/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-27 08:55:29\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:03:17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-18 08:12:21\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:08:29\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-05 17:37:43\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.0/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:14:57\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.1/haz.zip\";s:3:\"iso\";a:2:{i:1;s:3:\"haz\";i:2;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-08 22:28:26\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:25:25\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:27:28\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:29:34\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-15 22:23:37\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:33:39\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:35:42\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:43:18\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:47:56\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:7:\"Burmese\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 15:59:41\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:02:30\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-16 06:38:46\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:07:08\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/ps.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ps\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:11:07\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:14:41\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-27 14:48:56\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:19:48\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:23:44\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:25:46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:30:35\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:33:33\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-27 00:00:51\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:43:10\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-04-10 12:55:55\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.1/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:19:\"2015-03-26 16:55:15\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"4.1\";s:7:\"updated\";s:19:\"2014-12-26 02:21:02\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}","yes");
INSERT INTO `wp_options` VALUES("115785","_transient_timeout_wp-piwik_c379a9e41b55eaf070fb1cecd22565d0","1429954384","no");
INSERT INTO `wp_options` VALUES("115786","_transient_wp-piwik_c379a9e41b55eaf070fb1cecd22565d0","2.12.1","no");
INSERT INTO `wp_options` VALUES("115796","_transient_timeout_wp-piwik_a411a88d976e5eb2749592a5cd451bb6","1429955227","no");
INSERT INTO `wp_options` VALUES("115797","_transient_wp-piwik_a411a88d976e5eb2749592a5cd451bb6","a:11:{s:16:\"nb_uniq_visitors\";i:0;s:8:\"nb_users\";i:0;s:9:\"nb_visits\";i:0;s:10:\"nb_actions\";i:0;s:19:\"nb_visits_converted\";i:0;s:12:\"bounce_count\";i:0;s:16:\"sum_visit_length\";i:0;s:11:\"max_actions\";i:0;s:11:\"bounce_rate\";s:2:\"0%\";s:20:\"nb_actions_per_visit\";i:0;s:16:\"avg_time_on_site\";i:0;}","no");
INSERT INTO `wp_options` VALUES("117886","_transient_dash_4077549d03da2e451c8b5f002294ff51","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/HP8wb-DawIU/\'>La problématique des traductions officielles</a> <span class=\"rss-date\">25 mars 2015</span><div class=\"rssSummary\">Merci à WordPress Francophone de m’accueillir une fois de plus ici, et cette fois-ci pour une problématique très spécifique : la traduction, et surtout le fait de devoir respecter ou non un terme officiel. Pour la petite histoire, je rédige une seconde version du livre « Optimiser son référencement WordPress », et je suis une nouvelle fois [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/nhFl_mTTaWE/\'>La problématique des traductions officielles</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/KJsEy-lwkw0/\'>L’Hebdo WordPress n°256 : WordPress 4.2 – Traduction – Astuces</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/Nxk3eqWFjXU/\'>L’Hebdo WordPress n°255 : WPMX Day – WordPress 4.2 beta 1 – bbPress 2.5.5</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Extensions populaires:</span> <a href=\'https://wordpress.org/plugins/mailchimp-for-wp/\' class=\'dashboard-news-plugin-link\'>MailChimp for WordPress</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=mailchimp-for-wp&amp;_wpnonce=d675544e89&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'MailChimp for WordPress\'>Installer</a>)</span></li></ul></div>","no");
INSERT INTO `wp_options` VALUES("117899","_site_transient_timeout_itsec_notification_running","1429542805","yes");
INSERT INTO `wp_options` VALUES("117900","_site_transient_itsec_notification_running","1","yes");


DROP TABLE IF EXISTS `wp_postmeta`;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=144611 DEFAULT CHARSET=utf8;

INSERT INTO `wp_postmeta` VALUES("5","313","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"1-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"1-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"1-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"1-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("4","313","_wp_attached_file","2012/04/1.jpg");
INSERT INTO `wp_postmeta` VALUES("6","313","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("7","314","_wp_attached_file","2012/04/013.jpg");
INSERT INTO `wp_postmeta` VALUES("8","314","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/013.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"013-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"013-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"013-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"013-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"013-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"013-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"013-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"013-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"013-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"013-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"013-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"013-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"013-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("9","314","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("10","315","_wp_attached_file","2012/04/014.jpg");
INSERT INTO `wp_postmeta` VALUES("11","315","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/014.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"014-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"014-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"014-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"014-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:16:\"014-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"014-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:16:\"014-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"014-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"014-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:15:\"014-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"014-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:15:\"014-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:15:\"014-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("12","315","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("13","316","_wp_attached_file","2012/04/2.jpg");
INSERT INTO `wp_postmeta` VALUES("14","316","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/2.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"2-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:13:\"2-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:14:\"2-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:13:\"2-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:14:\"2-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"2-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"2-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:13:\"2-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:13:\"2-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:13:\"2-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:13:\"2-450x292.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:292;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("15","316","_woocommerce_exclude_image","0");
INSERT INTO `wp_postmeta` VALUES("16","745","_wp_attached_file","2011/12/imac_big_demo.png");
INSERT INTO `wp_postmeta` VALUES("17","745","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2011/12/imac_big_demo.png\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"imac_big_demo-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x360.png\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:26:\"imac_big_demo-1000x430.png\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"imac_big_demo-450x270.png\";s:5:\"width\";i:450;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("18","751","_avia_builder_template_single_portfolio_-_slider_two_third","{{{Single Portfolio - Slider Two Third}}}[av_two_third first]
[av_slideshow size=\'gallery\' animation=\'slide\' autoplay=\'true\' interval=\'5\']
[av_slide id=\'316\']
[av_slide id=\'315\']
[av_slide id=\'314\']
[av_slide id=\'313\']
[/av_slideshow]
[/av_two_third]

[av_one_third]
[av_textblock]
<h3>Portfolio Entry!</h3>
Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.
[/av_textblock]

[av_toggle_container initial=\'1\' mode=\'accordion\']
[av_toggle title=\'Client\']
<strong>XY Media</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

<strong>XY Media</strong> Website: <a href=\"http://www.wikipedia.com\">http://www.wikipedia.com</a>
[/av_toggle]
[av_toggle title=\'Our Task\']
<strong>Task</strong>

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu.
[/av_toggle]
[av_toggle title=\'Skills Involved\']
<strong>Skills</strong>
<ul>
	<li>Photoshop</li>
	<li>Indesign</li>
	<li>HTML</li>
	<li>CSS</li>
</ul>
[/av_toggle]
[/av_toggle_container]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_textblock]
<h4 style=\"text-align: center;\">Most Recent Entries</h4>
[/av_textblock]

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio columns=\'4\' items=\'4\' contents=\'excerpt\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("47","734","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("48","734","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("49","734","_aviaLayoutBuilderCleanData","[av_layerslider id=\'1\']

[av_one_third first]
[av_icon_box icon=\'ue80c\' font=\'entypo-fontello\' position=\'left\' title=\'S‘inscrire à l’évènement\' link=\'page,1401\' linktarget=\'\' linkelement=\'both\']Inscrivez-vous dès maintenant en ligne aux prochaines 48h de la pige. La 4e édition se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres. Toute l\'équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l\'évolutions de la presse et se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'Découvrez le programme\' link=\'page,1722\' linktarget=\'\' linkelement=\'both\']Découvrez et téléchargez le programme de la prochaine édition. Les prochaine 48 h proposeront aux participants un partage de la situation actuelle et l\'élaboration d\'une réflexion collective pour imaginer des réponses de demain. HORIZON 2030, un thème global et novateur afin d\'anticiper les évolutions de la presse et de se positionner sur les compétences à acquérir.

[/av_icon_box]
[/av_one_third]

[av_one_third]
[av_icon_box icon=\'ue856\' font=\'entypo-fontello\' position=\'left\' title=\'Pratique\' link=\'page,821\' linktarget=\'\' linkelement=\'\']Pour anticiper tous les aspects pratiques de votre venue à Vichy, cliquez ici ! Que vous veniez en voiture, en co-voiturage, en train ou encore à pieds, passez donc par cette rubrique afin de connaître l\'indispensable sur les prochaines 48h de la pige. Un forum est à votre disposition afin de partager un transport ou encore un hébergement sur place !</strong>

[/av_icon_box]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']
[av_one_full first]

[av_textblock]
<a href=\"http://48h.pigiste.org/portfolio-item/les-48h-en-images/\" title=\"Les 48H en images\">
<h2 style=\"text-align: center;\">Découvrez la galerie photo des 48h</h2>
</a>
[/av_textblock]

[av_hr class=\'short\' height=\'70\' position=\'center\']

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'auto\' image_size=\'portfolio\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]
[/av_section]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'repeat\' attach=\'scroll\' padding=\'large\' shadow=\'shadow\']

[av_one_fifth first]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/audiens.png\' attachment=\'1916\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.audiens.org/pigiste/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/afdas.png\' attachment=\'1915\' align=\'center\' animation=\'no-animation\' link=\'manually,https://www.afdas.com/\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/scam.png\' attachment=\'1917\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/pole-univ-01-footer.png\' attachment=\'1925\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][av_one_fifth]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2014/05/logos-allier-01.png\' attachment=\'2034\' align=\'center\' animation=\'no-animation\' link=\'manually,http://www.scam.fr/fr/Accueil.aspx\' target=\'\']

[/av_one_fifth][/av_section]");
INSERT INTO `wp_postmeta` VALUES("1088","1407","_menu-item-avia-megamenu","active");
INSERT INTO `wp_postmeta` VALUES("1089","1407","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1090","1407","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1092","44","_edit_lock","1398426608:1");
INSERT INTO `wp_postmeta` VALUES("1093","1410","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1094","1410","_edit_lock","1398434055:1");
INSERT INTO `wp_postmeta` VALUES("1095","1410","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1096","1410","_aviaLayoutBuilderCleanData","[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Découvrez les 48H en images\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'16\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1097","1410","_avia_builder_shortcode_tree","a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("1240","1433","_thumbnail_id","1438");
INSERT INTO `wp_postmeta` VALUES("1098","1410","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1099","1410","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1100","1410","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1101","1410","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1102","1410","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1103","1410","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1104","1410","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1105","1410","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1106","1410","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1107","1410","header","yes");
INSERT INTO `wp_postmeta` VALUES("1108","1410","footer","");
INSERT INTO `wp_postmeta` VALUES("1109","1411","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1110","1411","_menu_item_menu_item_parent","1386");
INSERT INTO `wp_postmeta` VALUES("1111","1411","_menu_item_object_id","1410");
INSERT INTO `wp_postmeta` VALUES("1112","1411","_menu_item_object","portfolio");
INSERT INTO `wp_postmeta` VALUES("1113","1411","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1114","1411","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1115","1411","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1116","1411","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1121","1413","_wp_attached_file","2011/12/IMG_6092.jpg");
INSERT INTO `wp_postmeta` VALUES("1118","1411","_menu-item-avia-megamenu","active");
INSERT INTO `wp_postmeta` VALUES("1119","1411","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1120","1411","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1122","1413","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6092.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6092-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6092-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6092-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6092-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6092-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6092-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6092-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6092-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6092-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6092-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6092-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1123","1414","_wp_attached_file","2011/12/IMG_6094.jpg");
INSERT INTO `wp_postmeta` VALUES("1124","1414","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6094.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6094-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6094-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6094-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6094-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6094-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6094-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6094-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6094-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6094-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6094-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6094-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("50","734","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("51","734","sidebar","");
INSERT INTO `wp_postmeta` VALUES("52","734","header","no");
INSERT INTO `wp_postmeta` VALUES("53","734","_avia_builder_shortcode_tree","a:6:{i:0;a:3:{s:3:\"tag\";s:14:\"av_layerslider\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:5;}i:4;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}i:2;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:8;}}s:5:\"index\";i:7;}i:5;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:5:{i:0;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:14;}}s:5:\"index\";i:13;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:15;}i:2;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}}s:5:\"index\";i:17;}i:3;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:20;}}s:5:\"index\";i:19;}i:4;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:21;}}s:5:\"index\";i:12;}}");
INSERT INTO `wp_postmeta` VALUES("1330","1496","_wp_attached_file","2011/12/BCR7704.jpg");
INSERT INTO `wp_postmeta` VALUES("1331","1496","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7704.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7704-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7704-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7704-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7704-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7704-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7704-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7704-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7704-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7704-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7704-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7704-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1071","1401","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("1072","1401","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1073","1401","_aviaLayoutBuilderCleanData","[av_fullscreen size=\'extra_large\' animation=\'fade\' autoplay=\'false\' interval=\'5\']
[av_fullscreen_slide id=\'1635\' position=\'Center Center\' title=\'\' caption_pos=\'caption_bottom\' link=\'\' link_target=\'\' link_apply=\'\' button_label=\'Click me\' button_color=\'light\'][/av_fullscreen_slide]
[/av_fullscreen]

[av_one_full first]
[av_heading heading=\'S‘inscrire à l’édition 2014 des 48h de la pige\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]
[/av_one_full]

[av_textblock ]
<p><strong> Les inscriptions sont closes pour l\'année 2014 ! Rendez-vous l\'année prochaine !</strong>

<em>L\'inscription aux 48h de la pige est gratuite. L\'évènement est ouvert à tous les journalistes pigistes.<br />Pour enregistrer votre inscription nous vous invitons à remplir ce formulaire. Il nous permettra de mieux vous accueillir et répondre à vos besoins en terme d\'hébergement, co-voiturage, restauration...</em></p>

[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("1074","1401","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:13:\"av_fullscreen\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}");
INSERT INTO `wp_postmeta` VALUES("1075","1401","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1076","1401","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1077","1401","header","yes");
INSERT INTO `wp_postmeta` VALUES("1078","1401","footer","");
INSERT INTO `wp_postmeta` VALUES("1079","1407","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1080","1407","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1081","1407","_menu_item_object_id","1401");
INSERT INTO `wp_postmeta` VALUES("61","756","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}");
INSERT INTO `wp_postmeta` VALUES("62","756","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("63","756","sidebar","");
INSERT INTO `wp_postmeta` VALUES("64","756","header","yes");
INSERT INTO `wp_postmeta` VALUES("65","756","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("66","756","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("67","756","_aviaLayoutBuilderCleanData","[av_portfolio columns=\'4\' items=\'16\' contents=\'title\' linking=\'\' sort=\'yes\' paginate=\'yes\']

[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_textblock]
This is an example of a sortable, 4 Column Portfolio.
For each Portfolio Page you create (any number possible) you can set column count,  pagination and item count, as well if its sortable or not.

You can add Portfolio Grids to every Page you want or need, with the help of the fantastic and easy to use template builder that is built right into the theme.
[/av_textblock]

");
INSERT INTO `wp_postmeta` VALUES("115","821","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("116","821","sidebar","");
INSERT INTO `wp_postmeta` VALUES("117","821","header","yes");
INSERT INTO `wp_postmeta` VALUES("118","821","_dp_original","812");
INSERT INTO `wp_postmeta` VALUES("119","821","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("120","821","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("121","821","_aviaLayoutBuilderCleanData","[av_heading tag=\'h3\' padding=\'10\' heading=\'Anticipez tous les aspects pratiques de votre venue à Vichy !\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\'][/av_heading]

[av_one_half first]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2014/04/P11705391-710x575.jpg\' attachment=\'1544\' align=\'center\' animation=\'left-to-right\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_textblock]
<h2>Bienvenue à Vichy !</h2>
[/av_textblock]

[av_textblock]
La 4e édition des 48 heures de la pige se tiendra à Vichy, les 3 et 4 juillet sur le campus Albert Londres
[/av_textblock]

[av_sidebar widget_area=\'Google Map\']
[/av_one_half]

[av_hr class=\'big\' height=\'50\' position=\'center\']

[av_one_fourth first]

[av_icon_box icon=\'ue8d7\' font=\'entypo-fontello\' position=\'left\' title=\'Comment venir ?\' link=\'page,1792\' linktarget=\'\' linkelement=\'both\']
<p>Pour connaître toutes les informations utiles concernant votre arrivée et les moyens de transport pour Vichy, c\'est par ici !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8b5\' font=\'entypo-fontello\' position=\'left\' title=\'Où dormir ?\' link=\'page,1801\' linktarget=\'\' linkelement=\'both\']
<p>Nous vous proposons plusieurs options pour vous loger sur place, découvrez ici les hôtels disponibles et renseignez la case hébergement lors de votre inscription !</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue8a9\' font=\'entypo-fontello\' position=\'left\' title=\'Que manger ?\' link=\'\' linktarget=\'\' linkelement=\'\']
<p>Si vous le désirez, vous pourrez vous restaurer sur place ! Renseignez simplement la case restauration lors de votre inscription à l\'événement</p>

[/av_icon_box]

[/av_one_fourth][av_one_fourth]

[av_icon_box icon=\'ue836\' font=\'entypo-fontello\' position=\'left\' title=\'Le forum\' link=\'page,1750\' linktarget=\'\' linkelement=\'both\']
<p>Pas envie de voyager ni de se loger seul(e) ? Partagez ici vos moyens de transport ou encore votre hébergement grâce à notre forum pratique !</p>

[/av_icon_box]

[/av_one_fourth][av_hr class=\'big\' height=\'50\' position=\'center\']

");
INSERT INTO `wp_postmeta` VALUES("1586","1629","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1588","1630","_wp_attachment_metadata","a:5:{s:5:\"width\";i:533;s:6:\"height\";i:96;s:4:\"file\";s:21:\"2014/04/textvichy.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"textvichy-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"textvichy-300x54.png\";s:5:\"width\";i:300;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"textvichy-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"textvichy-180x96.png\";s:5:\"width\";i:180;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"textvichy-495x96.png\";s:5:\"width\";i:495;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"textvichy-260x96.png\";s:5:\"width\";i:260;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"textvichy-120x96.png\";s:5:\"width\";i:120;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"textvichy-450x96.png\";s:5:\"width\";i:450;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"textvichy-450x81.png\";s:5:\"width\";i:450;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("122","821","_avia_builder_shortcode_tree","a:9:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:1;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}i:2;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}i:4;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}}s:5:\"index\";i:8;}i:5;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}}s:5:\"index\";i:10;}i:6;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:7;a:3:{s:3:\"tag\";s:13:\"av_one_fourth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}}s:5:\"index\";i:14;}i:8;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}");
INSERT INTO `wp_postmeta` VALUES("1577","1629","_menu_item_object_id","821");
INSERT INTO `wp_postmeta` VALUES("1578","1629","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1579","1629","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1580","1629","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1581","1629","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1582","1629","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1587","1630","_wp_attached_file","2014/04/textvichy.png");
INSERT INTO `wp_postmeta` VALUES("1584","1629","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1585","1629","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("2370","1991","_wp_attached_file","2014/05/HUNTER-2013-original1.jpg");
INSERT INTO `wp_postmeta` VALUES("2371","1991","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:474;s:4:\"file\";s:33:\"2014/05/HUNTER-2013-original1.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:31:\"HUNTER-2013-original1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x474.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:474;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-705x427.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:33:\"HUNTER-2013-original1-450x273.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:273;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2740","2069","_wp_attached_file","2014/05/logo-CMB.bmp");
INSERT INTO `wp_postmeta` VALUES("2443","2013","_wp_attached_file","2013/04/S.Daycard-Heid-12.jpg");
INSERT INTO `wp_postmeta` VALUES("2444","2013","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:680;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-12.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-300x243.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:243;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-12-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-705x572.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:572;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-12-450x365.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:365;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2549","2034","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:87;s:4:\"file\";s:27:\"2014/05/logos-allier-01.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:25:\"logos-allier-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-180x87.png\";s:5:\"width\";i:180;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"logos-allier-01-120x87.png\";s:5:\"width\";i:120;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2550","2037","_wp_attached_file","2014/05/Allier_le_Departement_bleu.png");
INSERT INTO `wp_postmeta` VALUES("2551","2037","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1687;s:6:\"height\";i:480;s:4:\"file\";s:38:\"2014/05/Allier_le_Departement_bleu.png\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"Allier_le_Departement_bleu-300x85.png\";s:5:\"width\";i:300;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x293.png\";s:5:\"width\";i:1030;s:6:\"height\";i:293;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:36:\"Allier_le_Departement_bleu-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x430.png\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1500x426.png\";s:5:\"width\";i:1500;s:6:\"height\";i:426;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x480.png\";s:5:\"width\";i:710;s:6:\"height\";i:480;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-705x200.png\";s:5:\"width\";i:705;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:39:\"Allier_le_Departement_bleu-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:38:\"Allier_le_Departement_bleu-450x128.png\";s:5:\"width\";i:450;s:6:\"height\";i:128;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2352","1978","_wp_attached_file","2014/05/g.le_roux.jpg");
INSERT INTO `wp_postmeta` VALUES("2278","1963","_wp_attached_file","2014/05/cistude_romain_riols.jpg");
INSERT INTO `wp_postmeta` VALUES("2279","1963","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:4:\"file\";s:32:\"2014/05/cistude_romain_riols.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"cistude_romain_riols-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:34:\"cistude_romain_riols-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:33:\"cistude_romain_riols-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"cistude_romain_riols-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2353","1978","_wp_attachment_metadata","a:5:{s:5:\"width\";i:4592;s:6:\"height\";i:2576;s:4:\"file\";s:21:\"2014/05/g.le_roux.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"g.le_roux-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"g.le_roux-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x577.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:577;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"g.le_roux-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"g.le_roux-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1500x841.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:841;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:21:\"g.le_roux-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"g.le_roux-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:21:\"g.le_roux-705x395.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:21:\"g.le_roux-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:22:\"g.le_roux-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"g.le_roux-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"g.le_roux-450x252.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:252;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:5.5999999999999996447286321199499070644378662109375;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"DSLR-A290\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1344353630;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"300\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:9:\"0.0015625\";s:5:\"title\";s:8:\"SONY DSC\";}}");
INSERT INTO `wp_postmeta` VALUES("2354","1979","_wp_attached_file","2014/05/riols_romain_milan_noir.jpg");
INSERT INTO `wp_postmeta` VALUES("2355","1979","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1200;s:4:\"file\";s:35:\"2014/05/riols_romain_milan_noir.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:33:\"riols_romain_milan_noir-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:37:\"riols_romain_milan_noir-1500x1125.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1125;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:36:\"riols_romain_milan_noir-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:35:\"riols_romain_milan_noir-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:3.70000000000000017763568394002504646778106689453125;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:29:\"Konica Digital Camera KD-310Z\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1049047227;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"14.2\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:6:\"0.0156\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2356","1980","_wp_attached_file","2014/05/val_dallier_jean_jacques_lallemant.jpg");
INSERT INTO `wp_postmeta` VALUES("2357","1980","_wp_attachment_metadata","a:5:{s:5:\"width\";i:2362;s:6:\"height\";i:1586;s:4:\"file\";s:46:\"2014/05/val_dallier_jean_jacques_lallemant.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x691.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:691;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:44:\"val_dallier_jean_jacques_lallemant-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1500x430.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"extra_large\";a:4:{s:4:\"file\";s:48:\"val_dallier_jean_jacques_lallemant-1500x1007.jpg\";s:5:\"width\";i:1500;s:6:\"height\";i:1007;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-705x473.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:47:\"val_dallier_jean_jacques_lallemant-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:46:\"val_dallier_jean_jacques_lallemant-450x302.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:302;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2360","1986","_wp_attached_file","2014/05/HUNTER-20131.jpg");
INSERT INTO `wp_postmeta` VALUES("2361","1986","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1295;s:4:\"file\";s:24:\"2014/05/HUNTER-20131.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-795x1030.jpg\";s:5:\"width\";i:795;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20131-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"HUNTER-20131-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20131-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2362","1987","_wp_attached_file","2014/05/HUNTER-20132.jpg");
INSERT INTO `wp_postmeta` VALUES("2363","1987","_wp_attachment_metadata","a:5:{s:5:\"width\";i:667;s:6:\"height\";i:864;s:4:\"file\";s:24:\"2014/05/HUNTER-20132.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20132-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x430.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x575.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-544x705.jpg\";s:5:\"width\";i:544;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x270.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-667x360.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20132-450x582.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:582;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2364","1988","_wp_attached_file","2014/05/HUNTER-20133.jpg");
INSERT INTO `wp_postmeta` VALUES("2365","1988","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:667;s:4:\"file\";s:24:\"2014/05/HUNTER-20133.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-205x300.jpg\";s:5:\"width\";i:205;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20133-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x575.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20133-450x655.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:655;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2366","1989","_wp_attached_file","2014/05/HUNTER-20134.jpg");
INSERT INTO `wp_postmeta` VALUES("2367","1989","_wp_attachment_metadata","a:5:{s:5:\"width\";i:458;s:6:\"height\";i:473;s:4:\"file\";s:24:\"2014/05/HUNTER-20134.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-290x300.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"HUNTER-20134-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x430.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x400.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x270.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-458x360.jpg\";s:5:\"width\";i:458;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"HUNTER-20134-450x464.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:464;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2368","1990","_wp_attached_file","2014/05/HUNTER-2013-original.jpg");
INSERT INTO `wp_postmeta` VALUES("2369","1990","_wp_attachment_metadata","a:5:{s:5:\"width\";i:781;s:6:\"height\";i:576;s:4:\"file\";s:32:\"2014/05/HUNTER-2013-original.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-300x221.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:30:\"HUNTER-2013-original-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x430.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-705x519.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-781x360.jpg\";s:5:\"width\";i:781;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"HUNTER-2013-original-450x331.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";d:2.79999999999999982236431605997495353221893310546875;s:6:\"credit\";s:13:\"Inga Juodytė\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1387031180;s:9:\"copyright\";s:13:\"Inga Juodytė\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:4:\"2000\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("307","44","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("308","44","_avia_elements_avia_options_propulsion","s:1046:\"a:6:{s:4:\"hero\";s:3:\"yes\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"36\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `wp_postmeta` VALUES("309","44","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("310","44","_avia_elements_avia_options_coherence","s:1436:\"a:13:{s:8:\"subtitle\";s:45:\"Donec pede justo, fringilla vel, aliquet nec!\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:22:\"Photography, Photoshop\";s:16:\"portfolio-meta-2\";s:10:\"Flashlight\";s:16:\"portfolio-meta-3\";s:91:\"&lt;a href=&quot;http://www.kriesi.at/themes/flashlight/&quot;&gt;Flashlight Demo&lt;/a&gt;\";}\";");
INSERT INTO `wp_postmeta` VALUES("1139","44","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("312","44","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `wp_postmeta` VALUES("313","44","_facebookcount-cache","0");
INSERT INTO `wp_postmeta` VALUES("314","44","_twittercount-cache","0");
INSERT INTO `wp_postmeta` VALUES("315","44","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("316","44","_aviaLayoutBuilderCleanData","[av_two_third first]

[av_gallery ids=\'1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1490,1491,1492,1493,1494,1496,1497,1498,1499,1500\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'square\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']

[/av_two_third][av_one_third]
[av_textblock ]
<h3>Aix en Provence</h3>
Pour l’édition 2013, le thème retenu était : \"Le journalisme de demain passe-t-il obligatoirement par le web ? » Avec la multiplication des réseaux sociaux, des sites d’information et des supports numériques en tous genres, la presse trouve un nouvel essor sur le web. Les offres de collaborations foisonnent et les pratiques se diversifient. Comment appréhender cette nouvelle réalité ? Qu’en est-il du transmédia et du cross-média ? Alternatives pour survivre ou modèles d’avenir, quelles sont les nouvelles pistes de fabrication et de diffusion de l’information ?
Ces rencontres ont notamment accueilli François Missen (Prix Pullitzer et Prix Albert-Londres), Denis Robert, auteur de l\'enquête Clearstream, et Xavier Monnier, rédacteur en chef de Backchich.info <strong>Découvrez les en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_portfolio categories=\'34,35,36\' columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1142","44","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1143","44","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1144","44","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1145","44","_preview_columns","8");
INSERT INTO `wp_postmeta` VALUES("1146","44","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1147","44","footer","");
INSERT INTO `wp_postmeta` VALUES("317","44","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1140","44","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1141","44","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("318","44","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("319","44","sidebar","");
INSERT INTO `wp_postmeta` VALUES("320","44","header","yes");
INSERT INTO `wp_postmeta` VALUES("375","1167","header","yes");
INSERT INTO `wp_postmeta` VALUES("376","1167","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("377","1167","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("378","1167","_aviaLayoutBuilderCleanData","[av_sidebar widget_area=\'Contact\']

[av_one_full first]

[av_heading tag=\'h3\' padding=\'10\' heading=\'Contactez-nous !\' color=\'meta-heading\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_contact email=\'aurore.staiger@hotmail.fr\' button=\'Envoyer\' title=\'\' sent=\'Votre message a bien été envoyé!\' subject=\'\' autorespond=\'\' captcha=\'\']
[av_contact_field label=\'Nom\' type=\'text\' options=\'\' check=\'is_empty\' width=\'element_half\']
[av_contact_field label=\'E-Mail\' type=\'text\' options=\'\' check=\'is_email\' width=\'element_half\']
[av_contact_field label=\'Sujet de votre message\' type=\'text\' options=\'\' check=\'is_empty\' width=\'\']
[av_contact_field label=\'Message\' type=\'textarea\' options=\'\' check=\'is_empty\' width=\'\']
[/av_contact]

[/av_one_full]");
INSERT INTO `wp_postmeta` VALUES("1607","1639","_wp_attachment_metadata","a:5:{s:5:\"width\";i:32;s:6:\"height\";i:32;s:4:\"file\";s:22:\"2013/04/favicon-01.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1063","734","_edit_lock","1429276061:5");
INSERT INTO `wp_postmeta` VALUES("379","1167","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("380","1167","sidebar","");
INSERT INTO `wp_postmeta` VALUES("381","1167","_avia_builder_shortcode_tree","a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_sidebar\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:1;a:3:{s:3:\"tag\";s:10:\"av_contact\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:1;}}");
INSERT INTO `wp_postmeta` VALUES("1606","1639","_wp_attached_file","2013/04/favicon-01.png");
INSERT INTO `wp_postmeta` VALUES("1085","1407","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("2439","2009","_wp_attached_file","2013/04/S.Daycard-Heid-1.jpg");
INSERT INTO `wp_postmeta` VALUES("2440","2009","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:1176;s:4:\"file\";s:28:\"2013/04/S.Daycard-Heid-1.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-213x300.jpg\";s:5:\"width\";i:213;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-1-733x1030.jpg\";s:5:\"width\";i:733;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"S.Daycard-Heid-1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-501x705.jpg\";s:5:\"width\";i:501;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"S.Daycard-Heid-1-450x632.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:632;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("2548","2034","_wp_attached_file","2014/05/logos-allier-01.png");
INSERT INTO `wp_postmeta` VALUES("2441","2011","_wp_attached_file","2013/04/S.Daycard-Heid-11.jpg");
INSERT INTO `wp_postmeta` VALUES("2442","2011","_wp_attachment_metadata","a:5:{s:5:\"width\";i:837;s:6:\"height\";i:738;s:4:\"file\";s:29:\"2013/04/S.Daycard-Heid-11.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-300x264.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:264;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"S.Daycard-Heid-11-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x430.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-705x621.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:621;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-837x360.jpg\";s:5:\"width\";i:837;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:29:\"S.Daycard-Heid-11-450x396.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:396;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("422","1248","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES("423","1248","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("424","1248","sidebar","");
INSERT INTO `wp_postmeta` VALUES("425","1248","header","yes");
INSERT INTO `wp_postmeta` VALUES("426","1248","_avia_builder_shortcode_tree","a:31:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:3:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}}s:5:\"index\";i:5;}i:3;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:9;}i:1;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}}s:5:\"index\";i:8;}i:4;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}i:5;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:13;}}s:5:\"index\";i:12;}i:6;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:15;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:16;}}s:5:\"index\";i:14;}i:7;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:18;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:19;}}s:5:\"index\";i:17;}i:8;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:21;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:22;}}s:5:\"index\";i:20;}i:9;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:24;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:25;}}s:5:\"index\";i:23;}i:10;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:27;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:28;}}s:5:\"index\";i:26;}i:11;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:30;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:31;}}s:5:\"index\";i:29;}i:12;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:32;}i:13;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:34;}}s:5:\"index\";i:33;}i:14;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:35;}i:15;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:37;}}s:5:\"index\";i:36;}i:16;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:39;}}s:5:\"index\";i:38;}i:17;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:41;}}s:5:\"index\";i:40;}i:18;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:43;}}s:5:\"index\";i:42;}i:19;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:45;}}s:5:\"index\";i:44;}i:20;a:3:{s:3:\"tag\";s:12:\"av_one_fifth\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:11:\"av_icon_box\";s:7:\"content\";a:0:{}s:5:\"index\";i:47;}}s:5:\"index\";i:46;}i:21;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:48;}i:22;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:50;}}s:5:\"index\";i:49;}i:23;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:51;}i:24;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:53;}}s:5:\"index\";i:52;}i:25;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:55;}}s:5:\"index\";i:54;}i:26;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:56;}i:27;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:58;}}s:5:\"index\";i:57;}i:28;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:59;}i:29;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:61;}}s:5:\"index\";i:60;}i:30;a:3:{s:3:\"tag\";s:9:\"av_button\";s:7:\"content\";a:0:{}s:5:\"index\";i:62;}}");
INSERT INTO `wp_postmeta` VALUES("1462","1248","footer","");
INSERT INTO `wp_postmeta` VALUES("1751","1734","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1752","1734","_menu_item_orphaned","1399370100");
INSERT INTO `wp_postmeta` VALUES("427","1248","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("428","1248","_aviaLayoutBuilderCleanData","[av_one_full first]
[av_heading heading=\'Le programme des 48h européennes de la pige 2015\' tag=\'h1\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_heading heading=\'Deux jours de réflexion, de rencontres et de formation pour les professionnels indépendants des médias d’Europe\' tag=\'h3\' color=\'\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']
[/av_one_full]

[av_icon_box icon=\'ue862\' font=\'entypo-fontello\' position=\'left\' title=\'JEUDI 2 JUILLET\' link=\'\' linktarget=\'\' linkelement=\'\']
Durant ces deux journée des jeunes “facilitateurs” polyglottes du CUEJ ou de European Youthpress seront présents accueillir et guider les participants.
[/av_icon_box]

[av_one_half first]
[av_heading heading=\'9h30 : Accueil et Ice breaker coffee\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2011/12/BCR7638-300x199.jpg\' attachment=\'1474\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_one_half]
[av_heading heading=\'10h30 : Réu de lancement Kick off meeting\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]

[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2011/12/BCR7667-300x199.jpg\' attachment=\'1485\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']
[/av_one_half]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'11h00 : Ateliers flash partage de compétences Sharing skills\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_one_third first]
[av_image src=\'\' attachment=\'\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'L’apport du multimédia\' tag=\'h5\' color=\'meta-heading\' custom_font=\'#000000\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Laurent Gontier (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/GieffersHanna-2015-300x300.jpeg\' attachment=\'19703\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le webdocumentaire\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Hanna Gieffers (Allemagne)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/GuadagniTommaso-2015-300x300.jpg\' attachment=\'19702\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Datajournalisme\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Tommaso Guadagni

[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/MartiniereMathieu-2015-300x300.jpg\' attachment=\'19704\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réussir un crowfunding\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'2\']
Mathieu Martinière (France)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/StrassenburgRomy-2015-296x300.jpg\' attachment=\'19705\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Bien vendre ses piges\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Romy Strassenburg (Allemagne)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/SansonStern-2014-287x300.jpg\' attachment=\'19706\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Réseaux sociaux\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Catherine Sanson-Stern (France)
[/av_heading]
[/av_one_third]

[av_one_third first]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/VallellianPatrick-2015-298x300.jpg\' attachment=\'19707\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'Le long format\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Patrick Vallelian (Suisse)

[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2015/04/WildNicolas-2015-300x300.jpg\' attachment=\'19710\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'La BD-reportage\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Nicolas Wild (France)
[/av_heading]
[/av_one_third]

[av_one_third]
[av_image src=\'http://48h.pigiste.org/wp-content/uploads/2013/04/BulligPaula-2015-300x299.jpg\' attachment=\'19709\' align=\'center\' animation=\'bottom-to-top\' link=\'\' target=\'\']

[av_heading heading=\'La BD-reportage\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
Paula Bullig (Allemagne)
[/av_heading]
[/av_one_third]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'13h : Déjeuner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'14h30 : Workshop Créer un nouveau média en 2h ? C’est possible ! (Ou presque)\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\' padding=\'0\']
En mode « Media Lab », les participants se répartissent en 4 groupes thématiques à l’intérieur desquels ils s’organisent en équipes aux compétences complémentaires.
Guidés par des modérateurs de Profession Pigiste, avec Romain Saillet comme référent, chaque équipe élabore le squelette d’un projet éditorial.

[/av_heading]
[/av_one_full]

[av_one_fourth first]
[av_icon_box icon=\'ue80d\' font=\'entypo-fontello\' position=\'left\' title=\'Webdocumentaire\' link=\'\' linktarget=\'\' linkelement=\'\']Cliquer ici pour ajouter votre propre texte

[/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue83b\' font=\'entypo-fontello\' position=\'left\' title=\'Reportage\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue8ab\' font=\'entypo-fontello\' position=\'left\' title=\'Journalisme de données\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_one_fourth]
[av_icon_box icon=\'ue833\' font=\'entypo-fontello\' position=\'left\' title=\'Long format\' link=\'\' linktarget=\'\' linkelement=\'\'][/av_icon_box]
[/av_one_fourth]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_one_full first]
[av_heading heading=\'16h30 : Pause\' tag=\'h5\' color=\'meta-heading\' custom_font=\'\' style=\'blockquote modern-quote\' size=\'\' subheading_active=\'\' subheading_size=\'10\' padding=\'0\'][/av_heading]
[/av_one_full]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'17h : Présentation de l’Afdas\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'10\' heading=\'17h20 : Restitution des ateliers\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Chaque équipe a cinq minutes pour « pitcher » le projet sur lequel elle a travaillé et le présenter aux participants de son groupe. Chaque groupe élit le meilleur projet.
[/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'18h20 : Un moment de liberté\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'19h : Apéritif\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'10\'][/av_heading]

[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\']

[av_heading tag=\'h5\' padding=\'0\' heading=\'20h30 : Dîner\' color=\'meta-heading\' style=\'blockquote modern-quote\' custom_font=\'\' size=\'\' subheading_active=\'subheading_below\' subheading_size=\'12\']
Avec une intervention de Gabriele Bertolli, de la direction générale de la DG Connect à la Commission européenne.
[/av_heading]

[av_button label=\'Voir le programme du vendredi\' link=\'page,1720\' link_target=\'\' color=\'theme-color\' custom_bg=\'#444444\' custom_font=\'#ffffff\' size=\'small\' position=\'right\' icon_select=\'yes\' icon=\'ue832\' font=\'entypo-fontello\']

");
INSERT INTO `wp_postmeta` VALUES("1475","1574","_wp_attached_file","2013/04/48hbyPP.png");
INSERT INTO `wp_postmeta` VALUES("1476","1574","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1146;s:6:\"height\";i:606;s:4:\"file\";s:19:\"2013/04/48hbyPP.png\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"48hbyPP-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"48hbyPP-300x158.png\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x544.png\";s:5:\"width\";i:1030;s:6:\"height\";i:544;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"48hbyPP-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"48hbyPP-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1146x430.png\";s:5:\"width\";i:1146;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"48hbyPP-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"48hbyPP-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"48hbyPP-705x372.png\";s:5:\"width\";i:705;s:6:\"height\";i:372;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"48hbyPP-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"48hbyPP-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"48hbyPP-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"48hbyPP-450x237.png\";s:5:\"width\";i:450;s:6:\"height\";i:237;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1750","1734","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1749","1734","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1748","1734","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("429","1248","_dp_original","1236");
INSERT INTO `wp_postmeta` VALUES("1572","821","_edit_lock","1427966762:3");
INSERT INTO `wp_postmeta` VALUES("1573","821","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1575","1629","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1576","1629","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1012","1373","_wp_attachment_metadata","a:5:{s:5:\"width\";i:558;s:6:\"height\";i:198;s:4:\"file\";s:26:\"2013/04/Logo48hcyan-01.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-300x106.png\";s:5:\"width\";i:300;s:6:\"height\";i:106;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:24:\"Logo48hcyan-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-495x198.png\";s:5:\"width\";i:495;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x198.png\";s:5:\"width\";i:450;s:6:\"height\";i:198;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:26:\"Logo48hcyan-01-450x159.png\";s:5:\"width\";i:450;s:6:\"height\";i:159;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1011","1373","_wp_attached_file","2013/04/Logo48hcyan-01.png");
INSERT INTO `wp_postmeta` VALUES("1066","1401","_edit_last","1");
INSERT INTO `wp_postmeta` VALUES("1067","1401","_edit_lock","1426615847:3");
INSERT INTO `wp_postmeta` VALUES("1136","1420","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6159.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6159-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6159-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6159-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6159-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6159-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6159-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6159-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6159-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6159-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6159-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6159-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6159-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6159-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6159-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1135","1420","_wp_attached_file","2011/12/IMG_6159.jpg");
INSERT INTO `wp_postmeta` VALUES("1134","1419","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6157.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6157-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6157-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6157-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6157-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6157-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6157-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6157-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6157-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6157-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6157-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6157-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6157-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6157-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6157-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1133","1419","_wp_attached_file","2011/12/IMG_6157.jpg");
INSERT INTO `wp_postmeta` VALUES("1132","1418","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6115.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6115-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6115-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6115-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6115-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6115-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6115-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6115-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1131","1418","_wp_attached_file","2011/12/IMG_6115.jpg");
INSERT INTO `wp_postmeta` VALUES("1130","1417","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6114.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6114-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6114-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6114-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6114-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6114-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6114-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6114-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6114-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6114-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6114-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6114-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6114-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6114-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6114-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1129","1417","_wp_attached_file","2011/12/IMG_6114.jpg");
INSERT INTO `wp_postmeta` VALUES("1128","1416","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1024;s:6:\"height\";i:684;s:4:\"file\";s:20:\"2011/12/IMG_6111.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6111-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6111-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6111-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6111-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_6111-1024x430.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6111-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6111-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6111-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_6111-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6111-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_6111-1024x360.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6111-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6111-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_6111-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1127","1416","_wp_attached_file","2011/12/IMG_6111.jpg");
INSERT INTO `wp_postmeta` VALUES("1126","1415","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6097.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6097-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6097-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6097-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6097-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6097-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6097-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6097-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1125","1415","_wp_attached_file","2011/12/IMG_6097.jpg");
INSERT INTO `wp_postmeta` VALUES("1065","734","footer","");
INSERT INTO `wp_postmeta` VALUES("1083","1407","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1086","1407","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1060","1386","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1059","1386","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1058","1386","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1056","1386","_menu_item_url","http://48h.pigiste.org");
INSERT INTO `wp_postmeta` VALUES("1055","1386","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1054","1386","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1053","1386","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1052","1386","_menu_item_object","custom");
INSERT INTO `wp_postmeta` VALUES("1051","1386","_menu_item_object_id","1386");
INSERT INTO `wp_postmeta` VALUES("1050","1386","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1048","1385","_menu-item-avia-textarea","");
INSERT INTO `wp_postmeta` VALUES("1047","1385","_menu-item-avia-division","");
INSERT INTO `wp_postmeta` VALUES("1046","1385","_menu-item-avia-megamenu","");
INSERT INTO `wp_postmeta` VALUES("1064","734","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1044","1385","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES("1043","1385","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES("1042","1385","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1041","1385","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES("1040","1385","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1037","1385","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES("1013","1373","av-custom-link","");
INSERT INTO `wp_postmeta` VALUES("1038","1385","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES("1039","1385","_menu_item_object_id","1167");
INSERT INTO `wp_postmeta` VALUES("1082","1407","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES("1049","1386","_menu_item_type","custom");
INSERT INTO `wp_postmeta` VALUES("1014","1374","_wp_attached_file","2014/04/Imac48h-01.png");
INSERT INTO `wp_postmeta` VALUES("1015","1374","_wp_attachment_metadata","a:5:{s:5:\"width\";i:284;s:6:\"height\";i:284;s:4:\"file\";s:22:\"2014/04/Imac48h-01.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Imac48h-01-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:20:\"Imac48h-01-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-284x270.png\";s:5:\"width\";i:284;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"Imac48h-01-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1016","1375","_wp_attached_file","2014/04/ipad.png");
INSERT INTO `wp_postmeta` VALUES("1017","1375","_wp_attachment_metadata","a:5:{s:5:\"width\";i:257;s:6:\"height\";i:200;s:4:\"file\";s:16:\"2014/04/ipad.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"ipad-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:14:\"ipad-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:16:\"ipad-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:16:\"ipad-257x185.png\";s:5:\"width\";i:257;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:16:\"ipad-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1018","1376","_wp_attached_file","2014/04/ipad48h.png");
INSERT INTO `wp_postmeta` VALUES("1019","1376","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1069;s:6:\"height\";i:826;s:4:\"file\";s:19:\"2014/04/ipad48h.png\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"ipad48h-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"ipad48h-300x231.png\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"ipad48h-1030x795.png\";s:5:\"width\";i:1030;s:6:\"height\";i:795;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"ipad48h-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"ipad48h-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"ipad48h-1069x430.png\";s:5:\"width\";i:1069;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"ipad48h-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"ipad48h-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"ipad48h-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"ipad48h-705x544.png\";s:5:\"width\";i:705;s:6:\"height\";i:544;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"ipad48h-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h-1030x360.png\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"ipad48h-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"ipad48h-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"ipad48h-450x347.png\";s:5:\"width\";i:450;s:6:\"height\";i:347;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1020","1377","_wp_attached_file","2014/04/ipad48h2.png");
INSERT INTO `wp_postmeta` VALUES("1021","1377","_wp_attachment_metadata","a:5:{s:5:\"width\";i:534;s:6:\"height\";i:413;s:4:\"file\";s:20:\"2014/04/ipad48h2.png\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ipad48h2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"ipad48h2-300x232.png\";s:5:\"width\";i:300;s:6:\"height\";i:232;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"ipad48h2-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"ipad48h2-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"ipad48h2-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"ipad48h2-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h2-534x270.png\";s:5:\"width\";i:534;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"ipad48h2-534x360.png\";s:5:\"width\";i:534;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"ipad48h2-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"ipad48h2-450x413.png\";s:5:\"width\";i:450;s:6:\"height\";i:413;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"ipad48h2-450x348.png\";s:5:\"width\";i:450;s:6:\"height\";i:348;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1022","1378","_wp_attached_file","2014/04/imac48.png");
INSERT INTO `wp_postmeta` VALUES("1023","1378","_wp_attachment_metadata","a:5:{s:5:\"width\";i:788;s:6:\"height\";i:633;s:4:\"file\";s:18:\"2014/04/imac48.png\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"imac48-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"imac48-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"imac48-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"imac48-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:18:\"imac48-788x430.png\";s:5:\"width\";i:788;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"imac48-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"imac48-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:18:\"imac48-710x575.png\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:18:\"imac48-705x566.png\";s:5:\"width\";i:705;s:6:\"height\";i:566;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:18:\"imac48-710x270.png\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:18:\"imac48-788x360.png\";s:5:\"width\";i:788;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"imac48-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"imac48-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"imac48-450x361.png\";s:5:\"width\";i:450;s:6:\"height\";i:361;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1024","1379","_wp_attached_file","2014/04/imac48heures.png");
INSERT INTO `wp_postmeta` VALUES("1025","1379","_wp_attachment_metadata","a:5:{s:5:\"width\";i:568;s:6:\"height\";i:455;s:4:\"file\";s:24:\"2014/04/imac48heures.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"imac48heures-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"imac48heures-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"imac48heures-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"imac48heures-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x430.png\";s:5:\"width\";i:568;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"imac48heures-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"imac48heures-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x270.png\";s:5:\"width\";i:568;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"imac48heures-568x360.png\";s:5:\"width\";i:568;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"imac48heures-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"imac48heures-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"imac48heures-450x360.png\";s:5:\"width\";i:450;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1026","1380","_wp_attached_file","2014/04/imac48heures3.png");
INSERT INTO `wp_postmeta` VALUES("1027","1380","_wp_attachment_metadata","a:5:{s:5:\"width\";i:568;s:6:\"height\";i:455;s:4:\"file\";s:25:\"2014/04/imac48heures3.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"imac48heures3-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"imac48heures3-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"imac48heures3-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"imac48heures3-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x430.png\";s:5:\"width\";i:568;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"imac48heures3-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"imac48heures3-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x270.png\";s:5:\"width\";i:568;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:25:\"imac48heures3-568x360.png\";s:5:\"width\";i:568;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"imac48heures3-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"imac48heures3-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:25:\"imac48heures3-450x360.png\";s:5:\"width\";i:450;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1028","1381","_wp_attached_file","2014/04/ipad48.png");
INSERT INTO `wp_postmeta` VALUES("1029","1381","_wp_attachment_metadata","a:5:{s:5:\"width\";i:320;s:6:\"height\";i:414;s:4:\"file\";s:18:\"2014/04/ipad48.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"ipad48-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"ipad48-231x300.png\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"ipad48-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"ipad48-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"ipad48-320x400.png\";s:5:\"width\";i:320;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"ipad48-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:18:\"ipad48-320x270.png\";s:5:\"width\";i:320;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:18:\"ipad48-320x360.png\";s:5:\"width\";i:320;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"ipad48-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1030","1382","_wp_attached_file","2014/04/ipa.png");
INSERT INTO `wp_postmeta` VALUES("1031","1382","_wp_attachment_metadata","a:5:{s:5:\"width\";i:215;s:6:\"height\";i:278;s:4:\"file\";s:15:\"2014/04/ipa.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"ipa-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"ipa-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"ipa-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"ipa-215x185.png\";s:5:\"width\";i:215;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:15:\"ipa-215x270.png\";s:5:\"width\";i:215;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"ipa-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1032","1383","_wp_attached_file","2014/04/txt.png");
INSERT INTO `wp_postmeta` VALUES("1033","1383","_wp_attachment_metadata","a:5:{s:5:\"width\";i:533;s:6:\"height\";i:96;s:4:\"file\";s:15:\"2014/04/txt.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"txt-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"txt-300x54.png\";s:5:\"width\";i:300;s:6:\"height\";i:54;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"txt-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:14:\"txt-180x96.png\";s:5:\"width\";i:180;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:14:\"txt-495x96.png\";s:5:\"width\";i:495;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:14:\"txt-260x96.png\";s:5:\"width\";i:260;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:14:\"txt-120x96.png\";s:5:\"width\";i:120;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:14:\"txt-450x96.png\";s:5:\"width\";i:450;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:14:\"txt-450x81.png\";s:5:\"width\";i:450;s:6:\"height\";i:81;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1034","1167","_edit_lock","1427965028:1");
INSERT INTO `wp_postmeta` VALUES("1035","1167","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1084","1407","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1036","1167","footer","nofooterwidgets");
INSERT INTO `wp_postmeta` VALUES("1137","1421","_wp_attached_file","2011/12/IMG_6167.jpg");
INSERT INTO `wp_postmeta` VALUES("1138","1421","_wp_attachment_metadata","a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2011/12/IMG_6167.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_6167-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_6167-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_6167-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_6167-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x430.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x400.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_6167-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x575.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x270.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x360.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_6167-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_6167-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:17:\"ERIC DELAPERRIERE\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:19:\"©Eric Delaperriere\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1148","44","_thumbnail_id","1420");
INSERT INTO `wp_postmeta` VALUES("1149","1422","_wp_attached_file","2011/12/IMG_5363.jpg");
INSERT INTO `wp_postmeta` VALUES("1150","1422","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5363.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5363-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5363-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5363-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5363-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5363-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5363-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5363-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5363-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5363-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5363-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5363-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5363-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5363-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5363-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1151","1423","_wp_attached_file","2011/12/IMG_5365.jpg");
INSERT INTO `wp_postmeta` VALUES("1152","1423","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5365.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5365-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5365-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5365-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5365-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5365-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5365-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5365-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5365-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5365-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5365-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5365-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5365-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5365-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5365-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1153","1424","_wp_attached_file","2011/12/IMG_5366.jpg");
INSERT INTO `wp_postmeta` VALUES("1154","1424","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5366.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5366-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5366-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5366-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5366-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5366-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5366-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5366-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5366-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5366-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5366-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5366-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5366-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5366-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1155","1425","_wp_attached_file","2011/12/IMG_5368.jpg");
INSERT INTO `wp_postmeta` VALUES("1156","1425","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:750;s:4:\"file\";s:20:\"2011/12/IMG_5368.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5368-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5368-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5368-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5368-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5368-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5368-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5368-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5368-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5368-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5368-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5368-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5368-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5368-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5368-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1157","1426","_wp_attached_file","2011/12/IMG_5371.jpg");
INSERT INTO `wp_postmeta` VALUES("1158","1426","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5371.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5371-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5371-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5371-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5371-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5371-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5371-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5371-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5371-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5371-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5371-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5371-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5371-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5371-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1159","1427","_wp_attached_file","2011/12/IMG_5373.jpg");
INSERT INTO `wp_postmeta` VALUES("1160","1427","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1333;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_5373.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5373-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5373-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1030x772.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:772;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5373-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5373-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1333x430.jpg\";s:5:\"width\";i:1333;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5373-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5373-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5373-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5373-705x528.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:528;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5373-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5373-1030x360.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5373-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5373-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5373-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1161","1428","_wp_attached_file","2011/12/IMG_5375.jpg");
INSERT INTO `wp_postmeta` VALUES("1162","1428","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2011/12/IMG_5375.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5375-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5375-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5375-772x1030.jpg\";s:5:\"width\";i:772;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5375-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5375-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5375-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5375-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5375-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5375-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5375-528x705.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5375-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5375-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5375-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5375-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5375-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1163","1429","_wp_attached_file","2011/12/IMG_8601.jpg");
INSERT INTO `wp_postmeta` VALUES("1164","1429","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_8601.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8601-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8601-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_8601-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8601-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8601-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8601-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8601-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8601-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8601-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8601-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8601-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8601-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8601-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8601-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8601-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1165","1430","_wp_attached_file","2011/12/IMG_8602.jpg");
INSERT INTO `wp_postmeta` VALUES("1166","1430","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_8602.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8602-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8602-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_8602-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8602-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8602-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8602-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8602-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8602-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8602-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8602-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8602-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8602-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8602-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8602-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8602-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1167","1431","_wp_attached_file","2011/12/IMG_8605.jpg");
INSERT INTO `wp_postmeta` VALUES("1168","1431","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:20:\"2011/12/IMG_8605.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_8605-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_8605-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_8605-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_8605-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_8605-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_8605-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_8605-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_8605-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_8605-705x705.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_8605-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_8605-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_8605-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_8605-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_8605-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1169","1432","_wp_attached_file","2011/12/IMG_5358.jpg");
INSERT INTO `wp_postmeta` VALUES("1170","1432","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1333;s:4:\"file\";s:20:\"2011/12/IMG_5358.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_5358-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_5358-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_5358-772x1030.jpg\";s:5:\"width\";i:772;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_5358-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_5358-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_5358-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_5358-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_5358-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_5358-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_5358-528x705.jpg\";s:5:\"width\";i:528;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_5358-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_5358-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_5358-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_5358-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_5358-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1171","751","_avia_builder_template_galerie_photo","{{{Galerie photo}}}[av_two_third first]
[av_gallery ids=\'1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'portfolio\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]
[av_textblock ]
<h3>Aix en Provence</h3>
Pour l’édition 2013, le thème retenu était : \"Le journalisme de demain passe-t-il obligatoirement par le web ? » Avec la multiplication des réseaux sociaux, des sites d’information et des supports numériques en tous genres, la presse trouve un nouvel essor sur le web. Les offres de collaborations foisonnent et les pratiques se diversifient. Comment appréhender cette nouvelle réalité ? Qu’en est-il du transmédia et du cross-média ? Alternatives pour survivre ou modèles d’avenir, quelles sont les nouvelles pistes de fabrication et de diffusion de l’information ?
Ces rencontres ont notamment accueilli François Missen (Prix Pullitzer et Prix Albert-Londres), Denis Robert, auteur de l\'enquête Clearstream, et Xavier Monnier, rédacteur en chef de Backchich.info <strong>Découvrez les en images !</strong>

[/av_textblock]
[/av_one_third]

[av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio columns=\'4\' items=\'4\' contents=\'excerpt\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]");
INSERT INTO `wp_postmeta` VALUES("1172","1433","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1173","1433","_edit_lock","1427716571:5");
INSERT INTO `wp_postmeta` VALUES("1174","1434","_wp_attached_file","2014/04/IMG_4110.jpg");
INSERT INTO `wp_postmeta` VALUES("1175","1434","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4110.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4110-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4110-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4110-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4110-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4110-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4110-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4110-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4110-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4110-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4110-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4110-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4110-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4110-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4110-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1176","1435","_wp_attached_file","2014/04/IMG_4108.jpg");
INSERT INTO `wp_postmeta` VALUES("1177","1435","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1500;s:4:\"file\";s:20:\"2014/04/IMG_4108.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4108-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4108-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_4108-686x1030.jpg\";s:5:\"width\";i:686;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4108-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4108-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4108-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4108-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4108-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4108-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4108-470x705.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4108-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4108-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4108-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4108-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4108-450x675.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1178","1436","_wp_attached_file","2014/04/IMG_4106.jpg");
INSERT INTO `wp_postmeta` VALUES("1179","1436","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4106.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4106-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4106-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4106-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4106-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4106-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4106-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4106-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4106-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4106-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4106-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4106-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4106-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4106-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4106-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1180","1437","_wp_attached_file","2014/04/IMG_4105.jpg");
INSERT INTO `wp_postmeta` VALUES("1181","1437","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4105.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"IMG_4105-e1398421965268-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4105-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4105-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4105-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4105-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4105-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4105-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4105-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4105-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4105-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4105-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4105-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4105-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4105-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1182","1438","_wp_attached_file","2014/04/IMG_4104.jpg");
INSERT INTO `wp_postmeta` VALUES("1183","1438","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4104.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4104-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4104-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4104-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4104-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4104-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4104-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4104-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4104-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4104-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4104-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4104-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4104-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4104-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4104-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1184","1439","_wp_attached_file","2014/04/IMG_4103.jpg");
INSERT INTO `wp_postmeta` VALUES("1185","1439","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4103.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4103-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4103-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4103-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4103-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4103-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4103-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4103-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4103-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4103-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4103-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4103-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4103-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4103-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4103-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1186","1440","_wp_attached_file","2014/04/IMG_4102.jpg");
INSERT INTO `wp_postmeta` VALUES("1187","1440","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4102.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4102-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4102-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4102-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4102-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4102-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4102-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4102-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4102-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4102-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4102-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4102-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4102-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4102-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4102-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1188","1441","_wp_attached_file","2014/04/IMG_4101.jpg");
INSERT INTO `wp_postmeta` VALUES("1189","1441","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4101.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4101-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4101-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4101-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4101-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4101-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4101-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4101-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4101-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4101-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4101-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4101-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4101-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4101-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4101-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1190","1442","_wp_attached_file","2014/04/IMG_4100.jpg");
INSERT INTO `wp_postmeta` VALUES("1191","1442","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4100.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4100-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4100-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4100-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4100-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4100-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4100-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4100-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4100-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4100-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4100-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4100-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4100-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4100-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4100-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1192","1443","_wp_attached_file","2014/04/IMG_4099.jpg");
INSERT INTO `wp_postmeta` VALUES("1193","1443","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4099.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4099-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4099-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4099-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4099-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4099-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4099-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4099-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4099-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4099-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4099-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4099-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4099-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4099-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4099-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1194","1444","_wp_attached_file","2014/04/IMG_4098.jpg");
INSERT INTO `wp_postmeta` VALUES("1195","1444","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4098.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4098-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4098-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4098-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4098-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4098-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4098-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4098-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4098-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4098-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4098-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4098-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4098-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4098-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4098-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1196","1445","_wp_attached_file","2014/04/IMG_4097.jpg");
INSERT INTO `wp_postmeta` VALUES("1197","1445","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4097.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4097-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4097-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4097-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4097-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4097-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4097-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4097-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4097-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4097-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4097-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4097-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4097-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4097-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4097-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1198","1446","_wp_attached_file","2014/04/IMG_4096.jpg");
INSERT INTO `wp_postmeta` VALUES("1199","1446","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4096.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4096-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4096-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4096-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4096-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4096-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4096-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4096-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4096-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4096-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4096-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4096-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4096-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4096-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4096-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1200","1447","_wp_attached_file","2014/04/IMG_4095.jpg");
INSERT INTO `wp_postmeta` VALUES("1201","1447","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4095.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4095-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4095-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4095-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4095-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4095-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4095-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4095-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4095-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4095-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4095-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4095-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4095-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4095-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4095-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1202","1448","_wp_attached_file","2014/04/IMG_4111.jpg");
INSERT INTO `wp_postmeta` VALUES("1203","1448","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4111.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4111-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4111-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4111-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4111-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4111-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4111-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4111-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4111-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4111-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4111-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4111-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4111-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4111-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4111-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1204","1449","_wp_attached_file","2014/04/IMG_4092.jpg");
INSERT INTO `wp_postmeta` VALUES("1205","1449","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4092.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4092-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4092-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4092-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4092-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4092-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4092-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4092-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4092-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4092-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4092-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4092-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4092-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4092-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4092-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1206","1450","_wp_attached_file","2014/04/IMG_4086.jpg");
INSERT INTO `wp_postmeta` VALUES("1207","1450","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4086.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4086-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4086-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4086-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4086-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4086-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4086-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4086-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4086-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4086-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4086-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4086-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4086-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4086-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4086-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1208","1451","_wp_attached_file","2014/04/IMG_4083.jpg");
INSERT INTO `wp_postmeta` VALUES("1209","1451","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4083.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4083-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4083-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4083-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4083-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4083-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4083-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4083-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4083-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4083-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4083-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4083-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4083-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4083-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4083-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1210","1452","_wp_attached_file","2014/04/IMG_4082.jpg");
INSERT INTO `wp_postmeta` VALUES("1211","1452","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4082.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4082-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4082-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4082-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4082-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4082-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4082-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4082-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4082-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4082-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4082-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4082-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4082-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4082-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4082-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1212","1453","_wp_attached_file","2014/04/IMG_4079.jpg");
INSERT INTO `wp_postmeta` VALUES("1213","1453","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4079.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4079-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4079-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4079-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4079-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4079-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4079-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4079-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4079-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4079-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4079-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4079-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4079-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4079-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4079-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1214","1454","_wp_attached_file","2014/04/IMG_4078.jpg");
INSERT INTO `wp_postmeta` VALUES("1215","1454","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4078.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4078-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4078-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4078-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4078-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4078-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4078-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4078-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4078-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4078-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4078-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4078-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4078-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4078-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4078-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1216","1455","_wp_attached_file","2014/04/IMG_4077.jpg");
INSERT INTO `wp_postmeta` VALUES("1217","1455","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4077.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4077-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4077-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4077-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4077-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4077-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4077-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4077-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4077-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4077-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4077-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4077-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4077-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4077-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4077-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1218","1456","_wp_attached_file","2014/04/IMG_4074.jpg");
INSERT INTO `wp_postmeta` VALUES("1219","1456","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4074.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4074-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4074-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4074-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4074-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4074-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4074-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4074-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4074-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4074-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4074-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4074-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4074-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4074-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4074-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1220","1457","_wp_attached_file","2014/04/IMG_4073.jpg");
INSERT INTO `wp_postmeta` VALUES("1221","1457","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4073.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4073-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4073-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4073-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4073-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4073-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4073-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4073-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4073-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4073-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4073-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4073-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4073-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4073-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4073-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1222","1458","_wp_attached_file","2014/04/IMG_4072.jpg");
INSERT INTO `wp_postmeta` VALUES("1223","1458","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4072.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4072-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4072-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4072-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4072-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4072-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4072-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4072-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4072-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4072-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4072-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4072-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4072-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4072-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4072-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1224","1459","_wp_attached_file","2014/04/IMG_4091.jpg");
INSERT INTO `wp_postmeta` VALUES("1225","1459","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/IMG_4091.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_4091-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_4091-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_4091-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_4091-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_4091-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_4091-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_4091-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_4091-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_4091-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_4091-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_4091-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_4091-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_4091-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_4091-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1226","1433","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1227","1433","_aviaLayoutBuilderCleanData","[av_two_third first]
[av_gallery ids=\'1435,1434,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,1451,1452,1453,1454,1455,1456,1457,1458,1459\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'square\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]

[av_textblock ]
<p>
<h3>Lyon</h3>
<p>La seconde édition des 48h de la pige s\'est tenu à Lyon les 2 et 3 juillet 2012 à l’université de Lyon 3, en plein centre-ville. L’objectif était toujours le même : permettre à chacun d’élargir le réseau de contacts tout en s’informant et en partageant les expériences. <strong>Découvrez Lyon 2012 en images !</strong></p>
© Johann Trompat

[/av_textblock]

[/av_one_third][av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_portfolio categories=\'34,35,36\' columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1228","1433","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1284","1471","_wp_attached_file","2011/12/BCR7615.jpg");
INSERT INTO `wp_postmeta` VALUES("1229","1433","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1230","1433","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1231","1433","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1232","1433","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1233","1433","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1234","1433","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1235","1433","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1236","1433","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1237","1433","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1238","1433","header","yes");
INSERT INTO `wp_postmeta` VALUES("1239","1433","footer","");
INSERT INTO `wp_postmeta` VALUES("1241","1437","_wp_attachment_backup_sizes","a:1:{s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:18:\"IMG_4105-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}}");
INSERT INTO `wp_postmeta` VALUES("1248","1460","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES("1249","1460","_edit_lock","1427716563:5");
INSERT INTO `wp_postmeta` VALUES("1250","1460","_aviaLayoutBuilder_active","active");
INSERT INTO `wp_postmeta` VALUES("1251","1460","_aviaLayoutBuilderCleanData","[av_two_third first]
[av_gallery ids=\'1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1560,1561,1562,1563,1564,1565,1566\' style=\'big_thumb\' preview_size=\'gallery\' crop_big_preview_thumbnail=\'avia-gallery-big-crop-thumb\' thumb_size=\'thumbnail\' columns=\'7\' imagelink=\'lightbox\' lazyload=\'avia_lazyload\']
[/av_two_third]

[av_one_third]

[av_textblock ]
<p>
<h3>Préparation 2014</h3>
<p>Toute l\'équipe de Profession Pigiste est sur le pied de guerre pour vous concocter un programme vous aidant à anticiper les l\'évolutions de la presse et se positionner sur les compétences à acquérir. Les prochaine 48 h. proposeront donc aux participants un partage de la situation actuelle et l\'élaboration d\'une réflexion collective pour imaginer des réponses de demain, avec :<br />- des expériences de journalistes pigistes et une co-construction en atelier (quelles sont les expériences innovantes, singulières, mises en œuvre par des journalistes pigistes, comment ces expériences peuvent nourrir mon projet professionnel, à quelles conditions sont-elles transférables ?)<br />- des outils pour anticiper les évolutions de la presse (regard d\'experts sur les évolutions à moyen terme, compétences à développer)<br />- des réflexions pour anticiper ces changements (imaginer des réponses collectives, mieux gérer notre efficacité).<br />La convivialité sera bien évidemment au rendez-vous avec une soirée festive. <strong>Découvrez la session de préparation en images !</strong></p>

[/av_textblock]

[/av_one_third][av_section color=\'alternate_color\' custom_bg=\'\' src=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\' padding=\'default\' shadow=\'shadow\']
[av_hr class=\'short\' height=\'50\' position=\'center\']

[av_portfolio categories=\'34,35,36\' columns=\'3\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'auto\' image_size=\'portfolio\' linking=\'\' sort=\'no\' paginate=\'no\']
[/av_section]

");
INSERT INTO `wp_postmeta` VALUES("1252","1460","_avia_builder_shortcode_tree","a:3:{i:0;a:3:{s:3:\"tag\";s:12:\"av_two_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:10:\"av_gallery\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_one_third\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:10:\"av_section\";s:7:\"content\";a:2:{i:0;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}i:1;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}s:5:\"index\";i:4;}}");
INSERT INTO `wp_postmeta` VALUES("1253","1460","_portfolio_custom_link","");
INSERT INTO `wp_postmeta` VALUES("1254","1460","_portfolio_custom_link_url","http://");
INSERT INTO `wp_postmeta` VALUES("1255","1460","_preview_ids","");
INSERT INTO `wp_postmeta` VALUES("1256","1460","_preview_display","gallery");
INSERT INTO `wp_postmeta` VALUES("1257","1460","_preview_autorotation","disabled");
INSERT INTO `wp_postmeta` VALUES("1258","1460","_preview_columns","6");
INSERT INTO `wp_postmeta` VALUES("1259","1460","_preview_text","");
INSERT INTO `wp_postmeta` VALUES("1260","1460","layout","fullsize");
INSERT INTO `wp_postmeta` VALUES("1261","1460","sidebar","");
INSERT INTO `wp_postmeta` VALUES("1262","1460","header","yes");
INSERT INTO `wp_postmeta` VALUES("1263","1460","footer","");
INSERT INTO `wp_postmeta` VALUES("1264","1461","_wp_attached_file","2011/12/IMG_2519.jpg");
INSERT INTO `wp_postmeta` VALUES("1265","1461","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2519.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2519-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2519-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2519-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2519-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2519-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2519-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2519-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2519-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2519-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2519-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2519-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2519-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2519-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2519-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1266","1462","_wp_attached_file","2011/12/IMG_2518.jpg");
INSERT INTO `wp_postmeta` VALUES("1267","1462","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2518.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2518-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2518-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2518-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2518-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2518-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2518-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2518-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2518-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2518-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2518-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2518-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2518-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2518-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2518-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1268","1463","_wp_attached_file","2011/12/IMG_2513.jpg");
INSERT INTO `wp_postmeta` VALUES("1269","1463","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2513.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2513-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2513-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2513-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2513-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2513-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2513-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2513-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2513-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2513-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2513-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2513-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2513-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2513-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2513-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1270","1464","_wp_attached_file","2011/12/IMG_2507.jpg");
INSERT INTO `wp_postmeta` VALUES("1271","1464","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2507.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2507-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2507-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2507-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2507-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2507-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2507-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2507-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2507-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2507-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2507-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2507-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2507-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2507-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2507-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1272","1465","_wp_attached_file","2011/12/IMG_2506.jpg");
INSERT INTO `wp_postmeta` VALUES("1273","1465","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2506.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2506-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2506-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2506-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2506-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2506-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2506-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2506-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2506-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2506-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2506-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2506-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2506-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2506-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2506-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1274","1466","_wp_attached_file","2011/12/IMG_2504.jpg");
INSERT INTO `wp_postmeta` VALUES("1275","1466","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2504.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2504-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2504-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2504-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2504-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2504-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2504-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2504-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2504-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2504-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2504-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2504-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2504-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2504-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2504-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1276","1467","_wp_attached_file","2011/12/IMG_2503.jpg");
INSERT INTO `wp_postmeta` VALUES("1277","1467","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1339;s:4:\"file\";s:20:\"2011/12/IMG_2503.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2503-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2503-224x300.jpg\";s:5:\"width\";i:224;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_2503-769x1030.jpg\";s:5:\"width\";i:769;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2503-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2503-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2503-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2503-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2503-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2503-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2503-526x705.jpg\";s:5:\"width\";i:526;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2503-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2503-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2503-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2503-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2503-450x602.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:602;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1278","1468","_wp_attached_file","2011/12/IMG_2500.jpg");
INSERT INTO `wp_postmeta` VALUES("1279","1468","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2500.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2500-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2500-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2500-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2500-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2500-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2500-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2500-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2500-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2500-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2500-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2500-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2500-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2500-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2500-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1280","1469","_wp_attached_file","2011/12/IMG_2502.jpg");
INSERT INTO `wp_postmeta` VALUES("1281","1469","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2502.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2502-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2502-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2502-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2502-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2502-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2502-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2502-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2502-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2502-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2502-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2502-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2502-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2502-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2502-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1282","1470","_wp_attached_file","2011/12/IMG_2520.jpg");
INSERT INTO `wp_postmeta` VALUES("1283","1470","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:747;s:4:\"file\";s:20:\"2011/12/IMG_2520.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"IMG_2520-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2520-300x224.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:224;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"IMG_2520-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"IMG_2520-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"IMG_2520-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"IMG_2520-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"IMG_2520-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"IMG_2520-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"IMG_2520-705x526.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:526;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"IMG_2520-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"IMG_2520-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2520-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"IMG_2520-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"IMG_2520-450x336.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:336;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1285","1471","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7615.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7615-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7615-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7615-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7615-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7615-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7615-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7615-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7615-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7615-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7615-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7615-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7615-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7615-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7615-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1286","1472","_wp_attached_file","2011/12/BCR7621.jpg");
INSERT INTO `wp_postmeta` VALUES("1287","1472","_wp_attachment_metadata","a:5:{s:5:\"width\";i:664;s:6:\"height\";i:1000;s:4:\"file\";s:19:\"2011/12/BCR7621.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7621-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7621-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7621-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7621-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x430.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7621-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7621-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x575.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7621-468x705.jpg\";s:5:\"width\";i:468;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x270.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7621-664x360.jpg\";s:5:\"width\";i:664;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7621-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7621-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7621-450x677.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:677;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1288","1473","_wp_attached_file","2011/12/BCR7629.jpg");
INSERT INTO `wp_postmeta` VALUES("1289","1473","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7629.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7629-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7629-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7629-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7629-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7629-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7629-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7629-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7629-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7629-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7629-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7629-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7629-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7629-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7629-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1290","1474","_wp_attached_file","2011/12/BCR7638.jpg");
INSERT INTO `wp_postmeta` VALUES("1291","1474","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7638.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7638-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7638-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7638-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7638-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7638-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7638-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7638-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7638-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7638-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7638-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7638-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7638-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7638-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7638-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1292","1475","_wp_attached_file","2011/12/BCR7639.jpg");
INSERT INTO `wp_postmeta` VALUES("1293","1475","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7639.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7639-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7639-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7639-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7639-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7639-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7639-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7639-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7639-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7639-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7639-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7639-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7639-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7639-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7639-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1294","1476","_wp_attached_file","2011/12/BCR7643.jpg");
INSERT INTO `wp_postmeta` VALUES("1295","1476","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7643.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7643-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7643-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7643-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7643-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7643-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7643-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7643-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7643-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7643-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7643-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7643-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7643-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7643-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7643-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1296","1477","_wp_attached_file","2011/12/BCR7651.jpg");
INSERT INTO `wp_postmeta` VALUES("1297","1477","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7651.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7651-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7651-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7651-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7651-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7651-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7651-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7651-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7651-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7651-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7651-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7651-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7651-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7651-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7651-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1298","1478","_wp_attached_file","2011/12/BCR7652.jpg");
INSERT INTO `wp_postmeta` VALUES("1299","1478","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7652.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7652-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7652-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7652-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7652-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7652-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7652-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7652-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7652-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7652-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7652-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7652-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7652-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7652-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7652-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1300","1479","_wp_attached_file","2011/12/BCR7653.jpg");
INSERT INTO `wp_postmeta` VALUES("1301","1479","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7653.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7653-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7653-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7653-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7653-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7653-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7653-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7653-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7653-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7653-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7653-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7653-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7653-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7653-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7653-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1302","1480","_wp_attached_file","2011/12/BCR7655.jpg");
INSERT INTO `wp_postmeta` VALUES("1303","1480","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7655.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7655-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7655-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7655-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7655-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7655-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7655-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7655-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7655-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7655-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7655-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7655-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7655-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7655-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7655-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1304","1481","_wp_attached_file","2011/12/BCR7657.jpg");
INSERT INTO `wp_postmeta` VALUES("1305","1481","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7657.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7657-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7657-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7657-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7657-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7657-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7657-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7657-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7657-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7657-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7657-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7657-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7657-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7657-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7657-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1306","1482","_wp_attached_file","2011/12/BCR7659.jpg");
INSERT INTO `wp_postmeta` VALUES("1307","1482","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7659.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7659-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7659-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7659-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7659-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7659-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7659-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7659-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7659-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7659-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7659-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7659-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7659-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7659-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7659-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1308","1483","_wp_attached_file","2011/12/BCR7662.jpg");
INSERT INTO `wp_postmeta` VALUES("1309","1483","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7662.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7662-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7662-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7662-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7662-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7662-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7662-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7662-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7662-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7662-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7662-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7662-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7662-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7662-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7662-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1310","1484","_wp_attached_file","2011/12/BCR7665.jpg");
INSERT INTO `wp_postmeta` VALUES("1311","1484","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7665.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7665-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7665-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7665-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7665-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7665-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7665-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7665-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7665-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7665-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7665-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7665-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7665-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7665-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7665-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1312","1485","_wp_attached_file","2011/12/BCR7667.jpg");
INSERT INTO `wp_postmeta` VALUES("1313","1485","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7667.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7667-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7667-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7667-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7667-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7667-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7667-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7667-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7667-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7667-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7667-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7667-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7667-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7667-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7667-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1314","1486","_wp_attached_file","2011/12/BCR7671.jpg");
INSERT INTO `wp_postmeta` VALUES("1315","1486","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7671.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7671-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7671-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7671-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7671-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7671-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7671-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7671-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7671-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7671-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7671-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7671-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7671-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7671-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7671-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1316","1487","_wp_attached_file","2011/12/BCR7672.jpg");
INSERT INTO `wp_postmeta` VALUES("1317","1487","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7672.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7672-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7672-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7672-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7672-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7672-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7672-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7672-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7672-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7672-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7672-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7672-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7672-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7672-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7672-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1318","1488","_wp_attached_file","2011/12/BCR7673.jpg");
INSERT INTO `wp_postmeta` VALUES("1319","1488","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7673.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7673-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7673-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7673-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7673-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7673-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7673-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7673-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7673-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7673-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7673-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7673-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7673-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7673-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7673-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1320","1490","_wp_attached_file","2011/12/BCR7674.jpg");
INSERT INTO `wp_postmeta` VALUES("1321","1490","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7674.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7674-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7674-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7674-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7674-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7674-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7674-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7674-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7674-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7674-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7674-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7674-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7674-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7674-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7674-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1322","1491","_wp_attached_file","2011/12/BCR7675.jpg");
INSERT INTO `wp_postmeta` VALUES("1323","1491","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7675.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7675-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7675-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7675-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7675-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7675-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7675-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7675-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7675-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7675-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7675-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7675-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7675-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7675-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7675-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1324","1492","_wp_attached_file","2011/12/BCR7676.jpg");
INSERT INTO `wp_postmeta` VALUES("1325","1492","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7676.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7676-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7676-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7676-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7676-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7676-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7676-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7676-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7676-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7676-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7676-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7676-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7676-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7676-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7676-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1326","1493","_wp_attached_file","2011/12/BCR7697.jpg");
INSERT INTO `wp_postmeta` VALUES("1327","1493","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7697.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7697-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7697-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7697-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7697-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7697-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7697-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7697-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7697-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7697-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7697-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7697-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7697-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7697-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7697-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1328","1494","_wp_attached_file","2011/12/BCR7701.jpg");
INSERT INTO `wp_postmeta` VALUES("1329","1494","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7701.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7701-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7701-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7701-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7701-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7701-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7701-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7701-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7701-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7701-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7701-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7701-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7701-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7701-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7701-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1332","1497","_wp_attached_file","2011/12/BCR7708.jpg");
INSERT INTO `wp_postmeta` VALUES("1333","1497","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7708.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7708-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7708-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7708-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7708-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7708-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7708-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7708-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7708-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7708-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7708-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7708-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7708-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7708-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7708-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1334","1498","_wp_attached_file","2011/12/BCR7710.jpg");
INSERT INTO `wp_postmeta` VALUES("1335","1498","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7710.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7710-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7710-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7710-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7710-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7710-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7710-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7710-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7710-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7710-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7710-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7710-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7710-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7710-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7710-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1336","1499","_wp_attached_file","2011/12/BCR7711.jpg");
INSERT INTO `wp_postmeta` VALUES("1337","1499","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7711.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7711-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7711-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7711-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7711-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7711-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7711-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7711-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7711-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7711-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7711-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7711-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7711-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7711-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7711-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1338","1500","_wp_attached_file","2011/12/BCR7714.jpg");
INSERT INTO `wp_postmeta` VALUES("1339","1500","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:664;s:4:\"file\";s:19:\"2011/12/BCR7714.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"BCR7714-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"BCR7714-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"BCR7714-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"BCR7714-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:20:\"BCR7714-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"BCR7714-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"BCR7714-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:19:\"BCR7714-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:19:\"BCR7714-705x468.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:19:\"BCR7714-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:20:\"BCR7714-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"BCR7714-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:19:\"BCR7714-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"BCR7714-450x298.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:298;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:12:\"Bruno Crozat\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1371","1521","_wp_attached_file","2014/04/P1170592.jpg");
INSERT INTO `wp_postmeta` VALUES("1372","1521","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170592.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170592-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170592-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170592-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170592-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170592-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170592-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170592-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170592-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170592-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170592-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170592-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170592-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170592-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170592-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1373","1522","_wp_attached_file","2014/04/P1170587.jpg");
INSERT INTO `wp_postmeta` VALUES("1374","1522","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170587.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170587-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170587-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170587-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170587-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170587-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170587-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170587-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170587-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170587-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170587-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170587-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170587-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170587-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170587-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1375","1523","_wp_attached_file","2014/04/P1170539.jpg");
INSERT INTO `wp_postmeta` VALUES("1376","1523","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:1332;s:4:\"file\";s:20:\"2014/04/P1170539.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170539-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170539-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"P1170539-773x1030.jpg\";s:5:\"width\";i:773;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170539-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170539-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170539-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170539-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170539-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170539-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170539-529x705.jpg\";s:5:\"width\";i:529;s:6:\"height\";i:705;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170539-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170539-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170539-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170539-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170539-450x599.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:599;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1377","1524","_wp_attached_file","2014/04/P1170573.jpg");
INSERT INTO `wp_postmeta` VALUES("1378","1524","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170573.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170573-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170573-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170573-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170573-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170573-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170573-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170573-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170573-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170573-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170573-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170573-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170573-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170573-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170573-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1379","1525","_wp_attached_file","2014/04/P1170565.jpg");
INSERT INTO `wp_postmeta` VALUES("1380","1525","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170565.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170565-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170565-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170565-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170565-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170565-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170565-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170565-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170565-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170565-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170565-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170565-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170565-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170565-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170565-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1381","1526","_wp_attached_file","2014/04/P1170562.jpg");
INSERT INTO `wp_postmeta` VALUES("1382","1526","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170562.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170562-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170562-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170562-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170562-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170562-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170562-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170562-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170562-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170562-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170562-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170562-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170562-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170562-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170562-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1383","1527","_wp_attached_file","2014/04/P1170561.jpg");
INSERT INTO `wp_postmeta` VALUES("1384","1527","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170561.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170561-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170561-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170561-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170561-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170561-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170561-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170561-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170561-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170561-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170561-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170561-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170561-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170561-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170561-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1385","1528","_wp_attached_file","2014/04/P1170549.jpg");
INSERT INTO `wp_postmeta` VALUES("1386","1528","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170549.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170549-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170549-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170549-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170549-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170549-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170549-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170549-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170549-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170549-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170549-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170549-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170549-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170549-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170549-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1387","1529","_wp_attached_file","2014/04/P1170548.jpg");
INSERT INTO `wp_postmeta` VALUES("1388","1529","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170548.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170548-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170548-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170548-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170548-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170548-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170548-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170548-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170548-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170548-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170548-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170548-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170548-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170548-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170548-450x300.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1389","1530","_wp_attached_file","2014/04/P1170541.jpg");
INSERT INTO `wp_postmeta` VALUES("1390","1530","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:751;s:4:\"file\";s:20:\"2014/04/P1170541.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170541-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170541-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170541-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170541-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170541-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170541-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170541-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170541-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170541-705x529.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:529;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170541-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170541-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170541-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170541-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"P1170541-450x337.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:337;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("1391","1531","_wp_attached_file","2014/04/P1170537.jpg");
INSERT INTO `wp_postmeta` VALUES("1392","1531","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:20:\"2014/04/P1170537.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"P1170537-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"P1170537-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"P1170537-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"P1170537-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:21:\"P1170537-1000x430.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"P1170537-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"P1170537-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:20:\"P1170537-710x575.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:20:\"P1170537-705x470.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:20:\"P1170537-710x270.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:21:\"P1170537-1000x360.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"P1170537-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"P1170537-450x450.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\